/*
 * Decompiled with CFR 0.152.
 */
package tla2tex;

import java.util.Vector;
import tla2tex.Misc;

public class CToken {
    public String string;
    public int column;
    public boolean isTLA;
    public boolean isAmbiguous;
    public int type;
    public static final int BUILTIN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int IDENT = 4;
    public static final int OTHER = 5;
    public static final int REP_CHAR = 6;
    public static final int LEFT_DQUOTE = 7;
    public static final int RIGHT_DQUOTE = 8;
    public static final int VERB = 9;
    public static final int TEX = 10;
    public static final int NULL = 11;
    public static final int PF_STEP = 12;
    public static CToken nullCToken = new CToken("", 0, 11, false, false);

    public CToken(String str, int col, int typ, boolean tla, boolean amb) {
        this.string = str;
        this.column = col;
        this.type = typ;
        this.isTLA = tla;
        this.isAmbiguous = amb;
    }

    public CToken() {
        this.string = "";
        this.column = 0;
        this.type = 0;
        this.isTLA = false;
    }

    public int getWidth() {
        if (this.string == null) {
            return 0;
        }
        if (this.type == 3) {
            return this.string.length() + 2;
        }
        return this.string.length();
    }

    static void FindPfStepCTokens(CToken[][] toks) {
        boolean lastIsTLA = false;
        for (int k = 0; k < toks.length; ++k) {
            CToken[] input = toks[k];
            Vector<CToken> outputVec = new Vector<CToken>(input.length);
            int i = 0;
            while (i < input.length) {
                if (i < input.length - 2 && input[i].string.equals("<") && input[i + 1].column == input[i].column + 1 && input[i + 1].type == 2 && input[i + 2].string.equals(">") && input[i + 2].column == input[i + 1].column + input[i + 1].getWidth()) {
                    int numOfToks = 3;
                    String str = "<" + input[i + 1].string + ">";
                    if (i < input.length - 3 && input[i + 3].column == input[i + 2].column + 1 && (input[i + 3].type == 2 || input[i + 3].type == 4)) {
                        str = str + input[i + 3].string;
                        numOfToks = 4;
                        if (i < input.length - 4 && input[i + 4].column == input[i + 3].column + input[i + 3].getWidth() && input[i + 4].string.equals(".")) {
                            str = str + ".";
                            numOfToks = 5;
                        }
                    }
                    outputVec.addElement(new CToken(str, input[i].column, 12, input[i].isTLA, input[i].isAmbiguous));
                    i += numOfToks;
                    continue;
                }
                outputVec.addElement(input[i]);
                ++i;
            }
            if (outputVec.size() == input.length) continue;
            toks[k] = new CToken[outputVec.size()];
            for (i = 0; i < outputVec.size(); ++i) {
                toks[k][i] = (CToken)outputVec.elementAt(i);
            }
        }
    }

    public String mostOfString() {
        String typeName = "";
        switch (this.type) {
            case 1: {
                typeName = "BUILTIN";
                break;
            }
            case 2: {
                typeName = "NUMBER";
                break;
            }
            case 3: {
                typeName = "STRING";
                break;
            }
            case 4: {
                typeName = "IDENT";
                break;
            }
            case 5: {
                typeName = "OTHER";
                break;
            }
            case 6: {
                typeName = "REP_CHAR";
                break;
            }
            case 7: {
                typeName = "LEFT_DQUOTE";
                break;
            }
            case 8: {
                typeName = "RIGHT_DQUOTE";
                break;
            }
            case 9: {
                typeName = "VERB";
                break;
            }
            case 10: {
                typeName = "TEX";
            }
        }
        String str = "\"" + this.string + "\"";
        if (this.string == null) {
            str = "null";
        }
        String result = "[str |-> " + str + ",\t type |-> " + typeName + ",\t col |-> " + this.column + ",\t width |-> " + this.getWidth();
        if (this.isTLA) {
            result = result + ",\t isTLA |-> true";
        }
        if (this.isAmbiguous) {
            result = result + ",\t isAmbig |-> true";
        }
        return result;
    }

    public String toString() {
        return Misc.BreakLine(this.mostOfString() + "]");
    }
}

