# Security Policy

## Supported Versions

The table below lists all the versions released to [PyPI](http://pypi.org/project/aleat3).

The versions that will still receive active support (on issues, discussions, and PRs) are labeled with :white_check_mark:.

Most of the versions are no longer supported (labeled with :x:). Some of them are programmed to be deprecated (or yanked by PyPI), this means they will receive support
by the moment but not in the future (labeled with a :warning:).

The `Development Status` label lets you know the status of the release (these are: `Latest`, `Stable`, `To be deprecated`, `Unsupported`, `Yanked (on PyPI)` and `Deleted`).

| Version             | Supported          | Development Status  |
| ------------------- | ------------------ | ------------------- |
| 0.3.0               | :white_check_mark: | On development      |
| 0.2.9               | :white_check_mark: | Latest              |
| >= 0.2.5, <= 0.2.8  | :warning:          | To be deprecated    |
| 0.2.4               | :x:                | Yanked (on PyPI)    |
| > 0.2.0, <= 0.2.3   | :x:                | Unsupported         |
| 0.1.8               | :x:                | Deleted             |
| 0.1.x, != 0.1.8     | :x:                | Unsupported         |
| < 0.1               | :x:                | Unsupported         |

## Reporting a Vulnerability

If you find a vulnerability and you don't know what to do, or you want extra help, open an [issue](http://github.com/diddileija/diddiparser/issues) and together
we'll find a solution. If you have an idea to patch a vulnerability, use a [Pull Request](http://github.com/diddileija/diddiparser/pulls).
