"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.run = void 0;
const path = require("path");
const Mocha = require("mocha");
const glob = require("glob");
function run() {
    // Create the mocha test
    const mocha = new Mocha({
        ui: 'tdd',
        color: true
    });
    const testsRoot = path.resolve(__dirname, '..');
    return new Promise((c, e) => {
        const testFiles = new glob.Glob("**/**.test.js", { cwd: testsRoot });
        const testFileStream = testFiles.stream();
        testFileStream.on("data", (file) => {
            mocha.addFile(path.resolve(testsRoot, file));
        });
        testFileStream.on("error", (err) => {
            e(err);
        });
        testFileStream.on("end", () => {
            try {
                // Run the mocha test
                mocha.run(failures => {
                    if (failures > 0) {
                        e(new Error(`${failures} tests failed.`));
                    }
                    else {
                        c();
                    }
                });
            }
            catch (err) {
                console.error(err);
                e(err);
            }
        });
    });
}
exports.run = run;
//# sourceMappingURL=index.js.map