const { resolve } = require('path')

module.exports = {
  rootDir: resolve(__dirname, '../../../'),
  srcDir: resolve(__dirname, '../'),
  render: {
    resourceHints: false
  },
  modules: [
    { handler: require('../../') }
  ],
  webfontloader: {
    google: {
      families: ['Lato:400,700']
    },
    loading: () => {
      window._fontsAreLoading = true
    }
  },
  build: {
    filenames: {
      app: '[name].js',
      chunk: '[name].js'
    }
  }
}
