# <p align="center">Frontend-Web-Development</p>
![react](https://user-images.githubusercontent.com/76655825/194720609-2fb31525-eb96-4845-8fd0-53f6596b4c8f.png)
![nextjs](https://user-images.githubusercontent.com/76655825/194720648-0ad25e1e-a714-4fe9-8a4f-62dd15c050b6.png)
![vue](https://user-images.githubusercontent.com/76655825/194720575-f363f54b-07f7-46a0-878f-d618ecfb19f4.png)

# Contributing Guidelines📝

## Before contributing

Welcome to [Frontend-Web-Development](https://github.com/Developer-Student-Clubs-MMDU/Frontend-Web-Development)! Before sending your pull requests, make sure that you __read the whole guidelines__.

## Contributing

### Contributor

We are very happy that you consider implementing algorithms and data structures for others! This repository is referenced and used by learners from all over the globe. Being one of our contributors, you agree and confirm that:

- You did your work - no plagiarism allowed
  - Any plagiarized work will not be merged.
- Your work will be distributed under [MIT License](LICENSE.md) once your pull request is merged
- Your submitted work fulfils or mostly fulfils our styles and standards

__New implementation__ is welcome! For example, new solutions for a problem, different representations for a graph data structure or algorithm designs with different complexity but __identical implementation__ of an existing implementation is not allowed. Please check whether the solution is already implemented or not before submitting your pull request.

__Improving comments__ and __writing proper tests__ are also highly welcome.

### Contribution

We appreciate any contribution, from fixing a grammar mistake in a comment to implementing complex algorithms. Please read this section if you are contributing your work.

Please help us keep our issue list small by adding fixes: #{$ISSUE_NO} to the commit message of pull requests that resolve open issues. GitHub will use this tag to auto-close the issue when the PR is merged.

### What is React?

React is a JavaScript library for building interactive user interfaces.
By user interfaces, we mean the elements that users see and interact with on-screen.

### What is Next.js?

Next.js is a React framework that gives you building blocks to create web applications.
By framework, we mean Next.js handles the tooling and configuration needed for React, and provides additional structure, features, and optimizations for your application.

### What is Vue?

Vue is a JavaScript framework for building user interfaces. It builds on top of standard HTML, CSS and JavaScript, and provides a declarative and component-based programming model that helps you efficiently develop user interfaces, be it simple or complex.

### Two Core feature of Vue:
- Declarative Rendering: Vue extends standard HTML with a template syntax that allows us to declaratively describe HTML output based on JavaScript state.

- Reactivity: Vue automatically tracks JavaScript state changes and efficiently updates the DOM when changes happen.

### Building Blocks of a Web Application
- User Interface: how users will consume and interact with your application.
- Routing: how users navigate between different parts of your application.
- Data Fetching: where your data lives and how to get it.
- Rendering: when and where you render static or dynamic content.
- Integrations: what third-party services you use (CMS, auth, payments, etc) and how you connect to them.
- Performance: how to optimize your application for end-users.
- Scalability: how your application adapts as your team, data, and traffic grow. 

### Other Requirements for Submissions
- If possible, follow the standard within the folder you are submitting to.
- Please avoid creating new directories if at all possible. Try to fit your work into the existing directory structure.
- If you decide to fix an issue, please be sure to check the comment thread in case somebody is already working on a fix. If nobody is working on it at the moment, please leave a comment stating that you intend to work on it so other people don’t accidentally duplicate your effort.

### Before submitting a pull request, please make sure the following is done:
- Run yarn in the repository root.
- Make sure your code lints
- Run the Flow typechecks

- Fork the Repo (Click the Fork button in the top right of this page, click your Profile Image)
 ![image](https://user-images.githubusercontent.com/80347492/194729264-db3e4901-b3f7-4d08-b64f-d9de8dbb4700.png)
-  Clone your fork down to your local machine
```bash
git clone https://github.com/your-username/hacktoberfest.git
```

* Create a branch

```git bash
git checkout -b branch-name
```

- Make your changes (choose from any task below)
- Commit and push

```bash
git add .
git commit -m 'Commit message'
git push origin branch-name
```

* Create a new pull request from your forked repository (Click the `New Pull Request` button located at the top of your repo)
* Wait for your PR review and merge approval!
* __Star 🌟🌟 this repository__ if you had fun😁!

