/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public final class Pools {
    private Pools() {
    }

    public static class SynchronizedPool<T>
    extends SimplePool<T> {
        private final Object mLock = new Object();

        public SynchronizedPool(int maxPoolSize) {
            super(maxPoolSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T acquire() {
            Object object = this.mLock;
            synchronized (object) {
                return super.acquire();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release(@NonNull T element) {
            Object object = this.mLock;
            synchronized (object) {
                return super.release(element);
            }
        }
    }

    public static class SimplePool<T>
    implements Pool<T> {
        private final Object[] mPool;
        private int mPoolSize;

        public SimplePool(int maxPoolSize) {
            if (maxPoolSize <= 0) {
                throw new IllegalArgumentException("The max pool size must be > 0");
            }
            this.mPool = new Object[maxPoolSize];
        }

        @Override
        public T acquire() {
            if (this.mPoolSize > 0) {
                int lastPooledIndex = this.mPoolSize - 1;
                Object instance = this.mPool[lastPooledIndex];
                this.mPool[lastPooledIndex] = null;
                --this.mPoolSize;
                return (T)instance;
            }
            return null;
        }

        @Override
        public boolean release(@NonNull T instance) {
            if (this.isInPool(instance)) {
                throw new IllegalStateException("Already in the pool!");
            }
            if (this.mPoolSize < this.mPool.length) {
                this.mPool[this.mPoolSize] = instance;
                ++this.mPoolSize;
                return true;
            }
            return false;
        }

        private boolean isInPool(@NonNull T instance) {
            for (int i = 0; i < this.mPoolSize; ++i) {
                if (this.mPool[i] != instance) continue;
                return true;
            }
            return false;
        }
    }

    public static interface Pool<T> {
        @Nullable
        public T acquire();

        public boolean release(@NonNull T var1);
    }
}

