/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.data.zze;
import com.google.android.gms.common.data.zzf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@KeepName
public final class DataHolder
extends zzbck
implements Closeable {
    public static final Parcelable.Creator<DataHolder> CREATOR = new zzf();
    private int zzdxs;
    private final String[] zzfql;
    private Bundle zzfqm;
    private final CursorWindow[] zzfqn;
    private final int zzfac;
    private final Bundle zzfqo;
    private int[] zzfqp;
    int zzfqq;
    private boolean mClosed = false;
    private boolean zzfqr = true;
    private static final zza zzfqs = new zze(new String[0], null);

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        this.zzdxs = n;
        this.zzfql = stringArray;
        this.zzfqn = cursorWindowArray;
        this.zzfac = n2;
        this.zzfqo = bundle;
    }

    private DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        this.zzdxs = 1;
        this.zzfql = (String[])zzbp.zzu((Object)stringArray);
        this.zzfqn = (CursorWindow[])zzbp.zzu((Object)cursorWindowArray);
        this.zzfac = n;
        this.zzfqo = bundle;
        this.zzaiv();
    }

    private DataHolder(zza zza2, int n, Bundle bundle) {
        this(zza2.zzfql, DataHolder.zza(zza2, -1), n, null);
    }

    public final void zzaiv() {
        int n;
        this.zzfqm = new Bundle();
        for (n = 0; n < this.zzfql.length; ++n) {
            this.zzfqm.putInt(this.zzfql[n], n);
        }
        this.zzfqp = new int[this.zzfqn.length];
        n = 0;
        for (int i = 0; i < this.zzfqn.length; ++i) {
            this.zzfqp[i] = n;
            int n2 = this.zzfqn[i].getStartPosition();
            int n3 = n - n2;
            n += this.zzfqn[i].getNumRows() - n3;
        }
        this.zzfqq = n;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataHolder dataHolder = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String[])dataHolder.zzfql, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (Parcelable[])dataHolder.zzfqn, (int)n, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)3, (int)dataHolder.zzfac);
        zzbcn.zza((Parcel)parcel2, (int)4, (Bundle)dataHolder.zzfqo, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)1000, (int)dataHolder.zzdxs);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
        if ((n & 1) != 0) {
            this.close();
        }
    }

    public final int getStatusCode() {
        return this.zzfac;
    }

    public final Bundle zzafi() {
        return this.zzfqo;
    }

    private static CursorWindow[] zza(zza zza2, int n) {
        if (zza2.zzfql.length == 0) {
            return new CursorWindow[0];
        }
        ArrayList arrayList = zza2.zzfqt;
        int n2 = arrayList.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList2 = new ArrayList<CursorWindow>();
        arrayList2.add(cursorWindow);
        cursorWindow.setNumColumns(zza2.zzfql.length);
        boolean bl = false;
        try {
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (!cursorWindow.allocRow()) {
                    int n4 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(72).append("Allocating additional cursor window for large data set (row ").append(n4).append(")").toString());
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzfql.length);
                    arrayList2.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList2.remove(cursorWindow);
                        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
                    }
                }
                Map map = (Map)arrayList.get(i);
                boolean bl2 = true;
                for (n3 = 0; n3 < zza2.zzfql.length && bl2; ++n3) {
                    String string2 = zza2.zzfql[n3];
                    Object v = map.get(string2);
                    if (v == null) {
                        bl2 = cursorWindow.putNull(i, n3);
                        continue;
                    }
                    if (v instanceof String) {
                        bl2 = cursorWindow.putString((String)v, i, n3);
                        continue;
                    }
                    if (v instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v).longValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v).intValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Boolean) {
                        boolean bl3 = (Boolean)v;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, i, n3);
                        continue;
                    }
                    if (v instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v, i, n3);
                        continue;
                    }
                    if (v instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v).doubleValue(), i, n3);
                        continue;
                    }
                    if (v instanceof Float) {
                        bl2 = cursorWindow.putDouble((double)((Float)v).floatValue(), i, n3);
                        continue;
                    }
                    String string3 = String.valueOf(v);
                    throw new IllegalArgumentException(new StringBuilder(32 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unsupported object for column ").append(string2).append(": ").append(string3).toString());
                }
                if (!bl2) {
                    if (bl) {
                        String string4 = "Could not add the value to a new CursorWindow. The size of value may be larger than what a CursorWindow can handle.";
                        throw new zzb(string4);
                    }
                    n3 = i;
                    Log.d((String)"DataHolder", (String)new StringBuilder(74).append("Couldn't populate window data for row ").append(n3).append(" - allocating new window.").toString());
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i);
                    cursorWindow.setNumColumns(zza2.zzfql.length);
                    arrayList2.add(cursorWindow);
                    --i;
                    bl = true;
                    continue;
                }
                bl = false;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList2.size();
            for (int i = 0; i < n5; ++i) {
                ((CursorWindow)arrayList2.get(i)).close();
            }
            throw runtimeException;
        }
        return arrayList2.toArray(new CursorWindow[arrayList2.size()]);
    }

    private final void zzh(String string2, int n) {
        if (this.zzfqm == null || !this.zzfqm.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "No such column: ".concat(string3) : new String("No such column: "));
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n < 0 || n >= this.zzfqq) {
            throw new CursorIndexOutOfBoundsException(n, this.zzfqq);
        }
    }

    public final boolean zzfu(String string2) {
        return this.zzfqm.containsKey(string2);
    }

    public final long zzb(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqn[n2].getLong(n, this.zzfqm.getInt(string2));
    }

    public final int zzc(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqn[n2].getInt(n, this.zzfqm.getInt(string2));
    }

    public final String zzd(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqn[n2].getString(n, this.zzfqm.getInt(string2));
    }

    public final boolean zze(String string2, int n, int n2) {
        this.zzh(string2, n);
        return Long.valueOf(this.zzfqn[n2].getLong(n, this.zzfqm.getInt(string2))) == 1L;
    }

    public final float zzf(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqn[n2].getFloat(n, this.zzfqm.getInt(string2));
    }

    public final byte[] zzg(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqn[n2].getBlob(n, this.zzfqm.getInt(string2));
    }

    public final void zza(String string2, int n, int n2, CharArrayBuffer charArrayBuffer) {
        this.zzh(string2, n);
        this.zzfqn[n2].copyStringToBuffer(n, this.zzfqm.getInt(string2), charArrayBuffer);
    }

    public final boolean zzh(String string2, int n, int n2) {
        this.zzh(string2, n);
        return this.zzfqn[n2].isNull(n, this.zzfqm.getInt(string2));
    }

    public final int getCount() {
        return this.zzfqq;
    }

    public final int zzbx(int n) {
        int n2;
        zzbp.zzbg((n >= 0 && n < this.zzfqq ? 1 : 0) != 0);
        for (n2 = 0; n2 < this.zzfqp.length; ++n2) {
            if (n >= this.zzfqp[n2]) continue;
            --n2;
            break;
        }
        if (n2 == this.zzfqp.length) {
            --n2;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i = 0; i < this.zzfqn.length; ++i) {
                    this.zzfqn[i].close();
                }
            }
            return;
        }
    }

    protected final void finalize() throws Throwable {
        try {
            if (this.zzfqr && this.zzfqn.length > 0 && !this.isClosed()) {
                this.close();
                String string2 = this.toString();
                Log.e((String)"DataBuffer", (String)new StringBuilder(178 + String.valueOf(string2).length()).append("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call release() on all DataBuffer extending objects when you are done with them. (internal object: ").append(string2).append(")").toString());
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public static zza zza(String[] stringArray) {
        return new zza(stringArray, null, null);
    }

    public static DataHolder zzby(int n) {
        int n2 = n;
        return new DataHolder(zzfqs, n2, null);
    }

    /* synthetic */ DataHolder(zza zza2, int n, Bundle bundle, zze zze2) {
        this(zza2, 0, null);
    }

    public static final class zzb
    extends RuntimeException {
        public zzb(String string2) {
            super(string2);
        }
    }

    public static class zza {
        private final String[] zzfql;
        private final ArrayList<HashMap<String, Object>> zzfqt;
        private final String zzfqu;
        private final HashMap<Object, Integer> zzfqv;
        private boolean zzfqw;
        private String zzfqx;

        private zza(String[] stringArray, String string2) {
            this.zzfql = (String[])zzbp.zzu((Object)stringArray);
            this.zzfqt = new ArrayList();
            this.zzfqu = string2;
            this.zzfqv = new HashMap();
            this.zzfqw = false;
            this.zzfqx = null;
        }

        public zza zza(HashMap<String, Object> hashMap) {
            int n;
            int n2;
            zzc.zzr(hashMap);
            HashMap<String, Object> hashMap2 = hashMap;
            zza zza2 = this;
            if (zza2.zzfqu == null) {
                n2 = -1;
            } else {
                Object object = hashMap2.get(zza2.zzfqu);
                if (object == null) {
                    n2 = -1;
                } else {
                    Integer n3 = zza2.zzfqv.get(object);
                    if (n3 == null) {
                        zza2.zzfqv.put(object, zza2.zzfqt.size());
                        n2 = -1;
                    } else {
                        n2 = n = n3.intValue();
                    }
                }
            }
            if (n2 == -1) {
                this.zzfqt.add(hashMap);
            } else {
                this.zzfqt.remove(n);
                this.zzfqt.add(n, hashMap);
            }
            this.zzfqw = false;
            return this;
        }

        public zza zza(ContentValues contentValues) {
            zzc.zzr((Object)contentValues);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(contentValues.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.zza(hashMap);
        }

        public final DataHolder zzbz(int n) {
            return new DataHolder(this, 0, null, null);
        }

        /* synthetic */ zza(String[] stringArray, String string2, zze zze2) {
            this(stringArray, null);
        }
    }
}

