/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzct;
import com.google.android.gms.common.api.internal.zzdh;
import com.google.android.gms.common.api.internal.zzdi;
import com.google.android.gms.common.internal.zzbp;
import java.lang.ref.WeakReference;

public final class zzdg<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzfph = null;
    private zzdg<? extends Result> zzfpi = null;
    private volatile ResultCallbacks<? super R> zzfpj = null;
    private PendingResult<R> zzfpk = null;
    private final Object zzfjf = new Object();
    private Status zzfpl = null;
    private final WeakReference<GoogleApiClient> zzfjh;
    private final zzdi zzfpm;
    private boolean zzfpn = false;

    public zzdg(WeakReference<GoogleApiClient> weakReference) {
        zzbp.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzfjh = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjh.get();
        this.zzfpm = new zzdi(this, googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public final <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> resultTransform) {
        Object object = this.zzfjf;
        synchronized (object) {
            zzbp.zza((this.zzfph == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzbp.zza((this.zzfpj == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfph = resultTransform;
            zzdg<R> zzdg2 = new zzdg<R>(this.zzfjh);
            this.zzfpi = zzdg2;
            this.zzain();
            return zzdg2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void andFinally(@NonNull ResultCallbacks<? super R> resultCallbacks) {
        Object object = this.zzfjf;
        synchronized (object) {
            zzbp.zza((this.zzfpj == null ? 1 : 0) != 0, (Object)"Cannot call andFinally() twice.");
            zzbp.zza((this.zzfph == null ? 1 : 0) != 0, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzfpj = resultCallbacks;
            this.zzain();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResult(R r) {
        Object object = this.zzfjf;
        synchronized (object) {
            if (r.getStatus().isSuccess()) {
                if (this.zzfph != null) {
                    zzct.zzahn().submit(new zzdh(this, (Result)r));
                } else if (this.zzaip()) {
                    this.zzfpj.onSuccess(r);
                }
            } else {
                this.zzd(r.getStatus());
                zzdg.zzd(r);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(PendingResult<?> pendingResult) {
        Object object = this.zzfjf;
        synchronized (object) {
            this.zzfpk = pendingResult;
            this.zzain();
            return;
        }
    }

    private final void zzain() {
        if (this.zzfph == null && this.zzfpj == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjh.get();
        if (!this.zzfpn && this.zzfph != null && googleApiClient != null) {
            googleApiClient.zza(this);
            this.zzfpn = true;
        }
        if (this.zzfpl != null) {
            this.zzw(this.zzfpl);
            return;
        }
        if (this.zzfpk != null) {
            this.zzfpk.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzd(Status status) {
        Object object = this.zzfjf;
        synchronized (object) {
            this.zzfpl = status;
            this.zzw(this.zzfpl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzw(Status status) {
        Object object = this.zzfjf;
        synchronized (object) {
            if (this.zzfph != null) {
                Status status2 = this.zzfph.onFailure(status);
                zzbp.zzb((Object)status2, (Object)"onFailure must not return null");
                super.zzd(status2);
            } else if (this.zzaip()) {
                this.zzfpj.onFailure(status);
            }
            return;
        }
    }

    final void zzaio() {
        this.zzfpj = null;
    }

    private final boolean zzaip() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzfjh.get();
        return this.zzfpj != null && googleApiClient != null;
    }

    private static void zzd(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
                return;
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"TransformedResultImpl", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    static /* synthetic */ ResultTransform zzc(zzdg zzdg2) {
        return zzdg2.zzfph;
    }

    static /* synthetic */ zzdi zzd(zzdg zzdg2) {
        return zzdg2.zzfpm;
    }

    static /* synthetic */ void zza(zzdg zzdg2, Result result) {
        zzdg.zzd(result);
    }

    static /* synthetic */ WeakReference zze(zzdg zzdg2) {
        return zzdg2.zzfjh;
    }

    static /* synthetic */ Object zzf(zzdg zzdg2) {
        return zzdg2.zzfjf;
    }

    static /* synthetic */ zzdg zzg(zzdg zzdg2) {
        return zzdg2.zzfpi;
    }

    static /* synthetic */ void zza(zzdg zzdg2, Status status) {
        zzdg2.zzd(status);
    }
}

