/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zzac;
import com.google.android.gms.common.api.internal.zzaf;
import com.google.android.gms.common.api.internal.zzag;
import com.google.android.gms.common.api.internal.zzbd;
import com.google.android.gms.common.api.internal.zzbp;
import com.google.android.gms.common.api.internal.zzcd;
import com.google.android.gms.common.api.internal.zzcv;
import com.google.android.gms.common.api.internal.zzdm;
import com.google.android.gms.common.api.internal.zzh;
import com.google.android.gms.common.api.internal.zzm;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzbdy;
import com.google.android.gms.internal.zzcps;
import com.google.android.gms.internal.zzcpt;
import com.google.android.gms.tasks.OnCompleteListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class zzad
implements zzcd {
    private final Map<Api.zzc<?>, zzac<?>> zzfkk = new HashMap();
    private final Map<Api.zzc<?>, zzac<?>> zzfkl = new HashMap();
    private final Map<Api<?>, Boolean> zzfkm;
    private final zzbp zzfgv;
    private final zzbd zzfkn;
    private final Lock zzfke;
    private final Looper zzakg;
    private final zze zzfko;
    private final Condition zzfkp;
    private final zzq zzfkj;
    private final boolean zzfkq;
    private final boolean zzfkr;
    private final Queue<zzm<?, ?>> zzfks = new LinkedList();
    private boolean zzfkt;
    private Map<zzh<?>, ConnectionResult> zzfku;
    private Map<zzh<?>, ConnectionResult> zzfkv;
    private zzag zzfkw;
    private ConnectionResult zzfkx;

    public zzad(Context context, Lock lock, Looper looper, zze zze2, Map<Api.zzc<?>, Api.zze> map, zzq zzq2, Map<Api<?>, Boolean> map2, Api.zza<? extends zzcps, zzcpt> zza2, ArrayList<zzw> arrayList, zzbd zzbd2, boolean bl) {
        this.zzfke = lock;
        this.zzakg = looper;
        this.zzfkp = lock.newCondition();
        this.zzfko = zze2;
        this.zzfkn = zzbd2;
        this.zzfkm = map2;
        this.zzfkj = zzq2;
        this.zzfkq = bl;
        HashMap hashMap = new HashMap();
        for (Api<?> api : map2.keySet()) {
            hashMap.put(api.zzafe(), api);
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<zzw> arrayList2 = arrayList;
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            zzw zzw2 = arrayList2.get(i);
            zzw zzw3 = zzw2;
            hashMap2.put(zzw3.zzfdg, zzw3);
        }
        boolean bl2 = false;
        boolean bl3 = true;
        boolean bl4 = false;
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze3 = entry.getValue();
            if (zze3.zzaff()) {
                bl4 = true;
                if (!this.zzfkm.get(api).booleanValue()) {
                    bl2 = true;
                }
            } else {
                bl3 = false;
            }
            zzw zzw4 = (zzw)hashMap2.get(api);
            zzac zzac2 = new zzac(context, api, looper, zze3, zzw4, zzq2, zza2);
            this.zzfkk.put(entry.getKey(), zzac2);
            if (!zze3.zzaac()) continue;
            this.zzfkl.put(entry.getKey(), zzac2);
        }
        this.zzfkr = bl4 && !bl3 && !bl2;
        this.zzfgv = zzbp.zzaho();
    }

    @Override
    public final <A extends Api.zzb, R extends Result, T extends zzm<R, A>> T zzd(@NonNull T t) {
        if (this.zzfkq && this.zzg(t)) {
            return t;
        }
        if (!this.isConnected()) {
            this.zzfks.add(t);
            return t;
        }
        this.zzfkn.zzfmt.zzb(t);
        return this.zzfkk.get(t.zzafe()).zza(t);
    }

    @Override
    public final <A extends Api.zzb, T extends zzm<? extends Result, A>> T zze(@NonNull T t) {
        Api.zzc<A> zzc2 = t.zzafe();
        if (this.zzfkq && this.zzg(t)) {
            return t;
        }
        this.zzfkn.zzfmt.zzb(t);
        return this.zzfkk.get(zzc2).zzb(t);
    }

    private final <T extends zzm<? extends Result, ? extends Api.zzb>> boolean zzg(@NonNull T t) {
        Api.zzc<? extends Api.zzb> zzc2 = t.zzafe();
        ConnectionResult connectionResult = this.zzb(zzc2);
        if (connectionResult != null && connectionResult.getErrorCode() == 4) {
            t.zzt(new Status(4, null, this.zzfgv.zza(this.zzfkk.get(zzc2).zzafk(), System.identityHashCode(this.zzfkn))));
            return true;
        }
        return false;
    }

    @Override
    public final void connect() {
        this.zzfke.lock();
        try {
            if (this.zzfkt) {
                return;
            }
            this.zzfkt = true;
            this.zzfku = null;
            this.zzfkv = null;
            this.zzfkw = null;
            this.zzfkx = null;
            this.zzfgv.zzafw();
            this.zzfgv.zza(this.zzfkk.values()).addOnCompleteListener((Executor)new zzbdy(this.zzakg), (OnCompleteListener)new zzaf(this, null));
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zzfkp.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfff;
        }
        if (this.zzfkx != null) {
            return this.zzfkx;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zzfkp.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.zzfff;
        }
        if (this.zzfkx != null) {
            return this.zzfkx;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public final void disconnect() {
        this.zzfke.lock();
        try {
            this.zzfkt = false;
            this.zzfku = null;
            this.zzfkv = null;
            if (this.zzfkw != null) {
                this.zzfkw.cancel();
                this.zzfkw = null;
            }
            this.zzfkx = null;
            while (!this.zzfks.isEmpty()) {
                zzm<?, ?> zzm2 = this.zzfks.remove();
                ((zzs)zzm2).zza((zzdm)null);
                ((PendingResult)zzm2).cancel();
            }
            this.zzfkp.signalAll();
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        return this.zzb(api.zzafe());
    }

    @Nullable
    private final ConnectionResult zzb(@NonNull Api.zzc<?> zzc2) {
        this.zzfke.lock();
        try {
            zzac<?> zzac2 = this.zzfkk.get(zzc2);
            if (this.zzfku != null && zzac2 != null) {
                ConnectionResult connectionResult = this.zzfku.get(zzac2.zzafk());
                return connectionResult;
            }
            return null;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final boolean isConnected() {
        this.zzfke.lock();
        try {
            boolean bl = this.zzfku != null && this.zzfkx == null;
            return bl;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zzfke.lock();
        try {
            boolean bl = this.zzfku == null && this.zzfkt;
            return bl;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    private final boolean zzago() {
        this.zzfke.lock();
        try {
            if (!this.zzfkt || !this.zzfkq) {
                return false;
            }
            for (Api.zzc<?> zzc2 : this.zzfkl.keySet()) {
                ConnectionResult connectionResult = this.zzb(zzc2);
                if (connectionResult != null && connectionResult.isSuccess()) continue;
                return false;
            }
            return true;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final boolean zza(zzcv zzcv2) {
        this.zzfke.lock();
        try {
            if (this.zzfkt && !this.zzago()) {
                this.zzfgv.zzafw();
                this.zzfkw = new zzag(this, zzcv2);
                this.zzfgv.zza(this.zzfkl.values()).addOnCompleteListener((Executor)new zzbdy(this.zzakg), (OnCompleteListener)this.zzfkw);
                return true;
            }
            return false;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void zzafp() {
        this.zzfke.lock();
        try {
            this.zzfgv.zzafp();
            if (this.zzfkw != null) {
                this.zzfkw.cancel();
                this.zzfkw = null;
            }
            if (this.zzfkv == null) {
                this.zzfkv = new ArrayMap(this.zzfkl.size());
            }
            ConnectionResult connectionResult = new ConnectionResult(4);
            for (zzac<?> zzac2 : this.zzfkl.values()) {
                this.zzfkv.put(zzac2.zzafk(), connectionResult);
            }
            if (this.zzfku != null) {
                this.zzfku.putAll(this.zzfkv);
            }
            return;
        }
        finally {
            this.zzfke.unlock();
        }
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public final void zzagi() {
    }

    private final void zzagp() {
        if (this.zzfkj == null) {
            this.zzfkn.zzfmo = Collections.emptySet();
            return;
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzfkj.zzajr());
        Map<Api<?>, com.google.android.gms.common.internal.zzs> map = this.zzfkj.zzajt();
        for (Api<?> api : map.keySet()) {
            ConnectionResult connectionResult = this.getConnectionResult(api);
            if (connectionResult == null || !connectionResult.isSuccess()) continue;
            hashSet.addAll(map.get(api).zzecm);
        }
        this.zzfkn.zzfmo = hashSet;
    }

    private final void zzagq() {
        while (!this.zzfks.isEmpty()) {
            this.zze(this.zzfks.remove());
        }
        this.zzfkn.zzj(null);
    }

    private final boolean zza(zzac<?> zzac2, ConnectionResult connectionResult) {
        return !connectionResult.isSuccess() && !connectionResult.hasResolution() && this.zzfkm.get(zzac2.zzafj()) != false && zzac2.zzagn().zzaff() && this.zzfko.isUserResolvableError(connectionResult.getErrorCode());
    }

    @Nullable
    private final ConnectionResult zzagr() {
        ConnectionResult connectionResult = null;
        int n = 0;
        ConnectionResult connectionResult2 = null;
        int n2 = 0;
        for (zzac<?> zzac2 : this.zzfkk.values()) {
            int n3;
            Api api = zzac2.zzafj();
            zzh zzh2 = zzac2.zzafk();
            ConnectionResult connectionResult3 = this.zzfku.get(zzh2);
            if (connectionResult3.isSuccess() || this.zzfkm.get(api).booleanValue() && !connectionResult3.hasResolution() && !this.zzfko.isUserResolvableError(connectionResult3.getErrorCode())) continue;
            if (connectionResult3.getErrorCode() == 4 && this.zzfkq) {
                n3 = api.zzafc().getPriority();
                if (connectionResult2 != null && n2 <= n3) continue;
                connectionResult2 = connectionResult3;
                n2 = n3;
                continue;
            }
            n3 = api.zzafc().getPriority();
            if (connectionResult != null && n <= n3) continue;
            connectionResult = connectionResult3;
            n = n3;
        }
        if (connectionResult != null && connectionResult2 != null && n > n2) {
            return connectionResult2;
        }
        return connectionResult;
    }

    static /* synthetic */ Lock zza(zzad zzad2) {
        return zzad2.zzfke;
    }

    static /* synthetic */ boolean zzb(zzad zzad2) {
        return zzad2.zzfkt;
    }

    static /* synthetic */ Map zza(zzad zzad2, Map map) {
        zzad2.zzfku = map;
        return zzad2.zzfku;
    }

    static /* synthetic */ Map zzc(zzad zzad2) {
        return zzad2.zzfkk;
    }

    static /* synthetic */ Map zzd(zzad zzad2) {
        return zzad2.zzfku;
    }

    static /* synthetic */ boolean zze(zzad zzad2) {
        return zzad2.zzfkr;
    }

    static /* synthetic */ boolean zza(zzad zzad2, zzac zzac2, ConnectionResult connectionResult) {
        return zzad2.zza(zzac2, connectionResult);
    }

    static /* synthetic */ ConnectionResult zza(zzad zzad2, ConnectionResult connectionResult) {
        zzad2.zzfkx = connectionResult;
        return zzad2.zzfkx;
    }

    static /* synthetic */ ConnectionResult zzf(zzad zzad2) {
        return zzad2.zzagr();
    }

    static /* synthetic */ Map zzg(zzad zzad2) {
        return zzad2.zzfkv;
    }

    static /* synthetic */ ConnectionResult zzh(zzad zzad2) {
        return zzad2.zzfkx;
    }

    static /* synthetic */ void zzi(zzad zzad2) {
        zzad2.zzagp();
    }

    static /* synthetic */ void zzj(zzad zzad2) {
        zzad2.zzagq();
    }

    static /* synthetic */ boolean zza(zzad zzad2, boolean bl) {
        zzad2.zzfkt = false;
        return false;
    }

    static /* synthetic */ zzbd zzk(zzad zzad2) {
        return zzad2.zzfkn;
    }

    static /* synthetic */ Condition zzl(zzad zzad2) {
        return zzad2.zzfkp;
    }

    static /* synthetic */ Map zzb(zzad zzad2, Map map) {
        zzad2.zzfkv = map;
        return zzad2.zzfkv;
    }

    static /* synthetic */ Map zzm(zzad zzad2) {
        return zzad2.zzfkl;
    }
}

