/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.location.zzr;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class LocationResult
extends zzbck
implements ReflectedParcelable {
    static final List<Location> zzhyc = Collections.emptyList();
    private final List<Location> zzhyd;
    public static final Parcelable.Creator<LocationResult> CREATOR = new zzr();

    public static LocationResult create(List<Location> list) {
        if (list == null) {
            list = zzhyc;
        }
        return new LocationResult(list);
    }

    LocationResult(List<Location> list) {
        this.zzhyd = list;
    }

    public final Location getLastLocation() {
        int n = this.zzhyd.size();
        if (n == 0) {
            return null;
        }
        return this.zzhyd.get(n - 1);
    }

    @NonNull
    public final List<Location> getLocations() {
        return this.zzhyd;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationResult locationResult = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, locationResult.getLocations(), (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public final int hashCode() {
        int n = 17;
        Iterator<Location> iterator = this.zzhyd.iterator();
        while (iterator.hasNext()) {
            long l = iterator.next().getTime();
            int n2 = (int)(l ^ l >>> 32);
            n = n * 31 + n2;
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof LocationResult)) {
            return false;
        }
        LocationResult locationResult = (LocationResult)((Object)object);
        if (locationResult.zzhyd.size() != this.zzhyd.size()) {
            return false;
        }
        Iterator<Location> iterator = locationResult.zzhyd.iterator();
        Iterator<Location> iterator2 = this.zzhyd.iterator();
        while (iterator.hasNext()) {
            Location location = iterator2.next();
            Location location2 = iterator.next();
            if (location.getTime() == location2.getTime()) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        String string = String.valueOf(this.zzhyd);
        return new StringBuilder(27 + String.valueOf(string).length()).append("LocationResult[locations: ").append(string).append("]").toString();
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.hasExtra("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }

    public static LocationResult extractResult(Intent intent) {
        if (!LocationResult.hasResult(intent)) {
            return null;
        }
        return (LocationResult)intent.getExtras().getParcelable("com.google.android.gms.location.EXTRA_LOCATION_RESULT");
    }
}

