/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.location.zzq;
import java.util.Arrays;

public final class LocationRequest
extends zzbck
implements ReflectedParcelable {
    public static final int PRIORITY_HIGH_ACCURACY = 100;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 102;
    public static final int PRIORITY_LOW_POWER = 104;
    public static final int PRIORITY_NO_POWER = 105;
    private int mPriority;
    private long zzhxx;
    private long zzhxy;
    private boolean zzgzv;
    private long zzhxg;
    private int zzhxz;
    private float zzhya;
    private long zzhyb;
    public static final Parcelable.Creator<LocationRequest> CREATOR = new zzq();

    public static LocationRequest create() {
        return new LocationRequest();
    }

    public LocationRequest() {
        this.mPriority = 102;
        this.zzhxx = 3600000L;
        this.zzhxy = 600000L;
        this.zzgzv = false;
        this.zzhxg = Long.MAX_VALUE;
        this.zzhxz = Integer.MAX_VALUE;
        this.zzhya = 0.0f;
        this.zzhyb = 0L;
    }

    public final LocationRequest setPriority(int n) {
        switch (n) {
            case 100: 
            case 102: 
            case 104: 
            case 105: {
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(28).append("invalid quality: ").append(n).toString());
            }
        }
        this.mPriority = n;
        return this;
    }

    public final int getPriority() {
        return this.mPriority;
    }

    public final LocationRequest setInterval(long l) {
        LocationRequest.zzai(l);
        this.zzhxx = l;
        if (!this.zzgzv) {
            this.zzhxy = (long)((double)this.zzhxx / 6.0);
        }
        return this;
    }

    public final long getInterval() {
        return this.zzhxx;
    }

    public final LocationRequest setMaxWaitTime(long l) {
        LocationRequest.zzai(l);
        this.zzhyb = l;
        return this;
    }

    public final long getMaxWaitTime() {
        long l = this.zzhyb;
        if (l < this.zzhxx) {
            l = this.zzhxx;
        }
        return l;
    }

    public final LocationRequest setFastestInterval(long l) {
        LocationRequest.zzai(l);
        this.zzgzv = true;
        this.zzhxy = l;
        return this;
    }

    public final long getFastestInterval() {
        return this.zzhxy;
    }

    public final LocationRequest setExpirationDuration(long l) {
        long l2 = SystemClock.elapsedRealtime();
        this.zzhxg = l > Long.MAX_VALUE - l2 ? Long.MAX_VALUE : l + l2;
        if (this.zzhxg < 0L) {
            this.zzhxg = 0L;
        }
        return this;
    }

    public final LocationRequest setExpirationTime(long l) {
        this.zzhxg = l;
        if (this.zzhxg < 0L) {
            this.zzhxg = 0L;
        }
        return this;
    }

    public final long getExpirationTime() {
        return this.zzhxg;
    }

    public final LocationRequest setNumUpdates(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid numUpdates: ").append(n).toString());
        }
        this.zzhxz = n;
        return this;
    }

    public final int getNumUpdates() {
        return this.zzhxz;
    }

    public final LocationRequest setSmallestDisplacement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(37).append("invalid displacement: ").append(f).toString());
        }
        this.zzhya = f;
        return this;
    }

    public final float getSmallestDisplacement() {
        return this.zzhya;
    }

    private static void zzai(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(new StringBuilder(38).append("invalid interval: ").append(l).toString());
        }
    }

    LocationRequest(int n, long l, long l2, boolean bl, long l3, int n2, float f, long l4) {
        this.mPriority = n;
        this.zzhxx = l;
        this.zzhxy = l2;
        this.zzgzv = bl;
        this.zzhxg = l3;
        this.zzhxz = n2;
        this.zzhya = f;
        this.zzhyb = l4;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationRequest locationRequest = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, (int)locationRequest.mPriority);
        zzbcn.zza((Parcel)parcel2, (int)2, (long)locationRequest.zzhxx);
        zzbcn.zza((Parcel)parcel2, (int)3, (long)locationRequest.zzhxy);
        zzbcn.zza((Parcel)parcel2, (int)4, (boolean)locationRequest.zzgzv);
        zzbcn.zza((Parcel)parcel2, (int)5, (long)locationRequest.zzhxg);
        zzbcn.zzc((Parcel)parcel2, (int)6, (int)locationRequest.zzhxz);
        zzbcn.zza((Parcel)parcel2, (int)7, (float)locationRequest.zzhya);
        zzbcn.zza((Parcel)parcel2, (int)8, (long)locationRequest.zzhyb);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = stringBuilder.append("Request[");
        switch (this.mPriority) {
            case 100: {
                string = "PRIORITY_HIGH_ACCURACY";
                break;
            }
            case 102: {
                string = "PRIORITY_BALANCED_POWER_ACCURACY";
                break;
            }
            case 104: {
                string = "PRIORITY_LOW_POWER";
                break;
            }
            case 105: {
                string = "PRIORITY_NO_POWER";
                break;
            }
            default: {
                string = "???";
            }
        }
        stringBuilder2.append(string);
        if (this.mPriority != 105) {
            stringBuilder.append(" requested=");
            stringBuilder.append(this.zzhxx).append("ms");
        }
        stringBuilder.append(" fastest=");
        stringBuilder.append(this.zzhxy).append("ms");
        if (this.zzhyb > this.zzhxx) {
            stringBuilder.append(" maxWait=");
            stringBuilder.append(this.zzhyb).append("ms");
        }
        if (this.zzhya > 0.0f) {
            stringBuilder.append(" smallestDisplacement=");
            stringBuilder.append(this.zzhya).append("m");
        }
        if (this.zzhxg != Long.MAX_VALUE) {
            long l = this.zzhxg - SystemClock.elapsedRealtime();
            stringBuilder.append(" expireIn=");
            stringBuilder.append(l).append("ms");
        }
        if (this.zzhxz != Integer.MAX_VALUE) {
            stringBuilder.append(" num=").append(this.zzhxz);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.mPriority, this.zzhxx, Float.valueOf(this.zzhya), this.zzhyb});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequest)) {
            return false;
        }
        LocationRequest locationRequest = (LocationRequest)((Object)object);
        return this.mPriority == locationRequest.mPriority && this.zzhxx == locationRequest.zzhxx && this.zzhxy == locationRequest.zzhxy && this.zzgzv == locationRequest.zzgzv && this.zzhxg == locationRequest.zzhxg && this.zzhxz == locationRequest.zzhxz && this.zzhya == locationRequest.zzhya && this.getMaxWaitTime() == locationRequest.getMaxWaitTime();
    }
}

