/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzcac;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.zzi;
import java.util.ArrayList;
import java.util.List;

public class GeofencingRequest
extends zzbck {
    public static final int INITIAL_TRIGGER_ENTER = 1;
    public static final int INITIAL_TRIGGER_EXIT = 2;
    public static final int INITIAL_TRIGGER_DWELL = 4;
    public static final Parcelable.Creator<GeofencingRequest> CREATOR = new zzi();
    private final List<zzcac> zzhxq;
    private final int zzhxr;
    private final String mTag;

    GeofencingRequest(List<zzcac> list, int n, String string) {
        this.zzhxq = list;
        this.zzhxr = n;
        this.mTag = string;
    }

    public List<Geofence> getGeofences() {
        ArrayList<Geofence> arrayList = new ArrayList<Geofence>();
        arrayList.addAll(this.zzhxq);
        return arrayList;
    }

    public int getInitialTrigger() {
        return this.zzhxr;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GeofencingRequest geofencingRequest = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, geofencingRequest.zzhxq, (boolean)false);
        zzbcn.zzc((Parcel)parcel2, (int)2, (int)geofencingRequest.getInitialTrigger());
        zzbcn.zza((Parcel)parcel2, (int)3, (String)geofencingRequest.mTag, (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeofencingRequest[");
        stringBuilder.append("geofences=");
        stringBuilder.append(this.zzhxq);
        int n = this.zzhxr;
        stringBuilder.append(new StringBuilder(30).append(", initialTrigger=").append(n).append(", ").toString());
        String string = String.valueOf(this.mTag);
        stringBuilder.append(string.length() != 0 ? "tag=".concat(string) : new String("tag="));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static final class Builder {
        private final List<zzcac> zzhxq = new ArrayList<zzcac>();
        private int zzhxr = 5;
        private String mTag = "";

        public Builder() {
        }

        public final Builder addGeofence(Geofence geofence) {
            zzbp.zzb((Object)geofence, (Object)"geofence can't be null.");
            zzbp.zzb((boolean)(geofence instanceof zzcac), (Object)"Geofence must be created using Geofence.Builder.");
            this.zzhxq.add((zzcac)geofence);
            return this;
        }

        public final Builder addGeofences(List<Geofence> list) {
            if (list == null || list.isEmpty()) {
                return this;
            }
            for (Geofence geofence : list) {
                if (geofence == null) continue;
                this.addGeofence(geofence);
            }
            return this;
        }

        public final Builder setInitialTrigger(int n) {
            this.zzhxr = n & 7;
            return this;
        }

        public final GeofencingRequest build() {
            zzbp.zzb((!this.zzhxq.isEmpty() ? 1 : 0) != 0, (Object)"No geofence has been added to this request.");
            return new GeofencingRequest(this.zzhxq, this.zzhxr, this.mTag);
        }
    }
}

