/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzcad;
import com.google.android.gms.location.Geofence;
import java.util.Locale;

public final class zzcac
extends zzbck
implements Geofence {
    private final String zzcjw;
    private final long zziaf;
    private final short zzhxh;
    private final double zzhxi;
    private final double zzhxj;
    private final float zzhxk;
    private final int zzhxf;
    private final int zzhxl;
    private final int zzhxm;
    public static final Parcelable.Creator<zzcac> CREATOR = new zzcad();

    public zzcac(String string, int n, short s, double d, double d2, float f, long l, int n2, int n3) {
        float f2;
        String string2 = string;
        if (string2 == null || string2.length() > 100) {
            String string3 = String.valueOf(string2);
            throw new IllegalArgumentException(string3.length() != 0 ? "requestId is null or too long: ".concat(string3) : new String("requestId is null or too long: "));
        }
        float f3 = f;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(31).append("invalid radius: ").append(f3).toString());
        }
        double d3 = d2;
        double d4 = d;
        if (d4 > 90.0 || d4 < -90.0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("invalid latitude: ").append(d4).toString());
        }
        if (d3 > 180.0 || d3 < -180.0) {
            throw new IllegalArgumentException(new StringBuilder(43).append("invalid longitude: ").append(d3).toString());
        }
        int n4 = n;
        int n5 = n4 & 7;
        if (n5 == 0) {
            throw new IllegalArgumentException(new StringBuilder(46).append("No supported transition specified: ").append(n4).toString());
        }
        n = n5;
        this.zzhxh = s;
        this.zzcjw = string;
        this.zzhxi = d;
        this.zzhxj = d2;
        this.zzhxk = f;
        this.zziaf = l;
        this.zzhxf = n;
        this.zzhxl = n2;
        this.zzhxm = n3;
    }

    @Override
    public final String getRequestId() {
        return this.zzcjw;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzcac zzcac2 = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)1, (String)zzcac2.getRequestId(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (long)zzcac2.zziaf);
        zzbcn.zza((Parcel)parcel2, (int)3, (short)zzcac2.zzhxh);
        zzbcn.zza((Parcel)parcel2, (int)4, (double)zzcac2.zzhxi);
        zzbcn.zza((Parcel)parcel2, (int)5, (double)zzcac2.zzhxj);
        zzbcn.zza((Parcel)parcel2, (int)6, (float)zzcac2.zzhxk);
        zzbcn.zzc((Parcel)parcel2, (int)7, (int)zzcac2.zzhxf);
        zzbcn.zzc((Parcel)parcel2, (int)8, (int)zzcac2.zzhxl);
        zzbcn.zzc((Parcel)parcel2, (int)9, (int)zzcac2.zzhxm);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public static zzcac zzo(byte[] byArray) {
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        zzcac zzcac2 = (zzcac)CREATOR.createFromParcel(parcel);
        parcel.recycle();
        return zzcac2;
    }

    public final String toString() {
        String string;
        Object[] objectArray = new Object[9];
        switch (this.zzhxh) {
            case 1: {
                string = "CIRCLE";
                break;
            }
            default: {
                string = null;
            }
        }
        objectArray[0] = string;
        objectArray[1] = this.zzcjw;
        objectArray[2] = this.zzhxf;
        objectArray[3] = this.zzhxi;
        objectArray[4] = this.zzhxj;
        objectArray[5] = Float.valueOf(this.zzhxk);
        objectArray[6] = this.zzhxl / 1000;
        objectArray[7] = this.zzhxm;
        objectArray[8] = this.zziaf;
        return String.format(Locale.US, "Geofence[%s id:%s transitions:%d %.6f, %.6f %.0fm, resp=%ds, dwell=%dms, @%d]", objectArray);
    }

    public final int hashCode() {
        long l = Double.doubleToLongBits(this.zzhxi);
        int n = 31 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zzhxj);
        n = n * 31 + (int)(l ^ l >>> 32);
        n = n * 31 + Float.floatToIntBits(this.zzhxk);
        n = n * 31 + this.zzhxh;
        return n * 31 + this.zzhxf;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof zzcac)) {
            return false;
        }
        zzcac zzcac2 = (zzcac)object;
        if (this.zzhxk != zzcac2.zzhxk) {
            return false;
        }
        if (this.zzhxi != zzcac2.zzhxi) {
            return false;
        }
        if (this.zzhxj != zzcac2.zzhxj) {
            return false;
        }
        return this.zzhxh == zzcac2.zzhxh;
    }
}

