/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.zzd;

public final class GroundOverlayOptions
extends zzbck {
    public static final Parcelable.Creator<GroundOverlayOptions> CREATOR = new zzd();
    public static final float NO_DIMENSION = -1.0f;
    @NonNull
    private BitmapDescriptor zziit;
    private LatLng zziiu;
    private float zziiv;
    private float zziiw;
    private LatLngBounds zziet;
    private float zziij;
    private float zziio;
    private boolean zziip = true;
    private float zziix = 0.0f;
    private float zziiy = 0.5f;
    private float zziiz = 0.5f;
    private boolean zziiq = false;

    GroundOverlayOptions(IBinder iBinder, LatLng latLng, float f, float f2, LatLngBounds latLngBounds, float f3, float f4, boolean bl, float f5, float f6, float f7, boolean bl2) {
        this.zziit = new BitmapDescriptor(IObjectWrapper.zza.zzao((IBinder)iBinder));
        this.zziiu = latLng;
        this.zziiv = f;
        this.zziiw = f2;
        this.zziet = latLngBounds;
        this.zziij = f3;
        this.zziio = f4;
        this.zziip = bl;
        this.zziix = f5;
        this.zziiy = f6;
        this.zziiz = f7;
        this.zziiq = bl2;
    }

    public GroundOverlayOptions() {
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GroundOverlayOptions groundOverlayOptions = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zza((Parcel)parcel2, (int)2, (IBinder)groundOverlayOptions.zziit.zzatl().asBinder(), (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)3, (Parcelable)groundOverlayOptions.getLocation(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)4, (float)groundOverlayOptions.getWidth());
        zzbcn.zza((Parcel)parcel2, (int)5, (float)groundOverlayOptions.getHeight());
        zzbcn.zza((Parcel)parcel2, (int)6, (Parcelable)groundOverlayOptions.getBounds(), (int)n, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)7, (float)groundOverlayOptions.getBearing());
        zzbcn.zza((Parcel)parcel2, (int)8, (float)groundOverlayOptions.getZIndex());
        zzbcn.zza((Parcel)parcel2, (int)9, (boolean)groundOverlayOptions.isVisible());
        zzbcn.zza((Parcel)parcel2, (int)10, (float)groundOverlayOptions.getTransparency());
        zzbcn.zza((Parcel)parcel2, (int)11, (float)groundOverlayOptions.getAnchorU());
        zzbcn.zza((Parcel)parcel2, (int)12, (float)groundOverlayOptions.getAnchorV());
        zzbcn.zza((Parcel)parcel2, (int)13, (boolean)groundOverlayOptions.isClickable());
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }

    public final GroundOverlayOptions image(@NonNull BitmapDescriptor bitmapDescriptor) {
        zzbp.zzb((Object)bitmapDescriptor, (Object)"imageDescriptor must not be null");
        this.zziit = bitmapDescriptor;
        return this;
    }

    public final GroundOverlayOptions anchor(float f, float f2) {
        this.zziiy = f;
        this.zziiz = f2;
        return this;
    }

    public final GroundOverlayOptions position(LatLng latLng, float f) {
        zzbp.zza((this.zziet == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbp.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbp.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        return this.zza(latLng, f, -1.0f);
    }

    public final GroundOverlayOptions position(LatLng latLng, float f, float f2) {
        zzbp.zza((this.zziet == null ? 1 : 0) != 0, (Object)"Position has already been set using positionFromBounds");
        zzbp.zzb((latLng != null ? 1 : 0) != 0, (Object)"Location must be specified");
        zzbp.zzb((f >= 0.0f ? 1 : 0) != 0, (Object)"Width must be non-negative");
        zzbp.zzb((f2 >= 0.0f ? 1 : 0) != 0, (Object)"Height must be non-negative");
        return this.zza(latLng, f, f2);
    }

    private final GroundOverlayOptions zza(LatLng latLng, float f, float f2) {
        this.zziiu = latLng;
        this.zziiv = f;
        this.zziiw = f2;
        return this;
    }

    public final GroundOverlayOptions positionFromBounds(LatLngBounds latLngBounds) {
        String string = String.valueOf((Object)this.zziiu);
        zzbp.zza((this.zziiu == null ? 1 : 0) != 0, (Object)new StringBuilder(46 + String.valueOf(string).length()).append("Position has already been set using position: ").append(string).toString());
        this.zziet = latLngBounds;
        return this;
    }

    public final GroundOverlayOptions bearing(float f) {
        this.zziij = (f % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public final GroundOverlayOptions zIndex(float f) {
        this.zziio = f;
        return this;
    }

    public final GroundOverlayOptions visible(boolean bl) {
        this.zziip = bl;
        return this;
    }

    public final GroundOverlayOptions transparency(float f) {
        zzbp.zzb((f >= 0.0f && f <= 1.0f ? 1 : 0) != 0, (Object)"Transparency must be in the range [0..1]");
        this.zziix = f;
        return this;
    }

    public final GroundOverlayOptions clickable(boolean bl) {
        this.zziiq = bl;
        return this;
    }

    public final BitmapDescriptor getImage() {
        return this.zziit;
    }

    public final LatLng getLocation() {
        return this.zziiu;
    }

    public final float getWidth() {
        return this.zziiv;
    }

    public final float getHeight() {
        return this.zziiw;
    }

    public final LatLngBounds getBounds() {
        return this.zziet;
    }

    public final float getBearing() {
        return this.zziij;
    }

    public final float getZIndex() {
        return this.zziio;
    }

    public final float getTransparency() {
        return this.zziix;
    }

    public final float getAnchorU() {
        return this.zziiy;
    }

    public final float getAnchorV() {
        return this.zziiz;
    }

    public final boolean isVisible() {
        return this.zziip;
    }

    public final boolean isClickable() {
        return this.zziiq;
    }
}

