/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.os.SystemClock;
import com.google.android.gms.internal.zzcac;

public interface Geofence {
    public static final int GEOFENCE_TRANSITION_ENTER = 1;
    public static final int GEOFENCE_TRANSITION_EXIT = 2;
    public static final int GEOFENCE_TRANSITION_DWELL = 4;
    public static final long NEVER_EXPIRE = -1L;

    public String getRequestId();

    public static final class Builder {
        private String zzcjw = null;
        private int zzhxf = 0;
        private long zzhxg = Long.MIN_VALUE;
        private short zzhxh = (short)-1;
        private double zzhxi;
        private double zzhxj;
        private float zzhxk;
        private int zzhxl = 0;
        private int zzhxm = -1;

        public Builder() {
        }

        public final Builder setRequestId(String string) {
            this.zzcjw = string;
            return this;
        }

        public final Builder setTransitionTypes(int n) {
            this.zzhxf = n;
            return this;
        }

        public final Builder setExpirationDuration(long l) {
            this.zzhxg = l < 0L ? -1L : SystemClock.elapsedRealtime() + l;
            return this;
        }

        public final Builder setCircularRegion(double d, double d2, float f) {
            this.zzhxh = 1;
            this.zzhxi = d;
            this.zzhxj = d2;
            this.zzhxk = f;
            return this;
        }

        public final Builder setNotificationResponsiveness(int n) {
            this.zzhxl = n;
            return this;
        }

        public final Builder setLoiteringDelay(int n) {
            this.zzhxm = n;
            return this;
        }

        public final Geofence build() {
            if (this.zzcjw == null) {
                throw new IllegalArgumentException("Request ID not set.");
            }
            if (this.zzhxf == 0) {
                throw new IllegalArgumentException("Transitions types not set.");
            }
            if ((this.zzhxf & 4) != 0 && this.zzhxm < 0) {
                throw new IllegalArgumentException("Non-negative loitering delay needs to be set when transition types include GEOFENCE_TRANSITION_DWELLING.");
            }
            if (this.zzhxg == Long.MIN_VALUE) {
                throw new IllegalArgumentException("Expiration not set.");
            }
            if (this.zzhxh == -1) {
                throw new IllegalArgumentException("Geofence region not set.");
            }
            if (this.zzhxl < 0) {
                throw new IllegalArgumentException("Notification responsiveness should be nonnegative.");
            }
            return new zzcac(this.zzcjw, this.zzhxf, 1, this.zzhxi, this.zzhxj, this.zzhxk, this.zzhxg, this.zzhxl, this.zzhxm);
        }
    }
}

