/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import com.google.android.gms.internal.zzbcp;
import com.google.android.gms.location.DetectedActivity;
import com.google.android.gms.location.zzb;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ActivityRecognitionResult
extends zzbck
implements ReflectedParcelable {
    public static final Parcelable.Creator<ActivityRecognitionResult> CREATOR = new zzb();
    private List<DetectedActivity> zzhwu;
    private long zzhwv;
    private long zzhww;
    private int zzhwx;
    private Bundle extras;

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2) {
        this(list, l, l2, 0, null);
    }

    public ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2) {
        this(detectedActivity, l, l2, 0, null);
    }

    private ActivityRecognitionResult(DetectedActivity detectedActivity, long l, long l2, int n, Bundle bundle) {
        this(Collections.singletonList(detectedActivity), l, l2, 0, null);
    }

    public static boolean hasResult(Intent intent) {
        if (intent == null) {
            return false;
        }
        Intent intent2 = intent;
        if (intent2 == null ? false : intent2.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT")) {
            return true;
        }
        List<ActivityRecognitionResult> list = ActivityRecognitionResult.zzj(intent);
        return list != null && !list.isEmpty();
    }

    /*
     * Unable to fully structure code
     */
    public static ActivityRecognitionResult extractResult(Intent var0) {
        var3_1 = var0;
        if (!ActivityRecognitionResult.hasResult(var3_1)) ** GOTO lbl-1000
        var4_2 = var3_1.getExtras().get("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT");
        if (var4_2 instanceof byte[]) {
            v0 = (ActivityRecognitionResult)zzbcp.zza((byte[])((byte[])var4_2), ActivityRecognitionResult.CREATOR);
        } else if (var4_2 instanceof ActivityRecognitionResult) {
            v0 = (ActivityRecognitionResult)var4_2;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var1_3 = null;
        }
        if (v0 != null) {
            return var1_3;
        }
        var2_4 = ActivityRecognitionResult.zzj(var0);
        if (var2_4 == null || var2_4.isEmpty()) {
            return null;
        }
        return var2_4.get(var2_4.size() - 1);
    }

    @Nullable
    private static List<ActivityRecognitionResult> zzj(Intent intent) {
        Intent intent2 = intent;
        if (!(intent2 == null ? false : intent2.hasExtra("com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST"))) {
            return null;
        }
        return zzbcp.zzb((Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_RESULT_LIST", CREATOR);
    }

    public DetectedActivity getMostProbableActivity() {
        return this.zzhwu.get(0);
    }

    public int getActivityConfidence(int n) {
        for (DetectedActivity detectedActivity : this.zzhwu) {
            if (detectedActivity.getType() != n) continue;
            return detectedActivity.getConfidence();
        }
        return 0;
    }

    public List<DetectedActivity> getProbableActivities() {
        return this.zzhwu;
    }

    public long getTime() {
        return this.zzhwv;
    }

    public long getElapsedRealtimeMillis() {
        return this.zzhww;
    }

    public String toString() {
        String string = String.valueOf(this.zzhwu);
        long l = this.zzhwv;
        long l2 = this.zzhww;
        return new StringBuilder(124 + String.valueOf(string).length()).append("ActivityRecognitionResult [probableActivities=").append(string).append(", timeMillis=").append(l).append(", elapsedRealtimeMillis=").append(l2).append("]").toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityRecognitionResult activityRecognitionResult = (ActivityRecognitionResult)((Object)object);
        return this.zzhwv == activityRecognitionResult.zzhwv && this.zzhww == activityRecognitionResult.zzhww && this.zzhwx == activityRecognitionResult.zzhwx && zzbf.equal(this.zzhwu, activityRecognitionResult.zzhwu) && ActivityRecognitionResult.zzc(this.extras, activityRecognitionResult.extras);
    }

    private static boolean zzc(Bundle bundle, Bundle bundle2) {
        if (bundle == null && bundle2 == null) {
            return true;
        }
        if (bundle == null && bundle2 != null || bundle != null && bundle2 == null) {
            return false;
        }
        if (bundle.size() != bundle2.size()) {
            return false;
        }
        for (String string : bundle.keySet()) {
            if (!bundle2.containsKey(string)) {
                return false;
            }
            if (!(bundle.get(string) == null ? bundle2.get(string) != null : (bundle.get(string) instanceof Bundle ? !ActivityRecognitionResult.zzc(bundle.getBundle(string), bundle2.getBundle(string)) : !bundle.get(string).equals(bundle2.get(string))))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzhwv, this.zzhww, this.zzhwx, this.zzhwu, this.extras});
    }

    public ActivityRecognitionResult(List<DetectedActivity> list, long l, long l2, int n, Bundle bundle) {
        zzbp.zzb((list != null && list.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least 1 detected activity");
        zzbp.zzb((l > 0L && l2 > 0L ? 1 : 0) != 0, (Object)"Must set times");
        this.zzhwu = list;
        this.zzhwv = l;
        this.zzhww = l2;
        this.zzhwx = n;
        this.extras = bundle;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityRecognitionResult activityRecognitionResult = this;
        int n2 = zzbcn.zze((Parcel)parcel2);
        zzbcn.zzc((Parcel)parcel2, (int)1, activityRecognitionResult.zzhwu, (boolean)false);
        zzbcn.zza((Parcel)parcel2, (int)2, (long)activityRecognitionResult.zzhwv);
        zzbcn.zza((Parcel)parcel2, (int)3, (long)activityRecognitionResult.zzhww);
        zzbcn.zzc((Parcel)parcel2, (int)4, (int)activityRecognitionResult.zzhwx);
        zzbcn.zza((Parcel)parcel2, (int)5, (Bundle)activityRecognitionResult.extras, (boolean)false);
        zzbcn.zzai((Parcel)parcel2, (int)n2);
    }
}

