/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.util;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.util.ThreadUtil;
import android.support.v7.util.TileList;
import android.util.Log;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

class MessageThreadUtil<T>
implements ThreadUtil<T> {
    MessageThreadUtil() {
    }

    @Override
    public ThreadUtil.MainThreadCallback<T> getMainThreadProxy(final ThreadUtil.MainThreadCallback<T> callback) {
        return new ThreadUtil.MainThreadCallback<T>(){
            final MessageQueue mQueue = new MessageQueue();
            private final Handler mMainThreadHandler = new Handler(Looper.getMainLooper());
            static final int UPDATE_ITEM_COUNT = 1;
            static final int ADD_TILE = 2;
            static final int REMOVE_TILE = 3;
            private Runnable mMainThreadRunnable = new Runnable(){

                @Override
                public void run() {
                    SyncQueueItem msg = mQueue.next();
                    while (msg != null) {
                        switch (msg.what) {
                            case 1: {
                                callback.updateItemCount(msg.arg1, msg.arg2);
                                break;
                            }
                            case 2: {
                                callback.addTile(msg.arg1, (TileList.Tile)msg.data);
                                break;
                            }
                            case 3: {
                                callback.removeTile(msg.arg1, msg.arg2);
                                break;
                            }
                            default: {
                                Log.e((String)"ThreadUtil", (String)("Unsupported message, what=" + msg.what));
                            }
                        }
                        msg = mQueue.next();
                    }
                }
            };

            @Override
            public void updateItemCount(int generation, int itemCount) {
                this.sendMessage(SyncQueueItem.obtainMessage(1, generation, itemCount));
            }

            @Override
            public void addTile(int generation, TileList.Tile<T> tile) {
                this.sendMessage(SyncQueueItem.obtainMessage(2, generation, tile));
            }

            @Override
            public void removeTile(int generation, int position) {
                this.sendMessage(SyncQueueItem.obtainMessage(3, generation, position));
            }

            private void sendMessage(SyncQueueItem msg) {
                this.mQueue.sendMessage(msg);
                this.mMainThreadHandler.post(this.mMainThreadRunnable);
            }
        };
    }

    @Override
    public ThreadUtil.BackgroundCallback<T> getBackgroundProxy(final ThreadUtil.BackgroundCallback<T> callback) {
        return new ThreadUtil.BackgroundCallback<T>(){
            final MessageQueue mQueue = new MessageQueue();
            private final Executor mExecutor = AsyncTask.THREAD_POOL_EXECUTOR;
            AtomicBoolean mBackgroundRunning = new AtomicBoolean(false);
            static final int REFRESH = 1;
            static final int UPDATE_RANGE = 2;
            static final int LOAD_TILE = 3;
            static final int RECYCLE_TILE = 4;
            private Runnable mBackgroundRunnable = new Runnable(){

                @Override
                public void run() {
                    SyncQueueItem msg;
                    block6: while ((msg = mQueue.next()) != null) {
                        switch (msg.what) {
                            case 1: {
                                mQueue.removeMessages(1);
                                callback.refresh(msg.arg1);
                                continue block6;
                            }
                            case 2: {
                                mQueue.removeMessages(2);
                                mQueue.removeMessages(3);
                                callback.updateRange(msg.arg1, msg.arg2, msg.arg3, msg.arg4, msg.arg5);
                                continue block6;
                            }
                            case 3: {
                                callback.loadTile(msg.arg1, msg.arg2);
                                continue block6;
                            }
                            case 4: {
                                callback.recycleTile((TileList.Tile)msg.data);
                                continue block6;
                            }
                        }
                        Log.e((String)"ThreadUtil", (String)("Unsupported message, what=" + msg.what));
                    }
                    mBackgroundRunning.set(false);
                }
            };

            @Override
            public void refresh(int generation) {
                this.sendMessageAtFrontOfQueue(SyncQueueItem.obtainMessage(1, generation, null));
            }

            @Override
            public void updateRange(int rangeStart, int rangeEnd, int extRangeStart, int extRangeEnd, int scrollHint) {
                this.sendMessageAtFrontOfQueue(SyncQueueItem.obtainMessage(2, rangeStart, rangeEnd, extRangeStart, extRangeEnd, scrollHint, null));
            }

            @Override
            public void loadTile(int position, int scrollHint) {
                this.sendMessage(SyncQueueItem.obtainMessage(3, position, scrollHint));
            }

            @Override
            public void recycleTile(TileList.Tile<T> tile) {
                this.sendMessage(SyncQueueItem.obtainMessage(4, 0, tile));
            }

            private void sendMessage(SyncQueueItem msg) {
                this.mQueue.sendMessage(msg);
                this.maybeExecuteBackgroundRunnable();
            }

            private void sendMessageAtFrontOfQueue(SyncQueueItem msg) {
                this.mQueue.sendMessageAtFrontOfQueue(msg);
                this.maybeExecuteBackgroundRunnable();
            }

            private void maybeExecuteBackgroundRunnable() {
                if (this.mBackgroundRunning.compareAndSet(false, true)) {
                    this.mExecutor.execute(this.mBackgroundRunnable);
                }
            }
        };
    }

    static class MessageQueue {
        private SyncQueueItem mRoot;

        MessageQueue() {
        }

        synchronized SyncQueueItem next() {
            if (this.mRoot == null) {
                return null;
            }
            SyncQueueItem next = this.mRoot;
            this.mRoot = this.mRoot.next;
            return next;
        }

        synchronized void sendMessageAtFrontOfQueue(SyncQueueItem item) {
            item.next = this.mRoot;
            this.mRoot = item;
        }

        synchronized void sendMessage(SyncQueueItem item) {
            if (this.mRoot == null) {
                this.mRoot = item;
                return;
            }
            SyncQueueItem last = this.mRoot;
            while (last.next != null) {
                last = last.next;
            }
            last.next = item;
        }

        synchronized void removeMessages(int what) {
            while (this.mRoot != null && this.mRoot.what == what) {
                SyncQueueItem item = this.mRoot;
                this.mRoot = this.mRoot.next;
                item.recycle();
            }
            if (this.mRoot != null) {
                SyncQueueItem prev = this.mRoot;
                SyncQueueItem item = prev.next;
                while (item != null) {
                    SyncQueueItem next = item.next;
                    if (item.what == what) {
                        prev.next = next;
                        item.recycle();
                    } else {
                        prev = item;
                    }
                    item = next;
                }
            }
        }
    }

    static class SyncQueueItem {
        private static SyncQueueItem sPool;
        private static final Object sPoolLock;
        private SyncQueueItem next;
        public int what;
        public int arg1;
        public int arg2;
        public int arg3;
        public int arg4;
        public int arg5;
        public Object data;

        SyncQueueItem() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void recycle() {
            this.next = null;
            this.arg5 = 0;
            this.arg4 = 0;
            this.arg3 = 0;
            this.arg2 = 0;
            this.arg1 = 0;
            this.what = 0;
            this.data = null;
            Object object = sPoolLock;
            synchronized (object) {
                if (sPool != null) {
                    this.next = sPool;
                }
                sPool = this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static SyncQueueItem obtainMessage(int what, int arg1, int arg2, int arg3, int arg4, int arg5, Object data) {
            Object object = sPoolLock;
            synchronized (object) {
                SyncQueueItem item;
                if (sPool == null) {
                    item = new SyncQueueItem();
                } else {
                    item = sPool;
                    sPool = SyncQueueItem.sPool.next;
                    item.next = null;
                }
                item.what = what;
                item.arg1 = arg1;
                item.arg2 = arg2;
                item.arg3 = arg3;
                item.arg4 = arg4;
                item.arg5 = arg5;
                item.data = data;
                return item;
            }
        }

        static SyncQueueItem obtainMessage(int what, int arg1, int arg2) {
            return SyncQueueItem.obtainMessage(what, arg1, arg2, 0, 0, 0, null);
        }

        static SyncQueueItem obtainMessage(int what, int arg1, Object data) {
            return SyncQueueItem.obtainMessage(what, arg1, 0, 0, 0, 0, data);
        }

        static {
            sPoolLock = new Object();
        }
    }
}

