/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.ViewOffsetBehavior;
import android.support.v4.math.MathUtils;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.util.AttributeSet;
import android.view.View;
import java.util.List;

abstract class HeaderScrollingViewBehavior
extends ViewOffsetBehavior<View> {
    final Rect mTempRect1 = new Rect();
    final Rect mTempRect2 = new Rect();
    private int mVerticalLayoutGap = 0;
    private int mOverlayTop;

    public HeaderScrollingViewBehavior() {
    }

    public HeaderScrollingViewBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onMeasureChild(CoordinatorLayout parent, View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        List<View> dependencies;
        View header;
        int childLpHeight = child.getLayoutParams().height;
        if ((childLpHeight == -1 || childLpHeight == -2) && (header = this.findFirstDependency(dependencies = parent.getDependencies(child))) != null) {
            int availableHeight;
            if (ViewCompat.getFitsSystemWindows((View)header) && !ViewCompat.getFitsSystemWindows((View)child)) {
                ViewCompat.setFitsSystemWindows((View)child, (boolean)true);
                if (ViewCompat.getFitsSystemWindows((View)child)) {
                    child.requestLayout();
                    return true;
                }
            }
            if ((availableHeight = View.MeasureSpec.getSize((int)parentHeightMeasureSpec)) == 0) {
                availableHeight = parent.getHeight();
            }
            int height = availableHeight - header.getMeasuredHeight() + this.getScrollRange(header);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)(childLpHeight == -1 ? 0x40000000 : Integer.MIN_VALUE));
            parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, heightMeasureSpec, heightUsed);
            return true;
        }
        return false;
    }

    @Override
    protected void layoutChild(CoordinatorLayout parent, View child, int layoutDirection) {
        List<View> dependencies = parent.getDependencies(child);
        View header = this.findFirstDependency(dependencies);
        if (header != null) {
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            Rect available = this.mTempRect1;
            available.set(parent.getPaddingLeft() + lp.leftMargin, header.getBottom() + lp.topMargin, parent.getWidth() - parent.getPaddingRight() - lp.rightMargin, parent.getHeight() + header.getBottom() - parent.getPaddingBottom() - lp.bottomMargin);
            WindowInsetsCompat parentInsets = parent.getLastWindowInsets();
            if (parentInsets != null && ViewCompat.getFitsSystemWindows((View)parent) && !ViewCompat.getFitsSystemWindows((View)child)) {
                available.left += parentInsets.getSystemWindowInsetLeft();
                available.right -= parentInsets.getSystemWindowInsetRight();
            }
            Rect out = this.mTempRect2;
            GravityCompat.apply((int)HeaderScrollingViewBehavior.resolveGravity(lp.gravity), (int)child.getMeasuredWidth(), (int)child.getMeasuredHeight(), (Rect)available, (Rect)out, (int)layoutDirection);
            int overlap = this.getOverlapPixelsForOffset(header);
            child.layout(out.left, out.top - overlap, out.right, out.bottom - overlap);
            this.mVerticalLayoutGap = out.top - header.getBottom();
        } else {
            super.layoutChild(parent, child, layoutDirection);
            this.mVerticalLayoutGap = 0;
        }
    }

    float getOverlapRatioForOffset(View header) {
        return 1.0f;
    }

    final int getOverlapPixelsForOffset(View header) {
        return this.mOverlayTop == 0 ? 0 : MathUtils.clamp((int)((int)(this.getOverlapRatioForOffset(header) * (float)this.mOverlayTop)), (int)0, (int)this.mOverlayTop);
    }

    private static int resolveGravity(int gravity) {
        return gravity == 0 ? 0x800033 : gravity;
    }

    abstract View findFirstDependency(List<View> var1);

    int getScrollRange(View v) {
        return v.getMeasuredHeight();
    }

    final int getVerticalLayoutGap() {
        return this.mVerticalLayoutGap;
    }

    public final void setOverlayTop(int overlayTop) {
        this.mOverlayTop = overlayTop;
    }

    public final int getOverlayTop() {
        return this.mOverlayTop;
    }
}

