# 前言

> 标题：ProjectionNet: Learning Efficient On-Device Deep Networks Using Neural Projections\
> 原文链接：[Link](https://arxiv.org/pdf/1708.00630.pdf)\
> Github：[NLP相关Paper笔记和代码复现](https://github.com/DengBoCong/nlp-paper)
> 说明：阅读论文时进行相关思想、结构、优缺点，内容进行提炼和记录，论文和相关引用会标明出处，引用之处如有侵权，烦请告知删除。\
> 转载请注明：DengBoCong

# 介绍
众所周知，深度学习网络通常很大，包括涉及许多层的参数，并经过大量数据训练，以学习可用于在推理时预测输出的有用表示形式，所以为了达到高效率，我们使用分布式计算达到目标，这将需要多个CPU内核或图形处理单元（GPU）。随着移动端设备的普及，我们自然而然的想将这些模型应用到移动端设备上，但是，与在云上运行的高性能群集不同，这些设备在低功耗模式下运行，并且存在显着的内存限制，所以如果还是使用老方法，完全是行不通的。

即使将模型部署在云端，通过网络连接的方式进行使用，也会涉及到连接性问题（数据无法发送到服务器）或隐私原因（某些数据类型和处理需要限制在某些范围内），而且在许多实际场景中，将计算密集型操作从设备委派给云并不可行。还有就是模型压缩，降低浮点精度等等手段去缩减模型体积，其实在某些情况下，达不到应用场景的精度需要。所以需要有一个学习高效，具有低内存占用量的设备上机器学习模型的能力，这些模型可以直接在设备上运行以进行推理，并且计算成本较低

论文中介绍了一种叫ProjectionNet的联合框架，可以为不同机器学习模型架构训练轻量的设备端模型。其使用复杂的前馈/循环架构（就像 LSTM）作为训练模型，联合一个简单的投影（projection）架构——其中包含动态投影操作以及一些窄带全连接层。整个架构使用反向传播在 TensorFlow 上进行端到端训练，在训练完成后，我们就可以直接使用紧凑的 ProjectionNet 进行推理了。通过这种方法，我们可以训练尺寸很小的 ProjectionNet 模型，兼顾小尺寸（比常规模型小几个数量级）与高性能，在一些视觉和语言分类任务中达到满意的效果。

# 相关工作
许多相关工作通过在有限的大小或内存限制下学习有效的模型，比如简单的字典查找、特征修剪或散列的神经网络压缩的技术，以及降低的数字精度、矢量量化、网络的二值化策略、权重共享来实现神经网络的紧凑表示。这些方法大多数旨在通过使用低秩分解或哈希技巧对连接进行分组来利用网络权重中的冗余。

相反，本论文中建议学习一个简单的基于投影（projection）的网络，该网络可以有效地编码中间网络表示形式（即隐藏单元）和所涉及的操作，而不是权重。同时还为设备模型引入了新的训练范例，其中简单网络经过耦合和联合训练可以模仿现有的深度网络，而且该深度网络非常灵活，可以根据不同的体系结构或任务进行自定义。

# 神经投影网络（Neural Projection Networks）
## ProjectionNets
神经网络是一类非线性模型，用于学习从输入 $\vec{x}_i$ 到输出 $y_i$ 的映射，其中 $\vec{x}_i$ 表示输入特征向量或序列（在递归神经网络的情况下），而 $y_i$ 是分类任务的输出类别或预测的序列。通常，这些网络由多层隐藏的单元或神经元组成，并在一对层之间建立连接。例如，在完全连接的前馈神经网络中，经过训练的加权连接或网络参数的数量为 $O(n^2)$，其中 $n$ 是每层隐藏单元的数量。而论文提出的联合优化框架，该架构结合了projection网络和trainer网络进行联合训练。如下图：
![在这里插入图片描述](https://img-blog.csdnimg.cn/2020111520400533.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0RCQ18xMjE=,size_16,color_FFFFFF,t_70#pic_center)
上图说明了神经投影网络架构，使用前馈NN作为trainer网络，这个耦合网络进行联合训练以优化组合损耗函数（公式1）：
$$L(\theta,p)=\lambda_1\cdot L_\theta(.)+\lambda_2 \cdot L^p(.)+\lambda_3 \cdot \hat{L^p}(.)$$
其中$L_\theta(.)$，$L^p(.)$和$\hat{L^p}(.)$，对应于以下定义的两个网络的损失函数（公式2）：
$$L_\theta(.)=\sum_{i\in N}D(h_\theta(\vec{x}_i), \hat{y_i})$$  $$L^p(.)=\sum_{i\in N}D(h^p(\vec{x}_i),h_\theta(\vec{x}_i))$$  $$\hat{L^p}(.)=\sum_{i\in N}D(h^p(\vec{x}_i), \hat{y_i})$$
其中，$N$ 表示数据集中训练实例的数量， $\vec{x}_i$ 表示前馈网络中的输入特征向量或RNN中的序列输入，而 $\hat{y_i}$ 表示用于网络训练的真实输出类别。$h_\theta(\vec{x}_i)$，表示训练器网络中隐藏单元的参数化表示，将 $\vec{x}_i$ 转换为输出预测 $y_i$，同样的，$h^p(\vec{x}_i)$ 表示将输入转换为相应预测 $y_i^p$ 的投影网络参数。我们在两个网络的最后一层应用softmax激活来计算预测 $y_i$ 和 $y_i^p$。

D表示距离函数，作为损失函数用于计算预测误差，误差分为三个部分：训练器预测误差，投影模拟误差和投影预测误差。减少第一个误差会得到更好的训练器网络，而减少后两个会反过来学习更好的投影网络，该网络更简单，但预测能力大致相同。实际上，我们在所有实验中对 $D(.)$ 使用交叉熵。

对于等式2中的投影 $L^p$，我们遵循一种蒸馏方法来优化 $D(.)$ ，因为它已经显示出比仅在标签 $\hat{y_i}$ 上训练的模型具有更好的泛化能力。$\lambda_1$，$\lambda_2$和 $\lambda_3$ 是影响这些不同类型误差之间权衡的超参数，这些是在一个小的保留开发集上进行调整的，在我们的实验中，我们将它们设置为$\lambda_1=1.0$，$\lambda_2=0.1$和 $\lambda_3=1.0$ 。
+ **Trainer Network (θ)**：训练器模型是一个完整的神经网络（前馈，RNN或CNN），其选择灵活，取决于任务。图1演示了使用前馈网络的训练器，但可以与LSTM RNN（我们稍后介绍）或其他深度神经网络互换。对于图中所示的网络，层 $l_{k+1}$ 中 $h_\theta(.)$ 的激活计算如下（公式3）：
$$A_{\theta_{l_{k+1}}}=\sigma(W_{\theta_{l_{k+1}}}\cdot A_{\theta_{l_k}}+B_{\theta_{l_{k+1}}})$$
其中，其中 $\sigma$ 是除最后一个层以外应用于每一层的ReLU激活函数，$A$ 表示计算得出的隐藏单元的激活值。该网络中的 权重/偏差 参数 $W_\theta$，$B_\theta$ 的数量可以任意大，因为这只会在训练阶段使用，而这可以通过使用具有CPU或GPU的高性能分布式计算来有效地完成。
+ **Projection Network ( p )**：投影模型是一个简单的网络，对一组有效的计算操作进行编码，这些操作将直接在设备上进行推断。模型本身定义了一组有效的“投影”函数 $\mathbb{P}(\vec{x}_i)$，将每个输入实例 $\vec{x}_i$ 投影到不同的空间 $\Omega_\mathbb{P}$ ，然后在该空间中执行学习以将其映射到相应的输出 $y_i^p$。我们使用简化的投影网络，几乎没有操作，如图1所示。输入 $\vec{x}_i$ 使用一系列 $T$ 投影函数 $\mathbb{P}^1,...,\mathbb{P}^T$ 进行转换，然后再进行单层激活（公式4和公式5）。
$$\vec{x}_i^p=\mathbb{P}^1(\vec{x}_i),...,\mathbb{P}^T(\vec{x}_i)$$  $$y_i^p=softmax(W^p\cdot \vec{x}_i^p + B^p)$$
投影转换使用预先计算的参数化方法，即在学习过程中未对其进行训练，并且将其输出连接起来以形成用于后续操作的隐藏单元。在训练期间，较简单的投影网络将学习选择和应用特定的投影操作 $\mathbb{P}^j$（通过激活），这些操作对于给定任务更具预测性。可以堆叠连接到该网络中间层的其他层，以实现投影的非线性组合。

投影模型是与训练器共同训练的，并学会模仿整个训练器网络进行的预测，训练器预测网具有更多的参数，因此具有更大的预测能力。一旦学习完成，就从投影网络中提取变换函数 $\mathbb{P}(.)$ 和相应的训练权重 $W^p$，$B^p$，以创建一个轻量级模型，并将其转移到设备。

在我们的设置中，选择投影矩阵 $\mathbb{P}$ 以及表示投影空间 $ΩP$ 会对计算成本和模型大小产生直接影响。我们建议利用局部敏感哈希（LSH）的修改版本，作为有效的随机投影方法来定义 $\mathbb{P}(.)$ 。结合起来，我们使用 $1^d$ 表示 $\Omega_\mathbb{P}$ ，即网络的隐藏单元本身使用投影的位向量表示。与整个网络相比，这在参数的数量和大小方面都大大降低了内存占用量。我们在下面重点介绍此方法的一些关键属性：
+ 与典型的机器学习方法不同，不需要依靠预设的词汇表或特征空间，典型的机器学习方法采用较小的词汇表作为缩放机制。例如，LSTM RNN模型通常应用修剪，并在输入编码步骤中使用较小且固定大小的词汇表来降低模型的复杂性。
+ 所提出的学习方法可有效地缩放到大数据大小和高维空间。这对于涉及稀疏高维特征空间的自然语言应用程序特别有用。对于密集的特征空间（例如图像像素），可以在不依赖大量参数的情况下有效地近似现有操作（例如全连接层（甚至卷积））进行预测。在限制存储需求下，这种操作还可以与投影功能结合使用，以产生更复杂的投影网络。
+  $\mathbb{P}(x_i)$ 的计算与训练数据的大小无关。
+ 我们确保 $\mathbb{P}(.)$ 可以高效地进行即时计算，以便在设备上进行推理。

接下来，将更详细地描述投影方法和相关的操作。
## 局部敏感投影网络（Locality Sensitive Projection Network）
前面描述的投影网络依赖于一组转换函数 $\mathbb{P}$，这些函数将输入 $\vec{x}_i$ 投影到隐藏的单位表示 $\Omega_\mathbb{P}$ 中。可以使用不同类型的函数来执行公式4中概述的投影操作。一种可能性是使用通过word2vec或类似技术得到预训练的特征嵌入矩阵，模型 $\mathbb{P}$ 作为 $\vec{x}_i$ 中特征的嵌入查找，然后进行诸如矢量平均之类的聚合操作。

相反，我们在此步骤中采用了有效的随机投影方法，我们使用局部敏感哈希（LSH）来建模基础的投影操作，LSH通常用作诸如聚类之类的应用程序的降维技术。我们在Projection Nets中使用LSH的动机是，它允许我们将类似的输入 $\vec{x}_i$ 或中间网络层投影到接近度量空间的隐藏单位向量中。这使我们能够转换输入并学习有效而紧凑的网络表示形式，该表示形式仅取决于数据的固有维数（即观察到的特征），而不是实例数或实际数据矢量的维数（即所有特征或词汇量）。我们通过二进制散列函数来实现。
+ **定理1**：对于 $\vec{x}_i,\vec{x}_j\in \mathbb{R}^n$ 和从 $\mathbb{R}^n$ 上的球对称分布绘制的矢量 $\mathbb{P}_k$，内积符号与矢量之间的角度 $\measuredangle(\vec{x}_i,\vec{x}_j)$ 之间的关系可以表示为：
$$\measuredangle(\vec{x}_i,\vec{x}_j)=\pi Pr\{sgn[<\vec{x}_i,\mathbb{P}_k>]\neq sgn[<\vec{x}_j,\mathbb{P}_k>]\}$$
此属性适用于简单的几何，即每当投影矩阵 $\mathbb{P}$ 的行向量落入单位向量之间在 $\vec{x}_i$ 和 $\vec{x}_j$ 方向上的角度之内时，它们将产生相反的符号。与包含 $\vec{x}_i\vec{x}_j$ 的平面正交的任何投影矢量都将无效。由于可以使用内积来确定附近的参数表示形式，所以 $<\vec{x}_i,\vec{x}_j>=||\vec{x}_i||\cdot ||\vec{x}_j||\cdot cos\measuredangle(\vec{x}_i,\vec{x}_j)$，因此我们可以通过使用矢量的签名来有效地建模和存储网络隐藏的激活单元矢量。
+ **计算投影**：遵循上述属性，我们反复使用二进制哈希，然后将 $\mathbb{P}$ 中的投影向量应用于将输入 $\vec{x}_i$ 转换为由 $\mathbb{P}_k(\vec{x}_i)\in \{0,1\}^d$ 表示的二进制哈希表示，其中 $[\mathbb{P}_k(\vec{x}_i)] :=sgn[<\vec{x}_i,\mathbb{P}_k>]$ 。使得 d-bit 矢量表示，对应于每个投影行 $\mathbb{P}_{k=1...d}$ 的一位。投影矩阵 $\mathbb{P}$ 在训练和推理之前是固定的，请注意，我们无需显式存储随机投影矢量 $\mathbb{P}_k$ ，因为我们可以使用哈希函数动态计算它们，而不用调用随机数生成器。此外，这还使我们能够执行在观察到的特征尺寸上呈线性的投影操作，而不是对高维数据而言可能过大的整体特征尺寸，从而节省了内存和计算成本。二进制表示很重要，因为与训练器网络相比，这使得投影网络参数表示的非常紧凑，从而大大减小了模型大小。注意，其他方法，例如量化或权重共享，可以叠加在此方法之上，以在内存减少方面提供较小的进一步收益。
+ **投影参数**：实际上，我们采用 $T$ 个不同的投影函数 $\mathbb{P}^{j=1...T}$ ，如图1所示。每一个都产生 d-bit 向量，将其连接起来以形成等式4中的预测激活单元 $\vec{x}_i^p$。$T$ 和 $d$ 取决于为 $\mathbb{P}$ 指定的投影网络参数配置，并且可以调整为在预测质量和模型大小之间进行权衡。

## 训练与推断
如前所述，我们使用紧凑的位单元来表示投影网络。在训练过程中，该网络学习在投影的位空间 $\Omega_\mathbb{P}$ 中彼此相邻的点沿相同方向移动梯度。梯度的方向和大小由可访问更多参数集和更复杂架构的训练器网络确定。使用反向传播对两个网络进行联合训练。尽管有联合优化目标，但在高性能CPU或GPU上进行分布式计算时，随机梯度下降可以有效地进行训练。经过训练后，这两个网络将解耦并用于不同的目的。 训练器模型可以部署在使用标准神经网络的任何地方。提取更简单的投影网络模型权重以及变换函数 $\mathbb{P}(.)$ ，以创建轻量级模型，并将其推送到设备。
+ 复杂度：推理的总体复杂度为 $O(n\cdot T\cdot d)$，其中 $n$ 是观察到的特征大小（**不是**总词汇量大小），它在输入大小上呈线性关系，$d$ 是为每个投影矢量 $\mathbb{P}_k$ 指定的LSH位数 ，$T$ 是 $\mathbb{P}$ 中使用的投影函数的数量。在此设置中，投影推断模型所需的模型大小（根据参数的数量）和存储空间为 $O(T\cdot d)$。

作为位向量表示 $\Omega_\mathbb{P}$ 的替代，投影矩阵 $\mathbb{P}$ 可以用来生成投影网络中隐藏单元的稀疏表示。每个 d-bit 块都可以编码为整数而不是位向量。这样会导致整体参数空间为 $O(T\cdot 2^d)$（反而更大），但是对于实际学习的参数数量很少，并且可以通过有效的稀疏查找操作进行推理的应用程序仍然是有益的。

# 实验结果
下表显示了基线（MNIST手写数字识别）的结果以及与具有不同大小 $(T,d)$ 的ProjectionNet模型的比较。结果表明，小型的ProjectionNet的压缩率高达388x，可以实现92.3％的高精度，而内存占用量明显更大的基准可以达到98.9％。此外，ProjectionNet模型能够实现模型尺寸的进一步减小（最大2000x-3500x），同时对top-1的预测的精度约为70-80％，而对top-3的预测的精度约为90-94％。
![在这里插入图片描述](https://img-blog.csdnimg.cn/20201115230624884.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0RCQ18xMjE=,size_16,color_FFFFFF,t_70#pic_center)
下表显示了ProjectionNets与基准（ CIFAR-100图像分类）之间的结果比较。 如前所述，此任务比MNIST更复杂，因此精度数较低。
![在这里插入图片描述](https://img-blog.csdnimg.cn/20201115231337199.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0RCQ18xMjE=,size_16,color_FFFFFF,t_70#pic_center)
下表使用神经投影网络和基线进行语义意图分类的结果。表中显示，使用LSTM RNN训练的ProjectionNet达到82.3％的precision@ 1，与基线LSTM相比仅下降了15％，但减少了内存占用和计算量（与LSTM展开步骤相比）。
![在这里插入图片描述](https://img-blog.csdnimg.cn/20201115231834990.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0RCQ18xMjE=,size_16,color_FFFFFF,t_70#pic_center)
在MNIST的识别任务中，80-100个神经投影bits足以得到70-80％的精度解决该任务，将其增加到720bits可达到92.3％的精度，通过使用更深的投影进一步提高了精度网络。对于涉及序列输入的语义分类的语言任务，需要720个神经投影bits才能达到82.3％的top-1精度。

下图显示了MNIST和CIFAR-100任务的图。 该图表明，可以使用简单的100位ProjectionNet进行MNIST分类，从而简洁地获得具有3-5M参数的3层前馈网络的预测能力（比率=〜0.8）。 需要恢复90％以上的基础深度网络质量。
![在这里插入图片描述](https://img-blog.csdnimg.cn/20201115232738807.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0RCQ18xMjE=,size_16,color_FFFFFF,t_70#pic_center)
# 总结
论文引入了一种新的神经投影方法来训练轻量级神经网络模型，从而以较低的计算和内存成本在设备上执行有效的推理。论文展示了这种方法在模型大小和深度网络体系结构变化方面的灵活性。第3节末尾讨论了该框架的一些可能的将来扩展。除了深度学习之外，还可以将此框架应用于其他类型的学习场景中的轻量级模型训练。例如，训练范例可以更改为半监督或无监督设置。可以修改训练器模型本身，以合并在图形或概率图形模型（而非深度神经网络）上定义的结构化损失函数。下图展示了使用图优化损失函数学习轻量模型的端到端投影图方法，可以使用大规模分布图算法甚至神经图方法有效地训练它们。
![在这里插入图片描述](https://img-blog.csdnimg.cn/20201115233402806.png?x-oss-process=image/watermark,type_ZmFuZ3poZW5naGVpdGk,shadow_10,text_aHR0cHM6Ly9ibG9nLmNzZG4ubmV0L0RCQ18xMjE=,size_16,color_FFFFFF,t_70#pic_center)
