# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [4.2.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@4.1.1...@vtmn/vue@4.2.0) (2024-02-21)

### Features

- **`@vtmn/react`, `@vtmn/vue`:** timeout enhancement ([#1483](https://github.com/Decathlon/vitamin-web/issues/1483)) ([135c6dd](https://github.com/Decathlon/vitamin-web/commit/135c6dde680c07f425625ca782f7dfaaffd1963f))

## [4.1.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@4.1.0...@vtmn/vue@4.1.1) (2024-02-12)

**Note:** Version bump only for package @vtmn/vue

# [4.1.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@4.0.1...@vtmn/vue@4.1.0) (2023-09-29)

### Bug Fixes

- **build:** fix lint issues ([#1465](https://github.com/Decathlon/vitamin-web/issues/1465)) ([80cf58f](https://github.com/Decathlon/vitamin-web/commit/80cf58f4fd9e326a7345c61b73f1f7d8e0139f8b))

### Features

- **`@vtmn/svelte`, `@vtmn/react`, `vtmn/vue`:** use `VtmnAlert` as a display component ([#1464](https://github.com/Decathlon/vitamin-web/issues/1464)) ([590dd2e](https://github.com/Decathlon/vitamin-web/commit/590dd2e2b3f112fede276ea769ea28ea1ab58738))

## [4.0.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@4.0.0...@vtmn/vue@4.0.1) (2023-09-13)

**Note:** Version bump only for package @vtmn/vue

# [4.0.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@3.1.6...@vtmn/vue@4.0.0) (2023-08-04)

### Features

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** `VtmnChip` variant `input` match now the figma specs ([#1456](https://github.com/Decathlon/vitamin-web/issues/1456)) ([8b33064](https://github.com/Decathlon/vitamin-web/commit/8b33064e0adacb41b268bd09c17b8b3064e57937))

### BREAKING CHANGES

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** The design of `VtmnChip`now matches Figma's version. If you used the `VtmnChip` with an "input" variant, you will have changes when you will upgrade to this new version. "Selected" input is no longer available on this variant. The color of the variant stays white, and no longer has a blue color.

## [3.1.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@3.1.5...@vtmn/vue@3.1.6) (2023-08-02)

**Note:** Version bump only for package @vtmn/vue

## [3.1.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@3.1.4...@vtmn/vue@3.1.5) (2023-07-03)

**Note:** Version bump only for package @vtmn/vue

## [3.1.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@3.1.3...@vtmn/vue@3.1.4) (2023-06-29)

**Note:** Version bump only for package @vtmn/vue

## [3.1.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@3.1.2...@vtmn/vue@3.1.3) (2023-06-29)

**Note:** Version bump only for package @vtmn/vue

## [3.1.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@3.1.1...@vtmn/vue@3.1.2) (2023-06-21)

**Note:** Version bump only for package @vtmn/vue

## [3.1.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@3.1.0...@vtmn/vue@3.1.1) (2023-06-20)

**Note:** Version bump only for package @vtmn/vue

# [3.1.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@3.0.0...@vtmn/vue@3.1.0) (2023-06-16)

### Features

- **`@vtmn/react`, `@vtmn/vue`, `@vtmn/svelte`:** add summaryComponent on `VtmnAccordion` ([#1441](https://github.com/Decathlon/vitamin-web/issues/1441)) ([abb2c7a](https://github.com/Decathlon/vitamin-web/commit/abb2c7a5cccea93c08aaa01470dfe6da1fbbd67a))

# [3.0.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.3.1...@vtmn/vue@3.0.0) (2023-06-13)

### Features

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** rework `VtmnNavbarLink` for SSR ([#1436](https://github.com/Decathlon/vitamin-web/issues/1436)) ([5f21476](https://github.com/Decathlon/vitamin-web/commit/5f21476c20f5431e2966920d262a62bf1079869e))

### BREAKING CHANGES

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** The VtmnNavbarLink component removes properties "label" and "showLabel", they are replaced by a <span> slot.

## [2.3.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.3.0...@vtmn/vue@2.3.1) (2023-06-05)

**Note:** Version bump only for package @vtmn/vue

# [2.3.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.2.0...@vtmn/vue@2.3.0) (2023-06-02)

### Features

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** rework `VtmnNavbarLink` for SSR ([#1425](https://github.com/Decathlon/vitamin-web/issues/1425)) ([dc6b999](https://github.com/Decathlon/vitamin-web/commit/dc6b99940a6aa3f1b2023bd7c139344c6a6e28cd))

# [2.2.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.1.3...@vtmn/vue@2.2.0) (2023-05-25)

### Features

- **textinput:** add custom label ([#1432](https://github.com/Decathlon/vitamin-web/issues/1432)) ([775da7f](https://github.com/Decathlon/vitamin-web/commit/775da7f369b872fea062d9e19a86e92b7fcb45f5))

## [2.1.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.1.2...@vtmn/vue@2.1.3) (2023-04-24)

### Bug Fixes

- **@vtmn/svelte, @vtmn/react, @vtmn/vue:** `VtmnNavbarLink` force rel noopener noreferrer if target blank ([#1423](https://github.com/Decathlon/vitamin-web/issues/1423)) ([7fedfc9](https://github.com/Decathlon/vitamin-web/commit/7fedfc9e64085e866e617a7f5cd2abcddf1f9676))
- **@vtmn/svelte, @vtmn/vue, @vtmn/react:** interactive `VtmnRating` have duplicate `$$restProps` ([#1411](https://github.com/Decathlon/vitamin-web/issues/1411)) ([fa054c5](https://github.com/Decathlon/vitamin-web/commit/fa054c539deacd04c228a452299fb7cfd0fcace3))

## [2.1.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.1.1...@vtmn/vue@2.1.2) (2023-04-18)

**Note:** Version bump only for package @vtmn/vue

## [2.1.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.1.0...@vtmn/vue@2.1.1) (2023-04-18)

**Note:** Version bump only for package @vtmn/vue

# [2.1.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.0.1...@vtmn/vue@2.1.0) (2023-04-12)

### Features

- **@vtmn/svelte, @vtmn/vue, @vtmn/react:** possibility to add a `VtmnBadge` on the `VtmnNavbarLink` ([#1416](https://github.com/Decathlon/vitamin-web/issues/1416)) ([ff345a9](https://github.com/Decathlon/vitamin-web/commit/ff345a93a43716004d1554eb0a17c1e5c1274768))

## [2.0.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@2.0.0...@vtmn/vue@2.0.1) (2023-04-12)

**Note:** Version bump only for package @vtmn/vue

# [2.0.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@1.1.0...@vtmn/vue@2.0.0) (2023-04-06)

### Features

- **@vtmn/react, @vtmn/vue:** manage height parameter of `VtmnSkeleton` component ([#1408](https://github.com/Decathlon/vitamin-web/issues/1408)) ([25a7c16](https://github.com/Decathlon/vitamin-web/commit/25a7c16abf352170e4936aacb6b674aec54e3067))

### BREAKING CHANGES

- **@vtmn/react, @vtmn/vue:** `VtmnSkeleton` should now receive unit directly in `width` (or `height`) in string instead of number related to percentage.

# [1.1.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.55.3...@vtmn/vue@1.1.0) (2023-03-22)

### Features

- bump packages to 1.x.x ([#1397](https://github.com/Decathlon/vitamin-web/issues/1397)) ([ddb1589](https://github.com/Decathlon/vitamin-web/commit/ddb1589616c267100edd785c11a476868d856bfc))

## [0.55.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.55.2...@vtmn/vue@0.55.3) (2023-03-22)

**Note:** Version bump only for package @vtmn/vue

## [0.55.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.55.1...@vtmn/vue@0.55.2) (2023-03-21)

**Note:** Version bump only for package @vtmn/vue

## [0.55.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.55.0...@vtmn/vue@0.55.1) (2023-03-21)

**Note:** Version bump only for package @vtmn/vue

# [0.55.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.54.4...@vtmn/vue@0.55.0) (2023-03-13)

### Features

- add new variants for VtmnIcon ([#1390](https://github.com/Decathlon/vitamin-web/issues/1390)) ([a8a5ae4](https://github.com/Decathlon/vitamin-web/commit/a8a5ae4074cc2e2690fc43dab25332858eb4534d))

## [0.54.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.54.3...@vtmn/vue@0.54.4) (2023-03-13)

**Note:** Version bump only for package @vtmn/vue

## [0.54.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.54.2...@vtmn/vue@0.54.3) (2023-03-09)

**Note:** Version bump only for package @vtmn/vue

## [0.54.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.54.1...@vtmn/vue@0.54.2) (2023-03-09)

**Note:** Version bump only for package @vtmn/vue

## [0.54.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.54.0...@vtmn/vue@0.54.1) (2023-03-06)

### Bug Fixes

- **@vtmn/svelte, @vtmn/react, @vtmn/vue:** fix rounded value on `VtmnRating` ([#1378](https://github.com/Decathlon/vitamin-web/issues/1378)) ([a6334b7](https://github.com/Decathlon/vitamin-web/commit/a6334b74c735b79811597d32d3d41643bb536f1d))

# [0.54.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.53.1...@vtmn/vue@0.54.0) (2023-02-21)

### Features

- add navbar link ([#1372](https://github.com/Decathlon/vitamin-web/issues/1372)) ([6b8a621](https://github.com/Decathlon/vitamin-web/commit/6b8a621c8b0c2eb0c99db88afedb4d5f1b0697ba))

## [0.53.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.53.0...@vtmn/vue@0.53.1) (2023-02-10)

**Note:** Version bump only for package @vtmn/vue

# [0.53.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.52.0...@vtmn/vue@0.53.0) (2023-02-10)

### Features

- add a prop to hide search button in Search component ([#1369](https://github.com/Decathlon/vitamin-web/issues/1369)) ([e59acd3](https://github.com/Decathlon/vitamin-web/commit/e59acd3a82712d8170714bd403baba9a7cae5606))

# [0.52.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.51.0...@vtmn/vue@0.52.0) (2023-02-10)

### Features

- add a new prop for Select component for border ([#1365](https://github.com/Decathlon/vitamin-web/issues/1365)) ([9e21b77](https://github.com/Decathlon/vitamin-web/commit/9e21b77407ca65715d290fdb5464380c70db330d))

# [0.51.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.50.0...@vtmn/vue@0.51.0) (2023-02-09)

### Features

- add small size for `Quantity` component ([#1368](https://github.com/Decathlon/vitamin-web/issues/1368)) ([1ab77c3](https://github.com/Decathlon/vitamin-web/commit/1ab77c3969a4f829795b01fc6903964041649cc7))

# [0.50.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.49.6...@vtmn/vue@0.50.0) (2023-02-09)

### Features

- make extensible quantity component ([#1364](https://github.com/Decathlon/vitamin-web/issues/1364)) ([69ebb23](https://github.com/Decathlon/vitamin-web/commit/69ebb232119a45379fe22e9a2149f4dcd779d54c))

## [0.49.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.49.5...@vtmn/vue@0.49.6) (2023-02-09)

**Note:** Version bump only for package @vtmn/vue

## [0.49.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.49.4...@vtmn/vue@0.49.5) (2023-02-05)

**Note:** Version bump only for package @vtmn/vue

## [0.49.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.49.3...@vtmn/vue@0.49.4) (2023-02-05)

**Note:** Version bump only for package @vtmn/vue

## [0.49.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.49.2...@vtmn/vue@0.49.3) (2023-02-03)

**Note:** Version bump only for package @vtmn/vue

## [0.49.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.49.1...@vtmn/vue@0.49.2) (2023-02-03)

**Note:** Version bump only for package @vtmn/vue

## [0.49.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.49.0...@vtmn/vue@0.49.1) (2023-01-31)

**Note:** Version bump only for package @vtmn/vue

# [0.49.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.48.4...@vtmn/vue@0.49.0) (2023-01-30)

### Features

- **@vtmn/css:** update price to allow no-padding ([#1343](https://github.com/Decathlon/vitamin-web/issues/1343)) ([d5ede03](https://github.com/Decathlon/vitamin-web/commit/d5ede03a6404b6426745a6b8a7035d2d40bf4f74))

## [0.48.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.48.3...@vtmn/vue@0.48.4) (2023-01-26)

**Note:** Version bump only for package @vtmn/vue

## [0.48.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.48.2...@vtmn/vue@0.48.3) (2023-01-20)

**Note:** Version bump only for package @vtmn/vue

## [0.48.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.48.1...@vtmn/vue@0.48.2) (2023-01-20)

**Note:** Version bump only for package @vtmn/vue

## [0.48.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.48.0...@vtmn/vue@0.48.1) (2023-01-20)

**Note:** Version bump only for package @vtmn/vue

# [0.48.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.47.0...@vtmn/vue@0.48.0) (2023-01-17)

### Features

- add XSmall size on Price variant ([#1329](https://github.com/Decathlon/vitamin-web/issues/1329)) ([ce1de41](https://github.com/Decathlon/vitamin-web/commit/ce1de417d6c3c5c558cb850d32870d188754118b))

# [0.47.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.46.2...@vtmn/vue@0.47.0) (2023-01-17)

### Features

- **@vtmn/css:** add href property on `VtmnListItem` ([#1321](https://github.com/Decathlon/vitamin-web/issues/1321)) ([598e663](https://github.com/Decathlon/vitamin-web/commit/598e66328a9fcb414d49a9fe8a1a4f24ba7321c6))

## [0.46.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.46.1...@vtmn/vue@0.46.2) (2023-01-16)

**Note:** Version bump only for package @vtmn/vue

## [0.46.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.46.0...@vtmn/vue@0.46.1) (2023-01-06)

**Note:** Version bump only for package @vtmn/vue

# [0.46.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.45.0...@vtmn/vue@0.46.0) (2022-12-30)

### Bug Fixes

- re-trigger linter for lerna ([c2ce2c4](https://github.com/Decathlon/vitamin-web/commit/c2ce2c4b3305b2283b68c8189d2d7ef6269d52e6))

### Features

- **@vtmn/css:** add small size for `VtmnTag` component ([#1320](https://github.com/Decathlon/vitamin-web/issues/1320)) ([e4b0ffb](https://github.com/Decathlon/vitamin-web/commit/e4b0ffbfc64d67718e7e0f4c3f0dbfa6c89de245))

# [0.45.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.8...@vtmn/vue@0.45.0) (2022-11-24)

### Features

- **@vtmn/svelte, @vtmn/react, @vtmn/vue, @vtmn/css:** add heading level on title + title wraps correctly ([#1304](https://github.com/Decathlon/vitamin-web/issues/1304)) ([bfc4a0a](https://github.com/Decathlon/vitamin-web/commit/bfc4a0aa0daaa5ee557c9b55fbd4830ebdbf989f))

## [0.44.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.7...@vtmn/vue@0.44.8) (2022-11-14)

**Note:** Version bump only for package @vtmn/vue

## [0.44.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.6...@vtmn/vue@0.44.7) (2022-10-28)

**Note:** Version bump only for package @vtmn/vue

## [0.44.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.5...@vtmn/vue@0.44.6) (2022-10-25)

### Bug Fixes

- **@vtmn/vue:** cancel event is not present in VtmnChip component (input variant) ([#1294](https://github.com/Decathlon/vitamin-web/issues/1294)) ([b3d9c10](https://github.com/Decathlon/vitamin-web/commit/b3d9c10f2d05e7ca985275fec097e1af2326fd13))

## [0.44.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.4...@vtmn/vue@0.44.5) (2022-10-21)

### Bug Fixes

- **@vtmn/svelte:** lint warnings ([#1290](https://github.com/Decathlon/vitamin-web/issues/1290)) ([224364a](https://github.com/Decathlon/vitamin-web/commit/224364a794c96fbccc949c9932949eecc043f536))

## [0.44.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.3...@vtmn/vue@0.44.4) (2022-10-21)

**Note:** Version bump only for package @vtmn/vue

## [0.44.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.2...@vtmn/vue@0.44.3) (2022-10-21)

**Note:** Version bump only for package @vtmn/vue

## [0.44.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.1...@vtmn/vue@0.44.2) (2022-10-19)

**Note:** Version bump only for package @vtmn/vue

## [0.44.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.44.0...@vtmn/vue@0.44.1) (2022-10-19)

**Note:** Version bump only for package @vtmn/vue

# [0.44.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.10...@vtmn/vue@0.44.0) (2022-10-17)

### Bug Fixes

- **@vtmn/vue:** lint styles ([124536b](https://github.com/Decathlon/vitamin-web/commit/124536bba15eee4d4a6e7bbd4fa296c3d24c07db))

### Features

- **@vtmn/css, @vtmn/svelte, @vtmn/react, @vtmn/vue:** add rel attribute for blank link targets to prevent security issues ([#1245](https://github.com/Decathlon/vitamin-web/issues/1245)) ([78e137e](https://github.com/Decathlon/vitamin-web/commit/78e137e71eb952fd38289ecd4ebde919d1c9b5d7))

## [0.43.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.9...@vtmn/vue@0.43.10) (2022-10-14)

**Note:** Version bump only for package @vtmn/vue

## [0.43.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.8...@vtmn/vue@0.43.9) (2022-10-07)

### Bug Fixes

- **@vtmn/css, @vtmn/react, @vtmn/vue, @vtmn/svelte:** linear progressbar animation ([#1238](https://github.com/Decathlon/vitamin-web/issues/1238)) ([bfb1aaf](https://github.com/Decathlon/vitamin-web/commit/bfb1aaf06a36b3faa1d06457c69b5b2308cabab2))

## [0.43.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.7...@vtmn/vue@0.43.8) (2022-09-23)

### Bug Fixes

- **@vtmn/css, @vtmn/svelte, @vtmn/react, @vtmn/vue:** popover position & a11y ([#1259](https://github.com/Decathlon/vitamin-web/issues/1259)) ([#1261](https://github.com/Decathlon/vitamin-web/issues/1261)) ([219d318](https://github.com/Decathlon/vitamin-web/commit/219d3182e6404ac7a6cede344334e354730e7008))

## [0.43.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.6...@vtmn/vue@0.43.7) (2022-09-13)

**Note:** Version bump only for package @vtmn/vue

## [0.43.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.5...@vtmn/vue@0.43.6) (2022-09-05)

**Note:** Version bump only for package @vtmn/vue

## [0.43.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.4...@vtmn/vue@0.43.5) (2022-08-22)

**Note:** Version bump only for package @vtmn/vue

## [0.43.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.3...@vtmn/vue@0.43.4) (2022-08-05)

**Note:** Version bump only for package @vtmn/vue

## [0.43.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.2...@vtmn/vue@0.43.3) (2022-08-04)

**Note:** Version bump only for package @vtmn/vue

## [0.43.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.1...@vtmn/vue@0.43.2) (2022-08-02)

**Note:** Version bump only for package @vtmn/vue

## [0.43.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.43.0...@vtmn/vue@0.43.1) (2022-07-29)

**Note:** Version bump only for package @vtmn/vue

# [0.43.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.42.0...@vtmn/vue@0.43.0) (2022-07-27)

### Features

- **@vtmn/css, @vtmn/react, @vtmn/svelte, @vtmn/vue:** add selected prop on VtmnTabsItem component ([29d9583](https://github.com/Decathlon/vitamin-web/commit/29d9583fe7146c9a392b231d258c4d9e3f644975))

# [0.42.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.41.3...@vtmn/vue@0.42.0) (2022-07-25)

### Features

- **@vtmn/css-link, @vtmn/react, @vtmn/vue, @vtmn/svelte:** add reversed variant for `VtmnLink` component ([#1213](https://github.com/Decathlon/vitamin-web/issues/1213)) ([1ce650e](https://github.com/Decathlon/vitamin-web/commit/1ce650e31dab5dde18185393437219f388801890))

## [0.41.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.41.2...@vtmn/vue@0.41.3) (2022-06-30)

**Note:** Version bump only for package @vtmn/vue

## [0.41.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.41.1...@vtmn/vue@0.41.2) (2022-06-28)

### Bug Fixes

- **@vtmn/css:** sonarcloud code smells ([f95800e](https://github.com/Decathlon/vitamin-web/commit/f95800e71b58cd015ad6bf6f0ad64283f2193df0))

## [0.41.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.41.0...@vtmn/vue@0.41.1) (2022-06-28)

### Bug Fixes

- **@vtmn/vue:** sonarcloud code smells ([e9dfc77](https://github.com/Decathlon/vitamin-web/commit/e9dfc77d9861544c1edbcdcefe02de96a1aba568))

# [0.41.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.40.0...@vtmn/vue@0.41.0) (2022-06-28)

### Features

- **@vtmn/css, @vtmn/react, @vtmn/svelte, @vtmn/vue:** add or improve `VtmnTabs` component ([#1168](https://github.com/Decathlon/vitamin-web/issues/1168)) ([5c22816](https://github.com/Decathlon/vitamin-web/commit/5c22816a19a9e60e33080eec65bad02492b9dd39))
- **@vtmn/react, @vtmn/vue:** add `VtmnDropdown` component ([#1169](https://github.com/Decathlon/vitamin-web/issues/1169)) ([4e88194](https://github.com/Decathlon/vitamin-web/commit/4e881948598a7c0acda21d89f3db03d39becaeb6))

# [0.40.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.39.0...@vtmn/vue@0.40.0) (2022-06-28)

### Features

- **@vtmn/css, @vtmn/react, @vtmn/svelte:** `progressbar`, add a11y requirements ([#1129](https://github.com/Decathlon/vitamin-web/issues/1129)) ([69829e8](https://github.com/Decathlon/vitamin-web/commit/69829e88f2cdc5f80b242cc4c5c2819d8c83d610))

# [0.39.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.38.5...@vtmn/vue@0.39.0) (2022-06-28)

### Features

- **@vtmn/css, @vtmn/react, @vtmn/svelte, @vtmn/vue:** `divider`, add a11y requirements ([#1137](https://github.com/Decathlon/vitamin-web/issues/1137)) ([d651cd2](https://github.com/Decathlon/vitamin-web/commit/d651cd2afbd5b4381865d04e5c5c27f671812ae8))

## [0.38.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.38.4...@vtmn/vue@0.38.5) (2022-06-27)

**Note:** Version bump only for package @vtmn/vue

## [0.38.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.38.3...@vtmn/vue@0.38.4) (2022-06-23)

**Note:** Version bump only for package @vtmn/vue

## [0.38.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.38.2...@vtmn/vue@0.38.3) (2022-06-23)

**Note:** Version bump only for package @vtmn/vue

## [0.38.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.38.1...@vtmn/vue@0.38.2) (2022-06-23)

**Note:** Version bump only for package @vtmn/vue

## [0.38.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.38.0...@vtmn/vue@0.38.1) (2022-06-21)

**Note:** Version bump only for package @vtmn/vue

# [0.38.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.37.2...@vtmn/vue@0.38.0) (2022-06-21)

### Features

- dropdown focus loop ([#1184](https://github.com/Decathlon/vitamin-web/issues/1184)) ([f4a73de](https://github.com/Decathlon/vitamin-web/commit/f4a73de326af16a3e0265db87a21237ad7817b0d)), closes [#1177](https://github.com/Decathlon/vitamin-web/issues/1177)

## [0.37.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.37.2...@vtmn/vue@0.37.4) (2022-06-21)

**Note:** Version bump only for package @vtmn/vue

## [0.37.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.37.1...@vtmn/vue@0.37.2) (2022-05-17)

**Note:** Version bump only for package @vtmn/vue

## [0.37.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.37.0...@vtmn/vue@0.37.1) (2022-05-16)

### Bug Fixes

- **@vtmn/react:** error build of typings ([2eead8c](https://github.com/Decathlon/vitamin-web/commit/2eead8c97165ffc8380a5d9d232400d0e71cf569))

# [0.37.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.36.2...@vtmn/vue@0.37.0) (2022-05-12)

### Features

- **@vtmn/vue:** add `VtmnCard` component ([#1152](https://github.com/Decathlon/vitamin-web/issues/1152)) ([181b607](https://github.com/Decathlon/vitamin-web/commit/181b60782f06743c7e0ac33e05a8b41a1b1dcc36))

## [0.36.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.36.1...@vtmn/vue@0.36.2) (2022-05-11)

**Note:** Version bump only for package @vtmn/vue

## [0.36.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.36.0...@vtmn/vue@0.36.1) (2022-05-11)

**Note:** Version bump only for package @vtmn/vue

# [0.36.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.35.0...@vtmn/vue@0.36.0) (2022-05-10)

### Features

- **@vtmn/vue:** add `VtmnList` component ([#1155](https://github.com/Decathlon/vitamin-web/issues/1155)) ([1c20a03](https://github.com/Decathlon/vitamin-web/commit/1c20a03cb40a7db45faea2cdbc1fb62d7331ba34))

# [0.35.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.34.0...@vtmn/vue@0.35.0) (2022-05-10)

### Features

- **@vtmn/vue:** add progressbar component ([#1154](https://github.com/Decathlon/vitamin-web/issues/1154)) ([77a817c](https://github.com/Decathlon/vitamin-web/commit/77a817cbe9571d6a1f287d69dbec0454b720ecec))

# [0.34.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.33.4...@vtmn/vue@0.34.0) (2022-05-10)

### Features

- **@vtmn/vue:** add `VtmnRating` component ([#1149](https://github.com/Decathlon/vitamin-web/issues/1149)) ([13fc8a3](https://github.com/Decathlon/vitamin-web/commit/13fc8a3f4d6c6e6495dfeda0c18da8597d806158))

## [0.33.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.33.3...@vtmn/vue@0.33.4) (2022-05-09)

**Note:** Version bump only for package @vtmn/vue

## [0.33.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.33.2...@vtmn/vue@0.33.3) (2022-05-09)

**Note:** Version bump only for package @vtmn/vue

## [0.33.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.33.1...@vtmn/vue@0.33.2) (2022-05-09)

**Note:** Version bump only for package @vtmn/vue

## [0.33.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.33.0...@vtmn/vue@0.33.1) (2022-05-09)

**Note:** Version bump only for package @vtmn/vue

# [0.33.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.32.0...@vtmn/vue@0.33.0) (2022-05-09)

### Features

- **@vtmn/vue:** add breadcrumb component ([#1147](https://github.com/Decathlon/vitamin-web/issues/1147)) ([3e9f56a](https://github.com/Decathlon/vitamin-web/commit/3e9f56a1e236454d7ada4adc60f693d6cc4f5266))
- **@vtmn/vue:** add navbar component ([#1148](https://github.com/Decathlon/vitamin-web/issues/1148)) ([30b0686](https://github.com/Decathlon/vitamin-web/commit/30b0686a53fa067f6ae336f923d4f0f7f5721401))

# [0.32.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.31.3...@vtmn/vue@0.32.0) (2022-05-09)

### Features

- **@vtmn/css & @vtmn/vue & @vtmn/react & @vtmn/svelte:** chip, add role button + a11y attribute, improve css ([#1134](https://github.com/Decathlon/vitamin-web/issues/1134)) ([cef64c9](https://github.com/Decathlon/vitamin-web/commit/cef64c9a368824a9dd55bd0ad3a25e958d15aba3))

## [0.31.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.31.2...@vtmn/vue@0.31.3) (2022-05-06)

**Note:** Version bump only for package @vtmn/vue

## [0.31.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.31.1...@vtmn/vue@0.31.2) (2022-05-05)

**Note:** Version bump only for package @vtmn/vue

## [0.31.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.31.0...@vtmn/vue@0.31.1) (2022-05-04)

**Note:** Version bump only for package @vtmn/vue

# [0.31.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.30.6...@vtmn/vue@0.31.0) (2022-05-02)

### Features

- **@vtmn/svelte, @vtmn/react, @vtmn/css:** accordion, change `button` variant ([#1135](https://github.com/Decathlon/vitamin-web/issues/1135)) ([d326114](https://github.com/Decathlon/vitamin-web/commit/d326114fd8c349bbf51f92b40ae9c5793ef42ab5))

## [0.30.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.30.5...@vtmn/vue@0.30.6) (2022-05-02)

**Note:** Version bump only for package @vtmn/vue

## [0.30.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.30.4...@vtmn/vue@0.30.5) (2022-04-22)

**Note:** Version bump only for package @vtmn/vue

## [0.30.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.30.3...@vtmn/vue@0.30.4) (2022-04-21)

**Note:** Version bump only for package @vtmn/vue

## [0.30.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.30.2...@vtmn/vue@0.30.3) (2022-04-21)

**Note:** Version bump only for package @vtmn/vue

## [0.30.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.30.1...@vtmn/vue@0.30.2) (2022-04-21)

**Note:** Version bump only for package @vtmn/vue

## [0.30.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.30.0...@vtmn/vue@0.30.1) (2022-04-14)

**Note:** Version bump only for package @vtmn/vue

# [0.30.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.29.1...@vtmn/vue@0.30.0) (2022-04-11)

### Features

- **@vtmn/vue:** add `VtmnQuantity` component ([#1109](https://github.com/Decathlon/vitamin-web/issues/1109)) ([84e3578](https://github.com/Decathlon/vitamin-web/commit/84e3578f00109f921ef5f8ccf6a46eaf4e017ac9))

## [0.29.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.29.0...@vtmn/vue@0.29.1) (2022-04-08)

**Note:** Version bump only for package @vtmn/vue

# [0.29.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.28.1...@vtmn/vue@0.29.0) (2022-04-08)

### Features

- **@vtmn/vue:** add `VtmnModal` component ([#1108](https://github.com/Decathlon/vitamin-web/issues/1108)) ([e7a3f9b](https://github.com/Decathlon/vitamin-web/commit/e7a3f9b45d43f4f6964c0e1092a4491f375cb2dd))

## [0.28.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.28.0...@vtmn/vue@0.28.1) (2022-04-08)

**Note:** Version bump only for package @vtmn/vue

# [0.28.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.27.1...@vtmn/vue@0.28.0) (2022-04-07)

### Features

- **@vtmn/vue:** add `VtmnSearch` component ([#1078](https://github.com/Decathlon/vitamin-web/issues/1078)) ([5388d86](https://github.com/Decathlon/vitamin-web/commit/5388d860cb73c35f3cd18b6cd439aaad047024ed))
- **@vtmn/vue:** add `VtmnSnackbar` component ([#1107](https://github.com/Decathlon/vitamin-web/issues/1107)) ([36074e4](https://github.com/Decathlon/vitamin-web/commit/36074e445ec7ea644de6887bc45b5c6ee892c3bc))
- **@vtmn/vue:** add `VtmnToast` component ([#1106](https://github.com/Decathlon/vitamin-web/issues/1106)) ([c521670](https://github.com/Decathlon/vitamin-web/commit/c521670d6062140acaf636b598ecd2ab17228b6b))

## [0.27.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.27.0...@vtmn/vue@0.27.1) (2022-04-05)

**Note:** Version bump only for package @vtmn/vue

# [0.27.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.26.0...@vtmn/vue@0.27.0) (2022-04-04)

### Features

- **@vtmn/vue:** add `VtmnPopover` component ([#1102](https://github.com/Decathlon/vitamin-web/issues/1102)) ([94009e6](https://github.com/Decathlon/vitamin-web/commit/94009e6e15fdccbaef3eb8f5b3153dda87a13b61))

# [0.26.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.25.0...@vtmn/vue@0.26.0) (2022-04-01)

### Features

- **@vtmn/vue:** add `VtmnAlert` component ([#1104](https://github.com/Decathlon/vitamin-web/issues/1104)) ([96668ff](https://github.com/Decathlon/vitamin-web/commit/96668ffdd692e3036b9c47906f0468e4bd27072a))

# [0.25.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.24.0...@vtmn/vue@0.25.0) (2022-03-31)

### Features

- **@vtmn/vue:** add accordion component ([#1100](https://github.com/Decathlon/vitamin-web/issues/1100)) ([ee05d88](https://github.com/Decathlon/vitamin-web/commit/ee05d8809cc2edba7d68ba0b59c1cfbe89bdc3e2))

# [0.24.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.23.0...@vtmn/vue@0.24.0) (2022-03-30)

### Features

- **@vtmn/vue:** add `VtmnChip` component ([#1076](https://github.com/Decathlon/vitamin-web/issues/1076)) ([55c483e](https://github.com/Decathlon/vitamin-web/commit/55c483eff9c7054647b538bf8e6df96a7e231adf))

# [0.23.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.22.0...@vtmn/vue@0.23.0) (2022-03-30)

### Features

- **@vtmn/vue:** add skeleton component ([#1094](https://github.com/Decathlon/vitamin-web/issues/1094)) ([4c36184](https://github.com/Decathlon/vitamin-web/commit/4c3618462d8125ff97c60025c88cba5b43df6db2))

# [0.22.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.21.0...@vtmn/vue@0.22.0) (2022-03-30)

### Features

- **@vtmn/vue:** add tooltip component ([#1092](https://github.com/Decathlon/vitamin-web/issues/1092)) ([d309dd2](https://github.com/Decathlon/vitamin-web/commit/d309dd299c1ccf646bedaab95cf7b1d3b473a1ed))

# [0.21.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.20.1...@vtmn/vue@0.21.0) (2022-03-29)

### Features

- **@vtmn/vue:** add disabled attr to options ([#1090](https://github.com/Decathlon/vitamin-web/issues/1090)) ([4552022](https://github.com/Decathlon/vitamin-web/commit/45520229a2f86975977b1287604e37941f0e4405))
- **@vtmn/vue:** fix text input binding ([#1091](https://github.com/Decathlon/vitamin-web/issues/1091)) ([1f895ac](https://github.com/Decathlon/vitamin-web/commit/1f895ac93fffaba9c177daeebc510975cbabb199))

## [0.20.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.20.0...@vtmn/vue@0.20.1) (2022-03-29)

**Note:** Version bump only for package @vtmn/vue

# [0.20.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.19.1...@vtmn/vue@0.20.0) (2022-03-25)

### Features

- **@vtmn/vue:** add `VtmnDivider` component ([#1074](https://github.com/Decathlon/vitamin-web/issues/1074)) ([205c7b6](https://github.com/Decathlon/vitamin-web/commit/205c7b6494707be47fb2ddbc83e0f6481ca3b1b0))
- **@vtmn/vue:** add `VtmnTag` component ([#1072](https://github.com/Decathlon/vitamin-web/issues/1072)) ([a782e93](https://github.com/Decathlon/vitamin-web/commit/a782e934130c4eb478d3e4b16617fcd8928b7fb6))

## [0.19.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.19.0...@vtmn/vue@0.19.1) (2022-03-23)

**Note:** Version bump only for package @vtmn/vue

# [0.19.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.8...@vtmn/vue@0.19.0) (2022-03-11)

### Features

- **@vtmn/vue:** disable inheritAttrs to components using attrs binding ([#1037](https://github.com/Decathlon/vitamin-web/issues/1037)) ([fd46460](https://github.com/Decathlon/vitamin-web/commit/fd46460ce878b6a9e6cddc42e6ebec5c17141fe1))

## [0.18.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.7...@vtmn/vue@0.18.8) (2022-03-11)

### Bug Fixes

- **@vtmn/vue:** className => class ([#1036](https://github.com/Decathlon/vitamin-web/issues/1036)) ([8132e2c](https://github.com/Decathlon/vitamin-web/commit/8132e2c729bd4a3aea4dfd9c58687d9cc83ae679))

## [0.18.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.6...@vtmn/vue@0.18.7) (2022-03-11)

**Note:** Version bump only for package @vtmn/vue

## [0.18.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.5...@vtmn/vue@0.18.6) (2022-03-11)

**Note:** Version bump only for package @vtmn/vue

## [0.18.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.4...@vtmn/vue@0.18.5) (2022-03-09)

**Note:** Version bump only for package @vtmn/vue

## [0.18.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.3...@vtmn/vue@0.18.4) (2022-03-07)

**Note:** Version bump only for package @vtmn/vue

## [0.18.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.2...@vtmn/vue@0.18.3) (2022-03-04)

**Note:** Version bump only for package @vtmn/vue

## [0.18.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.1...@vtmn/vue@0.18.2) (2022-03-04)

**Note:** Version bump only for package @vtmn/vue

## [0.18.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.18.0...@vtmn/vue@0.18.1) (2022-03-03)

**Note:** Version bump only for package @vtmn/vue

# [0.18.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.17.0...@vtmn/vue@0.18.0) (2022-03-03)

### Features

- **@vtmn/vue:** add `VtmnBadge` component ([#1007](https://github.com/Decathlon/vitamin-web/issues/1007)) ([b535717](https://github.com/Decathlon/vitamin-web/commit/b535717c4584d5649d4fa600f538fd8ce7ac47ca))

# [0.17.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.16.1...@vtmn/vue@0.17.0) (2022-03-03)

### Features

- **@vtmn/vue:** add `VtmnPrice` component ([#1006](https://github.com/Decathlon/vitamin-web/issues/1006)) ([99b0136](https://github.com/Decathlon/vitamin-web/commit/99b01360db6057950a7e22b032e34931fa81c1aa))

## [0.16.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.16.0...@vtmn/vue@0.16.1) (2022-03-02)

**Note:** Version bump only for package @vtmn/vue

# [0.16.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.15.4...@vtmn/vue@0.16.0) (2022-03-02)

### Features

- **@vtmn/vue:** display icon with `VtmnIcon` and remove useless type in `VtmnButton` ([#999](https://github.com/Decathlon/vitamin-web/issues/999)) ([b9ab259](https://github.com/Decathlon/vitamin-web/commit/b9ab259c1a6914d61aeeb1a0e394cd6312d15e62))

## [0.15.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.15.3...@vtmn/vue@0.15.4) (2022-03-02)

**Note:** Version bump only for package @vtmn/vue

## [0.15.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.15.2...@vtmn/vue@0.15.3) (2022-03-02)

**Note:** Version bump only for package @vtmn/vue

## [0.15.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.15.1...@vtmn/vue@0.15.2) (2022-03-01)

**Note:** Version bump only for package @vtmn/vue

## [0.15.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.15.0...@vtmn/vue@0.15.1) (2022-03-01)

**Note:** Version bump only for package @vtmn/vue

# [0.15.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.14.4...@vtmn/vue@0.15.0) (2022-03-01)

### Features

- **@vtmn/vue:** add `VtmnLoader` component ([#1003](https://github.com/Decathlon/vitamin-web/issues/1003)) ([2a05e77](https://github.com/Decathlon/vitamin-web/commit/2a05e776090472bf0b33c933e78cfe97bbae2c4b))

## [0.14.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.14.3...@vtmn/vue@0.14.4) (2022-03-01)

**Note:** Version bump only for package @vtmn/vue

## [0.14.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.14.2...@vtmn/vue@0.14.3) (2022-03-01)

### Bug Fixes

- **@vtmn/vue:** sonarcloud duplications ([c973e05](https://github.com/Decathlon/vitamin-web/commit/c973e0506397c2b8684012f785d87c1c50242ba2))

## [0.14.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.14.1...@vtmn/vue@0.14.2) (2022-03-01)

### Bug Fixes

- **@vtmn/vue:** sonarcloud duplications for forms components ([ea9a17e](https://github.com/Decathlon/vitamin-web/commit/ea9a17edd0cefd90b5faf067f6af94b06c3ff318))

## [0.14.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.14.0...@vtmn/vue@0.14.1) (2022-03-01)

**Note:** Version bump only for package @vtmn/vue

# [0.14.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.13.6...@vtmn/vue@0.14.0) (2022-03-01)

### Bug Fixes

- **@vtmn/vue:** build ([0534995](https://github.com/Decathlon/vitamin-web/commit/05349959aaa88d0e292f842cdc80483444197919))
- **@vtmn/vue:** dependencies ([38cc602](https://github.com/Decathlon/vitamin-web/commit/38cc602d6b9de6890b982719f3a00a86a5381542))

### Features

- **@vtmn/vue:** add `VtmnTextInput` reactivity and `VtmnSelect` component ([#998](https://github.com/Decathlon/vitamin-web/issues/998)) ([7506d84](https://github.com/Decathlon/vitamin-web/commit/7506d848a4ea905c4b4f20b392d02f8aa56df44c))

## [0.13.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.13.5...@vtmn/vue@0.13.6) (2022-02-28)

### Bug Fixes

- **build:** fix build on Windows ([#992](https://github.com/Decathlon/vitamin-web/issues/992)) ([e1eac98](https://github.com/Decathlon/vitamin-web/commit/e1eac984141860462ed04a44331847c3dd13c7cb))

## [0.13.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.13.4...@vtmn/vue@0.13.5) (2022-02-28)

**Note:** Version bump only for package @vtmn/vue

## [0.13.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.13.3...@vtmn/vue@0.13.4) (2022-02-25)

**Note:** Version bump only for package @vtmn/vue

## [0.13.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.13.2...@vtmn/vue@0.13.3) (2022-02-23)

**Note:** Version bump only for package @vtmn/vue

## [0.13.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.13.1...@vtmn/vue@0.13.2) (2022-02-23)

**Note:** Version bump only for package @vtmn/vue

## [0.13.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.13.0...@vtmn/vue@0.13.1) (2022-02-23)

**Note:** Version bump only for package @vtmn/vue

# [0.13.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.12.1...@vtmn/vue@0.13.0) (2022-02-15)

### Features

- **@vtmn/vue:** make identifier props required for selection controls components ([#974](https://github.com/Decathlon/vitamin-web/issues/974)) ([a1a1503](https://github.com/Decathlon/vitamin-web/commit/a1a1503e4648cdfa8a4b74655c20bab8b45f45b5))

## [0.12.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.12.0...@vtmn/vue@0.12.1) (2022-02-15)

**Note:** Version bump only for package @vtmn/vue

# [0.12.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.11.2...@vtmn/vue@0.12.0) (2022-02-11)

### Features

- **@vtmn/vue:** add `VtmnToggle` and `VtmnCheckbox` reactivity ([#967](https://github.com/Decathlon/vitamin-web/issues/967)) ([e2b8ff2](https://github.com/Decathlon/vitamin-web/commit/e2b8ff2579bbe955925cef0fe55c493ff5579d27))
- **@vtmn/vue:** add VtmnLink types ([#968](https://github.com/Decathlon/vitamin-web/issues/968)) ([46c3cfc](https://github.com/Decathlon/vitamin-web/commit/46c3cfc6d28c70dcce673fe0444f65b6246a1bec))

## [0.11.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.11.1...@vtmn/vue@0.11.2) (2022-02-10)

**Note:** Version bump only for package @vtmn/vue

## [0.11.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.11.0...@vtmn/vue@0.11.1) (2022-02-08)

**Note:** Version bump only for package @vtmn/vue

# [0.11.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.10.0...@vtmn/vue@0.11.0) (2022-02-08)

### Bug Fixes

- **@vtmn/vue:** lint ([53bdee8](https://github.com/Decathlon/vitamin-web/commit/53bdee84cb14fe30ac968ab7d5e9ef287b51f4a6))

### Features

- **@vtmn/vue:** add reactivity to `VtmnRadioButton` component ([#956](https://github.com/Decathlon/vitamin-web/issues/956)) ([a2d1139](https://github.com/Decathlon/vitamin-web/commit/a2d11397f9d5b2a5c687304aaa6d6cce32e0dc16))

# [0.10.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.29...@vtmn/vue@0.10.0) (2022-02-08)

### Features

- **@vtmn/vue:** add `VtmnIcon` component ([#955](https://github.com/Decathlon/vitamin-web/issues/955)) ([f0bb8ea](https://github.com/Decathlon/vitamin-web/commit/f0bb8ea1ef5b199fae4e9e51509b49be5c35e612))
- **@vtmn/vue:** add types and props to`VtmnButton` component ([#954](https://github.com/Decathlon/vitamin-web/issues/954)) ([4ff9756](https://github.com/Decathlon/vitamin-web/commit/4ff9756f21a7d7c574786932e875d4b27284ba1e))

## [0.9.29](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.28...@vtmn/vue@0.9.29) (2022-02-03)

**Note:** Version bump only for package @vtmn/vue

## [0.9.28](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.27...@vtmn/vue@0.9.28) (2022-02-03)

**Note:** Version bump only for package @vtmn/vue

## [0.9.27](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.26...@vtmn/vue@0.9.27) (2022-02-02)

**Note:** Version bump only for package @vtmn/vue

## [0.9.26](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.25...@vtmn/vue@0.9.26) (2022-01-28)

**Note:** Version bump only for package @vtmn/vue

## [0.9.25](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.24...@vtmn/vue@0.9.25) (2022-01-27)

**Note:** Version bump only for package @vtmn/vue

## [0.9.24](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.23...@vtmn/vue@0.9.24) (2022-01-26)

**Note:** Version bump only for package @vtmn/vue

## [0.9.23](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.22...@vtmn/vue@0.9.23) (2022-01-24)

**Note:** Version bump only for package @vtmn/vue

## [0.9.22](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.21...@vtmn/vue@0.9.22) (2022-01-20)

**Note:** Version bump only for package @vtmn/vue

## [0.9.21](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.20...@vtmn/vue@0.9.21) (2022-01-20)

**Note:** Version bump only for package @vtmn/vue

## [0.9.20](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.19...@vtmn/vue@0.9.20) (2022-01-20)

**Note:** Version bump only for package @vtmn/vue

## [0.9.19](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.18...@vtmn/vue@0.9.19) (2022-01-20)

**Note:** Version bump only for package @vtmn/vue

## [0.9.18](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.17...@vtmn/vue@0.9.18) (2022-01-19)

**Note:** Version bump only for package @vtmn/vue

## [0.9.17](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.16...@vtmn/vue@0.9.17) (2022-01-19)

**Note:** Version bump only for package @vtmn/vue

## [0.9.16](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.15...@vtmn/vue@0.9.16) (2022-01-19)

**Note:** Version bump only for package @vtmn/vue

## [0.9.15](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.14...@vtmn/vue@0.9.15) (2022-01-19)

**Note:** Version bump only for package @vtmn/vue

## [0.9.14](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.13...@vtmn/vue@0.9.14) (2022-01-19)

**Note:** Version bump only for package @vtmn/vue

## [0.9.13](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.12...@vtmn/vue@0.9.13) (2022-01-18)

**Note:** Version bump only for package @vtmn/vue

## [0.9.12](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.11...@vtmn/vue@0.9.12) (2022-01-17)

**Note:** Version bump only for package @vtmn/vue

## [0.9.11](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.10...@vtmn/vue@0.9.11) (2022-01-14)

**Note:** Version bump only for package @vtmn/vue

## [0.9.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.9...@vtmn/vue@0.9.10) (2022-01-10)

**Note:** Version bump only for package @vtmn/vue

## [0.9.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.8...@vtmn/vue@0.9.9) (2022-01-10)

**Note:** Version bump only for package @vtmn/vue

## [0.9.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.7...@vtmn/vue@0.9.8) (2022-01-05)

**Note:** Version bump only for package @vtmn/vue

## [0.9.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.6...@vtmn/vue@0.9.7) (2022-01-03)

**Note:** Version bump only for package @vtmn/vue

## [0.9.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.5...@vtmn/vue@0.9.6) (2021-12-31)

**Note:** Version bump only for package @vtmn/vue

## [0.9.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.4...@vtmn/vue@0.9.5) (2021-12-30)

**Note:** Version bump only for package @vtmn/vue

## [0.9.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.3...@vtmn/vue@0.9.4) (2021-12-28)

**Note:** Version bump only for package @vtmn/vue

## [0.9.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.2...@vtmn/vue@0.9.3) (2021-12-28)

**Note:** Version bump only for package @vtmn/vue

## [0.9.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.1...@vtmn/vue@0.9.2) (2021-12-28)

**Note:** Version bump only for package @vtmn/vue

## [0.9.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.9.0...@vtmn/vue@0.9.1) (2021-12-27)

**Note:** Version bump only for package @vtmn/vue

# [0.9.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.28...@vtmn/vue@0.9.0) (2021-12-15)

### Features

- **@vtmn/css:** add navbar component ([#676](https://github.com/Decathlon/vitamin-web/issues/676)) ([95fb5dc](https://github.com/Decathlon/vitamin-web/commit/95fb5dcf2b29edd7850ed51c9c008de8ade6560e))

## [0.8.28](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.27...@vtmn/vue@0.8.28) (2021-12-03)

**Note:** Version bump only for package @vtmn/vue

## [0.8.27](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.26...@vtmn/vue@0.8.27) (2021-12-03)

**Note:** Version bump only for package @vtmn/vue

## [0.8.26](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.25...@vtmn/vue@0.8.26) (2021-12-03)

**Note:** Version bump only for package @vtmn/vue

## [0.8.25](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.24...@vtmn/vue@0.8.25) (2021-11-30)

**Note:** Version bump only for package @vtmn/vue

## [0.8.24](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.23...@vtmn/vue@0.8.24) (2021-11-30)

**Note:** Version bump only for package @vtmn/vue

## [0.8.23](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.22...@vtmn/vue@0.8.23) (2021-11-30)

**Note:** Version bump only for package @vtmn/vue

## [0.8.22](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.21...@vtmn/vue@0.8.22) (2021-11-23)

**Note:** Version bump only for package @vtmn/vue

## [0.8.21](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.20...@vtmn/vue@0.8.21) (2021-11-22)

**Note:** Version bump only for package @vtmn/vue

## [0.8.20](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.19...@vtmn/vue@0.8.20) (2021-11-18)

**Note:** Version bump only for package @vtmn/vue

## [0.8.19](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.18...@vtmn/vue@0.8.19) (2021-11-15)

**Note:** Version bump only for package @vtmn/vue

## [0.8.18](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.17...@vtmn/vue@0.8.18) (2021-11-14)

**Note:** Version bump only for package @vtmn/vue

## [0.8.17](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.16...@vtmn/vue@0.8.17) (2021-11-09)

**Note:** Version bump only for package @vtmn/vue

## [0.8.16](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.15...@vtmn/vue@0.8.16) (2021-11-09)

**Note:** Version bump only for package @vtmn/vue

## [0.8.15](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.14...@vtmn/vue@0.8.15) (2021-11-03)

**Note:** Version bump only for package @vtmn/vue

## [0.8.14](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.13...@vtmn/vue@0.8.14) (2021-11-03)

**Note:** Version bump only for package @vtmn/vue

## [0.8.13](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.12...@vtmn/vue@0.8.13) (2021-10-29)

**Note:** Version bump only for package @vtmn/vue

## [0.8.12](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.11...@vtmn/vue@0.8.12) (2021-10-28)

**Note:** Version bump only for package @vtmn/vue

## [0.8.11](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.10...@vtmn/vue@0.8.11) (2021-10-26)

**Note:** Version bump only for package @vtmn/vue

## [0.8.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.9...@vtmn/vue@0.8.10) (2021-10-26)

**Note:** Version bump only for package @vtmn/vue

## [0.8.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.8...@vtmn/vue@0.8.9) (2021-10-25)

**Note:** Version bump only for package @vtmn/vue

## [0.8.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.7...@vtmn/vue@0.8.8) (2021-10-25)

**Note:** Version bump only for package @vtmn/vue

## [0.8.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.6...@vtmn/vue@0.8.7) (2021-10-25)

### Bug Fixes

- **@vtmn/vue:** add @rollup/plugin-typescript in dependencies ([794403a](https://github.com/Decathlon/vitamin-web/commit/794403a5356bd596a5ca330eea06f10fa8ad6379))

## [0.8.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.5...@vtmn/vue@0.8.6) (2021-10-22)

**Note:** Version bump only for package @vtmn/vue

## [0.8.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.4...@vtmn/vue@0.8.5) (2021-10-22)

**Note:** Version bump only for package @vtmn/vue

## [0.8.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.3...@vtmn/vue@0.8.4) (2021-10-22)

**Note:** Version bump only for package @vtmn/vue

## [0.8.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.2...@vtmn/vue@0.8.3) (2021-10-22)

### Bug Fixes

- **@vtmn/vue:** typescript build init ([#677](https://github.com/Decathlon/vitamin-web/issues/677)) ([7a7c24a](https://github.com/Decathlon/vitamin-web/commit/7a7c24a0a9fd8fe9be266b3bab7a11785b4ca456))

## [0.8.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.1...@vtmn/vue@0.8.2) (2021-10-12)

**Note:** Version bump only for package @vtmn/vue

## [0.8.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.8.0...@vtmn/vue@0.8.1) (2021-10-01)

**Note:** Version bump only for package @vtmn/vue

# [0.8.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.10...@vtmn/vue@0.8.0) (2021-09-28)

### Features

- **@vtmn/css:** add skeleton component ([#616](https://github.com/Decathlon/vitamin-web/issues/616)) ([db8d9e8](https://github.com/Decathlon/vitamin-web/commit/db8d9e80eeb56aac8b3b5584b421244eb8588537))

## [0.7.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.9...@vtmn/vue@0.7.10) (2021-09-14)

**Note:** Version bump only for package @vtmn/vue

## [0.7.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.8...@vtmn/vue@0.7.9) (2021-08-25)

**Note:** Version bump only for package @vtmn/vue

## [0.7.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.7...@vtmn/vue@0.7.8) (2021-08-18)

**Note:** Version bump only for package @vtmn/vue

## [0.7.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.6...@vtmn/vue@0.7.7) (2021-08-09)

**Note:** Version bump only for package @vtmn/vue

## [0.7.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.5...@vtmn/vue@0.7.6) (2021-08-03)

**Note:** Version bump only for package @vtmn/vue

## [0.7.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.4...@vtmn/vue@0.7.5) (2021-08-02)

**Note:** Version bump only for package @vtmn/vue

## [0.7.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.3...@vtmn/vue@0.7.4) (2021-07-30)

**Note:** Version bump only for package @vtmn/vue

## [0.7.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.2...@vtmn/vue@0.7.3) (2021-07-28)

**Note:** Version bump only for package @vtmn/vue

## [0.7.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.1...@vtmn/vue@0.7.2) (2021-07-23)

**Note:** Version bump only for package @vtmn/vue

## [0.7.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.7.0...@vtmn/vue@0.7.1) (2021-07-23)

**Note:** Version bump only for package @vtmn/vue

# [0.7.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.6.4...@vtmn/vue@0.7.0) (2021-07-23)

### Features

- **@vtmn/react @vtmn/vue @vtmn/svelte:** correct multiline states and helper texts ([#454](https://github.com/Decathlon/vitamin-web/issues/454)) ([f119bbe](https://github.com/Decathlon/vitamin-web/commit/f119bbe75eddf1f859461a071569bc6c53b4d1a3))

## [0.6.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.6.3...@vtmn/vue@0.6.4) (2021-07-22)

**Note:** Version bump only for package @vtmn/vue

## [0.6.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.6.2...@vtmn/vue@0.6.3) (2021-07-19)

**Note:** Version bump only for package @vtmn/vue

## [0.6.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.6.1...@vtmn/vue@0.6.2) (2021-06-25)

**Note:** Version bump only for package @vtmn/vue

## [0.6.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.6.0...@vtmn/vue@0.6.1) (2021-06-24)

**Note:** Version bump only for package @vtmn/vue

# [0.6.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.5.0...@vtmn/vue@0.6.0) (2021-06-24)

### Features

- **@vtmn/vue:** add toggle component ([#383](https://github.com/Decathlon/vitamin-web/issues/383)) ([027fb90](https://github.com/Decathlon/vitamin-web/commit/027fb90a11a86cb46e7160a59df1cae98490f992))

# [0.5.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.4.0...@vtmn/vue@0.5.0) (2021-06-23)

### Features

- **@vtmn/vue:** add icons in button component ([#382](https://github.com/Decathlon/vitamin-web/issues/382)) ([6ea5eb8](https://github.com/Decathlon/vitamin-web/commit/6ea5eb8f009e48edb368fbc278f1a5c2de0e748d))

# [0.4.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.3.0...@vtmn/vue@0.4.0) (2021-06-21)

### Features

- **@vtmn/vue:** add text input component ([#359](https://github.com/Decathlon/vitamin-web/issues/359)) ([0589891](https://github.com/Decathlon/vitamin-web/commit/058989123c0282b126fddb7021d887a05f94ab8b))

# [0.3.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.2.1...@vtmn/vue@0.3.0) (2021-06-21)

### Features

- **@vtmn/vue:** add link component ([#358](https://github.com/Decathlon/vitamin-web/issues/358)) ([7de0dd7](https://github.com/Decathlon/vitamin-web/commit/7de0dd77ca00686fabbd1fec1f2db6f75bef7068)), closes [#341](https://github.com/Decathlon/vitamin-web/issues/341)

## [0.2.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.2.0...@vtmn/vue@0.2.1) (2021-06-17)

**Note:** Version bump only for package @vtmn/vue

# [0.2.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.1.0...@vtmn/vue@0.2.0) (2021-06-17)

### Features

- **@vtmn/vue:** add checkbox component ([#363](https://github.com/Decathlon/vitamin-web/issues/363)) ([b3258c4](https://github.com/Decathlon/vitamin-web/commit/b3258c4374dac5a22d3e208cb785b444b6bdfdfd))

# [0.1.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.31...@vtmn/vue@0.1.0) (2021-06-17)

### Features

- **@vtmn/vue:** add radio button component ([#360](https://github.com/Decathlon/vitamin-web/issues/360)) ([96f7c48](https://github.com/Decathlon/vitamin-web/commit/96f7c48fd978a85927d6d82ad8ee5c7dddd1608a))

## [0.0.31](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.30...@vtmn/vue@0.0.31) (2021-06-17)

**Note:** Version bump only for package @vtmn/vue

## [0.0.30](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.29...@vtmn/vue@0.0.30) (2021-06-17)

**Note:** Version bump only for package @vtmn/vue

## [0.0.29](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.28...@vtmn/vue@0.0.29) (2021-06-14)

**Note:** Version bump only for package @vtmn/vue

## [0.0.28](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.27...@vtmn/vue@0.0.28) (2021-06-14)

**Note:** Version bump only for package @vtmn/vue

## [0.0.27](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.26...@vtmn/vue@0.0.27) (2021-06-14)

**Note:** Version bump only for package @vtmn/vue

## [0.0.26](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.25...@vtmn/vue@0.0.26) (2021-06-03)

**Note:** Version bump only for package @vtmn/vue

## [0.0.25](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.24...@vtmn/vue@0.0.25) (2021-06-02)

**Note:** Version bump only for package @vtmn/vue

## [0.0.24](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.23...@vtmn/vue@0.0.24) (2021-06-02)

**Note:** Version bump only for package @vtmn/vue

## [0.0.23](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.22...@vtmn/vue@0.0.23) (2021-06-01)

**Note:** Version bump only for package @vtmn/vue

## [0.0.22](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.21...@vtmn/vue@0.0.22) (2021-05-13)

**Note:** Version bump only for package @vtmn/vue

## [0.0.21](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.20...@vtmn/vue@0.0.21) (2021-04-29)

**Note:** Version bump only for package @vtmn/vue

## [0.0.20](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.19...@vtmn/vue@0.0.20) (2021-04-20)

**Note:** Version bump only for package @vtmn/vue

## [0.0.19](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.18...@vtmn/vue@0.0.19) (2021-04-19)

**Note:** Version bump only for package @vtmn/vue

## [0.0.18](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.17...@vtmn/vue@0.0.18) (2021-04-16)

**Note:** Version bump only for package @vtmn/vue

## [0.0.17](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.16...@vtmn/vue@0.0.17) (2021-04-02)

**Note:** Version bump only for package @vtmn/vue

## [0.0.16](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.15...@vtmn/vue@0.0.16) (2021-03-31)

**Note:** Version bump only for package @vtmn/vue

## [0.0.15](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.14...@vtmn/vue@0.0.15) (2021-03-20)

**Note:** Version bump only for package @vtmn/vue

## [0.0.14](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.13...@vtmn/vue@0.0.14) (2021-03-15)

**Note:** Version bump only for package @vtmn/vue

## [0.0.13](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.12...@vtmn/vue@0.0.13) (2021-03-15)

**Note:** Version bump only for package @vtmn/vue

## [0.0.12](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.11...@vtmn/vue@0.0.12) (2021-03-10)

**Note:** Version bump only for package @vtmn/vue

## [0.0.11](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.10...@vtmn/vue@0.0.11) (2021-03-09)

**Note:** Version bump only for package @vtmn/vue

## [0.0.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.9...@vtmn/vue@0.0.10) (2021-02-26)

**Note:** Version bump only for package @vtmn/vue

## [0.0.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.8...@vtmn/vue@0.0.9) (2021-02-26)

**Note:** Version bump only for package @vtmn/vue

## [0.0.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.7...@vtmn/vue@0.0.8) (2021-02-25)

**Note:** Version bump only for package @vtmn/vue

## [0.0.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.6...@vtmn/vue@0.0.7) (2021-02-25)

**Note:** Version bump only for package @vtmn/vue

## [0.0.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.5...@vtmn/vue@0.0.6) (2021-02-25)

**Note:** Version bump only for package @vtmn/vue

## [0.0.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.4...@vtmn/vue@0.0.5) (2021-02-25)

**Note:** Version bump only for package @vtmn/vue

## [0.0.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.3...@vtmn/vue@0.0.4) (2021-02-25)

**Note:** Version bump only for package @vtmn/vue

## [0.0.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.2...@vtmn/vue@0.0.3) (2021-02-23)

**Note:** Version bump only for package @vtmn/vue

## [0.0.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/vue@0.0.1...@vtmn/vue@0.0.2) (2021-02-22)

**Note:** Version bump only for package @vtmn/vue

## 0.0.1 (2021-02-22)

**Note:** Version bump only for package @vtmn/vue
