# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [3.0.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@3.0.1...@vtmn/css@3.0.2) (2024-02-12)

### Bug Fixes

- **`@vtmn/svelte`, `@vtmn/css`:** fix timeout on overlays components ([#1480](https://github.com/Decathlon/vitamin-web/issues/1480)) ([15ccc52](https://github.com/Decathlon/vitamin-web/commit/15ccc5286832d3da0ff531c903148ba0f31f8e6e))

## [3.0.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@3.0.0...@vtmn/css@3.0.1) (2023-09-13)

### Bug Fixes

- bug on appearance of VtmnQuantity for Safari & Chrome mobile + improve showcases ([cb83c73](https://github.com/Decathlon/vitamin-web/commit/cb83c7334bb372be4617904f0cca26140dd3f26d))

# [3.0.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@2.0.7...@vtmn/css@3.0.0) (2023-08-04)

### Features

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** `VtmnChip` variant `input` match now the figma specs ([#1456](https://github.com/Decathlon/vitamin-web/issues/1456)) ([8b33064](https://github.com/Decathlon/vitamin-web/commit/8b33064e0adacb41b268bd09c17b8b3064e57937))

### BREAKING CHANGES

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** The design of `VtmnChip`now matches Figma's version. If you used the `VtmnChip` with an "input" variant, you will have changes when you will upgrade to this new version. "Selected" input is no longer available on this variant. The color of the variant stays white, and no longer has a blue color.

## [2.0.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@2.0.6...@vtmn/css@2.0.7) (2023-08-02)

### Bug Fixes

- convert breakpoints variables to values instead of strings ([#1458](https://github.com/Decathlon/vitamin-web/issues/1458)) ([e0e3a34](https://github.com/Decathlon/vitamin-web/commit/e0e3a34a8513cb8eb8d0b4ea2bd83a8fe6457253))

## [2.0.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@2.0.5...@vtmn/css@2.0.6) (2023-07-03)

**Note:** Version bump only for package @vtmn/css

## [2.0.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@2.0.4...@vtmn/css@2.0.5) (2023-06-29)

### Bug Fixes

- **@vtmn/css:** wrong color of close icon in text-input component ([09dfe88](https://github.com/Decathlon/vitamin-web/commit/09dfe888c599f68ac0eb68a4c2505c28ea00c3c6))

## [2.0.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@2.0.3...@vtmn/css@2.0.4) (2023-06-29)

### Bug Fixes

- **@vtmn/css:** wrong color of close icon in text-input component ([cac53d3](https://github.com/Decathlon/vitamin-web/commit/cac53d3a2daa62948f6a7495bb8bf12ef46e5173))

## [2.0.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@2.0.2...@vtmn/css@2.0.3) (2023-06-21)

**Note:** Version bump only for package @vtmn/css

## [2.0.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@2.0.1...@vtmn/css@2.0.2) (2023-06-20)

### Bug Fixes

- **@vtmn/css:** the thumb of the Toggle component doesn't have the right color in dark mode ([#1443](https://github.com/Decathlon/vitamin-web/issues/1443)) ([8ad1179](https://github.com/Decathlon/vitamin-web/commit/8ad1179d83928a9b692edd3b6e96896b93e989fe))

## [2.0.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@2.0.0...@vtmn/css@2.0.1) (2023-06-16)

### Bug Fixes

- **`@vtmn/css`:** fix padding end with child count for `VtmnSearch` ([#1439](https://github.com/Decathlon/vitamin-web/issues/1439)) ([41cb153](https://github.com/Decathlon/vitamin-web/commit/41cb15348b9583c18d6e19071d8c9715c257dbad))

# [2.0.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@1.3.1...@vtmn/css@2.0.0) (2023-06-13)

### Features

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** rework `VtmnNavbarLink` for SSR ([#1436](https://github.com/Decathlon/vitamin-web/issues/1436)) ([5f21476](https://github.com/Decathlon/vitamin-web/commit/5f21476c20f5431e2966920d262a62bf1079869e))

### BREAKING CHANGES

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** The VtmnNavbarLink component removes properties "label" and "showLabel", they are replaced by a <span> slot.

## [1.3.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@1.3.0...@vtmn/css@1.3.1) (2023-06-05)

**Note:** Version bump only for package @vtmn/css

# [1.3.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@1.2.2...@vtmn/css@1.3.0) (2023-06-02)

### Features

- **`@vtmn/css`, `@vtmn/svelte`, `@vtmn/react`, `@vtmn/vue`:** rework `VtmnNavbarLink` for SSR ([#1425](https://github.com/Decathlon/vitamin-web/issues/1425)) ([dc6b999](https://github.com/Decathlon/vitamin-web/commit/dc6b99940a6aa3f1b2023bd7c139344c6a6e28cd))

## [1.2.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@1.2.1...@vtmn/css@1.2.2) (2023-04-18)

**Note:** Version bump only for package @vtmn/css

## [1.2.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@1.2.0...@vtmn/css@1.2.1) (2023-04-18)

**Note:** Version bump only for package @vtmn/css

# [1.2.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@1.1.2...@vtmn/css@1.2.0) (2023-04-12)

### Features

- **@vtmn/svelte, @vtmn/vue, @vtmn/react:** possibility to add a `VtmnBadge` on the `VtmnNavbarLink` ([#1416](https://github.com/Decathlon/vitamin-web/issues/1416)) ([ff345a9](https://github.com/Decathlon/vitamin-web/commit/ff345a93a43716004d1554eb0a17c1e5c1274768))

## [1.1.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@1.1.1...@vtmn/css@1.1.2) (2023-04-12)

**Note:** Version bump only for package @vtmn/css

## [1.1.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@1.1.0...@vtmn/css@1.1.1) (2023-04-02)

**Note:** Version bump only for package @vtmn/css

# [1.1.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.96.4...@vtmn/css@1.1.0) (2023-03-22)

### Features

- bump packages to 1.x.x ([#1397](https://github.com/Decathlon/vitamin-web/issues/1397)) ([ddb1589](https://github.com/Decathlon/vitamin-web/commit/ddb1589616c267100edd785c11a476868d856bfc))

## [0.96.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.96.3...@vtmn/css@0.96.4) (2023-03-22)

**Note:** Version bump only for package @vtmn/css

## [0.96.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.96.2...@vtmn/css@0.96.3) (2023-03-21)

**Note:** Version bump only for package @vtmn/css

## [0.96.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.96.1...@vtmn/css@0.96.2) (2023-03-21)

**Note:** Version bump only for package @vtmn/css

## [0.96.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.96.0...@vtmn/css@0.96.1) (2023-03-13)

**Note:** Version bump only for package @vtmn/css

# [0.96.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.95.2...@vtmn/css@0.96.0) (2023-03-09)

### Features

- **listItem:** add position relative ([#1383](https://github.com/Decathlon/vitamin-web/issues/1383)) ([ca23341](https://github.com/Decathlon/vitamin-web/commit/ca23341c3e39f6504f42f98c4262a650a76c8f17))
- **listItem:** add position relative ([#1384](https://github.com/Decathlon/vitamin-web/issues/1384)) ([8382373](https://github.com/Decathlon/vitamin-web/commit/838237316c438ad345a3d6a46d3ceb1bfa0599ca))

## [0.95.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.95.1...@vtmn/css@0.95.2) (2023-03-09)

**Note:** Version bump only for package @vtmn/css

## [0.95.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.95.0...@vtmn/css@0.95.1) (2023-02-27)

**Note:** Version bump only for package @vtmn/css

# [0.95.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.94.1...@vtmn/css@0.95.0) (2023-02-21)

### Features

- add navbar link ([#1372](https://github.com/Decathlon/vitamin-web/issues/1372)) ([6b8a621](https://github.com/Decathlon/vitamin-web/commit/6b8a621c8b0c2eb0c99db88afedb4d5f1b0697ba))

## [0.94.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.94.0...@vtmn/css@0.94.1) (2023-02-10)

### Bug Fixes

- **@vtmn/css-quantity:** full-width ([#1371](https://github.com/Decathlon/vitamin-web/issues/1371)) ([638c73f](https://github.com/Decathlon/vitamin-web/commit/638c73fef3e5e982053d90d328661788188d6503))

# [0.94.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.93.0...@vtmn/css@0.94.0) (2023-02-10)

### Features

- add a new prop for Select component for border ([#1365](https://github.com/Decathlon/vitamin-web/issues/1365)) ([9e21b77](https://github.com/Decathlon/vitamin-web/commit/9e21b77407ca65715d290fdb5464380c70db330d))

# [0.93.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.92.0...@vtmn/css@0.93.0) (2023-02-09)

### Features

- add small size for `Quantity` component ([#1368](https://github.com/Decathlon/vitamin-web/issues/1368)) ([1ab77c3](https://github.com/Decathlon/vitamin-web/commit/1ab77c3969a4f829795b01fc6903964041649cc7))

# [0.92.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.91.5...@vtmn/css@0.92.0) (2023-02-09)

### Bug Fixes

- **@vtmn/css-card:** align padding between variants ([#1366](https://github.com/Decathlon/vitamin-web/issues/1366)) ([ffbaf65](https://github.com/Decathlon/vitamin-web/commit/ffbaf650c1b8236b16db05aaf79aa828d8145ead))

### Features

- make extensible quantity component ([#1364](https://github.com/Decathlon/vitamin-web/issues/1364)) ([69ebb23](https://github.com/Decathlon/vitamin-web/commit/69ebb232119a45379fe22e9a2149f4dcd779d54c))

## [0.91.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.91.4...@vtmn/css@0.91.5) (2023-02-05)

**Note:** Version bump only for package @vtmn/css

## [0.91.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.91.3...@vtmn/css@0.91.4) (2023-02-05)

**Note:** Version bump only for package @vtmn/css

## [0.91.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.91.2...@vtmn/css@0.91.3) (2023-02-03)

**Note:** Version bump only for package @vtmn/css

## [0.91.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.91.1...@vtmn/css@0.91.2) (2023-02-03)

**Note:** Version bump only for package @vtmn/css

## [0.91.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.91.0...@vtmn/css@0.91.1) (2023-01-31)

**Note:** Version bump only for package @vtmn/css

# [0.91.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.90.1...@vtmn/css@0.91.0) (2023-01-30)

### Features

- **@vtmn/css:** update price to allow no-padding ([#1343](https://github.com/Decathlon/vitamin-web/issues/1343)) ([d5ede03](https://github.com/Decathlon/vitamin-web/commit/d5ede03a6404b6426745a6b8a7035d2d40bf4f74))

## [0.90.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.90.0...@vtmn/css@0.90.1) (2023-01-26)

### Reverts

- Revert "feat(@vtmn/css): improve `VtmnPrice` component by removing padding (#1341)" ([26378a2](https://github.com/Decathlon/vitamin-web/commit/26378a2a492d08a8c32bd2edbc8bad04d417a462)), closes [#1341](https://github.com/Decathlon/vitamin-web/issues/1341)

# [0.90.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.89.2...@vtmn/css@0.90.0) (2023-01-20)

### Features

- **@vtmn/css:** improve `VtmnPrice` component by removing padding ([#1341](https://github.com/Decathlon/vitamin-web/issues/1341)) ([b49492d](https://github.com/Decathlon/vitamin-web/commit/b49492d358563868566a7526000fe2b038426aea))

## [0.89.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.89.1...@vtmn/css@0.89.2) (2023-01-20)

**Note:** Version bump only for package @vtmn/css

## [0.89.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.89.0...@vtmn/css@0.89.1) (2023-01-20)

### Bug Fixes

- **@vtmn/css:** remove white space for list text ([#1340](https://github.com/Decathlon/vitamin-web/issues/1340)) ([daa0f12](https://github.com/Decathlon/vitamin-web/commit/daa0f126df79b6a76c4e89bac6ef4afa43b382ad))

# [0.89.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.88.0...@vtmn/css@0.89.0) (2023-01-17)

### Features

- add XSmall size on Price variant ([#1329](https://github.com/Decathlon/vitamin-web/issues/1329)) ([ce1de41](https://github.com/Decathlon/vitamin-web/commit/ce1de417d6c3c5c558cb850d32870d188754118b))

# [0.88.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.87.1...@vtmn/css@0.88.0) (2023-01-17)

### Features

- **@vtmn/css:** add href property on `VtmnListItem` ([#1321](https://github.com/Decathlon/vitamin-web/issues/1321)) ([598e663](https://github.com/Decathlon/vitamin-web/commit/598e66328a9fcb414d49a9fe8a1a4f24ba7321c6))

## [0.87.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.87.0...@vtmn/css@0.87.1) (2023-01-06)

**Note:** Version bump only for package @vtmn/css

# [0.87.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.86.0...@vtmn/css@0.87.0) (2022-12-30)

### Bug Fixes

- re-trigger linter for lerna ([c2ce2c4](https://github.com/Decathlon/vitamin-web/commit/c2ce2c4b3305b2283b68c8189d2d7ef6269d52e6))

### Features

- **@vtmn/css:** add small size for `VtmnTag` component ([#1320](https://github.com/Decathlon/vitamin-web/issues/1320)) ([e4b0ffb](https://github.com/Decathlon/vitamin-web/commit/e4b0ffbfc64d67718e7e0f4c3f0dbfa6c89de245))

# [0.86.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.19...@vtmn/css@0.86.0) (2022-11-24)

### Features

- **@vtmn/svelte, @vtmn/react, @vtmn/vue, @vtmn/css:** add heading level on title + title wraps correctly ([#1304](https://github.com/Decathlon/vitamin-web/issues/1304)) ([bfc4a0a](https://github.com/Decathlon/vitamin-web/commit/bfc4a0aa0daaa5ee557c9b55fbd4830ebdbf989f))

## [0.85.19](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.18...@vtmn/css@0.85.19) (2022-11-17)

**Note:** Version bump only for package @vtmn/css

## [0.85.18](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.17...@vtmn/css@0.85.18) (2022-11-14)

**Note:** Version bump only for package @vtmn/css

## [0.85.17](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.16...@vtmn/css@0.85.17) (2022-10-28)

**Note:** Version bump only for package @vtmn/css

## [0.85.16](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.15...@vtmn/css@0.85.16) (2022-10-21)

**Note:** Version bump only for package @vtmn/css

## [0.85.15](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.14...@vtmn/css@0.85.15) (2022-10-21)

### Bug Fixes

- **@vtmn/showcase-svelte:** showcase header & Card component in Storybook Svelte ([#1289](https://github.com/Decathlon/vitamin-web/issues/1289)) ([4b1c430](https://github.com/Decathlon/vitamin-web/commit/4b1c430afc22a4a43fbede848039350557dd4f9b))

## [0.85.14](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.13...@vtmn/css@0.85.14) (2022-10-19)

**Note:** Version bump only for package @vtmn/css

## [0.85.13](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.12...@vtmn/css@0.85.13) (2022-10-19)

### Bug Fixes

- manage preflight styles ([#1279](https://github.com/Decathlon/vitamin-web/issues/1279)) ([df6f86f](https://github.com/Decathlon/vitamin-web/commit/df6f86f6315f6555cd9d36f30104037ca07cb4d7)), closes [#1278](https://github.com/Decathlon/vitamin-web/issues/1278) [#1278](https://github.com/Decathlon/vitamin-web/issues/1278)

## [0.85.12](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.11...@vtmn/css@0.85.12) (2022-10-14)

### Bug Fixes

- **@vtmn/css:** tailwind custom reset styles ([94ad083](https://github.com/Decathlon/vitamin-web/commit/94ad0833800cb26d9596436046fdeb0b7c05a60e))

## [0.85.11](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.10...@vtmn/css@0.85.11) (2022-10-14)

### Bug Fixes

- **@vtmn/css, @vtmn/svelte:** missing preflight for some component like `VtmnTabs` ([#1277](https://github.com/Decathlon/vitamin-web/issues/1277)) ([cd3df25](https://github.com/Decathlon/vitamin-web/commit/cd3df250770439bb636c3ac8ca51f3c330b2a4e1))

## [0.85.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.9...@vtmn/css@0.85.10) (2022-10-14)

**Note:** Version bump only for package @vtmn/css

## [0.85.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.8...@vtmn/css@0.85.9) (2022-10-07)

### Bug Fixes

- **@vtmn/css, @vtmn/react, @vtmn/vue, @vtmn/svelte:** linear progressbar animation ([#1238](https://github.com/Decathlon/vitamin-web/issues/1238)) ([bfb1aaf](https://github.com/Decathlon/vitamin-web/commit/bfb1aaf06a36b3faa1d06457c69b5b2308cabab2))

## [0.85.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.7...@vtmn/css@0.85.8) (2022-09-23)

### Bug Fixes

- **@vtmn/css, @vtmn/svelte, @vtmn/react, @vtmn/vue:** popover position & a11y ([#1259](https://github.com/Decathlon/vitamin-web/issues/1259)) ([#1261](https://github.com/Decathlon/vitamin-web/issues/1261)) ([219d318](https://github.com/Decathlon/vitamin-web/commit/219d3182e6404ac7a6cede344334e354730e7008))

## [0.85.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.6...@vtmn/css@0.85.7) (2022-09-13)

**Note:** Version bump only for package @vtmn/css

## [0.85.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.5...@vtmn/css@0.85.6) (2022-09-05)

**Note:** Version bump only for package @vtmn/css

## [0.85.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.4...@vtmn/css@0.85.5) (2022-08-22)

**Note:** Version bump only for package @vtmn/css

## [0.85.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.3...@vtmn/css@0.85.4) (2022-08-05)

### Bug Fixes

- **@vtmn/css:** corrections of a11y from second audit check ([#1230](https://github.com/Decathlon/vitamin-web/issues/1230)) ([2c3846b](https://github.com/Decathlon/vitamin-web/commit/2c3846b5220e402c8b404ff481fdb6173bb0edea))

## [0.85.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.2...@vtmn/css@0.85.3) (2022-08-04)

### Bug Fixes

- **@vtmn/css:** fix modal bug from sonarcloud ([#1231](https://github.com/Decathlon/vitamin-web/issues/1231)) ([41efb25](https://github.com/Decathlon/vitamin-web/commit/41efb2534910819f95cc1a8ad7238efa3c08a9bd))

## [0.85.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.1...@vtmn/css@0.85.2) (2022-08-02)

### Bug Fixes

- **@vtmn/css:** fix min-width and wrap behaviour to correctly display the arrow ([#1226](https://github.com/Decathlon/vitamin-web/issues/1226)) ([aafcd3a](https://github.com/Decathlon/vitamin-web/commit/aafcd3a1fb1f885a5d2ac36e75a06e6da16fb4dd))

## [0.85.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.85.0...@vtmn/css@0.85.1) (2022-07-29)

**Note:** Version bump only for package @vtmn/css

# [0.85.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.84.4...@vtmn/css@0.85.0) (2022-07-27)

### Features

- **@vtmn/css, @vtmn/react, @vtmn/svelte, @vtmn/vue:** add selected prop on VtmnTabsItem component ([29d9583](https://github.com/Decathlon/vitamin-web/commit/29d9583fe7146c9a392b231d258c4d9e3f644975))

## [0.84.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.84.3...@vtmn/css@0.84.4) (2022-07-27)

### Bug Fixes

- **@vtmn/css-tailwind-preset:** expose dist folder to retrieve types ([000599a](https://github.com/Decathlon/vitamin-web/commit/000599afced3bd9c5fc28932f5d88ce8597509cd))

## [0.84.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.84.2...@vtmn/css@0.84.3) (2022-07-27)

### Bug Fixes

- **@vtmn/css-tailwind-preset:** generate only types declarations files ([9cc4f77](https://github.com/Decathlon/vitamin-web/commit/9cc4f77c0b8a87a94cae7ebfe14f4104c9ff4ae7))

## [0.84.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.84.1...@vtmn/css@0.84.2) (2022-07-27)

### Bug Fixes

- **@vtmn/css-tailwind-preset:** add types ([#1218](https://github.com/Decathlon/vitamin-web/issues/1218)) ([1605e93](https://github.com/Decathlon/vitamin-web/commit/1605e933711d682898f120177df01b47a3426ca3))
- **@vtmn/css-tailwind-preset:** add types ([#1222](https://github.com/Decathlon/vitamin-web/issues/1222)) ([608e874](https://github.com/Decathlon/vitamin-web/commit/608e8749b0a8a9817a8c203ef927b1780cf65e8b))

### Reverts

- Revert "fix(@vtmn/css-tailwind-preset): add types (#1218)" (#1221) ([cc4080d](https://github.com/Decathlon/vitamin-web/commit/cc4080d5e219623537a41ab1c65ae50ed6de970b)), closes [#1218](https://github.com/Decathlon/vitamin-web/issues/1218) [#1221](https://github.com/Decathlon/vitamin-web/issues/1221)

## [0.84.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.84.0...@vtmn/css@0.84.1) (2022-07-26)

### Bug Fixes

- height:auto in VtmnDropdown component ([#1219](https://github.com/Decathlon/vitamin-web/issues/1219)) ([1da2003](https://github.com/Decathlon/vitamin-web/commit/1da2003879d0c0f0bca0f1e9fb98480ad613b3c1))

# [0.84.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.83.2...@vtmn/css@0.84.0) (2022-07-25)

### Features

- **@vtmn/css-link, @vtmn/react, @vtmn/vue, @vtmn/svelte:** add reversed variant for `VtmnLink` component ([#1213](https://github.com/Decathlon/vitamin-web/issues/1213)) ([1ce650e](https://github.com/Decathlon/vitamin-web/commit/1ce650e31dab5dde18185393437219f388801890))

## [0.83.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.83.1...@vtmn/css@0.83.2) (2022-06-30)

### Bug Fixes

- **@vtmn/css:** select wrap property ([#1202](https://github.com/Decathlon/vitamin-web/issues/1202)) ([a2f5603](https://github.com/Decathlon/vitamin-web/commit/a2f56036b7d448ec9ea45e9c071a9df986ff4b84))

## [0.83.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.83.0...@vtmn/css@0.83.1) (2022-06-28)

### Bug Fixes

- **@vtmn/css:** sonarcloud code smells ([f95800e](https://github.com/Decathlon/vitamin-web/commit/f95800e71b58cd015ad6bf6f0ad64283f2193df0))

# [0.83.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.82.0...@vtmn/css@0.83.0) (2022-06-28)

### Features

- **@vtmn/css, @vtmn/react, @vtmn/svelte, @vtmn/vue:** add or improve `VtmnTabs` component ([#1168](https://github.com/Decathlon/vitamin-web/issues/1168)) ([5c22816](https://github.com/Decathlon/vitamin-web/commit/5c22816a19a9e60e33080eec65bad02492b9dd39))

# [0.82.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.81.0...@vtmn/css@0.82.0) (2022-06-28)

### Features

- **@vtmn/css, @vtmn/react, @vtmn/svelte:** `progressbar`, add a11y requirements ([#1129](https://github.com/Decathlon/vitamin-web/issues/1129)) ([69829e8](https://github.com/Decathlon/vitamin-web/commit/69829e88f2cdc5f80b242cc4c5c2819d8c83d610))

# [0.81.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.80.1...@vtmn/css@0.81.0) (2022-06-27)

### Features

- **@vtmn/css:** change border colors, add missing colors in color themes ([#1194](https://github.com/Decathlon/vitamin-web/issues/1194)) ([95f0329](https://github.com/Decathlon/vitamin-web/commit/95f032995684e909ad7aa868ea86717bbfc2786d))

## [0.80.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.80.0...@vtmn/css@0.80.1) (2022-06-23)

**Note:** Version bump only for package @vtmn/css

# [0.80.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.79.0...@vtmn/css@0.80.0) (2022-06-23)

### Features

- **@vtmn/css:** fix linear grident full image card ([#1188](https://github.com/Decathlon/vitamin-web/issues/1188)) ([a18641b](https://github.com/Decathlon/vitamin-web/commit/a18641bf2d29d5d5832cee1bd70840d0c5d7b976))

# [0.79.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.78.1...@vtmn/css@0.79.0) (2022-06-23)

### Features

- **@vtmn/css:** changre borders quantity component ([#1187](https://github.com/Decathlon/vitamin-web/issues/1187)) ([c0c368d](https://github.com/Decathlon/vitamin-web/commit/c0c368d50e6dde37133225ba97de6ff447b16616))

## [0.78.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.78.0...@vtmn/css@0.78.1) (2022-06-21)

**Note:** Version bump only for package @vtmn/css

# [0.78.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.76.2...@vtmn/css@0.78.0) (2022-06-21)

### Features

- dropdown focus loop ([#1184](https://github.com/Decathlon/vitamin-web/issues/1184)) ([f4a73de](https://github.com/Decathlon/vitamin-web/commit/f4a73de326af16a3e0265db87a21237ad7817b0d)), closes [#1177](https://github.com/Decathlon/vitamin-web/issues/1177)
- modal focus loop ([#1185](https://github.com/Decathlon/vitamin-web/issues/1185)) ([f4b5244](https://github.com/Decathlon/vitamin-web/commit/f4b52445e0e632de608a73c470d9c1212f563b41))

## [0.76.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.76.2...@vtmn/css@0.76.4) (2022-06-21)

**Note:** Version bump only for package @vtmn/css

## [0.76.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.76.1...@vtmn/css@0.76.2) (2022-05-17)

### Bug Fixes

- **@vtmn/css:** add modal padding ([#1166](https://github.com/Decathlon/vitamin-web/issues/1166)) ([979273d](https://github.com/Decathlon/vitamin-web/commit/979273d68829573c20333f829f3aaacc35d5d208))
- **@vtmn/css:** fix scroll padding mobile ([#1165](https://github.com/Decathlon/vitamin-web/issues/1165)) ([3ee15ba](https://github.com/Decathlon/vitamin-web/commit/3ee15bac64639c3021e0cde49ea64cd8dc5dfad1))
- **@vtmn/css:** lint modal component ([a18a3ff](https://github.com/Decathlon/vitamin-web/commit/a18a3ffdf3dca2895aef87c3ea26be400c629a01))

## [0.76.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.76.0...@vtmn/css@0.76.1) (2022-05-16)

### Bug Fixes

- **@vtmn/css:** visual regression of alert component ([#1162](https://github.com/Decathlon/vitamin-web/issues/1162)) ([3c2623f](https://github.com/Decathlon/vitamin-web/commit/3c2623f6ba399ad58ff154449f0660a61f6a16c2))

# [0.76.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.75.3...@vtmn/css@0.76.0) (2022-05-11)

### Features

- **@vtmn/css:** replace physical properties by logical properties ([#1140](https://github.com/Decathlon/vitamin-web/issues/1140)) ([71d13a8](https://github.com/Decathlon/vitamin-web/commit/71d13a8163fec6e3fc3c29647fbeadf46071b6ee))

## [0.75.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.75.2...@vtmn/css@0.75.3) (2022-05-09)

### Bug Fixes

- **@vtmn/css-popover:** bottom position ([e307b3f](https://github.com/Decathlon/vitamin-web/commit/e307b3f2157353ad523eb64913870c9cbc629dfa))

## [0.75.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.75.1...@vtmn/css@0.75.2) (2022-05-09)

**Note:** Version bump only for package @vtmn/css

## [0.75.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.75.0...@vtmn/css@0.75.1) (2022-05-09)

**Note:** Version bump only for package @vtmn/css

# [0.75.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.74.2...@vtmn/css@0.75.0) (2022-05-09)

### Features

- **@vtmn/css & @vtmn/vue & @vtmn/react & @vtmn/svelte:** chip, add role button + a11y attribute, improve css ([#1134](https://github.com/Decathlon/vitamin-web/issues/1134)) ([cef64c9](https://github.com/Decathlon/vitamin-web/commit/cef64c9a368824a9dd55bd0ad3a25e958d15aba3))

## [0.74.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.74.1...@vtmn/css@0.74.2) (2022-05-06)

### Bug Fixes

- **@vtmn/css:** move flex auto to body ([#1150](https://github.com/Decathlon/vitamin-web/issues/1150)) ([f8ebfbf](https://github.com/Decathlon/vitamin-web/commit/f8ebfbf4f32b797c3dafa6caf457bd44c1ea56c0))

## [0.74.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.74.0...@vtmn/css@0.74.1) (2022-05-05)

### Bug Fixes

- **@vtmn/svelte:** add flex auto + remove overflow indicator ([#1143](https://github.com/Decathlon/vitamin-web/issues/1143)) ([3082378](https://github.com/Decathlon/vitamin-web/commit/3082378ea90cae7c48e29a5f69c73afe6b568bcb))

# [0.74.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.73.1...@vtmn/css@0.74.0) (2022-05-04)

### Features

- **@vtmn/css-quantity:** no default border ([#1141](https://github.com/Decathlon/vitamin-web/issues/1141)) ([bc8664c](https://github.com/Decathlon/vitamin-web/commit/bc8664c029a67d8d314faf259d7c83538e15f057))

## [0.73.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.73.0...@vtmn/css@0.73.1) (2022-05-02)

### Bug Fixes

- **@vtmn/css:** edit `button` icon sizes, increase icon sizes for `icon-alone` variant, a11y ([#1138](https://github.com/Decathlon/vitamin-web/issues/1138)) ([ecf7b25](https://github.com/Decathlon/vitamin-web/commit/ecf7b25799fd24f1b114837258b866032b4c5d6d))

# [0.73.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.72.0...@vtmn/css@0.73.0) (2022-04-22)

### Features

- **@vtmn/css:** add screen readers support with `.sr-only` ([#1118](https://github.com/Decathlon/vitamin-web/issues/1118)) ([4a8ae38](https://github.com/Decathlon/vitamin-web/commit/4a8ae3825b50245813eacb88a88b06abc86e11a5))

# [0.72.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.71.0...@vtmn/css@0.72.0) (2022-04-22)

### Features

- **@vtmn/css:** breadcrumb, add a11y aria-current ([#1130](https://github.com/Decathlon/vitamin-web/issues/1130)) ([01c033c](https://github.com/Decathlon/vitamin-web/commit/01c033c7eced1cf5fcd681cc1907856baa2766be))

# [0.71.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.70.1...@vtmn/css@0.71.0) (2022-04-21)

### Features

- **@vtmn/css:** text-input & its showcases ([#1128](https://github.com/Decathlon/vitamin-web/issues/1128)) ([8c50684](https://github.com/Decathlon/vitamin-web/commit/8c5068470e97f8c542f336ea10aaf98c7070b1d5))

## [0.70.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.70.0...@vtmn/css@0.70.1) (2022-04-21)

**Note:** Version bump only for package @vtmn/css

# [0.70.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.69.0...@vtmn/css@0.70.0) (2022-04-14)

### Features

- **@vtmn/css:** use logical properties in btn spacings ([#1122](https://github.com/Decathlon/vitamin-web/issues/1122)) ([6b8f6b3](https://github.com/Decathlon/vitamin-web/commit/6b8f6b38732c36ab815c44f005bcccc58effebf8))

# [0.69.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.68.0...@vtmn/css@0.69.0) (2022-04-08)

### Features

- **@vtmn/css:** remove useless textInput line-height ([#1119](https://github.com/Decathlon/vitamin-web/issues/1119)) ([86e0997](https://github.com/Decathlon/vitamin-web/commit/86e099737ab88b4078e5ef1a0d65a47bca4e971b))

# [0.68.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.67.2...@vtmn/css@0.68.0) (2022-04-08)

### Features

- **@vtmn/svelte:** add `VtmnDropdown` component ([#1112](https://github.com/Decathlon/vitamin-web/issues/1112)) ([758b971](https://github.com/Decathlon/vitamin-web/commit/758b971c5154e6fee6f48edde4fef3d3ad613db6))

## [0.67.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.67.1...@vtmn/css@0.67.2) (2022-04-08)

### Bug Fixes

- **@vtmn/css:** `dropdown` adjustments ([#1115](https://github.com/Decathlon/vitamin-web/issues/1115)) ([5e2aadf](https://github.com/Decathlon/vitamin-web/commit/5e2aadf5127e65dc65e143514556b354db628b74))

## [0.67.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.67.0...@vtmn/css@0.67.1) (2022-04-07)

### Bug Fixes

- **@vtmn/css-card:** missing import of spacings ([#1116](https://github.com/Decathlon/vitamin-web/issues/1116)) ([43d2b6d](https://github.com/Decathlon/vitamin-web/commit/43d2b6d9f137730147642e022e93ce9c8d9700c9))

# [0.67.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.66.0...@vtmn/css@0.67.0) (2022-04-06)

### Features

- **@vtmn/svelte:** optimization of `VtmnModal` component ([#1111](https://github.com/Decathlon/vitamin-web/issues/1111)) ([847bb32](https://github.com/Decathlon/vitamin-web/commit/847bb32de470ee7434206e45d1fabf449287908e))

# [0.66.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.65.0...@vtmn/css@0.66.0) (2022-04-06)

### Features

- **@vtmn/svelte:** add `VtmnBreadcrumb` component ([#1064](https://github.com/Decathlon/vitamin-web/issues/1064)) ([4a18ec5](https://github.com/Decathlon/vitamin-web/commit/4a18ec59e0cd2360a59e1666452644a99d180323))

# [0.65.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.64.3...@vtmn/css@0.65.0) (2022-04-05)

### Features

- **@vtmn/css:** improve dropdown a11y + fix bug scrolltop ([#1113](https://github.com/Decathlon/vitamin-web/issues/1113)) ([17a5b1b](https://github.com/Decathlon/vitamin-web/commit/17a5b1b65741f780d4fa3a3668daddcb426e6fb4))

## [0.64.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.64.2...@vtmn/css@0.64.3) (2022-04-04)

**Note:** Version bump only for package @vtmn/css

## [0.64.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.64.1...@vtmn/css@0.64.2) (2022-03-31)

### Bug Fixes

- **@vtmn/css:** quantity inner and outer spin buttons ([#1099](https://github.com/Decathlon/vitamin-web/issues/1099)) ([1f6c80b](https://github.com/Decathlon/vitamin-web/commit/1f6c80b8562a6cd520e5c48ae6c21bcaa6d5ec0f))

## [0.64.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.64.0...@vtmn/css@0.64.1) (2022-03-30)

**Note:** Version bump only for package @vtmn/css

# [0.64.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.63.0...@vtmn/css@0.64.0) (2022-03-29)

### Features

- **@vtmn/css:** fix line-height ([#1089](https://github.com/Decathlon/vitamin-web/issues/1089)) ([560a2c3](https://github.com/Decathlon/vitamin-web/commit/560a2c36c1a3aa337959af2396f5663de7c8924b))

# [0.63.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.62.3...@vtmn/css@0.63.0) (2022-03-25)

### Features

- **@vtmn/vue:** add `VtmnDivider` component ([#1074](https://github.com/Decathlon/vitamin-web/issues/1074)) ([205c7b6](https://github.com/Decathlon/vitamin-web/commit/205c7b6494707be47fb2ddbc83e0f6481ca3b1b0))

## [0.62.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.62.2...@vtmn/css@0.62.3) (2022-03-24)

**Note:** Version bump only for package @vtmn/css

## [0.62.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.62.1...@vtmn/css@0.62.2) (2022-03-24)

### Bug Fixes

- **@vtmn/css:** modal indicator overflow ([#1068](https://github.com/Decathlon/vitamin-web/issues/1068)) ([6338cd2](https://github.com/Decathlon/vitamin-web/commit/6338cd2c0450ecdb32e7d7fb2b6ae2d81847fa4b))

## [0.62.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.62.0...@vtmn/css@0.62.1) (2022-03-23)

### Bug Fixes

- **@vtmn/css:** `toggle`, incorrect checked icon color ([#1066](https://github.com/Decathlon/vitamin-web/issues/1066)) ([34df2a8](https://github.com/Decathlon/vitamin-web/commit/34df2a833a38d19b22a2c5ad6990f9f94af9d56a))

# [0.62.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.61.0...@vtmn/css@0.62.0) (2022-03-22)

### Features

- **@vtmn/css:** tag, overload font-size for icon ([#1058](https://github.com/Decathlon/vitamin-web/issues/1058)) ([7501eec](https://github.com/Decathlon/vitamin-web/commit/7501eec11e04a6266af6680be4dec0913e540671))

# [0.61.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.60.5...@vtmn/css@0.61.0) (2022-03-22)

### Features

- **@vtmn/css-card:** add tag showcase + css class ([#1054](https://github.com/Decathlon/vitamin-web/issues/1054)) ([64789df](https://github.com/Decathlon/vitamin-web/commit/64789df67d22db97df18a1176f520340cdf18df3))

## [0.60.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.60.4...@vtmn/css@0.60.5) (2022-03-18)

**Note:** Version bump only for package @vtmn/css

## [0.60.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.60.3...@vtmn/css@0.60.4) (2022-03-11)

**Note:** Version bump only for package @vtmn/css

## [0.60.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.60.2...@vtmn/css@0.60.3) (2022-03-11)

### Bug Fixes

- **@vtmn/css:** line-height on buttons with icons + fix border on primary-reversed ([#1034](https://github.com/Decathlon/vitamin-web/issues/1034)) ([8b3fb4c](https://github.com/Decathlon/vitamin-web/commit/8b3fb4c0406bacb2762a149e449ed41a0679761a))

## [0.60.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.60.1...@vtmn/css@0.60.2) (2022-03-09)

**Note:** Version bump only for package @vtmn/css

## [0.60.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.60.0...@vtmn/css@0.60.1) (2022-03-07)

**Note:** Version bump only for package @vtmn/css

# [0.60.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.9...@vtmn/css@0.60.0) (2022-03-04)

### Features

- **@vtmn/css:** add icon leading for tag ([#1014](https://github.com/Decathlon/vitamin-web/issues/1014)) ([53d19c2](https://github.com/Decathlon/vitamin-web/commit/53d19c23a6f69a0994c90d343aa64528aad9a304))

## [0.59.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.8...@vtmn/css@0.59.9) (2022-03-03)

**Note:** Version bump only for package @vtmn/css

## [0.59.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.7...@vtmn/css@0.59.8) (2022-03-03)

**Note:** Version bump only for package @vtmn/css

## [0.59.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.6...@vtmn/css@0.59.7) (2022-03-03)

### Bug Fixes

- **@vtmn/css:** fix incorrect color values ([#1002](https://github.com/Decathlon/vitamin-web/issues/1002)) ([991d1ef](https://github.com/Decathlon/vitamin-web/commit/991d1efc8ee54f0f203634b98b9d60d00d7c54b6))

## [0.59.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.5...@vtmn/css@0.59.6) (2022-03-01)

**Note:** Version bump only for package @vtmn/css

## [0.59.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.4...@vtmn/css@0.59.5) (2022-03-01)

**Note:** Version bump only for package @vtmn/css

## [0.59.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.3...@vtmn/css@0.59.4) (2022-03-01)

**Note:** Version bump only for package @vtmn/css

## [0.59.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.2...@vtmn/css@0.59.3) (2022-03-01)

**Note:** Version bump only for package @vtmn/css

## [0.59.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.1...@vtmn/css@0.59.2) (2022-02-28)

### Bug Fixes

- **@vtmn/css:** fix arrow position select ([#996](https://github.com/Decathlon/vitamin-web/issues/996)) ([2d56508](https://github.com/Decathlon/vitamin-web/commit/2d56508f52656bc071a05cfa156337796d4be1ca))

## [0.59.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.59.0...@vtmn/css@0.59.1) (2022-02-28)

**Note:** Version bump only for package @vtmn/css

# [0.59.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.58.1...@vtmn/css@0.59.0) (2022-02-25)

### Features

- **@vtmn/css:** refactor border color + add new shadow colors ([#980](https://github.com/Decathlon/vitamin-web/issues/980)) ([67e13ff](https://github.com/Decathlon/vitamin-web/commit/67e13ff48c922ddea167feea824e9dfdc8b18fec))

## [0.58.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.58.0...@vtmn/css@0.58.1) (2022-02-24)

### Bug Fixes

- **@vtmn/css:** modal overview displays correctly on mobile, fix radius mobile ([#991](https://github.com/Decathlon/vitamin-web/issues/991)) ([7c9cdbd](https://github.com/Decathlon/vitamin-web/commit/7c9cdbd396df895ccf3032c6dd30bf62c5a89ae0))

# [0.58.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.57.7...@vtmn/css@0.58.0) (2022-02-23)

### Features

- **@vtmn/css:** add new font size (caption) ([#982](https://github.com/Decathlon/vitamin-web/issues/982)) ([03877ed](https://github.com/Decathlon/vitamin-web/commit/03877ed69df9d6b354ebe5ccf828751b106ce8ff))

## [0.57.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.57.6...@vtmn/css@0.57.7) (2022-02-23)

### Bug Fixes

- **@vtmn/css:** change margin holders for quantity and select, optimizations on forms component ([#988](https://github.com/Decathlon/vitamin-web/issues/988)) ([2e589ae](https://github.com/Decathlon/vitamin-web/commit/2e589aeb8ce0d9d2e2487037c0cbd2ce51de9dc6))

## [0.57.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.57.5...@vtmn/css@0.57.6) (2022-02-15)

### Bug Fixes

- **@vtmn/css:** remove blink on safari linear progressbar ([#975](https://github.com/Decathlon/vitamin-web/issues/975)) ([53422d1](https://github.com/Decathlon/vitamin-web/commit/53422d1088f23b027bb08a4f0d7ed3f6be279822))

## [0.57.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.57.4...@vtmn/css@0.57.5) (2022-02-08)

**Note:** Version bump only for package @vtmn/css

## [0.57.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.57.3...@vtmn/css@0.57.4) (2022-02-08)

**Note:** Version bump only for package @vtmn/css

## [0.57.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.57.2...@vtmn/css@0.57.3) (2022-02-03)

**Note:** Version bump only for package @vtmn/css

## [0.57.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.57.1...@vtmn/css@0.57.2) (2022-02-02)

**Note:** Version bump only for package @vtmn/css

## [0.57.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.57.0...@vtmn/css@0.57.1) (2022-01-28)

**Note:** Version bump only for package @vtmn/css

# [0.57.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.56.1...@vtmn/css@0.57.0) (2022-01-27)

### Features

- **@vtmn/css:** rename hober brand to hover tertiary ([#949](https://github.com/Decathlon/vitamin-web/issues/949)) ([8bbd2ea](https://github.com/Decathlon/vitamin-web/commit/8bbd2ea43e3ccacc10e9a32ab003c629aa125ae1))

## [0.56.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.56.0...@vtmn/css@0.56.1) (2022-01-26)

### Bug Fixes

- **@vtmn/css:** change the text input marge holders ([#947](https://github.com/Decathlon/vitamin-web/issues/947)) ([fe51e50](https://github.com/Decathlon/vitamin-web/commit/fe51e5074dbe7a46435f06914e2008e5403baba8))

# [0.56.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.55.1...@vtmn/css@0.56.0) (2022-01-25)

### Features

- **@vtmn/css:** add dropdown component ([#901](https://github.com/Decathlon/vitamin-web/issues/901)) ([97b0216](https://github.com/Decathlon/vitamin-web/commit/97b021674d25a89a51358ab5f23e07371fdca801))

## [0.55.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.55.0...@vtmn/css@0.55.1) (2022-01-24)

**Note:** Version bump only for package @vtmn/css

# [0.55.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.54.1...@vtmn/css@0.55.0) (2022-01-24)

### Features

- **@vtmn/css:** fix box shadow on mobile + remove radius on mobile ([#927](https://github.com/Decathlon/vitamin-web/issues/927)) ([968e94d](https://github.com/Decathlon/vitamin-web/commit/968e94d883cdaf2137b70593aa8d8f17050c8334))
- **@vtmn/css:** remove outline when components are focus on mobile devices ([#931](https://github.com/Decathlon/vitamin-web/issues/931)) ([719a379](https://github.com/Decathlon/vitamin-web/commit/719a379f5863d9c95e67795fb1ca0e4975e12a4e))

## [0.54.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.54.0...@vtmn/css@0.54.1) (2022-01-24)

### Bug Fixes

- **@vtmn/css:** min sizes for button in quantity ([#926](https://github.com/Decathlon/vitamin-web/issues/926)) ([b1249e4](https://github.com/Decathlon/vitamin-web/commit/b1249e4f4703a81694c19df50f08a4e2b380bad6))

# [0.54.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.53.0...@vtmn/css@0.54.0) (2022-01-24)

### Features

- **@vtmn/css:** fix incorrect class for css props ([#923](https://github.com/Decathlon/vitamin-web/issues/923)) ([5a51eeb](https://github.com/Decathlon/vitamin-web/commit/5a51eebf54cd8cc8a38bd3c7ca3f740054bb5fb7))
- **@vtmn/css:** remove focus visible when disabled + add cursor and no event ([#925](https://github.com/Decathlon/vitamin-web/issues/925)) ([5e71583](https://github.com/Decathlon/vitamin-web/commit/5e7158337a7a0b7931e0b14616c15d809e9f8b78))

# [0.53.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.52.0...@vtmn/css@0.53.0) (2022-01-21)

### Features

- **@vtmn/css:** remove acccordion list-type on safari browser and other non supported ([#920](https://github.com/Decathlon/vitamin-web/issues/920)) ([fff8e29](https://github.com/Decathlon/vitamin-web/commit/fff8e2913766fbd8eb82d8ad1d4b33455195119c))

# [0.52.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.51.1...@vtmn/css@0.52.0) (2022-01-20)

### Features

- **@vtmn/css:** add alert variant and remove line height ([#918](https://github.com/Decathlon/vitamin-web/issues/918)) ([6576310](https://github.com/Decathlon/vitamin-web/commit/6576310208a1167743ce73df148e023bd25e2baf))

## [0.51.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.51.0...@vtmn/css@0.51.1) (2022-01-20)

### Bug Fixes

- bad versions of design tokens ([ecb49f3](https://github.com/Decathlon/vitamin-web/commit/ecb49f3d1e672cb3ba78c23dc64fd899ea4a08c1))

# [0.51.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.50.0...@vtmn/css@0.51.0) (2022-01-20)

### Features

- **@vtmn/css:** add accordion component ([#848](https://github.com/Decathlon/vitamin-web/issues/848)) ([ac06aef](https://github.com/Decathlon/vitamin-web/commit/ac06aefac5a4d33e76049303a78fcfb5014c3bcf))

# [0.50.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.49.2...@vtmn/css@0.50.0) (2022-01-20)

### Features

- **@vtmn/css:** rename hoverBrandReversedTransparent into hoverTertiaryReversedTransparent ([#914](https://github.com/Decathlon/vitamin-web/issues/914)) ([09b1e8f](https://github.com/Decathlon/vitamin-web/commit/09b1e8f3d42d4da3c4376685eaaee40cba93a0f4))

## [0.49.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.49.1...@vtmn/css@0.49.2) (2022-01-20)

### Bug Fixes

- **@vtmn/css-design-tokens:** missing commas ([#917](https://github.com/Decathlon/vitamin-web/issues/917)) ([fa35ee8](https://github.com/Decathlon/vitamin-web/commit/fa35ee84b9d8e17d25c0b90db9868de6b3ef7f1c))

## [0.49.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.49.0...@vtmn/css@0.49.1) (2022-01-19)

**Note:** Version bump only for package @vtmn/css

# [0.49.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.48.1...@vtmn/css@0.49.0) (2022-01-19)

### Features

- **@vtmn/css:** add activeTertiaryReversedTransparent ([#913](https://github.com/Decathlon/vitamin-web/issues/913)) ([1649dba](https://github.com/Decathlon/vitamin-web/commit/1649dbaa140da9d5888284f690dd888151c7d9d3))

## [0.48.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.48.0...@vtmn/css@0.48.1) (2022-01-19)

**Note:** Version bump only for package @vtmn/css

# [0.48.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.47.3...@vtmn/css@0.48.0) (2022-01-19)

### Features

- **@vtmn/css:** add radius design tokens + imports in css ([#908](https://github.com/Decathlon/vitamin-web/issues/908)) ([26a0cd3](https://github.com/Decathlon/vitamin-web/commit/26a0cd3809792e9ea127bfaa8aa66ed3bd276990))
- **@vtmn/css:** fix active primary colour light/dark theme ([#907](https://github.com/Decathlon/vitamin-web/issues/907)) ([9356a7b](https://github.com/Decathlon/vitamin-web/commit/9356a7b3657fd7e5ffae9af0fb4ad14c95ca8aad))

## [0.47.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.47.2...@vtmn/css@0.47.3) (2022-01-19)

**Note:** Version bump only for package @vtmn/css

## [0.47.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.47.1...@vtmn/css@0.47.2) (2022-01-18)

**Note:** Version bump only for package @vtmn/css

## [0.47.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.47.0...@vtmn/css@0.47.1) (2022-01-18)

**Note:** Version bump only for package @vtmn/css

# [0.47.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.46.5...@vtmn/css@0.47.0) (2022-01-17)

### Features

- **@vtmn/css:** fix alignements pb + font style shortcut ([#890](https://github.com/Decathlon/vitamin-web/issues/890)) ([6b31b94](https://github.com/Decathlon/vitamin-web/commit/6b31b943acd3d159110d1b3013f687187f728cf3))

## [0.46.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.46.4...@vtmn/css@0.46.5) (2022-01-17)

### Bug Fixes

- **@vtmn/css:** animation alert disapearing ([#884](https://github.com/Decathlon/vitamin-web/issues/884)) ([0a9f92b](https://github.com/Decathlon/vitamin-web/commit/0a9f92b0b22c66d8137e05cadbb6337df322c517))

## [0.46.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.46.3...@vtmn/css@0.46.4) (2022-01-14)

**Note:** Version bump only for package @vtmn/css

## [0.46.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.46.2...@vtmn/css@0.46.3) (2022-01-11)

**Note:** Version bump only for package @vtmn/css

## [0.46.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.46.1...@vtmn/css@0.46.2) (2022-01-11)

**Note:** Version bump only for package @vtmn/css

## [0.46.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.46.0...@vtmn/css@0.46.1) (2022-01-10)

**Note:** Version bump only for package @vtmn/css

# [0.46.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.45.0...@vtmn/css@0.46.0) (2022-01-10)

### Features

- **@vtmn/css:** add transition on focus-visible ([#866](https://github.com/Decathlon/vitamin-web/issues/866)) ([81820b4](https://github.com/Decathlon/vitamin-web/commit/81820b4ebfcd8df223b8415885cb37a5d4ab5bd2))

# [0.45.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.44.0...@vtmn/css@0.45.0) (2022-01-05)

### Features

- **@vtmn/css:** add price component ([#847](https://github.com/Decathlon/vitamin-web/issues/847)) ([a30666c](https://github.com/Decathlon/vitamin-web/commit/a30666c6496330cc6dad1669032cb5f89374780c))

# [0.44.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.43.1...@vtmn/css@0.44.0) (2022-01-05)

### Features

- **@vtmn/css:** add list component ([#814](https://github.com/Decathlon/vitamin-web/issues/814)) ([7fa9593](https://github.com/Decathlon/vitamin-web/commit/7fa959314f72fcfbd8a2eadeb6d55147c63ff625))
- **@vtmn/css:** add tag component ([#846](https://github.com/Decathlon/vitamin-web/issues/846)) ([bcb461c](https://github.com/Decathlon/vitamin-web/commit/bcb461c8115e4594075b5a678e113191e13c73ac))

## [0.43.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.43.0...@vtmn/css@0.43.1) (2022-01-03)

**Note:** Version bump only for package @vtmn/css

# [0.43.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.42.3...@vtmn/css@0.43.0) (2022-01-03)

### Features

- **@vtmn/css:** add quantity component ([#833](https://github.com/Decathlon/vitamin-web/issues/833)) ([e7aa8a3](https://github.com/Decathlon/vitamin-web/commit/e7aa8a35310ca912e9ccc5bf7a2795e869faec6d))

## [0.42.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.42.2...@vtmn/css@0.42.3) (2021-12-31)

**Note:** Version bump only for package @vtmn/css

## [0.42.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.42.1...@vtmn/css@0.42.2) (2021-12-31)

### Bug Fixes

- **@vtmn/css:** add missing imports + props ([#838](https://github.com/Decathlon/vitamin-web/issues/838)) ([4dc1ee8](https://github.com/Decathlon/vitamin-web/commit/4dc1ee8f9df153bbf97a2eb06ac1d7926bf7a010))

## [0.42.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.42.0...@vtmn/css@0.42.1) (2021-12-30)

**Note:** Version bump only for package @vtmn/css

# [0.42.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.41.0...@vtmn/css@0.42.0) (2021-12-28)

### Bug Fixes

- **@vtmn/css:** flexbox scroll bug ([#827](https://github.com/Decathlon/vitamin-web/issues/827)) ([32429e4](https://github.com/Decathlon/vitamin-web/commit/32429e4031c65d4e82e3eea7ff922c81810e81d4))

### Features

- **@vtmn/css:** add token focus-visible for breadcrumb and tabs ([#829](https://github.com/Decathlon/vitamin-web/issues/829)) ([daddc0c](https://github.com/Decathlon/vitamin-web/commit/daddc0c1952e152d8cd05f74da27d1472d0c1fdc))

# [0.41.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.40.0...@vtmn/css@0.41.0) (2021-12-28)

### Features

- **@vtmn/css:** add search component ([#812](https://github.com/Decathlon/vitamin-web/issues/812)) ([d10e7d1](https://github.com/Decathlon/vitamin-web/commit/d10e7d1f70af698c8609a78bb604a405121fd544))

# [0.40.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.39.3...@vtmn/css@0.40.0) (2021-12-28)

### Features

- **@vtmn/css:** add tabs component ([#806](https://github.com/Decathlon/vitamin-web/issues/806)) ([7f1d510](https://github.com/Decathlon/vitamin-web/commit/7f1d51006209c357afbe369970268d400817433b))

## [0.39.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.39.2...@vtmn/css@0.39.3) (2021-12-27)

**Note:** Version bump only for package @vtmn/css

## [0.39.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.39.1...@vtmn/css@0.39.2) (2021-12-27)

**Note:** Version bump only for package @vtmn/css

## [0.39.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.39.0...@vtmn/css@0.39.1) (2021-12-27)

**Note:** Version bump only for package @vtmn/css

# [0.39.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.38.0...@vtmn/css@0.39.0) (2021-12-21)

### Features

- **@vtmn/css:** add divider component ([#799](https://github.com/Decathlon/vitamin-web/issues/799)) ([38b78d7](https://github.com/Decathlon/vitamin-web/commit/38b78d7d8edd5f77b0be8a998dcf0f9b67844ed1))

# [0.38.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.37.0...@vtmn/css@0.38.0) (2021-12-16)

### Features

- **@vtmn/react:** add alert component ([#791](https://github.com/Decathlon/vitamin-web/issues/791)) ([4205bfe](https://github.com/Decathlon/vitamin-web/commit/4205bfec0785462d83b71aa0a02a706eae35d046))

# [0.37.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.36.1...@vtmn/css@0.37.0) (2021-12-15)

### Features

- **@vtmn/css:** add navbar component ([#676](https://github.com/Decathlon/vitamin-web/issues/676)) ([95fb5dc](https://github.com/Decathlon/vitamin-web/commit/95fb5dcf2b29edd7850ed51c9c008de8ade6560e))

## [0.36.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.36.0...@vtmn/css@0.36.1) (2021-12-03)

**Note:** Version bump only for package @vtmn/css

# [0.36.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.35.0...@vtmn/css@0.36.0) (2021-12-03)

### Features

- **@vtmn/css:** add breadcrumb component ([#750](https://github.com/Decathlon/vitamin-web/issues/750)) ([ad60d8f](https://github.com/Decathlon/vitamin-web/commit/ad60d8fd9a7317a0b691507b8369a88b97c583da))

# [0.35.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.34.4...@vtmn/css@0.35.0) (2021-12-03)

### Bug Fixes

- **@vtmn/css:** add aside styles for the card in the showcase ([88f2215](https://github.com/Decathlon/vitamin-web/commit/88f22150a29b1d5147f50a1d56a01f280f292f9e))
- **@vtmn/css:** buton in side bar fit-content ([4d3064f](https://github.com/Decathlon/vitamin-web/commit/4d3064f51854f08f425db4d50b2ba87fe8b6234f))
- **@vtmn/css:** button has a min-height instead of a height ([429577a](https://github.com/Decathlon/vitamin-web/commit/429577aeee80e8e8a94d605deae074bacc32eda6))
- **@vtmn/css:** fix class for full opaque background ([9372c8a](https://github.com/Decathlon/vitamin-web/commit/9372c8adabdaf5b6c41fbe7aaa29f5955740dd91))
- **@vtmn/css:** remove min-width ([ce6ee13](https://github.com/Decathlon/vitamin-web/commit/ce6ee131a7ddbc1fc43523a1c7b2fda6b6cfebb1))
- **@vtmn/css:** token background color ([b8d676b](https://github.com/Decathlon/vitamin-web/commit/b8d676b48258a9b27f813a797035952ea572f595))

### Features

- **@vtmn/css:** fix width cards ([c0e81ca](https://github.com/Decathlon/vitamin-web/commit/c0e81ca2c7a5c6f4d9615465b1530c68e028aeae))
- **@vtmn/css:** fix width progressbar linear ([451754b](https://github.com/Decathlon/vitamin-web/commit/451754b0d892e137fe476e5bdd7536386e296c0a))

## [0.34.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.34.3...@vtmn/css@0.34.4) (2021-11-30)

### Bug Fixes

- **@vtmn/css-tailwind-preset:** font-normal class has two definitions ([#760](https://github.com/Decathlon/vitamin-web/issues/760)) ([be5f392](https://github.com/Decathlon/vitamin-web/commit/be5f39296dfaa2deb89e84f2823e10108fb037a2))

## [0.34.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.34.2...@vtmn/css@0.34.3) (2021-11-30)

### Bug Fixes

- **@vtmn/css:** specify letter spacing for each size variant of the button ([#782](https://github.com/Decathlon/vitamin-web/issues/782)) ([3485ee3](https://github.com/Decathlon/vitamin-web/commit/3485ee3cd6e27795fdf54ff65576f2ca0c8d1b54))

## [0.34.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.34.1...@vtmn/css@0.34.2) (2021-11-23)

**Note:** Version bump only for package @vtmn/css

## [0.34.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.34.0...@vtmn/css@0.34.1) (2021-11-22)

**Note:** Version bump only for package @vtmn/css

# [0.34.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.33.4...@vtmn/css@0.34.0) (2021-11-18)

### Features

- **@vtmn/css:** add chip component ([#730](https://github.com/Decathlon/vitamin-web/issues/730)) ([c2de91d](https://github.com/Decathlon/vitamin-web/commit/c2de91de8695b73c81a24c0efea587348c599947))

## [0.33.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.33.3...@vtmn/css@0.33.4) (2021-11-17)

**Note:** Version bump only for package @vtmn/css

## [0.33.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.33.2...@vtmn/css@0.33.3) (2021-11-15)

**Note:** Version bump only for package @vtmn/css

## [0.33.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.33.1...@vtmn/css@0.33.2) (2021-11-15)

**Note:** Version bump only for package @vtmn/css

## [0.33.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.33.0...@vtmn/css@0.33.1) (2021-11-15)

**Note:** Version bump only for package @vtmn/css

# [0.33.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.32.2...@vtmn/css@0.33.0) (2021-11-14)

### Features

- expose our Tailwind CSS preset ([#741](https://github.com/Decathlon/vitamin-web/issues/741)) ([fee3087](https://github.com/Decathlon/vitamin-web/commit/fee308730bd4978fecdcfdf4bc3d8b9ef95e5739))

## [0.32.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.32.1...@vtmn/css@0.32.2) (2021-11-09)

**Note:** Version bump only for package @vtmn/css

## [0.32.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.32.0...@vtmn/css@0.32.1) (2021-10-29)

**Note:** Version bump only for package @vtmn/css

# [0.32.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.30.4...@vtmn/css@0.32.0) (2021-10-28)

### Features

- **@vtmn/css:** add card component ([#718](https://github.com/Decathlon/vitamin-web/issues/718)) ([4fb362d](https://github.com/Decathlon/vitamin-web/commit/4fb362dd39e518e0637dfc4772d76fdc077c66a1))

## [0.30.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.30.3...@vtmn/css@0.30.4) (2021-10-26)

**Note:** Version bump only for package @vtmn/css

## [0.30.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.30.2...@vtmn/css@0.30.3) (2021-10-25)

**Note:** Version bump only for package @vtmn/css

## [0.30.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.30.1...@vtmn/css@0.30.2) (2021-10-20)

**Note:** Version bump only for package @vtmn/css

## [0.30.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.30.0...@vtmn/css@0.30.1) (2021-10-19)

### Bug Fixes

- **@vtmn/svelte:** allow to dynamically import css modules ([#701](https://github.com/Decathlon/vitamin-web/issues/701)) ([7c6e08c](https://github.com/Decathlon/vitamin-web/commit/7c6e08c4f76aa32fe92f91d7979df73796ff66e7))

# [0.30.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.10...@vtmn/css@0.30.0) (2021-10-18)

### Features

- **@vtmn/web-components:** refacto link, change css style order ([#682](https://github.com/Decathlon/vitamin-web/issues/682)) ([45d96cc](https://github.com/Decathlon/vitamin-web/commit/45d96ccf2acbb571ac9de724a12abadea675b626))

## [0.29.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.9...@vtmn/css@0.29.10) (2021-10-14)

**Note:** Version bump only for package @vtmn/css

## [0.29.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.8...@vtmn/css@0.29.9) (2021-10-13)

### Bug Fixes

- **@vtmn/css:** order of CSS classes ([#679](https://github.com/Decathlon/vitamin-web/issues/679)) ([9ca377f](https://github.com/Decathlon/vitamin-web/commit/9ca377fc2342d1b97c19d0517158f541983811f2))

## [0.29.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.7...@vtmn/css@0.29.8) (2021-10-12)

**Note:** Version bump only for package @vtmn/css

## [0.29.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.6...@vtmn/css@0.29.7) (2021-10-04)

### Bug Fixes

- **@vtmn/css-modal:** add clickable overlay ([#647](https://github.com/Decathlon/vitamin-web/issues/647)) ([3a0b569](https://github.com/Decathlon/vitamin-web/commit/3a0b56947b9f13a4bf674e698675b5fd4bd7378b))

## [0.29.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.5...@vtmn/css@0.29.6) (2021-10-04)

**Note:** Version bump only for package @vtmn/css

## [0.29.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.4...@vtmn/css@0.29.5) (2021-10-02)

**Note:** Version bump only for package @vtmn/css

## [0.29.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.3...@vtmn/css@0.29.4) (2021-10-01)

**Note:** Version bump only for package @vtmn/css

## [0.29.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.2...@vtmn/css@0.29.3) (2021-10-01)

### Bug Fixes

- **@vtmn-snackbar:** button wrapping ([#642](https://github.com/Decathlon/vitamin-web/issues/642)) ([36074b1](https://github.com/Decathlon/vitamin-web/commit/36074b1b2a9cf5222f4ff0b2e360f9733b0417e7))

## [0.29.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.1...@vtmn/css@0.29.2) (2021-10-01)

### Bug Fixes

- **storybook:** fix deprecated content ([#639](https://github.com/Decathlon/vitamin-web/issues/639)) ([cf54633](https://github.com/Decathlon/vitamin-web/commit/cf54633e0b0ed503037860f6f1d456c413cf9874))

## [0.29.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.29.0...@vtmn/css@0.29.1) (2021-09-30)

**Note:** Version bump only for package @vtmn/css

# [0.29.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.28.0...@vtmn/css@0.29.0) (2021-09-30)

### Features

- **@vtmn/css:** add progressbar component ([#612](https://github.com/Decathlon/vitamin-web/issues/612)) ([a04df2e](https://github.com/Decathlon/vitamin-web/commit/a04df2e7b5badc7145a686ed6d0fb5ed80794468))

# [0.28.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.27.1...@vtmn/css@0.28.0) (2021-09-28)

### Features

- **@vtmn/css:** add skeleton component ([#616](https://github.com/Decathlon/vitamin-web/issues/616)) ([db8d9e8](https://github.com/Decathlon/vitamin-web/commit/db8d9e80eeb56aac8b3b5584b421244eb8588537))

## [0.27.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.27.0...@vtmn/css@0.27.1) (2021-09-27)

**Note:** Version bump only for package @vtmn/css

# [0.27.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.26.0...@vtmn/css@0.27.0) (2021-09-22)

### Features

- **@vtmn/css:** add modal component ([#498](https://github.com/Decathlon/vitamin-web/issues/498)) ([059e932](https://github.com/Decathlon/vitamin-web/commit/059e9326b6218f4aac3c2c69696139ee73768917))

# [0.26.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.25.0...@vtmn/css@0.26.0) (2021-09-22)

### Bug Fixes

- **@vtmn/css-design-tokens:** problem with vtmn-semantic-color_hover-tertiary variable ([6f668f9](https://github.com/Decathlon/vitamin-web/commit/6f668f99b8f4895facecc2189190902052a6c042))

### Features

- **@vtmn/css:** add alert component ([#501](https://github.com/Decathlon/vitamin-web/issues/501)) ([5386c78](https://github.com/Decathlon/vitamin-web/commit/5386c7858ecf08beaf55c6474589d63026c6bf82))

# [0.25.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.24.1...@vtmn/css@0.25.0) (2021-09-17)

### Features

- **@vtmn/css:** add toast component ([#500](https://github.com/Decathlon/vitamin-web/issues/500)) ([ce81148](https://github.com/Decathlon/vitamin-web/commit/ce811483867afda773b942ec557d925a23882f12))

## [0.24.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.24.0...@vtmn/css@0.24.1) (2021-09-17)

**Note:** Version bump only for package @vtmn/css

# [0.24.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.23.0...@vtmn/css@0.24.0) (2021-09-17)

### Features

- **@vtmn/css:** add snackbar component ([#499](https://github.com/Decathlon/vitamin-web/issues/499)) ([fccad63](https://github.com/Decathlon/vitamin-web/commit/fccad63db0b4c86e038166dceafdf43dd0cfdf58))

# [0.23.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.22.5...@vtmn/css@0.23.0) (2021-09-17)

### Features

- **@vtmn/css-text-input:** adjust width of label and texts, focus is… ([#593](https://github.com/Decathlon/vitamin-web/issues/593)) ([34dc78f](https://github.com/Decathlon/vitamin-web/commit/34dc78fabd1469767d0bdf227ab6ceed4c34d01e))

## [0.22.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.22.4...@vtmn/css@0.22.5) (2021-09-16)

**Note:** Version bump only for package @vtmn/css

## [0.22.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.22.3...@vtmn/css@0.22.4) (2021-09-14)

**Note:** Version bump only for package @vtmn/css

## [0.22.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.22.2...@vtmn/css@0.22.3) (2021-09-10)

**Note:** Version bump only for package @vtmn/css

## [0.22.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.22.1...@vtmn/css@0.22.2) (2021-08-31)

**Note:** Version bump only for package @vtmn/css

## [0.22.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.22.0...@vtmn/css@0.22.1) (2021-08-15)

**Note:** Version bump only for package @vtmn/css

# [0.22.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.21.0...@vtmn/css@0.22.0) (2021-08-13)

### Features

- **@vtmn/css-popover & @vtmn/css-tooltip:** change showcase for a better global experience ([#513](https://github.com/Decathlon/vitamin-web/issues/513)) ([773e5c0](https://github.com/Decathlon/vitamin-web/commit/773e5c000e53e641dccdf4757d05c97492263c6e))

# [0.21.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.20.4...@vtmn/css@0.21.0) (2021-08-11)

### Features

- **@vtmn/css-select:** move the icon after from the label to the container ([#510](https://github.com/Decathlon/vitamin-web/issues/510)) ([5445a63](https://github.com/Decathlon/vitamin-web/commit/5445a63b6c2199aee4d66d71208b30c0f77a7461))

## [0.20.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.20.3...@vtmn/css@0.20.4) (2021-08-09)

**Note:** Version bump only for package @vtmn/css

## [0.20.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.20.2...@vtmn/css@0.20.3) (2021-08-09)

**Note:** Version bump only for package @vtmn/css

## [0.20.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.20.1...@vtmn/css@0.20.2) (2021-08-09)

**Note:** Version bump only for package @vtmn/css

## [0.20.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.20.0...@vtmn/css@0.20.1) (2021-08-06)

**Note:** Version bump only for package @vtmn/css

# [0.20.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.19.0...@vtmn/css@0.20.0) (2021-08-06)

### Features

- **@vtmn/css:** add loader component ([#497](https://github.com/Decathlon/vitamin-web/issues/497)) ([25205ab](https://github.com/Decathlon/vitamin-web/commit/25205ab9eeccfff910128accceb50528aed81f4f))

# [0.19.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.18.0...@vtmn/css@0.19.0) (2021-08-04)

### Features

- **@vtmn/css:** add popover component ([#481](https://github.com/Decathlon/vitamin-web/issues/481)) ([7002c6b](https://github.com/Decathlon/vitamin-web/commit/7002c6b16aed968eaf80be399a14dff632e0e81a))

# [0.18.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.17.1...@vtmn/css@0.18.0) (2021-08-04)

### Features

- **@vtmn/css:** add rating component ([#434](https://github.com/Decathlon/vitamin-web/issues/434)) ([0c23395](https://github.com/Decathlon/vitamin-web/commit/0c2339551711095a8e2ca14bd16eda462fdf15cd)), closes [#317](https://github.com/Decathlon/vitamin-web/issues/317)

## [0.17.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.17.0...@vtmn/css@0.17.1) (2021-08-03)

**Note:** Version bump only for package @vtmn/css

# [0.17.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.16.5...@vtmn/css@0.17.0) (2021-08-02)

### Features

- **@vtmn/css:** add tooltip component ([#468](https://github.com/Decathlon/vitamin-web/issues/468)) ([d74bc64](https://github.com/Decathlon/vitamin-web/commit/d74bc64ffb941cc143095ed96d98a4225955cfd4))

## [0.16.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.16.4...@vtmn/css@0.16.5) (2021-07-30)

**Note:** Version bump only for package @vtmn/css

## [0.16.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.16.3...@vtmn/css@0.16.4) (2021-07-29)

**Note:** Version bump only for package @vtmn/css

## [0.16.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.16.2...@vtmn/css@0.16.3) (2021-07-28)

**Note:** Version bump only for package @vtmn/css

## [0.16.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.16.1...@vtmn/css@0.16.2) (2021-07-27)

### Bug Fixes

- **@vtmn/css:** better icon alignment for buttons ([#474](https://github.com/Decathlon/vitamin-web/issues/474)) ([c1f2c1c](https://github.com/Decathlon/vitamin-web/commit/c1f2c1c97d932f88e1af5476dce0222484315a75))

## [0.16.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.16.0...@vtmn/css@0.16.1) (2021-07-23)

**Note:** Version bump only for package @vtmn/css

# [0.16.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.15.1...@vtmn/css@0.16.0) (2021-07-23)

### Features

- **@vtmn/css:** add select component ([#451](https://github.com/Decathlon/vitamin-web/issues/451)) ([8b96cff](https://github.com/Decathlon/vitamin-web/commit/8b96cffa6b1e516f210713cc8cb8dbfc42a00d58)), closes [#317](https://github.com/Decathlon/vitamin-web/issues/317)

## [0.15.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.15.0...@vtmn/css@0.15.1) (2021-07-23)

**Note:** Version bump only for package @vtmn/css

# [0.15.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.14.0...@vtmn/css@0.15.0) (2021-07-22)

### Features

- **@vtmn/css:** add variable for disabled state opacity ([#458](https://github.com/Decathlon/vitamin-web/issues/458)) ([d9f0e62](https://github.com/Decathlon/vitamin-web/commit/d9f0e624e55e4c6c1d1cb8672dd159c1879abfbd))

# [0.14.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.13.0...@vtmn/css@0.14.0) (2021-07-20)

### Features

- **@vtmn/web-components:** add badge component ([#410](https://github.com/Decathlon/vitamin-web/issues/410)) ([adcdeff](https://github.com/Decathlon/vitamin-web/commit/adcdeff7092be7a77779be60c05183d5f630186b))

# [0.13.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.12.2...@vtmn/css@0.13.0) (2021-07-20)

### Features

- **@vtmn/css:** add badge component ([#317](https://github.com/Decathlon/vitamin-web/issues/317)) ([4beea13](https://github.com/Decathlon/vitamin-web/commit/4beea134d9bf23174d368747d9282dabdf4fdef9))

## [0.12.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.12.1...@vtmn/css@0.12.2) (2021-07-19)

**Note:** Version bump only for package @vtmn/css

## [0.12.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.12.0...@vtmn/css@0.12.1) (2021-06-24)

**Note:** Version bump only for package @vtmn/css

# [0.12.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.11.2...@vtmn/css@0.12.0) (2021-06-24)

### Features

- **@vtmn/css:** improvements (text input) ([#378](https://github.com/Decathlon/vitamin-web/issues/378)) ([c7dec76](https://github.com/Decathlon/vitamin-web/commit/c7dec76f40ba6539e7d5204ee08c51a162958cfa))

## [0.11.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.11.1...@vtmn/css@0.11.2) (2021-06-22)

### Bug Fixes

- **@vtmn/css:** no more hover effect over focus-visible state ([#379](https://github.com/Decathlon/vitamin-web/issues/379)) ([48dc7ee](https://github.com/Decathlon/vitamin-web/commit/48dc7eea56caf547fea98f210852003dff4fa162))

## [0.11.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.11.0...@vtmn/css@0.11.1) (2021-06-18)

### Bug Fixes

- **@vtmn/css-textinput:** add resize property ([#369](https://github.com/Decathlon/vitamin-web/issues/369)) ([a94cb1f](https://github.com/Decathlon/vitamin-web/commit/a94cb1fca08d2f39b4d4b2e1347a1e0abe389f31))

# [0.11.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.12...@vtmn/css@0.11.0) (2021-06-17)

### Features

- **@vtmn/vue:** add checkbox component ([#363](https://github.com/Decathlon/vitamin-web/issues/363)) ([b3258c4](https://github.com/Decathlon/vitamin-web/commit/b3258c4374dac5a22d3e208cb785b444b6bdfdfd))

## [0.10.12](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.11...@vtmn/css@0.10.12) (2021-06-17)

**Note:** Version bump only for package @vtmn/css

## [0.10.11](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.10...@vtmn/css@0.10.11) (2021-06-17)

**Note:** Version bump only for package @vtmn/css

## [0.10.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.9...@vtmn/css@0.10.10) (2021-06-17)

**Note:** Version bump only for package @vtmn/css

## [0.10.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.8...@vtmn/css@0.10.9) (2021-06-15)

**Note:** Version bump only for package @vtmn/css

## [0.10.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.7...@vtmn/css@0.10.8) (2021-06-15)

**Note:** Version bump only for package @vtmn/css

## [0.10.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.6...@vtmn/css@0.10.7) (2021-06-14)

**Note:** Version bump only for package @vtmn/css

## [0.10.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.5...@vtmn/css@0.10.6) (2021-06-14)

**Note:** Version bump only for package @vtmn/css

## [0.10.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.4...@vtmn/css@0.10.5) (2021-06-14)

**Note:** Version bump only for package @vtmn/css

## [0.10.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.3...@vtmn/css@0.10.4) (2021-06-14)

### Bug Fixes

- **@vtmn/css-checkbox:** bug fixes + improvements ([#350](https://github.com/Decathlon/vitamin-web/issues/350)) ([bc1f1b2](https://github.com/Decathlon/vitamin-web/commit/bc1f1b2141573596e0468d5fcbe67daa6edae8d2))

## [0.10.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.2...@vtmn/css@0.10.3) (2021-06-14)

**Note:** Version bump only for package @vtmn/css

## [0.10.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.1...@vtmn/css@0.10.2) (2021-06-10)

### Bug Fixes

- **@vtmn/css-link:** refacto standalone + inline links styles ([#351](https://github.com/Decathlon/vitamin-web/issues/351)) ([778ca8b](https://github.com/Decathlon/vitamin-web/commit/778ca8b676f27f236797e6dd202065d2f51d9af9))

## [0.10.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.10.0...@vtmn/css@0.10.1) (2021-06-03)

**Note:** Version bump only for package @vtmn/css

# [0.10.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.9.4...@vtmn/css@0.10.0) (2021-06-02)

### Features

- **@vtmn/css:** add focus-visible ([#315](https://github.com/Decathlon/vitamin-web/issues/315)) ([0ebf1c7](https://github.com/Decathlon/vitamin-web/commit/0ebf1c7505d2506d964f4dbd878489ce93be421b))

## [0.9.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.9.3...@vtmn/css@0.9.4) (2021-06-02)

**Note:** Version bump only for package @vtmn/css

## [0.9.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.9.2...@vtmn/css@0.9.3) (2021-06-01)

**Note:** Version bump only for package @vtmn/css

## [0.9.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.9.1...@vtmn/css@0.9.2) (2021-05-13)

**Note:** Version bump only for package @vtmn/css

## [0.9.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.9.0...@vtmn/css@0.9.1) (2021-05-07)

**Note:** Version bump only for package @vtmn/css

# [0.9.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.8.0...@vtmn/css@0.9.0) (2021-05-06)

### Features

- **@vtmn/web-components:** css fixes for message margin + text input state set up ([1570974](https://github.com/Decathlon/vitamin-web/commit/15709740360dbd5f34d8cc89575e9539d5495b6c))

# [0.8.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.7.1...@vtmn/css@0.8.0) (2021-05-04)

### Features

- **@vtmn/css-checkbox:** add color-mod function ([b0c09b7](https://github.com/Decathlon/vitamin-web/commit/b0c09b7a057b004b9aef871ad90632be99a8b5aa))
- **@vtmn/css-checkbox:** init ([d50f90c](https://github.com/Decathlon/vitamin-web/commit/d50f90c14d27af023e8e7f7304ae311f1b9990ac))

## [0.7.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.7.0...@vtmn/css@0.7.1) (2021-05-03)

**Note:** Version bump only for package @vtmn/css

# [0.7.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.6.0...@vtmn/css@0.7.0) (2021-04-29)

### Features

- add sources part ([23754d6](https://github.com/Decathlon/vitamin-web/commit/23754d6c3bc0e4b56eaffb40cdbefae77d4d6179))

# [0.6.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.5.1...@vtmn/css@0.6.0) (2021-04-21)

### Bug Fixes

- **@vtmn/cs-text-input:** larger check icon for valid input ([04f8422](https://github.com/Decathlon/vitamin-web/commit/04f842299c04aa9b1184ad67765a051cffac9eb7))
- **@vtmn/css-text-input:** adjust icon font size ([7d2abf0](https://github.com/Decathlon/vitamin-web/commit/7d2abf06929193856c88cd51833bda9ddebd69a1))
- **vtmn-text-input:** icon in html to allow to change it + when disabled component turns opaque ([e0f2c6e](https://github.com/Decathlon/vitamin-web/commit/e0f2c6ec1d5e8630f3e0b061c6d1ce7055da5e6d))
- **vtmn-text-input:** when disabled, change opacity instead of colors manually ([9a054c7](https://github.com/Decathlon/vitamin-web/commit/9a054c744e90300752ce6cedf21f8cd64eea9df3))

### Features

- **@vtmn/css-text-input:** add three different ways to embed icon ([c7169c3](https://github.com/Decathlon/vitamin-web/commit/c7169c33b30a406193911bee670e877b65f1efb0))
- **vtmn-text-input:** add checked icon for valid text-input ([caf90d1](https://github.com/Decathlon/vitamin-web/commit/caf90d1e91cb1f5827eb5fdfd57248b47e20632f))
- **vtmn-text-input:** add icon for default, disabled, error text inputs ([dd719db](https://github.com/Decathlon/vitamin-web/commit/dd719db186c5e2a2670a25bbf13787f0d3039860))
- **vtmn-text-input:** add icon warning on error text input ([13e1f41](https://github.com/Decathlon/vitamin-web/commit/13e1f41ae9df85a941f684c4da378d157a508cd9))

## [0.5.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.5.0...@vtmn/css@0.5.1) (2021-04-19)

**Note:** Version bump only for package @vtmn/css

# [0.5.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.4.2...@vtmn/css@0.5.0) (2021-04-16)

### Features

- **@vtmn/css-link:** add outline border for accessibility ([c6dc834](https://github.com/Decathlon/vitamin-web/commit/c6dc8349753883d12aa7d892bfcf50f2156d440f))
- **@vtmn/css-link:** add standalone and inline versions of link ([196f385](https://github.com/Decathlon/vitamin-web/commit/196f385eeaa563894967044862e7dfb37058b717))
- **vtmn-link:** add 3 size variants for link component with icon ([24c1f2d](https://github.com/Decathlon/vitamin-web/commit/24c1f2d8e89f6a8ec5dec520ccab113232dfb545))
- **vtmn-link:** init css link component ([af2e922](https://github.com/Decathlon/vitamin-web/commit/af2e92280f22267b23fda4ed0c0b13a767fcf83e))

## [0.4.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.4.1...@vtmn/css@0.4.2) (2021-04-16)

**Note:** Version bump only for package @vtmn/css

## [0.4.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.4.0...@vtmn/css@0.4.1) (2021-04-15)

**Note:** Version bump only for package @vtmn/css

# [0.4.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.3.0...@vtmn/css@0.4.0) (2021-04-14)

### Bug Fixes

- **vtmn-toggle:** optimize css class for disabled case ([8453e1c](https://github.com/Decathlon/vitamin-web/commit/8453e1cb9bb20441b63be0823c8f6b5242f47e1f))

### Features

- **vtmn-toggle:** add default toggle component with basic design behaviour ([6acc776](https://github.com/Decathlon/vitamin-web/commit/6acc776a6dc4581c6268439df921f402927b8581))
- **vtmn-toggle:** add disabled toggle component ([4b8dd2c](https://github.com/Decathlon/vitamin-web/commit/4b8dd2cf3ba64cd335572d54760ebb784d541c26))
- **vtmn-toggle:** add small size toggle component variant ([62502a1](https://github.com/Decathlon/vitamin-web/commit/62502a1d9d38a9da649a9bf656efa3f54e60661f))
- **vtmn-toggle:** create toggle component source and showcase folders ([82817e6](https://github.com/Decathlon/vitamin-web/commit/82817e6b3f58bcbd98a1a4787aeeb9a94d9ee69d))
- **vtmn-toggle:** css optimisation, regroup classes ([c85200d](https://github.com/Decathlon/vitamin-web/commit/c85200da68d9ac26e77c4ef8eab82e9a87d71f05))
- **vtmn-toggle:** refacto toggle to optimize css code, add small version, add check icon ([66153f5](https://github.com/Decathlon/vitamin-web/commit/66153f595d7f14da93e77d0aa75f55499a9d157d))

# [0.3.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.2.6...@vtmn/css@0.3.0) (2021-04-07)

### Bug Fixes

- **vtmn-text-input:** reduce text-input margin-top to match figma data ([ffc296d](https://github.com/Decathlon/vitamin-web/commit/ffc296d3821c84a84d393ee6c6f9ef15ae9bae47))

### Features

- **vtmn-text-input:** add line break ([df6b3ad](https://github.com/Decathlon/vitamin-web/commit/df6b3ad08b8aea09a9424a56d78f5eca00f7638a))
- **vtmn-text-input:** error message color changed to black and edit the default text ([2a58fc5](https://github.com/Decathlon/vitamin-web/commit/2a58fc51ba26c447893de0248682c7f1260800bf))

## [0.2.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.2.5...@vtmn/css@0.2.6) (2021-04-02)

**Note:** Version bump only for package @vtmn/css

## [0.2.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.2.4...@vtmn/css@0.2.5) (2021-03-31)

**Note:** Version bump only for package @vtmn/css

## [0.2.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.2.3...@vtmn/css@0.2.4) (2021-03-29)

**Note:** Version bump only for package @vtmn/css

## [0.2.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.2.2...@vtmn/css@0.2.3) (2021-03-20)

**Note:** Version bump only for package @vtmn/css

## [0.2.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.2.1...@vtmn/css@0.2.2) (2021-03-20)

**Note:** Version bump only for package @vtmn/css

## [0.2.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.2.0...@vtmn/css@0.2.1) (2021-03-15)

**Note:** Version bump only for package @vtmn/css

# [0.2.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.12...@vtmn/css@0.2.0) (2021-03-15)

### Features

- **@vtmn/css-design-tokens:** generate .less output ([068f2e4](https://github.com/Decathlon/vitamin-web/commit/068f2e4e932a3185c90b3de96ccd2a613a70e8de))
- **@vtmn/css-design-tokens:** generate .scss output ([af50104](https://github.com/Decathlon/vitamin-web/commit/af50104d9891f23b0493c35b3a2bc91c9dac698d))

## [0.1.12](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.11...@vtmn/css@0.1.12) (2021-03-10)

**Note:** Version bump only for package @vtmn/css

## [0.1.11](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.10...@vtmn/css@0.1.11) (2021-03-09)

**Note:** Version bump only for package @vtmn/css

## [0.1.10](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.9...@vtmn/css@0.1.10) (2021-03-09)

**Note:** Version bump only for package @vtmn/css

## [0.1.9](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.8...@vtmn/css@0.1.9) (2021-02-26)

**Note:** Version bump only for package @vtmn/css

## [0.1.8](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.7...@vtmn/css@0.1.8) (2021-02-26)

**Note:** Version bump only for package @vtmn/css

## [0.1.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.6...@vtmn/css@0.1.7) (2021-02-12)

**Note:** Version bump only for package @vtmn/css

## [0.1.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.5...@vtmn/css@0.1.6) (2021-02-10)

**Note:** Version bump only for package @vtmn/css

## [0.1.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.4...@vtmn/css@0.1.5) (2021-02-10)

**Note:** Version bump only for package @vtmn/css

## [0.1.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.3...@vtmn/css@0.1.4) (2021-02-08)

**Note:** Version bump only for package @vtmn/css

## [0.1.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.2...@vtmn/css@0.1.3) (2021-02-05)

**Note:** Version bump only for package @vtmn/css

## [0.1.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.1...@vtmn/css@0.1.2) (2021-02-03)

**Note:** Version bump only for package @vtmn/css

## [0.1.1](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.1.0...@vtmn/css@0.1.1) (2021-02-03)

**Note:** Version bump only for package @vtmn/css

# [0.1.0](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.0.7...@vtmn/css@0.1.0) (2021-02-03)

### Features

- **@vtmn/css:** add text input ([#68](https://github.com/Decathlon/vitamin-web/issues/68)) ([f0d8137](https://github.com/Decathlon/vitamin-web/commit/f0d8137e88d081f3f8195dc0ecbf802a350c6b0d))

## [0.0.7](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.0.6...@vtmn/css@0.0.7) (2021-02-03)

**Note:** Version bump only for package @vtmn/css

## [0.0.6](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.0.5...@vtmn/css@0.0.6) (2021-01-30)

**Note:** Version bump only for package @vtmn/css

## [0.0.5](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.0.4...@vtmn/css@0.0.5) (2021-01-21)

**Note:** Version bump only for package @vtmn/css

## [0.0.4](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.0.3...@vtmn/css@0.0.4) (2021-01-21)

**Note:** Version bump only for package @vtmn/css

## [0.0.3](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.0.2...@vtmn/css@0.0.3) (2021-01-21)

**Note:** Version bump only for package @vtmn/css

## [0.0.2](https://github.com/Decathlon/vitamin-web/compare/@vtmn/css@0.0.1...@vtmn/css@0.0.2) (2021-01-21)

**Note:** Version bump only for package @vtmn/css

## 0.0.1 (2021-01-21)

### Bug Fixes

- stylelint errors ([#43](https://github.com/Decathlon/vitamin-web/issues/43)) ([08f01ce](https://github.com/Decathlon/vitamin-web/commit/08f01ce02690e5d38919f7f1b4c95980a4805470))
