module.exports = {
  stories: [
    '../stories/*.stories.@(mdx|js)',
    '../stories/guidelines/**/*.stories.@(mdx|js)',
    '../stories/components/**/*.stories.@(mdx|js)',
  ],
  addons: [
    '@storybook/addon-essentials',
    '@storybook/addon-a11y',
    '@whitespace/storybook-addon-html',
    'storybook-addon-designs',
  ],
  webpackFinal: (config) => {
    config.module.rules = [
      // remove the old html-loader, with default value to true for minimize parameter
      ...config.module.rules.filter(({ test }) => test.toString() !== /\.html$/.toString()),
      // add new html-loader with right configuration
      {
        test: /\.html$/,
        loader: 'html-loader',
        options: {
          minimize: false
        }
      }
    ];
    return config;
  },
};
