<!-- ======================================== yaac1-specs.md Start ======================================== -->


<!-- ------------------------------ Intro Start ------------------------------ -->

# Y.A.A.C-1 - Hardware Specs

Hardware Specs for the Y.A.A.C-1

<!-- ------------------------------ Intro End ------------------------------ -->


<!-- ------------------------------ Overview Start ------------------------------ -->

# Contents:

 - [Cases](#Cases)
 - [Core Compute](#Core-Compute)
 - [Display](#Display)
 - [Power](#Power)
 - [Storage](#Storage)

<!-- ------------------------------ Overview End ------------------------------ -->


<!-- ------------------------------ Case Start ------------------------------ -->

## Cases

### APACHE 3800 Weatherproof Protective Case

* **Waterproofing:** IP65 Rated- watertight and dustproof
  - Adjustable pressure relief valve equalizes pressure for easy opening
* **Material:** Super strong reinforced polypropylene construction
* **Security:** Pre-drilled for two padlocks
* **Exterior Dimensions:** 16-1/2" x 13" x 6-3/4"
* **Interior Dimensions:** 14-7/8" x 10-5/8" x 6-1/8"

<!-- ------------------------------ Case End ------------------------------ -->


<!-- ------------------------------ Core Compute Start ------------------------------ -->

## Core Compute

### Raspberry Pi 4 Model B

* **CPU:** Broadcom BCM2711, Quad core Cortex-A72 (ARM v8) 64-bit SoC @ 1.8GHz
* **RAM:** 8GB LPDDR4-3200 SDRAM (depending on model)
* **WiFi:** 2.4 GHz and 5.0 GHz IEEE 802.11ac wireless
* **BT:** Bluetooth 5.0, BLE
* **Ethernet:** Gigabit Ethernet
* **USB:** 2 USB 3.0 ports; 2 USB 2.0 ports.
* **GPIO:** Raspberry Pi standard 40 pin GPIO header (fully backwards compatible with previous boards)
* **Display:** 2 × micro-HDMI® ports (up to 4kp60 supported), 2-lane MIPI DSI display port
* **Camera:** 2-lane MIPI CSI camera port
* **Audio:** 4-pole stereo audio and composite video port
* **Storage:** Micro-SD card slot for loading operating system and data storage

<!-- ------------------------------ Core Compute End ------------------------------ -->


<!-- ------------------------------ Display Start ------------------------------ -->

## Display

### Waveshare 10.1inch Capacitive Touch Screen LCD (B) with Case, 1280×800, HDMI, IPS Screen, Low Power

* **Size: 10.1"**
* **Resolution:** 1280x800
* **Display Interface:** HDMI
* **Display Panel:** In-Plane Switching
* **Viewing Angle:** 170°
* **Touch:** Capacitive, 10 Point Touch
* **Power Interface:** Micro USB
* **Power Usage:** Approximately 3 - 5 watts

<!-- ------------------------------ Display End ------------------------------ -->


<!-- ------------------------------ Power Start ------------------------------ -->

## Power

### Anker 737 Power Bank, 24,000mAh 3-Port Portable Charger
* **Capacity:** 24,000 mAh
* **Ports:** 1 USB-A in/out, 1 USB-C in/out, 1 USB-C out
* **Display:** Shows current wattage being used per port, as well as remaining time on the battery

### Geekworm Raspberry Pi X728 UPS
* **Voltage:** 5.1 Volts
* **Amperage:** Up to 6 Amp output
* Supports safe shutdown via software when battery voltage is low

### 2x Panasonic NCR 18650 3400mAh 3.7V Unprotected High-Drain 4.87A LiOn Flat Top
* **Capacity:** 3,400 mAh
* **Voltage:** 3.7 Volts

### CanaKit 3.5A Raspberry Pi 4 Power Supply with PiSwitch (USB-C)
* **Voltage:** 5.1 Volts
* **Amperage:** 3.5 Amps
* Detachable power switch with LED indicator

<!-- ------------------------------ Power End ------------------------------ -->


<!-- ------------------------------ Storage Start ------------------------------ -->

## Storage

### Crucial X9 1TB Portable SSD
* **Capacity:** 1 TB
* **Interface:** USB-C
* **Speed:** Up to 1050 MB/s

### SanDisk 1TB Extreme External Portable SSD
* **Capacity:** 1 TB
* **Interface:** USB-C
* **Speed:** Up to 1050 MB/s

### SanDisk 512GB Ultra microSDXC
* **Capacity:** 512 GB
* **Interface:** microSD
* **Speed:** Up to 150 MB/s

<!-- ------------------------------ Storage End ------------------------------ -->


<!-- ------------------------------ Outro Start ------------------------------ -->

<!-- ------------------------------ Outro End ------------------------------ -->


<!-- ======================================== yaac1-specs.md End ======================================== -->
