/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
public class HashChangeEvent
extends Event {
    private String oldURL_ = "";
    private String newURL_ = "";

    public HashChangeEvent() {
        this.setEventType("");
    }

    public HashChangeEvent(SimpleScriptable scriptable, String type, String oldURL, String newURL) {
        super(scriptable, type);
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.EVENT_ONHASHCHANGE_BUBBLES_FALSE)) {
            this.setBubbles(false);
        }
        this.setCancelable(false);
    }

    @Override
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        String oldURL = "";
        String newURL = "";
        if (details != null && !Undefined.instance.equals(details)) {
            oldURL = (String)details.get("oldURL");
            newURL = (String)details.get("newURL");
        }
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public void initHashChangeEvent(String type, boolean bubbles, boolean cancelable, String oldURL, String newURL) {
        this.initEvent(type, bubbles, cancelable);
        this.oldURL_ = oldURL;
        this.newURL_ = newURL;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public Object getOldURL() {
        return this.oldURL_;
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public Object getNewURL() {
        return this.newURL_;
    }
}

