/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit;

import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebConsole
implements Serializable {
    private Formatter formatter_ = new DefaultFormatter();
    private Logger logger_ = new DefaultLogger();

    public void setFormatter(Formatter formatter) {
        this.formatter_ = formatter;
    }

    public Formatter getFormatter() {
        return this.formatter_;
    }

    public void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    public Logger getLogger() {
        return this.logger_;
    }

    public void trace(Object ... args) {
        if (this.logger_.isTraceEnabled()) {
            this.logger_.trace(this.process(args));
        }
    }

    public void debug(Object ... args) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug(this.process(args));
        }
    }

    public void info(Object ... args) {
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info(this.process(args));
        }
    }

    public void warn(Object ... args) {
        if (this.logger_.isWarnEnabled()) {
            this.logger_.warn(this.process(args));
        }
    }

    public void error(Object ... args) {
        if (this.logger_.isErrorEnabled()) {
            this.logger_.error(this.process(args));
        }
    }

    private String process(Object[] objs) {
        if (objs == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        LinkedList<Object> args = new LinkedList<Object>(Arrays.asList(objs));
        Formatter formatter = this.getFormatter();
        if (args.size() > 1 && args.get(0) instanceof String) {
            int n;
            StringBuilder msg = new StringBuilder((String)args.remove(0));
            int n2 = msg.indexOf("%");
            while (n > -1 && n < msg.length() - 1 && args.size() > 0) {
                if (n != 0 && msg.charAt((int)(n - true)) == '%') {
                    msg.replace(n, (int)(n + true), "");
                } else {
                    char type = msg.charAt((int)(n + true));
                    String replacement = null;
                    switch (type) {
                        case 'o': 
                        case 's': {
                            replacement = formatter.parameterAsString(WebConsole.pop(args));
                            break;
                        }
                        case 'd': 
                        case 'i': {
                            replacement = formatter.parameterAsInteger(WebConsole.pop(args));
                            break;
                        }
                        case 'f': {
                            replacement = formatter.parameterAsFloat(WebConsole.pop(args));
                            break;
                        }
                    }
                    if (replacement != null) {
                        msg.replace(n, (int)(n + 2), replacement);
                        n += replacement.length();
                    } else {
                        ++n;
                    }
                }
                n = msg.indexOf("%", n);
            }
            sb.append((CharSequence)msg);
        }
        for (Object e : args) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append(formatter.printObject(e));
        }
        return sb.toString();
    }

    private static Object pop(List<Object> list) {
        return list.isEmpty() ? null : list.remove(0);
    }

    private static class DefaultLogger
    implements Logger,
    Serializable {
        private static final Log LOG = LogFactory.getLog(WebConsole.class);

        private DefaultLogger() {
        }

        @Override
        public boolean isTraceEnabled() {
            return LOG.isTraceEnabled();
        }

        @Override
        public void trace(Object message) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(message);
            }
        }

        @Override
        public boolean isDebugEnabled() {
            return LOG.isDebugEnabled();
        }

        @Override
        public void debug(Object message) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(message);
            }
        }

        @Override
        public boolean isInfoEnabled() {
            return LOG.isInfoEnabled();
        }

        @Override
        public void info(Object message) {
            LOG.info(message);
        }

        @Override
        public boolean isWarnEnabled() {
            return LOG.isWarnEnabled();
        }

        @Override
        public void warn(Object message) {
            LOG.warn(message);
        }

        @Override
        public boolean isErrorEnabled() {
            return LOG.isErrorEnabled();
        }

        @Override
        public void error(Object message) {
            LOG.error(message);
        }
    }

    private static class DefaultFormatter
    implements Formatter,
    Serializable {
        private DefaultFormatter() {
        }

        @Override
        public String printObject(Object o) {
            return this.parameterAsString(o);
        }

        @Override
        public String parameterAsString(Object o) {
            if (o != null) {
                return o.toString();
            }
            return "null";
        }

        @Override
        public String parameterAsInteger(Object o) {
            if (o instanceof Number) {
                return Integer.toString(((Number)o).intValue());
            }
            if (o instanceof String) {
                try {
                    return Integer.toString(Integer.parseInt((String)o));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return "NaN";
        }

        @Override
        public String parameterAsFloat(Object o) {
            if (o instanceof Number) {
                return Float.toString(((Number)o).floatValue());
            }
            if (o instanceof String) {
                try {
                    return Float.toString(Float.parseFloat((String)o));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return "NaN";
        }
    }

    public static interface Formatter {
        public String printObject(Object var1);

        public String parameterAsString(Object var1);

        public String parameterAsInteger(Object var1);

        public String parameterAsFloat(Object var1);
    }

    public static interface Logger {
        public boolean isTraceEnabled();

        public void trace(Object var1);

        public boolean isDebugEnabled();

        public void debug(Object var1);

        public boolean isInfoEnabled();

        public void info(Object var1);

        public boolean isWarnEnabled();

        public void warn(Object var1);

        public boolean isErrorEnabled();

        public void error(Object var1);
    }
}

