#!/data/data/com.termux/files/usr/bin/bash 
installing () {
directory=parrot-fs
if [ -d "$directory" ];then
first=1
printf "\x1b[38;5;227m[WARNING]:\e[0m \x1b[38;5;87m Skipping the download and the extraction\n"
elif [ -z "$(command -v proot)" ];then
printf "\x1b[38;5;203m[ERROR]:\e[0m \x1b[38;5;87m Please install proot.\n"
printf "\e[0m"
exit 1
elif [ -z "$(command -v wget)" ];then
printf "\x1b[38;5;203m[ERROR]:\e[0m \x1b[38;5;87m Please install wget.\n"
printf "\e[0m"
exit 1
fi
tarball="parrot-rootfs.tar.xz"
if [ "$first" != 1 ];then
if [ -f "parrot-rootfs.tar.xz" ];then
rm -rf parrot-rootfs.tar.xz
fi
if [ ! -f "parrot-rootfs.tar.xz" ];then
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Downloading the parrot rootfs, please wait...\n"
ARCHITECTURE=$(dpkg --print-architecture)
case "$ARCHITECTURE" in
aarch64) ARCHITECTURE=arm64;;
arm) ARCHITECTURE=armhf;;
amd64|x86_64) ARCHITECTURE=amd64;;
i*86) ARCHITECTURE=i386;;
x86) ARCHITECTURE=i386;;
*)
printf "\x1b[38;5;203m[ERROR]:\e[0m \x1b[38;5;87m Unknown architecture :- $ARCHITECTURE"
exit 1
;;

esac

wget https://github.com/RiSecID/AndronixOrigin/blob/master/Rootfs/Parrot/${ARCHITECTURE}/parrot-rootfs-${ARCHITECTURE}.tar.xz?raw=true -q -O parrot-rootfs.tar.xz --show-progress
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Download complete!\n"

fi
	cur=`pwd`
	mkdir -p "$directory"
	cd "$directory"
	echo "Decompressing Rootfs, please be patient."
	proot --link2symlink tar -xJf ${cur}/${tarball}||:
	cd "$cur"
fi
mkdir -p parrot-binds
bin=parrot
echo "writing launch script"
cat > $bin <<- EOM
#!/bin/bash
cd \$(dirname \$0)
## unset LD_PRELOAD in case termux-exec is installed
unset LD_PRELOAD
command="proot"
command+=" --link2symlink"
command+=" -0"
command+=" -r $directory"
if [ -n "\$(ls -A parrot-binds)" ]; then
    for f in parrot-binds/* ;do
      . \$f
    done
fi
command+=" -b /dev"
command+=" -b /proc"
command+=" -b parrot-fs/root:/dev/shm"
## uncomment the following line to have access to the home directory of termux
#command+=" -b /data/data/com.termux/files/home:/root"
## uncomment the following line to mount /sdcard directly to / 
#command+=" -b /sdcard"
command+=" -w /root"
command+=" /usr/bin/env -i"
command+=" HOME=/root"
command+=" PATH=/usr/local/sbin:/usr/local/bin:/bin:/usr/bin:/sbin:/usr/sbin:/usr/games:/usr/local/games"
command+=" TERM=\$TERM"
command+=" LANG=C.UTF-8"
command+=" /bin/bash --login"
com="\$@"
if [ -z "\$1" ];then
    exec \$command
else
    \$command -c "\$com"
fi
EOM
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m The start script has been successfully created!\n"
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Fixing shebang of startparrot.sh, please wait...\n"
termux-fix-shebang $bin
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Successfully fixed shebang of startparrot.sh! \n"
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Making startparrot.sh executable please wait...\n"
chmod +x $bin
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Successfully made startparrot.sh executable\n"
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Cleaning up please wait...\n"
rm parrot-rootfs.tar.xz -rf
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Successfully cleaned up!\n"
cat parrot-fs/etc/apt/sources.list | \
sed -e 's/stable/lts/g' >> parrot-fs/etc/apt/sources.list
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m Parsing Parrot with stable repo!\n"
printf "\x1b[38;5;83m[Installer thread/INFO]:\e[0m \x1b[38;5;87m The installation has been completed! You can now launch parrot script type ./parrot\n"
printf "\e[0m"

#fixed repo
rm parrot-fs/etc/apt/sources.list
echo "deb http://mirrors.ustc.edu.cn/parrot parrot main contrib non-free" >> parrot-fs/etc/apt/sources.list
echo "deb-src http://mirrors.ustc.edu.cn/parrot parrot main contrib non-free" >> parrot-fs/etc/apt/sources.list
#Import the gpg key, this is only required in Parrot Security OS
wget http://archive.parrotsec.org/parrot/misc/archive.gpg -O parrot-fs/etc/apt/trusted.gpg.d/parrot-archive-key.asc

#Setup DNS
echo "127.0.0.1 localhost" > parrot-fs/etc/hosts
echo "nameserver 8.8.8.8" > parrot-fs/etc/resolv.conf
echo "nameserver 8.8.4.4" >> parrot-fs/etc/resolv.conf
sleep 2
mkdir ParrotOS && mv $bin parrot-binds parrot-fs ParrotOS && mv ParrotOS /data/data/com.termux/files/home
}
# Call The Function 
installing 
# End The Script
