// created by jay 0.7 (c) 1998 Axel.Schreiner@informatik.uni-osnabrueck.de

#line 2 "cs-parser.jay"
//
// cs-parser.jay: The Parser for the C# compiler
//
// Authors: Miguel de Icaza (miguel@gnu.org)
//          Ravi Pratap     (ravi@ximian.com)
//          Marek Safar		(marek.safar@gmail.com)
//
// Dual Licensed under the terms of the GNU GPL and the MIT X11 license
//
// (C) 2001 Ximian, Inc (http://www.ximian.com)
// (C) 2004 Novell, Inc
//
// TODO:
//   (1) Figure out why error productions dont work.  `type-declaration' is a
//       great spot to put an `error' because you can reproduce it with this input:
//	 "public X { }"
//

using System.Text;
using System.IO;
using System;
using System.Collections.Generic;

namespace Mono.CSharp
{
	/// <summary>
	///    The C# Parser
	/// </summary>
	public class CSharpParser
	{
		[Flags]
		enum ParameterModifierType
		{
			Ref		= 1 << 1,
			Out		= 1 << 2,
			This	= 1 << 3,
			Params	= 1 << 4,
			Arglist	= 1 << 5,
			DefaultValue = 1 << 6,
			
			All = Ref | Out | This | Params | Arglist | DefaultValue
		}
		
		static readonly object ModifierNone = 0;
	
		NamespaceContainer  current_namespace;
		TypeContainer   current_container;
		DeclSpace	current_class;
		PropertyBase current_property;
		EventProperty current_event;
		EventField current_event_field;
		FieldBase current_field;
	
		/// <summary>
		///   Current block is used to add statements as we find
		///   them.  
		/// </summary>
		Block      current_block;
		
		BlockVariableDeclaration current_variable;

		Delegate   current_delegate;
		
		AnonymousMethodExpression current_anonymous_method;

		/// <summary>
		///   This is used by the unary_expression code to resolve
		///   a name against a parameter.  
		/// </summary>
		
		// FIXME: This is very ugly and it's very hard to reset it correctly
		// on all places, especially when some parameters are autogenerated.
		ParametersCompiled current_local_parameters;

		bool parsing_anonymous_method;

		///
		/// An out-of-band stack.
		///
		static Stack<object> oob_stack;

		///
		/// Controls the verbosity of the errors produced by the parser
		///
		static public int yacc_verbose_flag;

		/// 
		/// Used by the interactive shell, flags whether EOF was reached
		/// and an error was produced
		///
		public bool UnexpectedEOF;

		///
		/// The current file.
		///
		readonly CompilationSourceFile file;

		///
		/// Temporary Xml documentation cache.
		/// For enum types, we need one more temporary store.
		///
		string tmpComment;
		string enumTypeComment;
	       		
		/// Current attribute target
		string current_attr_target;
		
		ParameterModifierType valid_param_mod;
		
		bool default_parameter_used;

		/// When using the interactive parser, this holds the
		/// resulting expression
		public Class InteractiveResult;

		//
		// Keeps track of global data changes to undo on parser error
		//
		public Undo undo;
		
		Stack<Linq.QueryBlock> linq_clause_blocks;

		ModuleContainer module;
		
		readonly CompilerContext compiler;
		readonly LanguageVersion lang_version;
		readonly bool doc_support;
		readonly CompilerSettings settings;
		readonly Report report;
		
		//
		// Instead of allocating carrier array everytime we
		// share the bucket for very common constructs which can never
		// be recursive
		//
		static List<Parameter> parameters_bucket = new List<Parameter> (6);
		
		//
		// Full AST support members
		//
		LocationsBag lbag;
		UsingsBag ubag;
		List<Tuple<Modifiers, Location>> mod_locations;
		Location parameterModifierLocation, savedLocation, savedOpenLocation, savedCloseLocation;
#line default

  /** error output stream.
      It should be changeable.
    */
  public System.IO.TextWriter ErrorOutput = System.Console.Out;

  /** simplified error message.
      @see <a href="#yyerror(java.lang.String, java.lang.String[])">yyerror</a>
    */
  public void yyerror (string message) {
    yyerror(message, null);
  }

  /* An EOF token */
  public int eof_token;

  /** (syntax) error message.
      Can be overwritten to control message format.
      @param message text to be displayed.
      @param expected vector of acceptable tokens, if available.
    */
  public void yyerror (string message, string[] expected) {
    if ((yacc_verbose_flag > 0) && (expected != null) && (expected.Length  > 0)) {
      ErrorOutput.Write (message+", expecting");
      for (int n = 0; n < expected.Length; ++ n)
        ErrorOutput.Write (" "+expected[n]);
        ErrorOutput.WriteLine ();
    } else
      ErrorOutput.WriteLine (message);
  }

  /** debugging support, requires the package jay.yydebug.
      Set to null to suppress debugging messages.
    */
//t  internal yydebug.yyDebug debug;

  protected const int yyFinal = 7;
//t // Put this array into a separate class so it is only initialized if debugging is actually used
//t // Use MarshalByRefObject to disable inlining
//t class YYRules : MarshalByRefObject {
//t  public static readonly string [] yyRule = {
//t    "$accept : compilation_unit",
//t    "compilation_unit : outer_declaration opt_EOF",
//t    "$$1 :",
//t    "compilation_unit : interactive_parsing $$1 opt_EOF",
//t    "compilation_unit : documentation_parsing",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations opt_attributes",
//t    "outer_declaration : opt_extern_alias_directives opt_using_directives attribute_sections",
//t    "outer_declaration : error",
//t    "opt_EOF :",
//t    "opt_EOF : EOF",
//t    "extern_alias_directives : extern_alias_directive",
//t    "extern_alias_directives : extern_alias_directives extern_alias_directive",
//t    "extern_alias_directive : EXTERN_ALIAS IDENTIFIER IDENTIFIER SEMICOLON",
//t    "extern_alias_directive : EXTERN_ALIAS error",
//t    "using_directives : using_directive",
//t    "using_directives : using_directives using_directive",
//t    "using_directive : using_alias_directive",
//t    "using_directive : using_namespace_directive",
//t    "using_alias_directive : USING IDENTIFIER ASSIGN namespace_or_type_name SEMICOLON",
//t    "using_alias_directive : USING error",
//t    "using_namespace_directive : USING namespace_name SEMICOLON",
//t    "$$2 :",
//t    "$$3 :",
//t    "namespace_declaration : opt_attributes NAMESPACE qualified_identifier $$2 OPEN_BRACE $$3 opt_extern_alias_directives opt_using_directives opt_namespace_or_type_declarations CLOSE_BRACE opt_semicolon",
//t    "qualified_identifier : IDENTIFIER",
//t    "qualified_identifier : qualified_identifier DOT IDENTIFIER",
//t    "qualified_identifier : error",
//t    "opt_semicolon :",
//t    "opt_semicolon : SEMICOLON",
//t    "opt_comma :",
//t    "opt_comma : COMMA",
//t    "namespace_name : namespace_or_type_name",
//t    "opt_using_directives :",
//t    "opt_using_directives : using_directives",
//t    "opt_extern_alias_directives :",
//t    "opt_extern_alias_directives : extern_alias_directives",
//t    "opt_namespace_or_type_declarations :",
//t    "opt_namespace_or_type_declarations : namespace_or_type_declarations",
//t    "namespace_or_type_declarations : namespace_or_type_declaration",
//t    "namespace_or_type_declarations : namespace_or_type_declarations namespace_or_type_declaration",
//t    "namespace_or_type_declaration : type_declaration",
//t    "namespace_or_type_declaration : namespace_declaration",
//t    "type_declaration : class_declaration",
//t    "type_declaration : struct_declaration",
//t    "type_declaration : interface_declaration",
//t    "type_declaration : enum_declaration",
//t    "type_declaration : delegate_declaration",
//t    "opt_attributes :",
//t    "opt_attributes : attribute_sections",
//t    "attribute_sections : attribute_section",
//t    "attribute_sections : attribute_sections attribute_section",
//t    "$$4 :",
//t    "attribute_section : OPEN_BRACKET $$4 attribute_section_cont",
//t    "$$5 :",
//t    "attribute_section_cont : attribute_target COLON $$5 attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_section_cont : attribute_list opt_comma CLOSE_BRACKET",
//t    "attribute_target : IDENTIFIER",
//t    "attribute_target : EVENT",
//t    "attribute_target : RETURN",
//t    "attribute_target : error",
//t    "attribute_list : attribute",
//t    "attribute_list : attribute_list COMMA attribute",
//t    "$$6 :",
//t    "attribute : attribute_name $$6 opt_attribute_arguments",
//t    "attribute_name : namespace_or_type_name",
//t    "opt_attribute_arguments :",
//t    "opt_attribute_arguments : OPEN_PARENS attribute_arguments CLOSE_PARENS",
//t    "attribute_arguments :",
//t    "attribute_arguments : positional_or_named_argument",
//t    "attribute_arguments : named_attribute_argument",
//t    "attribute_arguments : attribute_arguments COMMA positional_or_named_argument",
//t    "attribute_arguments : attribute_arguments COMMA named_attribute_argument",
//t    "positional_or_named_argument : expression",
//t    "positional_or_named_argument : named_argument",
//t    "$$7 :",
//t    "named_attribute_argument : IDENTIFIER ASSIGN $$7 expression",
//t    "named_argument : IDENTIFIER COLON opt_named_modifier expression",
//t    "opt_named_modifier :",
//t    "opt_named_modifier : REF",
//t    "opt_named_modifier : OUT",
//t    "opt_class_member_declarations :",
//t    "opt_class_member_declarations : class_member_declarations",
//t    "class_member_declarations : class_member_declaration",
//t    "class_member_declarations : class_member_declarations class_member_declaration",
//t    "class_member_declaration : constant_declaration",
//t    "class_member_declaration : field_declaration",
//t    "class_member_declaration : method_declaration",
//t    "class_member_declaration : property_declaration",
//t    "class_member_declaration : event_declaration",
//t    "class_member_declaration : indexer_declaration",
//t    "class_member_declaration : operator_declaration",
//t    "class_member_declaration : constructor_declaration",
//t    "class_member_declaration : destructor_declaration",
//t    "class_member_declaration : type_declaration",
//t    "class_member_declaration : error",
//t    "$$8 :",
//t    "$$9 :",
//t    "$$10 :",
//t    "$$11 :",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT $$8 type_declaration_name $$9 opt_class_base opt_type_parameter_constraints_clauses $$10 struct_body $$11 opt_semicolon",
//t    "struct_declaration : opt_attributes opt_modifiers opt_partial STRUCT error",
//t    "$$12 :",
//t    "struct_body : OPEN_BRACE $$12 opt_struct_member_declarations CLOSE_BRACE",
//t    "opt_struct_member_declarations :",
//t    "opt_struct_member_declarations : struct_member_declarations",
//t    "struct_member_declarations : struct_member_declaration",
//t    "struct_member_declarations : struct_member_declarations struct_member_declaration",
//t    "struct_member_declaration : constant_declaration",
//t    "struct_member_declaration : field_declaration",
//t    "struct_member_declaration : method_declaration",
//t    "struct_member_declaration : property_declaration",
//t    "struct_member_declaration : event_declaration",
//t    "struct_member_declaration : indexer_declaration",
//t    "struct_member_declaration : operator_declaration",
//t    "struct_member_declaration : constructor_declaration",
//t    "struct_member_declaration : type_declaration",
//t    "struct_member_declaration : destructor_declaration",
//t    "$$13 :",
//t    "constant_declaration : opt_attributes opt_modifiers CONST type IDENTIFIER $$13 constant_initializer opt_constant_declarators SEMICOLON",
//t    "opt_constant_declarators :",
//t    "opt_constant_declarators : constant_declarators",
//t    "constant_declarators : constant_declarator",
//t    "constant_declarators : constant_declarators constant_declarator",
//t    "constant_declarator : COMMA IDENTIFIER constant_initializer",
//t    "$$14 :",
//t    "constant_initializer : ASSIGN $$14 constant_initializer_expr",
//t    "constant_initializer : error",
//t    "constant_initializer_expr : constant_expression",
//t    "constant_initializer_expr : array_initializer",
//t    "$$15 :",
//t    "field_declaration : opt_attributes opt_modifiers member_type IDENTIFIER $$15 opt_field_initializer opt_field_declarators SEMICOLON",
//t    "$$16 :",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type IDENTIFIER $$16 fixed_field_size opt_fixed_field_declarators SEMICOLON",
//t    "field_declaration : opt_attributes opt_modifiers FIXED simple_type error SEMICOLON",
//t    "opt_field_initializer :",
//t    "$$17 :",
//t    "opt_field_initializer : ASSIGN $$17 variable_initializer",
//t    "opt_field_declarators :",
//t    "opt_field_declarators : field_declarators",
//t    "field_declarators : field_declarator",
//t    "field_declarators : field_declarators field_declarator",
//t    "field_declarator : COMMA IDENTIFIER",
//t    "$$18 :",
//t    "field_declarator : COMMA IDENTIFIER ASSIGN $$18 variable_initializer",
//t    "opt_fixed_field_declarators :",
//t    "opt_fixed_field_declarators : fixed_field_declarators",
//t    "fixed_field_declarators : fixed_field_declarator",
//t    "fixed_field_declarators : fixed_field_declarators fixed_field_declarator",
//t    "fixed_field_declarator : COMMA IDENTIFIER fixed_field_size",
//t    "$$19 :",
//t    "fixed_field_size : OPEN_BRACKET $$19 expression CLOSE_BRACKET",
//t    "fixed_field_size : OPEN_BRACKET error",
//t    "variable_initializer : expression",
//t    "variable_initializer : array_initializer",
//t    "variable_initializer : error",
//t    "$$20 :",
//t    "method_declaration : method_header $$20 method_body",
//t    "$$21 :",
//t    "$$22 :",
//t    "method_header : opt_attributes opt_modifiers member_type method_declaration_name OPEN_PARENS $$21 opt_formal_parameter_list CLOSE_PARENS $$22 opt_type_parameter_constraints_clauses",
//t    "$$23 :",
//t    "$$24 :",
//t    "method_header : opt_attributes opt_modifiers PARTIAL VOID method_declaration_name OPEN_PARENS $$23 opt_formal_parameter_list CLOSE_PARENS $$24 opt_type_parameter_constraints_clauses",
//t    "method_header : opt_attributes opt_modifiers member_type modifiers method_declaration_name OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS",
//t    "method_body : block",
//t    "method_body : SEMICOLON",
//t    "opt_formal_parameter_list :",
//t    "opt_formal_parameter_list : formal_parameter_list",
//t    "formal_parameter_list : fixed_parameters",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array",
//t    "formal_parameter_list : fixed_parameters COMMA arglist_modifier",
//t    "formal_parameter_list : parameter_array COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA parameter_array COMMA error",
//t    "formal_parameter_list : arglist_modifier COMMA error",
//t    "formal_parameter_list : fixed_parameters COMMA ARGLIST COMMA error",
//t    "formal_parameter_list : parameter_array",
//t    "formal_parameter_list : arglist_modifier",
//t    "formal_parameter_list : error",
//t    "fixed_parameters : fixed_parameter",
//t    "fixed_parameters : fixed_parameters COMMA fixed_parameter",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER OPEN_BRACKET CLOSE_BRACKET",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type error",
//t    "$$25 :",
//t    "fixed_parameter : opt_attributes opt_parameter_modifier parameter_type IDENTIFIER ASSIGN $$25 constant_expression",
//t    "opt_parameter_modifier :",
//t    "opt_parameter_modifier : parameter_modifiers",
//t    "parameter_modifiers : parameter_modifier",
//t    "parameter_modifiers : parameter_modifiers parameter_modifier",
//t    "parameter_modifier : REF",
//t    "parameter_modifier : OUT",
//t    "parameter_modifier : THIS",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER",
//t    "parameter_array : opt_attributes params_modifier type IDENTIFIER ASSIGN constant_expression",
//t    "parameter_array : opt_attributes params_modifier type error",
//t    "params_modifier : PARAMS",
//t    "params_modifier : PARAMS parameter_modifier",
//t    "params_modifier : PARAMS params_modifier",
//t    "arglist_modifier : ARGLIST",
//t    "$$26 :",
//t    "$$27 :",
//t    "$$28 :",
//t    "property_declaration : opt_attributes opt_modifiers member_type member_declaration_name $$26 OPEN_BRACE $$27 accessor_declarations $$28 CLOSE_BRACE",
//t    "$$29 :",
//t    "$$30 :",
//t    "$$31 :",
//t    "indexer_declaration : opt_attributes opt_modifiers member_type indexer_declaration_name OPEN_BRACKET $$29 opt_formal_parameter_list CLOSE_BRACKET OPEN_BRACE $$30 accessor_declarations $$31 CLOSE_BRACE",
//t    "accessor_declarations : get_accessor_declaration",
//t    "accessor_declarations : get_accessor_declaration accessor_declarations",
//t    "accessor_declarations : set_accessor_declaration",
//t    "accessor_declarations : set_accessor_declaration accessor_declarations",
//t    "accessor_declarations : error",
//t    "$$32 :",
//t    "get_accessor_declaration : opt_attributes opt_modifiers GET $$32 accessor_body",
//t    "$$33 :",
//t    "set_accessor_declaration : opt_attributes opt_modifiers SET $$33 accessor_body",
//t    "accessor_body : block",
//t    "accessor_body : SEMICOLON",
//t    "accessor_body : error",
//t    "$$34 :",
//t    "$$35 :",
//t    "$$36 :",
//t    "$$37 :",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE $$34 type_declaration_name $$35 opt_class_base opt_type_parameter_constraints_clauses $$36 OPEN_BRACE opt_interface_member_declarations CLOSE_BRACE $$37 opt_semicolon",
//t    "interface_declaration : opt_attributes opt_modifiers opt_partial INTERFACE error",
//t    "opt_interface_member_declarations :",
//t    "opt_interface_member_declarations : interface_member_declarations",
//t    "interface_member_declarations : interface_member_declaration",
//t    "interface_member_declarations : interface_member_declarations interface_member_declaration",
//t    "interface_member_declaration : constant_declaration",
//t    "interface_member_declaration : field_declaration",
//t    "interface_member_declaration : method_declaration",
//t    "interface_member_declaration : property_declaration",
//t    "interface_member_declaration : event_declaration",
//t    "interface_member_declaration : indexer_declaration",
//t    "interface_member_declaration : operator_declaration",
//t    "interface_member_declaration : constructor_declaration",
//t    "interface_member_declaration : type_declaration",
//t    "$$38 :",
//t    "operator_declaration : opt_attributes opt_modifiers operator_declarator $$38 operator_body",
//t    "operator_body : block",
//t    "operator_body : SEMICOLON",
//t    "operator_type : type_expression_or_array",
//t    "operator_type : VOID",
//t    "$$39 :",
//t    "operator_declarator : operator_type OPERATOR overloadable_operator OPEN_PARENS $$39 opt_formal_parameter_list CLOSE_PARENS",
//t    "operator_declarator : conversion_operator_declarator",
//t    "overloadable_operator : BANG",
//t    "overloadable_operator : TILDE",
//t    "overloadable_operator : OP_INC",
//t    "overloadable_operator : OP_DEC",
//t    "overloadable_operator : TRUE",
//t    "overloadable_operator : FALSE",
//t    "overloadable_operator : PLUS",
//t    "overloadable_operator : MINUS",
//t    "overloadable_operator : STAR",
//t    "overloadable_operator : DIV",
//t    "overloadable_operator : PERCENT",
//t    "overloadable_operator : BITWISE_AND",
//t    "overloadable_operator : BITWISE_OR",
//t    "overloadable_operator : CARRET",
//t    "overloadable_operator : OP_SHIFT_LEFT",
//t    "overloadable_operator : OP_SHIFT_RIGHT",
//t    "overloadable_operator : OP_EQ",
//t    "overloadable_operator : OP_NE",
//t    "overloadable_operator : OP_GT",
//t    "overloadable_operator : OP_LT",
//t    "overloadable_operator : OP_GE",
//t    "overloadable_operator : OP_LE",
//t    "$$40 :",
//t    "conversion_operator_declarator : IMPLICIT OPERATOR type OPEN_PARENS $$40 opt_formal_parameter_list CLOSE_PARENS",
//t    "$$41 :",
//t    "conversion_operator_declarator : EXPLICIT OPERATOR type OPEN_PARENS $$41 opt_formal_parameter_list CLOSE_PARENS",
//t    "conversion_operator_declarator : IMPLICIT error",
//t    "conversion_operator_declarator : EXPLICIT error",
//t    "constructor_declaration : constructor_declarator constructor_body",
//t    "$$42 :",
//t    "$$43 :",
//t    "constructor_declarator : opt_attributes opt_modifiers IDENTIFIER $$42 OPEN_PARENS opt_formal_parameter_list CLOSE_PARENS $$43 opt_constructor_initializer",
//t    "constructor_body : block_prepared",
//t    "constructor_body : SEMICOLON",
//t    "opt_constructor_initializer :",
//t    "opt_constructor_initializer : constructor_initializer",
//t    "$$44 :",
//t    "constructor_initializer : COLON BASE OPEN_PARENS $$44 opt_argument_list CLOSE_PARENS",
//t    "$$45 :",
//t    "constructor_initializer : COLON THIS OPEN_PARENS $$45 opt_argument_list CLOSE_PARENS",
//t    "constructor_initializer : error",
//t    "$$46 :",
//t    "destructor_declaration : opt_attributes opt_modifiers TILDE $$46 IDENTIFIER OPEN_PARENS CLOSE_PARENS method_body",
//t    "$$47 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name $$47 opt_event_initializer opt_event_declarators SEMICOLON",
//t    "$$48 :",
//t    "$$49 :",
//t    "event_declaration : opt_attributes opt_modifiers EVENT type member_declaration_name OPEN_BRACE $$48 event_accessor_declarations $$49 CLOSE_BRACE",
//t    "opt_event_initializer :",
//t    "$$50 :",
//t    "opt_event_initializer : ASSIGN $$50 event_variable_initializer",
//t    "opt_event_declarators :",
//t    "opt_event_declarators : event_declarators",
//t    "event_declarators : event_declarator",
//t    "event_declarators : event_declarators event_declarator",
//t    "event_declarator : COMMA IDENTIFIER",
//t    "$$51 :",
//t    "event_declarator : COMMA IDENTIFIER ASSIGN $$51 event_variable_initializer",
//t    "$$52 :",
//t    "event_variable_initializer : $$52 variable_initializer",
//t    "event_accessor_declarations : add_accessor_declaration remove_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration add_accessor_declaration",
//t    "event_accessor_declarations : add_accessor_declaration",
//t    "event_accessor_declarations : remove_accessor_declaration",
//t    "event_accessor_declarations : error",
//t    "$$53 :",
//t    "add_accessor_declaration : opt_attributes opt_modifiers ADD $$53 event_accessor_block",
//t    "$$54 :",
//t    "remove_accessor_declaration : opt_attributes opt_modifiers REMOVE $$54 event_accessor_block",
//t    "event_accessor_block : opt_semicolon",
//t    "event_accessor_block : block",
//t    "$$55 :",
//t    "$$56 :",
//t    "$$57 :",
//t    "enum_declaration : opt_attributes opt_modifiers ENUM type_declaration_name opt_enum_base $$55 OPEN_BRACE $$56 opt_enum_member_declarations $$57 CLOSE_BRACE opt_semicolon",
//t    "opt_enum_base :",
//t    "opt_enum_base : COLON type",
//t    "opt_enum_base : COLON error",
//t    "opt_enum_member_declarations :",
//t    "opt_enum_member_declarations : enum_member_declarations",
//t    "opt_enum_member_declarations : enum_member_declarations COMMA",
//t    "enum_member_declarations : enum_member_declaration",
//t    "enum_member_declarations : enum_member_declarations COMMA enum_member_declaration",
//t    "enum_member_declaration : opt_attributes IDENTIFIER",
//t    "$$58 :",
//t    "enum_member_declaration : opt_attributes IDENTIFIER $$58 ASSIGN constant_expression",
//t    "$$59 :",
//t    "$$60 :",
//t    "$$61 :",
//t    "delegate_declaration : opt_attributes opt_modifiers DELEGATE member_type type_declaration_name OPEN_PARENS $$59 opt_formal_parameter_list CLOSE_PARENS $$60 opt_type_parameter_constraints_clauses $$61 SEMICOLON",
//t    "opt_nullable :",
//t    "opt_nullable : INTERR_NULLABLE",
//t    "namespace_or_type_name : member_name",
//t    "namespace_or_type_name : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_name : type_name",
//t    "member_name : namespace_or_type_name DOT IDENTIFIER opt_type_argument_list",
//t    "type_name : IDENTIFIER opt_type_argument_list",
//t    "opt_type_argument_list :",
//t    "opt_type_argument_list : OP_GENERICS_LT type_arguments OP_GENERICS_GT",
//t    "opt_type_argument_list : OP_GENERICS_LT error",
//t    "type_arguments : type",
//t    "type_arguments : type_arguments COMMA type",
//t    "$$62 :",
//t    "type_declaration_name : IDENTIFIER $$62 opt_type_parameter_list",
//t    "member_declaration_name : method_declaration_name",
//t    "method_declaration_name : type_declaration_name",
//t    "method_declaration_name : explicit_interface IDENTIFIER opt_type_parameter_list",
//t    "indexer_declaration_name : THIS",
//t    "indexer_declaration_name : explicit_interface THIS",
//t    "explicit_interface : IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : qualified_alias_member IDENTIFIER opt_type_argument_list DOT",
//t    "explicit_interface : explicit_interface IDENTIFIER opt_type_argument_list DOT",
//t    "opt_type_parameter_list :",
//t    "opt_type_parameter_list : OP_GENERICS_LT_DECL type_parameters OP_GENERICS_GT",
//t    "type_parameters : type_parameter",
//t    "type_parameters : type_parameters COMMA type_parameter",
//t    "type_parameter : opt_attributes opt_type_parameter_variance IDENTIFIER",
//t    "type_parameter : error",
//t    "type_and_void : type_expression_or_array",
//t    "type_and_void : VOID",
//t    "member_type : type_and_void",
//t    "type : type_expression_or_array",
//t    "type : VOID",
//t    "simple_type : type_expression",
//t    "simple_type : VOID",
//t    "parameter_type : type_expression_or_array",
//t    "parameter_type : VOID",
//t    "type_expression_or_array : type_expression",
//t    "type_expression_or_array : type_expression rank_specifiers",
//t    "type_expression : namespace_or_type_name opt_nullable",
//t    "type_expression : namespace_or_type_name pointer_stars",
//t    "type_expression : builtin_types opt_nullable",
//t    "type_expression : builtin_types pointer_stars",
//t    "type_expression : VOID pointer_stars",
//t    "type_list : base_type_name",
//t    "type_list : type_list COMMA base_type_name",
//t    "base_type_name : type",
//t    "base_type_name : error",
//t    "builtin_types : OBJECT",
//t    "builtin_types : STRING",
//t    "builtin_types : BOOL",
//t    "builtin_types : DECIMAL",
//t    "builtin_types : FLOAT",
//t    "builtin_types : DOUBLE",
//t    "builtin_types : integral_type",
//t    "integral_type : SBYTE",
//t    "integral_type : BYTE",
//t    "integral_type : SHORT",
//t    "integral_type : USHORT",
//t    "integral_type : INT",
//t    "integral_type : UINT",
//t    "integral_type : LONG",
//t    "integral_type : ULONG",
//t    "integral_type : CHAR",
//t    "primary_expression : primary_expression_or_type",
//t    "primary_expression : literal",
//t    "primary_expression : array_creation_expression",
//t    "primary_expression : parenthesized_expression",
//t    "primary_expression : default_value_expression",
//t    "primary_expression : invocation_expression",
//t    "primary_expression : element_access",
//t    "primary_expression : this_access",
//t    "primary_expression : base_access",
//t    "primary_expression : post_increment_expression",
//t    "primary_expression : post_decrement_expression",
//t    "primary_expression : object_or_delegate_creation_expression",
//t    "primary_expression : anonymous_type_expression",
//t    "primary_expression : typeof_expression",
//t    "primary_expression : sizeof_expression",
//t    "primary_expression : checked_expression",
//t    "primary_expression : unchecked_expression",
//t    "primary_expression : pointer_member_access",
//t    "primary_expression : anonymous_method_expression",
//t    "primary_expression : undocumented_expressions",
//t    "primary_expression_or_type : IDENTIFIER opt_type_argument_list",
//t    "primary_expression_or_type : IDENTIFIER GENERATE_COMPLETION",
//t    "primary_expression_or_type : member_access",
//t    "literal : boolean_literal",
//t    "literal : LITERAL",
//t    "literal : NULL",
//t    "boolean_literal : TRUE",
//t    "boolean_literal : FALSE",
//t    "open_parens_any : OPEN_PARENS",
//t    "open_parens_any : OPEN_PARENS_CAST",
//t    "close_parens : CLOSE_PARENS",
//t    "close_parens : COMPLETE_COMPLETION",
//t    "parenthesized_expression : OPEN_PARENS expression CLOSE_PARENS",
//t    "parenthesized_expression : OPEN_PARENS expression COMPLETE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : builtin_types DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : BASE DOT IDENTIFIER opt_type_argument_list",
//t    "member_access : qualified_alias_member IDENTIFIER opt_type_argument_list",
//t    "member_access : primary_expression DOT GENERATE_COMPLETION",
//t    "member_access : primary_expression DOT IDENTIFIER GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT GENERATE_COMPLETION",
//t    "member_access : builtin_types DOT IDENTIFIER GENERATE_COMPLETION",
//t    "invocation_expression : primary_expression open_parens_any opt_argument_list close_parens",
//t    "opt_object_or_collection_initializer :",
//t    "opt_object_or_collection_initializer : object_or_collection_initializer",
//t    "object_or_collection_initializer : OPEN_BRACE opt_member_initializer_list close_brace_or_complete_completion",
//t    "object_or_collection_initializer : OPEN_BRACE member_initializer_list COMMA CLOSE_BRACE",
//t    "opt_member_initializer_list :",
//t    "opt_member_initializer_list : member_initializer_list",
//t    "member_initializer_list : member_initializer",
//t    "member_initializer_list : member_initializer_list COMMA member_initializer",
//t    "member_initializer_list : member_initializer_list error",
//t    "member_initializer : IDENTIFIER ASSIGN initializer_value",
//t    "member_initializer : GENERATE_COMPLETION",
//t    "member_initializer : non_assignment_expression opt_COMPLETE_COMPLETION",
//t    "member_initializer : OPEN_BRACE expression_list CLOSE_BRACE",
//t    "member_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "initializer_value : expression",
//t    "initializer_value : object_or_collection_initializer",
//t    "opt_argument_list :",
//t    "opt_argument_list : argument_list",
//t    "argument_list : argument_or_named_argument",
//t    "argument_list : argument_list COMMA argument",
//t    "argument_list : argument_list COMMA named_argument",
//t    "argument_list : argument_list COMMA",
//t    "argument_list : COMMA error",
//t    "argument : expression",
//t    "argument : non_simple_argument",
//t    "argument_or_named_argument : argument",
//t    "argument_or_named_argument : named_argument",
//t    "non_simple_argument : REF variable_reference",
//t    "non_simple_argument : OUT variable_reference",
//t    "non_simple_argument : ARGLIST OPEN_PARENS argument_list CLOSE_PARENS",
//t    "non_simple_argument : ARGLIST OPEN_PARENS CLOSE_PARENS",
//t    "variable_reference : expression",
//t    "element_access : primary_expression OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "expression_list : expression",
//t    "expression_list : expression_list COMMA expression",
//t    "expression_list : expression_list error",
//t    "expression_list_arguments : expression_list_argument",
//t    "expression_list_arguments : expression_list_arguments COMMA expression_list_argument",
//t    "expression_list_argument : expression",
//t    "expression_list_argument : named_argument",
//t    "this_access : THIS",
//t    "base_access : BASE OPEN_BRACKET_EXPR expression_list_arguments CLOSE_BRACKET",
//t    "base_access : BASE OPEN_BRACKET error",
//t    "post_increment_expression : primary_expression OP_INC",
//t    "post_decrement_expression : primary_expression OP_DEC",
//t    "object_or_delegate_creation_expression : NEW new_expr_type open_parens_any opt_argument_list CLOSE_PARENS opt_object_or_collection_initializer",
//t    "object_or_delegate_creation_expression : NEW new_expr_type object_or_collection_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET_EXPR expression_list CLOSE_BRACKET opt_rank_specifier opt_array_initializer",
//t    "array_creation_expression : NEW new_expr_type rank_specifiers opt_array_initializer",
//t    "array_creation_expression : NEW rank_specifier array_initializer",
//t    "array_creation_expression : NEW new_expr_type OPEN_BRACKET CLOSE_BRACKET OPEN_BRACKET_EXPR error CLOSE_BRACKET",
//t    "array_creation_expression : NEW new_expr_type error",
//t    "$$63 :",
//t    "new_expr_type : $$63 simple_type",
//t    "anonymous_type_expression : NEW OPEN_BRACE anonymous_type_parameters_opt_comma CLOSE_BRACE",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters_opt",
//t    "anonymous_type_parameters_opt_comma : anonymous_type_parameters COMMA",
//t    "anonymous_type_parameters_opt :",
//t    "anonymous_type_parameters_opt : anonymous_type_parameters",
//t    "anonymous_type_parameters : anonymous_type_parameter",
//t    "anonymous_type_parameters : anonymous_type_parameters COMMA anonymous_type_parameter",
//t    "anonymous_type_parameter : IDENTIFIER ASSIGN variable_initializer",
//t    "anonymous_type_parameter : IDENTIFIER",
//t    "anonymous_type_parameter : member_access",
//t    "anonymous_type_parameter : error",
//t    "opt_rank_specifier :",
//t    "opt_rank_specifier : rank_specifiers",
//t    "rank_specifiers : rank_specifier",
//t    "rank_specifiers : rank_specifier rank_specifiers",
//t    "rank_specifier : OPEN_BRACKET CLOSE_BRACKET",
//t    "rank_specifier : OPEN_BRACKET dim_separators CLOSE_BRACKET",
//t    "dim_separators : COMMA",
//t    "dim_separators : dim_separators COMMA",
//t    "opt_array_initializer :",
//t    "opt_array_initializer : array_initializer",
//t    "array_initializer : OPEN_BRACE CLOSE_BRACE",
//t    "array_initializer : OPEN_BRACE variable_initializer_list opt_comma CLOSE_BRACE",
//t    "variable_initializer_list : variable_initializer",
//t    "variable_initializer_list : variable_initializer_list COMMA variable_initializer",
//t    "$$64 :",
//t    "typeof_expression : TYPEOF $$64 open_parens_any typeof_type_expression CLOSE_PARENS",
//t    "typeof_type_expression : type_and_void",
//t    "typeof_type_expression : unbound_type_name",
//t    "typeof_type_expression : error",
//t    "unbound_type_name : IDENTIFIER generic_dimension",
//t    "unbound_type_name : qualified_alias_member IDENTIFIER generic_dimension",
//t    "unbound_type_name : unbound_type_name DOT IDENTIFIER",
//t    "unbound_type_name : unbound_type_name DOT IDENTIFIER generic_dimension",
//t    "unbound_type_name : namespace_or_type_name DOT IDENTIFIER generic_dimension",
//t    "generic_dimension : GENERIC_DIMENSION",
//t    "qualified_alias_member : IDENTIFIER DOUBLE_COLON",
//t    "sizeof_expression : SIZEOF open_parens_any type CLOSE_PARENS",
//t    "checked_expression : CHECKED open_parens_any expression CLOSE_PARENS",
//t    "unchecked_expression : UNCHECKED open_parens_any expression CLOSE_PARENS",
//t    "pointer_member_access : primary_expression OP_PTR IDENTIFIER opt_type_argument_list",
//t    "$$65 :",
//t    "anonymous_method_expression : DELEGATE opt_anonymous_method_signature $$65 block",
//t    "opt_anonymous_method_signature :",
//t    "opt_anonymous_method_signature : anonymous_method_signature",
//t    "$$66 :",
//t    "anonymous_method_signature : OPEN_PARENS $$66 opt_formal_parameter_list CLOSE_PARENS",
//t    "default_value_expression : DEFAULT open_parens_any type CLOSE_PARENS",
//t    "unary_expression : primary_expression",
//t    "unary_expression : BANG prefixed_unary_expression",
//t    "unary_expression : TILDE prefixed_unary_expression",
//t    "unary_expression : cast_expression",
//t    "cast_expression : OPEN_PARENS_CAST type CLOSE_PARENS prefixed_unary_expression",
//t    "prefixed_unary_expression : unary_expression",
//t    "prefixed_unary_expression : PLUS prefixed_unary_expression",
//t    "prefixed_unary_expression : MINUS prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_INC prefixed_unary_expression",
//t    "prefixed_unary_expression : OP_DEC prefixed_unary_expression",
//t    "prefixed_unary_expression : STAR prefixed_unary_expression",
//t    "prefixed_unary_expression : BITWISE_AND prefixed_unary_expression",
//t    "multiplicative_expression : prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression STAR prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression DIV prefixed_unary_expression",
//t    "multiplicative_expression : multiplicative_expression PERCENT prefixed_unary_expression",
//t    "additive_expression : multiplicative_expression",
//t    "additive_expression : additive_expression PLUS multiplicative_expression",
//t    "additive_expression : additive_expression MINUS multiplicative_expression",
//t    "additive_expression : parenthesized_expression MINUS multiplicative_expression",
//t    "additive_expression : additive_expression AS type",
//t    "additive_expression : additive_expression IS type",
//t    "shift_expression : additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_LEFT additive_expression",
//t    "shift_expression : shift_expression OP_SHIFT_RIGHT additive_expression",
//t    "relational_expression : shift_expression",
//t    "relational_expression : relational_expression OP_LT shift_expression",
//t    "relational_expression : relational_expression OP_GT shift_expression",
//t    "relational_expression : relational_expression OP_LE shift_expression",
//t    "relational_expression : relational_expression OP_GE shift_expression",
//t    "equality_expression : relational_expression",
//t    "equality_expression : equality_expression OP_EQ relational_expression",
//t    "equality_expression : equality_expression OP_NE relational_expression",
//t    "and_expression : equality_expression",
//t    "and_expression : and_expression BITWISE_AND equality_expression",
//t    "exclusive_or_expression : and_expression",
//t    "exclusive_or_expression : exclusive_or_expression CARRET and_expression",
//t    "inclusive_or_expression : exclusive_or_expression",
//t    "inclusive_or_expression : inclusive_or_expression BITWISE_OR exclusive_or_expression",
//t    "conditional_and_expression : inclusive_or_expression",
//t    "conditional_and_expression : conditional_and_expression OP_AND inclusive_or_expression",
//t    "conditional_or_expression : conditional_and_expression",
//t    "conditional_or_expression : conditional_or_expression OP_OR conditional_and_expression",
//t    "null_coalescing_expression : conditional_or_expression",
//t    "null_coalescing_expression : conditional_or_expression OP_COALESCING null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression",
//t    "conditional_expression : null_coalescing_expression INTERR expression COLON expression",
//t    "assignment_expression : prefixed_unary_expression ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MULT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_DIV_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_MOD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_ADD_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SUB_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_LEFT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_SHIFT_RIGHT_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_AND_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_OR_ASSIGN expression",
//t    "assignment_expression : prefixed_unary_expression OP_XOR_ASSIGN expression",
//t    "lambda_parameter_list : lambda_parameter",
//t    "lambda_parameter_list : lambda_parameter_list COMMA lambda_parameter",
//t    "lambda_parameter : parameter_modifier parameter_type IDENTIFIER",
//t    "lambda_parameter : parameter_type IDENTIFIER",
//t    "lambda_parameter : IDENTIFIER",
//t    "opt_lambda_parameter_list :",
//t    "opt_lambda_parameter_list : lambda_parameter_list",
//t    "lambda_expression_body : lambda_expression_body_simple",
//t    "lambda_expression_body : block",
//t    "$$67 :",
//t    "lambda_expression_body_simple : $$67 expression_or_error",
//t    "expression_or_error : expression",
//t    "expression_or_error : error",
//t    "$$68 :",
//t    "lambda_expression : IDENTIFIER ARROW $$68 lambda_expression_body",
//t    "$$69 :",
//t    "$$70 :",
//t    "lambda_expression : OPEN_PARENS_LAMBDA $$69 opt_lambda_parameter_list CLOSE_PARENS ARROW $$70 lambda_expression_body",
//t    "expression : assignment_expression",
//t    "expression : non_assignment_expression",
//t    "non_assignment_expression : conditional_expression",
//t    "non_assignment_expression : lambda_expression",
//t    "non_assignment_expression : query_expression",
//t    "non_assignment_expression : ARGLIST",
//t    "undocumented_expressions : REFVALUE OPEN_PARENS non_assignment_expression COMMA type CLOSE_PARENS",
//t    "undocumented_expressions : REFTYPE open_parens_any expression CLOSE_PARENS",
//t    "undocumented_expressions : MAKEREF open_parens_any expression CLOSE_PARENS",
//t    "constant_expression : expression",
//t    "boolean_expression : expression",
//t    "$$71 :",
//t    "$$72 :",
//t    "$$73 :",
//t    "$$74 :",
//t    "class_declaration : opt_attributes opt_modifiers opt_partial CLASS $$71 type_declaration_name $$72 opt_class_base opt_type_parameter_constraints_clauses $$73 OPEN_BRACE opt_class_member_declarations CLOSE_BRACE $$74 opt_semicolon",
//t    "opt_partial :",
//t    "opt_partial : PARTIAL",
//t    "opt_modifiers :",
//t    "opt_modifiers : modifiers",
//t    "modifiers : modifier",
//t    "modifiers : modifiers modifier",
//t    "modifier : NEW",
//t    "modifier : PUBLIC",
//t    "modifier : PROTECTED",
//t    "modifier : INTERNAL",
//t    "modifier : PRIVATE",
//t    "modifier : ABSTRACT",
//t    "modifier : SEALED",
//t    "modifier : STATIC",
//t    "modifier : READONLY",
//t    "modifier : VIRTUAL",
//t    "modifier : OVERRIDE",
//t    "modifier : EXTERN",
//t    "modifier : VOLATILE",
//t    "modifier : UNSAFE",
//t    "modifier : ASYNC",
//t    "opt_class_base :",
//t    "opt_class_base : COLON type_list",
//t    "opt_type_parameter_constraints_clauses :",
//t    "opt_type_parameter_constraints_clauses : type_parameter_constraints_clauses",
//t    "opt_type_parameter_constraints_clauses : error",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clause",
//t    "type_parameter_constraints_clauses : type_parameter_constraints_clauses type_parameter_constraints_clause",
//t    "type_parameter_constraints_clause : WHERE IDENTIFIER COLON type_parameter_constraints",
//t    "type_parameter_constraints : type_parameter_constraint",
//t    "type_parameter_constraints : type_parameter_constraints COMMA type_parameter_constraint",
//t    "type_parameter_constraint : type",
//t    "type_parameter_constraint : NEW OPEN_PARENS CLOSE_PARENS",
//t    "type_parameter_constraint : CLASS",
//t    "type_parameter_constraint : STRUCT",
//t    "opt_type_parameter_variance :",
//t    "opt_type_parameter_variance : type_parameter_variance",
//t    "type_parameter_variance : OUT",
//t    "type_parameter_variance : IN",
//t    "$$75 :",
//t    "block : OPEN_BRACE $$75 opt_statement_list block_end",
//t    "block_end : CLOSE_BRACE",
//t    "block_end : COMPLETE_COMPLETION",
//t    "$$76 :",
//t    "block_prepared : OPEN_BRACE $$76 opt_statement_list CLOSE_BRACE",
//t    "opt_statement_list :",
//t    "opt_statement_list : statement_list",
//t    "statement_list : statement",
//t    "statement_list : statement_list statement",
//t    "statement : block_variable_declaration",
//t    "statement : valid_declaration_statement",
//t    "statement : labeled_statement",
//t    "statement : error",
//t    "interactive_statement_list : interactive_statement",
//t    "interactive_statement_list : interactive_statement_list interactive_statement",
//t    "interactive_statement : block_variable_declaration",
//t    "interactive_statement : interactive_valid_declaration_statement",
//t    "interactive_statement : labeled_statement",
//t    "valid_declaration_statement : block",
//t    "valid_declaration_statement : empty_statement",
//t    "valid_declaration_statement : expression_statement",
//t    "valid_declaration_statement : selection_statement",
//t    "valid_declaration_statement : iteration_statement",
//t    "valid_declaration_statement : jump_statement",
//t    "valid_declaration_statement : try_statement",
//t    "valid_declaration_statement : checked_statement",
//t    "valid_declaration_statement : unchecked_statement",
//t    "valid_declaration_statement : lock_statement",
//t    "valid_declaration_statement : using_statement",
//t    "valid_declaration_statement : unsafe_statement",
//t    "valid_declaration_statement : fixed_statement",
//t    "interactive_valid_declaration_statement : block",
//t    "interactive_valid_declaration_statement : empty_statement",
//t    "interactive_valid_declaration_statement : interactive_expression_statement",
//t    "interactive_valid_declaration_statement : selection_statement",
//t    "interactive_valid_declaration_statement : iteration_statement",
//t    "interactive_valid_declaration_statement : jump_statement",
//t    "interactive_valid_declaration_statement : try_statement",
//t    "interactive_valid_declaration_statement : checked_statement",
//t    "interactive_valid_declaration_statement : unchecked_statement",
//t    "interactive_valid_declaration_statement : lock_statement",
//t    "interactive_valid_declaration_statement : using_statement",
//t    "interactive_valid_declaration_statement : unsafe_statement",
//t    "interactive_valid_declaration_statement : fixed_statement",
//t    "embedded_statement : valid_declaration_statement",
//t    "embedded_statement : block_variable_declaration",
//t    "embedded_statement : labeled_statement",
//t    "embedded_statement : error",
//t    "empty_statement : SEMICOLON",
//t    "$$77 :",
//t    "labeled_statement : IDENTIFIER COLON $$77 statement",
//t    "variable_type : variable_type_simple",
//t    "variable_type : variable_type_simple rank_specifiers",
//t    "variable_type_simple : primary_expression_or_type opt_nullable",
//t    "variable_type_simple : primary_expression_or_type pointer_stars",
//t    "variable_type_simple : builtin_types opt_nullable",
//t    "variable_type_simple : builtin_types pointer_stars",
//t    "variable_type_simple : VOID pointer_stars",
//t    "variable_type_simple : VOID",
//t    "pointer_stars : pointer_star",
//t    "pointer_stars : pointer_star pointer_stars",
//t    "pointer_star : STAR",
//t    "$$78 :",
//t    "block_variable_declaration : variable_type IDENTIFIER $$78 opt_local_variable_initializer opt_variable_declarators SEMICOLON",
//t    "$$79 :",
//t    "block_variable_declaration : CONST variable_type IDENTIFIER $$79 const_variable_initializer opt_const_declarators SEMICOLON",
//t    "opt_local_variable_initializer :",
//t    "opt_local_variable_initializer : ASSIGN block_variable_initializer",
//t    "opt_local_variable_initializer : error",
//t    "opt_variable_declarators :",
//t    "opt_variable_declarators : variable_declarators",
//t    "variable_declarators : variable_declarator",
//t    "variable_declarators : variable_declarators variable_declarator",
//t    "variable_declarator : COMMA IDENTIFIER",
//t    "variable_declarator : COMMA IDENTIFIER ASSIGN block_variable_initializer",
//t    "const_variable_initializer :",
//t    "const_variable_initializer : ASSIGN constant_initializer_expr",
//t    "opt_const_declarators :",
//t    "opt_const_declarators : const_declarators",
//t    "const_declarators : const_declarator",
//t    "const_declarators : const_declarators const_declarator",
//t    "const_declarator : COMMA IDENTIFIER ASSIGN constant_initializer_expr",
//t    "block_variable_initializer : variable_initializer",
//t    "block_variable_initializer : STACKALLOC simple_type OPEN_BRACKET_EXPR expression CLOSE_BRACKET",
//t    "block_variable_initializer : STACKALLOC simple_type",
//t    "expression_statement : statement_expression SEMICOLON",
//t    "expression_statement : statement_expression COMPLETE_COMPLETION",
//t    "interactive_expression_statement : interactive_statement_expression SEMICOLON",
//t    "interactive_expression_statement : interactive_statement_expression COMPLETE_COMPLETION",
//t    "statement_expression : expression",
//t    "interactive_statement_expression : expression",
//t    "interactive_statement_expression : error",
//t    "selection_statement : if_statement",
//t    "selection_statement : switch_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "if_statement : IF open_parens_any boolean_expression CLOSE_PARENS embedded_statement ELSE embedded_statement",
//t    "$$80 :",
//t    "switch_statement : SWITCH open_parens_any expression CLOSE_PARENS OPEN_BRACE $$80 opt_switch_sections CLOSE_BRACE",
//t    "opt_switch_sections :",
//t    "opt_switch_sections : switch_sections",
//t    "switch_sections : switch_section",
//t    "switch_sections : switch_sections switch_section",
//t    "switch_sections : error",
//t    "$$81 :",
//t    "switch_section : switch_labels $$81 statement_list",
//t    "switch_labels : switch_label",
//t    "switch_labels : switch_labels switch_label",
//t    "switch_label : CASE constant_expression COLON",
//t    "switch_label : DEFAULT_COLON",
//t    "iteration_statement : while_statement",
//t    "iteration_statement : do_statement",
//t    "iteration_statement : for_statement",
//t    "iteration_statement : foreach_statement",
//t    "while_statement : WHILE open_parens_any boolean_expression CLOSE_PARENS embedded_statement",
//t    "do_statement : DO embedded_statement WHILE open_parens_any boolean_expression CLOSE_PARENS SEMICOLON",
//t    "$$82 :",
//t    "for_statement : FOR open_parens_any $$82 for_statement_cont",
//t    "for_statement_cont : opt_for_initializer SEMICOLON opt_for_condition SEMICOLON opt_for_iterator CLOSE_PARENS embedded_statement",
//t    "for_statement_cont : error",
//t    "opt_for_initializer :",
//t    "opt_for_initializer : for_initializer",
//t    "$$83 :",
//t    "for_initializer : variable_type IDENTIFIER $$83 opt_local_variable_initializer opt_variable_declarators",
//t    "for_initializer : statement_expression_list",
//t    "opt_for_condition :",
//t    "opt_for_condition : boolean_expression",
//t    "opt_for_iterator :",
//t    "opt_for_iterator : for_iterator",
//t    "for_iterator : statement_expression_list",
//t    "statement_expression_list : statement_expression",
//t    "statement_expression_list : statement_expression_list COMMA statement_expression",
//t    "foreach_statement : FOREACH open_parens_any type IN expression CLOSE_PARENS",
//t    "$$84 :",
//t    "foreach_statement : FOREACH open_parens_any type IDENTIFIER IN expression CLOSE_PARENS $$84 embedded_statement",
//t    "jump_statement : break_statement",
//t    "jump_statement : continue_statement",
//t    "jump_statement : goto_statement",
//t    "jump_statement : return_statement",
//t    "jump_statement : throw_statement",
//t    "jump_statement : yield_statement",
//t    "break_statement : BREAK SEMICOLON",
//t    "continue_statement : CONTINUE SEMICOLON",
//t    "goto_statement : GOTO IDENTIFIER SEMICOLON",
//t    "goto_statement : GOTO CASE constant_expression SEMICOLON",
//t    "goto_statement : GOTO DEFAULT SEMICOLON",
//t    "return_statement : RETURN opt_expression SEMICOLON",
//t    "throw_statement : THROW opt_expression SEMICOLON",
//t    "yield_statement : IDENTIFIER RETURN opt_expression SEMICOLON",
//t    "yield_statement : IDENTIFIER BREAK SEMICOLON",
//t    "opt_expression :",
//t    "opt_expression : expression",
//t    "try_statement : TRY block catch_clauses",
//t    "try_statement : TRY block FINALLY block",
//t    "try_statement : TRY block catch_clauses FINALLY block",
//t    "try_statement : TRY block error",
//t    "catch_clauses : catch_clause",
//t    "catch_clauses : catch_clauses catch_clause",
//t    "opt_identifier :",
//t    "opt_identifier : IDENTIFIER",
//t    "catch_clause : CATCH block",
//t    "$$85 :",
//t    "catch_clause : CATCH open_parens_any type opt_identifier CLOSE_PARENS $$85 block_prepared",
//t    "catch_clause : CATCH open_parens_any error",
//t    "checked_statement : CHECKED block",
//t    "unchecked_statement : UNCHECKED block",
//t    "$$86 :",
//t    "unsafe_statement : UNSAFE $$86 block",
//t    "lock_statement : LOCK open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "$$87 :",
//t    "$$88 :",
//t    "fixed_statement : FIXED open_parens_any variable_type IDENTIFIER $$87 using_or_fixed_variable_initializer opt_variable_declarators CLOSE_PARENS $$88 embedded_statement",
//t    "$$89 :",
//t    "$$90 :",
//t    "using_statement : USING open_parens_any variable_type IDENTIFIER $$89 using_or_fixed_variable_initializer opt_variable_declarators CLOSE_PARENS $$90 embedded_statement",
//t    "using_statement : USING open_parens_any expression CLOSE_PARENS embedded_statement",
//t    "using_or_fixed_variable_initializer :",
//t    "using_or_fixed_variable_initializer : ASSIGN variable_initializer",
//t    "query_expression : first_from_clause query_body",
//t    "query_expression : nested_from_clause query_body",
//t    "query_expression : first_from_clause COMPLETE_COMPLETION",
//t    "query_expression : nested_from_clause COMPLETE_COMPLETION",
//t    "first_from_clause : FROM_FIRST IDENTIFIER IN expression",
//t    "first_from_clause : FROM_FIRST type IDENTIFIER IN expression",
//t    "nested_from_clause : FROM IDENTIFIER IN expression",
//t    "nested_from_clause : FROM type IDENTIFIER IN expression",
//t    "$$91 :",
//t    "from_clause : FROM IDENTIFIER IN $$91 expression",
//t    "$$92 :",
//t    "from_clause : FROM type IDENTIFIER IN $$92 expression",
//t    "query_body : opt_query_body_clauses select_or_group_clause opt_query_continuation",
//t    "query_body : opt_query_body_clauses COMPLETE_COMPLETION",
//t    "query_body : error",
//t    "$$93 :",
//t    "select_or_group_clause : SELECT $$93 expression",
//t    "$$94 :",
//t    "$$95 :",
//t    "select_or_group_clause : GROUP $$94 expression $$95 BY expression",
//t    "opt_query_body_clauses :",
//t    "opt_query_body_clauses : query_body_clauses",
//t    "query_body_clauses : query_body_clause",
//t    "query_body_clauses : query_body_clauses query_body_clause",
//t    "query_body_clause : from_clause",
//t    "query_body_clause : let_clause",
//t    "query_body_clause : where_clause",
//t    "query_body_clause : join_clause",
//t    "query_body_clause : orderby_clause",
//t    "$$96 :",
//t    "let_clause : LET IDENTIFIER ASSIGN $$96 expression",
//t    "$$97 :",
//t    "where_clause : WHERE $$97 expression",
//t    "$$98 :",
//t    "$$99 :",
//t    "$$100 :",
//t    "join_clause : JOIN IDENTIFIER IN $$98 expression ON $$99 expression EQUALS $$100 expression opt_join_into",
//t    "$$101 :",
//t    "$$102 :",
//t    "$$103 :",
//t    "join_clause : JOIN type IDENTIFIER IN $$101 expression ON $$102 expression EQUALS $$103 expression opt_join_into",
//t    "opt_join_into :",
//t    "opt_join_into : INTO IDENTIFIER",
//t    "$$104 :",
//t    "orderby_clause : ORDERBY $$104 orderings",
//t    "orderings : order_by",
//t    "$$105 :",
//t    "orderings : order_by COMMA $$105 orderings_then_by",
//t    "orderings_then_by : then_by",
//t    "$$106 :",
//t    "orderings_then_by : orderings_then_by COMMA $$106 then_by",
//t    "order_by : expression",
//t    "order_by : expression ASCENDING",
//t    "order_by : expression DESCENDING",
//t    "then_by : expression",
//t    "then_by : expression ASCENDING",
//t    "then_by : expression DESCENDING",
//t    "opt_query_continuation :",
//t    "$$107 :",
//t    "opt_query_continuation : INTO IDENTIFIER $$107 query_body",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER EOF",
//t    "interactive_parsing : EVAL_USING_DECLARATIONS_UNIT_PARSER using_directives opt_COMPLETE_COMPLETION",
//t    "$$108 :",
//t    "interactive_parsing : EVAL_STATEMENT_PARSER $$108 interactive_statement_list opt_COMPLETE_COMPLETION",
//t    "interactive_parsing : EVAL_COMPILATION_UNIT_PARSER interactive_compilation_unit",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives",
//t    "interactive_compilation_unit : opt_extern_alias_directives opt_using_directives namespace_or_type_declarations",
//t    "opt_COMPLETE_COMPLETION :",
//t    "opt_COMPLETE_COMPLETION : COMPLETE_COMPLETION",
//t    "close_brace_or_complete_completion : CLOSE_BRACE",
//t    "close_brace_or_complete_completion : COMPLETE_COMPLETION",
//t    "documentation_parsing : DOC_SEE doc_cref",
//t    "doc_cref : doc_type_declaration_name opt_doc_method_sig",
//t    "doc_cref : builtin_types opt_doc_method_sig",
//t    "doc_cref : builtin_types DOT IDENTIFIER opt_doc_method_sig",
//t    "doc_cref : doc_type_declaration_name DOT THIS",
//t    "$$109 :",
//t    "doc_cref : doc_type_declaration_name DOT THIS OPEN_BRACKET $$109 opt_doc_parameters CLOSE_BRACKET",
//t    "doc_cref : EXPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : IMPLICIT OPERATOR type opt_doc_method_sig",
//t    "doc_cref : OPERATOR overloadable_operator opt_doc_method_sig",
//t    "doc_type_declaration_name : type_declaration_name",
//t    "doc_type_declaration_name : doc_type_declaration_name DOT type_declaration_name",
//t    "opt_doc_method_sig :",
//t    "$$110 :",
//t    "opt_doc_method_sig : OPEN_PARENS $$110 opt_doc_parameters CLOSE_PARENS",
//t    "opt_doc_parameters :",
//t    "opt_doc_parameters : doc_parameters",
//t    "doc_parameters : doc_parameter",
//t    "doc_parameters : doc_parameters COMMA doc_parameter",
//t    "doc_parameter : opt_parameter_modifier parameter_type",
//t  };
//t public static string getRule (int index) {
//t    return yyRule [index];
//t }
//t}
  protected static readonly string [] yyNames = {    
    "end-of-file",null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,null,null,null,null,null,null,null,
    null,null,null,null,null,null,null,"EOF","NONE","ERROR",
    "FIRST_KEYWORD","ABSTRACT","AS","ADD","BASE","BOOL","BREAK","BYTE",
    "CASE","CATCH","CHAR","CHECKED","CLASS","CONST","CONTINUE","DECIMAL",
    "DEFAULT","DELEGATE","DO","DOUBLE","ELSE","ENUM","EVENT","EXPLICIT",
    "EXTERN","FALSE","FINALLY","FIXED","FLOAT","FOR","FOREACH","GOTO",
    "IF","IMPLICIT","IN","INT","INTERFACE","INTERNAL","IS","LOCK","LONG",
    "NAMESPACE","NEW","NULL","OBJECT","OPERATOR","OUT","OVERRIDE",
    "PARAMS","PRIVATE","PROTECTED","PUBLIC","READONLY","REF","RETURN",
    "REMOVE","SBYTE","SEALED","SHORT","SIZEOF","STACKALLOC","STATIC",
    "STRING","STRUCT","SWITCH","THIS","THROW","TRUE","TRY","TYPEOF",
    "UINT","ULONG","UNCHECKED","UNSAFE","USHORT","USING","VIRTUAL","VOID",
    "VOLATILE","WHERE","WHILE","ARGLIST","PARTIAL","ARROW","FROM",
    "FROM_FIRST","JOIN","ON","EQUALS","SELECT","GROUP","BY","LET",
    "ORDERBY","ASCENDING","DESCENDING","INTO","INTERR_NULLABLE",
    "EXTERN_ALIAS","ASYNC","REFVALUE","REFTYPE","MAKEREF","GET","SET",
    "LAST_KEYWORD","OPEN_BRACE","CLOSE_BRACE","OPEN_BRACKET",
    "CLOSE_BRACKET","OPEN_PARENS","CLOSE_PARENS","DOT","COMMA","COLON",
    "SEMICOLON","TILDE","PLUS","MINUS","BANG","ASSIGN","OP_LT","OP_GT",
    "BITWISE_AND","BITWISE_OR","STAR","PERCENT","DIV","CARRET","INTERR",
    "DOUBLE_COLON","OP_INC","OP_DEC","OP_SHIFT_LEFT","OP_SHIFT_RIGHT",
    "OP_LE","OP_GE","OP_EQ","OP_NE","OP_AND","OP_OR","OP_MULT_ASSIGN",
    "OP_DIV_ASSIGN","OP_MOD_ASSIGN","OP_ADD_ASSIGN","OP_SUB_ASSIGN",
    "OP_SHIFT_LEFT_ASSIGN","OP_SHIFT_RIGHT_ASSIGN","OP_AND_ASSIGN",
    "OP_XOR_ASSIGN","OP_OR_ASSIGN","OP_PTR","OP_COALESCING",
    "OP_GENERICS_LT","OP_GENERICS_LT_DECL","OP_GENERICS_GT","LITERAL",
    "IDENTIFIER","OPEN_PARENS_LAMBDA","OPEN_PARENS_CAST",
    "GENERIC_DIMENSION","DEFAULT_COLON","OPEN_BRACKET_EXPR",
    "EVAL_STATEMENT_PARSER","EVAL_COMPILATION_UNIT_PARSER",
    "EVAL_USING_DECLARATIONS_UNIT_PARSER","DOC_SEE","GENERATE_COMPLETION",
    "COMPLETE_COMPLETION","UMINUS",
  };

  /** index-checked interface to yyNames[].
      @param token single character or %token value.
      @return token name or [illegal] or [unknown].
    */
//t  public static string yyname (int token) {
//t    if ((token < 0) || (token > yyNames.Length)) return "[illegal]";
//t    string name;
//t    if ((name = yyNames[token]) != null) return name;
//t    return "[unknown]";
//t  }

  int yyExpectingState;
  /** computes list of expected tokens on error by tracing the tables.
      @param state for which to compute the list.
      @return list of token names.
    */
  protected int [] yyExpectingTokens (int state){
    int token, n, len = 0;
    bool[] ok = new bool[yyNames.Length];
    if ((n = yySindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    if ((n = yyRindex[state]) != 0)
      for (token = n < 0 ? -n : 0;
           (token < yyNames.Length) && (n+token < yyTable.Length); ++ token)
        if (yyCheck[n+token] == token && !ok[token] && yyNames[token] != null) {
          ++ len;
          ok[token] = true;
        }
    int [] result = new int [len];
    for (n = token = 0; n < len;  ++ token)
      if (ok[token]) result[n++] = token;
    return result;
  }
  protected string[] yyExpecting (int state) {
    int [] tokens = yyExpectingTokens (state);
    string [] result = new string[tokens.Length];
    for (int n = 0; n < tokens.Length;  n++)
      result[n++] = yyNames[tokens [n]];
    return result;
  }

  /** the generated parser, with debugging messages.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @param yydebug debug message writer implementing yyDebug, or null.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex, Object yyd)
				 {
//t    this.debug = (yydebug.yyDebug)yyd;
    return yyparse(yyLex);
  }

  /** initial size and increment of the state/value stack [default 256].
      This is not final so that it can be overwritten outside of invocations
      of yyparse().
    */
  protected int yyMax;

  /** executed at the beginning of a reduce action.
      Used as $$ = yyDefault($1), prior to the user-specified action, if any.
      Can be overwritten to provide deep copy, etc.
      @param first value for $1, or null.
      @return first.
    */
  protected Object yyDefault (Object first) {
    return first;
  }

	static int[] global_yyStates;
	static object[] global_yyVals;
	protected bool use_global_stacks;
	object[] yyVals;					// value stack
	object yyVal;						// value stack ptr
	int yyToken;						// current input
	int yyTop;

  /** the generated parser.
      Maintains a state and a value stack, currently with fixed maximum size.
      @param yyLex scanner.
      @return result of the last reduction, if any.
      @throws yyException on irrecoverable parse error.
    */
  internal Object yyparse (yyParser.yyInput yyLex)
  {
    if (yyMax <= 0) yyMax = 256;		// initial size
    int yyState = 0;                   // state stack ptr
    int [] yyStates;               	// state stack 
    yyVal = null;
    yyToken = -1;
    int yyErrorFlag = 0;				// #tks to shift
	if (use_global_stacks && global_yyStates != null) {
		yyVals = global_yyVals;
		yyStates = global_yyStates;
   } else {
		yyVals = new object [yyMax];
		yyStates = new int [yyMax];
		if (use_global_stacks) {
			global_yyVals = yyVals;
			global_yyStates = yyStates;
		}
	}

    /*yyLoop:*/ for (yyTop = 0;; ++ yyTop) {
      if (yyTop >= yyStates.Length) {			// dynamically increase
        global::System.Array.Resize (ref yyStates, yyStates.Length+yyMax);
        global::System.Array.Resize (ref yyVals, yyVals.Length+yyMax);
      }
      yyStates[yyTop] = yyState;
      yyVals[yyTop] = yyVal;
//t      if (debug != null) debug.push(yyState, yyVal);

      /*yyDiscarded:*/ while (true) {	// discarding a token does not change stack
        int yyN;
        if ((yyN = yyDefRed[yyState]) == 0) {	// else [default] reduce (yyN)
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t              debug.lex(yyState, yyToken, yyname(yyToken), yyLex.value());
          }
          if ((yyN = yySindex[yyState]) != 0 && ((yyN += yyToken) >= 0)
              && (yyN < yyTable.Length) && (yyCheck[yyN] == yyToken)) {
//t            if (debug != null)
//t              debug.shift(yyState, yyTable[yyN], yyErrorFlag-1);
            yyState = yyTable[yyN];		// shift to yyN
            yyVal = yyLex.value();
            yyToken = -1;
            if (yyErrorFlag > 0) -- yyErrorFlag;
            goto continue_yyLoop;
          }
          if ((yyN = yyRindex[yyState]) != 0 && (yyN += yyToken) >= 0
              && yyN < yyTable.Length && yyCheck[yyN] == yyToken)
            yyN = yyTable[yyN];			// reduce (yyN)
          else
            switch (yyErrorFlag) {
  
            case 0:
              yyExpectingState = yyState;
              // yyerror(String.Format ("syntax error, got token `{0}'", yyname (yyToken)), yyExpecting(yyState));
//t              if (debug != null) debug.error("syntax error");
              if (yyToken == 0 /*eof*/ || yyToken == eof_token) throw new yyParser.yyUnexpectedEof ();
              goto case 1;
            case 1: case 2:
              yyErrorFlag = 3;
              do {
                if ((yyN = yySindex[yyStates[yyTop]]) != 0
                    && (yyN += Token.yyErrorCode) >= 0 && yyN < yyTable.Length
                    && yyCheck[yyN] == Token.yyErrorCode) {
//t                  if (debug != null)
//t                    debug.shift(yyStates[yyTop], yyTable[yyN], 3);
                  yyState = yyTable[yyN];
                  yyVal = yyLex.value();
                  goto continue_yyLoop;
                }
//t                if (debug != null) debug.pop(yyStates[yyTop]);
              } while (-- yyTop >= 0);
//t              if (debug != null) debug.reject();
              throw new yyParser.yyException("irrecoverable syntax error");
  
            case 3:
              if (yyToken == 0) {
//t                if (debug != null) debug.reject();
                throw new yyParser.yyException("irrecoverable syntax error at end-of-file");
              }
//t              if (debug != null)
//t                debug.discard(yyState, yyToken, yyname(yyToken),
//t  							yyLex.value());
              yyToken = -1;
              goto continue_yyDiscarded;		// leave stack alone
            }
        }
        int yyV = yyTop + 1-yyLen[yyN];
//t        if (debug != null)
//t          debug.reduce(yyState, yyStates[yyV-1], yyN, YYRules.getRule (yyN), yyLen[yyN]);
        yyVal = yyV > yyTop ? null : yyVals[yyV]; // yyVal = yyDefault(yyV > yyTop ? null : yyVals[yyV]);
        switch (yyN) {
case 1:
#line 379 "cs-parser.jay"
  {
		Lexer.check_incorrect_doc_comment ();
	  }
  break;
case 2:
#line 380 "cs-parser.jay"
  { Lexer.CompleteOnEOF = false; }
  break;
case 6:
  case_6();
  break;
case 7:
#line 397 "cs-parser.jay"
  {
		module.AddAttributes ((Attributes) yyVals[0+yyTop], current_namespace);
	  }
  break;
case 8:
  case_8();
  break;
case 13:
  case_13();
  break;
case 14:
#line 435 "cs-parser.jay"
  {
	  	syntax_error (GetLocation (yyVals[-1+yyTop]), "`alias' expected");   /* TODO: better*/
	  }
  break;
case 17:
  case_17();
  break;
case 18:
  case_18();
  break;
case 19:
  case_19();
  break;
case 20:
  case_20();
  break;
case 21:
  case_21();
  break;
case 22:
  case_22();
  break;
case 23:
  case_23();
  break;
case 24:
  case_24();
  break;
case 25:
  case_25();
  break;
case 26:
  case_26();
  break;
case 27:
  case_27();
  break;
case 32:
  case_32();
  break;
case 41:
  case_41();
  break;
case 42:
#line 628 "cs-parser.jay"
  {
		current_namespace.DeclarationFound = true;
	  }
  break;
case 50:
  case_50();
  break;
case 51:
  case_51();
  break;
case 52:
  case_52();
  break;
case 53:
  case_53();
  break;
case 54:
  case_54();
  break;
case 55:
  case_55();
  break;
case 56:
  case_56();
  break;
case 57:
  case_57();
  break;
case 58:
#line 721 "cs-parser.jay"
  { yyVal = "event"; }
  break;
case 59:
#line 722 "cs-parser.jay"
  { yyVal = "return"; }
  break;
case 60:
  case_60();
  break;
case 61:
#line 739 "cs-parser.jay"
  {
		yyVal = new List<Attribute> (4) { (Attribute) yyVals[0+yyTop] };
	  }
  break;
case 62:
  case_62();
  break;
case 63:
#line 753 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 64:
  case_64();
  break;
case 66:
#line 774 "cs-parser.jay"
  { yyVal = null; }
  break;
case 67:
#line 778 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 68:
#line 783 "cs-parser.jay"
  { yyVal = null; }
  break;
case 69:
  case_69();
  break;
case 70:
  case_70();
  break;
case 71:
  case_71();
  break;
case 72:
  case_72();
  break;
case 73:
#line 827 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 75:
#line 835 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 76:
  case_76();
  break;
case 77:
  case_77();
  break;
case 78:
#line 860 "cs-parser.jay"
  { yyVal = null; }
  break;
case 79:
#line 864 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Ref;
	  }
  break;
case 80:
#line 868 "cs-parser.jay"
  { 
		yyVal = Argument.AType.Out;
	  }
  break;
case 95:
  case_95();
  break;
case 96:
#line 909 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 97:
  case_97();
  break;
case 98:
  case_98();
  break;
case 99:
  case_99();
  break;
case 100:
  case_100();
  break;
case 101:
#line 941 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);
	  }
  break;
case 102:
  case_102();
  break;
case 103:
#line 953 "cs-parser.jay"
  {
		lbag.AppendToMember (current_class, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 118:
  case_118();
  break;
case 119:
  case_119();
  break;
case 122:
#line 1022 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 123:
#line 1026 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 124:
  case_124();
  break;
case 125:
#line 1042 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 126:
  case_126();
  break;
case 127:
  case_127();
  break;
case 130:
  case_130();
  break;
case 131:
  case_131();
  break;
case 132:
  case_132();
  break;
case 133:
  case_133();
  break;
case 134:
#line 1121 "cs-parser.jay"
  {
		report.Error (1641, GetLocation (yyVals[-1+yyTop]), "A fixed size buffer field must have the array size specifier after the field name");
	  }
  break;
case 136:
  case_136();
  break;
case 137:
  case_137();
  break;
case 140:
#line 1151 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 141:
#line 1155 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 142:
  case_142();
  break;
case 143:
#line 1168 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 144:
  case_144();
  break;
case 147:
#line 1187 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 148:
#line 1191 "cs-parser.jay"
  {
		current_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 149:
  case_149();
  break;
case 150:
#line 1207 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 151:
  case_151();
  break;
case 152:
  case_152();
  break;
case 155:
  case_155();
  break;
case 156:
  case_156();
  break;
case 157:
  case_157();
  break;
case 158:
#line 1264 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 159:
#line 1268 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 160:
  case_160();
  break;
case 161:
#line 1309 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.All;
	  }
  break;
case 162:
#line 1313 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 163:
  case_163();
  break;
case 164:
  case_164();
  break;
case 166:
#line 1389 "cs-parser.jay"
  { yyVal = null; }
  break;
case 167:
#line 1393 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 169:
  case_169();
  break;
case 170:
  case_170();
  break;
case 171:
  case_171();
  break;
case 172:
  case_172();
  break;
case 173:
  case_173();
  break;
case 174:
  case_174();
  break;
case 175:
  case_175();
  break;
case 176:
#line 1452 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[0+yyTop] } );
	  }
  break;
case 177:
#line 1456 "cs-parser.jay"
  {
		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[0+yyTop])) }, true);
	  }
  break;
case 178:
  case_178();
  break;
case 179:
  case_179();
  break;
case 180:
  case_180();
  break;
case 181:
  case_181();
  break;
case 182:
  case_182();
  break;
case 183:
  case_183();
  break;
case 184:
#line 1531 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 185:
  case_185();
  break;
case 186:
#line 1572 "cs-parser.jay"
  { yyVal = Parameter.Modifier.NONE; }
  break;
case 188:
  case_188();
  break;
case 189:
  case_189();
  break;
case 190:
  case_190();
  break;
case 191:
  case_191();
  break;
case 192:
  case_192();
  break;
case 193:
  case_193();
  break;
case 194:
  case_194();
  break;
case 195:
  case_195();
  break;
case 196:
  case_196();
  break;
case 197:
  case_197();
  break;
case 198:
#line 1670 "cs-parser.jay"
  {
		Error_DuplicateParameterModifier (GetLocation (yyVals[-1+yyTop]), Parameter.Modifier.PARAMS);
	  }
  break;
case 199:
  case_199();
  break;
case 200:
  case_200();
  break;
case 201:
  case_201();
  break;
case 202:
  case_202();
  break;
case 203:
  case_203();
  break;
case 204:
#line 1724 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 205:
  case_205();
  break;
case 206:
#line 1754 "cs-parser.jay"
  {
		  lexer.PropertyParsing = false;
	  }
  break;
case 207:
  case_207();
  break;
case 212:
  case_212();
  break;
case 213:
  case_213();
  break;
case 214:
  case_214();
  break;
case 215:
  case_215();
  break;
case 216:
  case_216();
  break;
case 218:
  case_218();
  break;
case 219:
  case_219();
  break;
case 220:
#line 1896 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 221:
  case_221();
  break;
case 222:
  case_222();
  break;
case 223:
  case_223();
  break;
case 224:
  case_224();
  break;
case 225:
#line 1929 "cs-parser.jay"
  {
		Error_SyntaxError (yyToken);	  
	  }
  break;
case 230:
#line 1946 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 231:
#line 1950 "cs-parser.jay"
  {
		report.Error (525, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain fields or constants");
	  }
  break;
case 236:
#line 1958 "cs-parser.jay"
  {
	  	report.Error (567, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain operators");
	  }
  break;
case 237:
#line 1962 "cs-parser.jay"
  {
	  	report.Error (526, GetLocation (yyVals[0+yyTop]), "Interfaces cannot contain contructors");
	  }
  break;
case 238:
#line 1966 "cs-parser.jay"
  {
	  	report.Error (524, GetLocation (yyVals[0+yyTop]), "Interfaces cannot declare classes, structs, interfaces, delegates, or enumerations");
	  }
  break;
case 239:
#line 1972 "cs-parser.jay"
  {
	  }
  break;
case 240:
  case_240();
  break;
case 242:
#line 1999 "cs-parser.jay"
  { yyVal = null; }
  break;
case 244:
  case_244();
  break;
case 245:
#line 2015 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 246:
  case_246();
  break;
case 248:
#line 2061 "cs-parser.jay"
  { yyVal = Operator.OpType.LogicalNot; }
  break;
case 249:
#line 2062 "cs-parser.jay"
  { yyVal = Operator.OpType.OnesComplement; }
  break;
case 250:
#line 2063 "cs-parser.jay"
  { yyVal = Operator.OpType.Increment; }
  break;
case 251:
#line 2064 "cs-parser.jay"
  { yyVal = Operator.OpType.Decrement; }
  break;
case 252:
#line 2065 "cs-parser.jay"
  { yyVal = Operator.OpType.True; }
  break;
case 253:
#line 2066 "cs-parser.jay"
  { yyVal = Operator.OpType.False; }
  break;
case 254:
#line 2068 "cs-parser.jay"
  { yyVal = Operator.OpType.Addition; }
  break;
case 255:
#line 2069 "cs-parser.jay"
  { yyVal = Operator.OpType.Subtraction; }
  break;
case 256:
#line 2071 "cs-parser.jay"
  { yyVal = Operator.OpType.Multiply; }
  break;
case 257:
#line 2072 "cs-parser.jay"
  {  yyVal = Operator.OpType.Division; }
  break;
case 258:
#line 2073 "cs-parser.jay"
  { yyVal = Operator.OpType.Modulus; }
  break;
case 259:
#line 2074 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseAnd; }
  break;
case 260:
#line 2075 "cs-parser.jay"
  { yyVal = Operator.OpType.BitwiseOr; }
  break;
case 261:
#line 2076 "cs-parser.jay"
  { yyVal = Operator.OpType.ExclusiveOr; }
  break;
case 262:
#line 2077 "cs-parser.jay"
  { yyVal = Operator.OpType.LeftShift; }
  break;
case 263:
#line 2078 "cs-parser.jay"
  { yyVal = Operator.OpType.RightShift; }
  break;
case 264:
#line 2079 "cs-parser.jay"
  { yyVal = Operator.OpType.Equality; }
  break;
case 265:
#line 2080 "cs-parser.jay"
  { yyVal = Operator.OpType.Inequality; }
  break;
case 266:
#line 2081 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThan; }
  break;
case 267:
#line 2082 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThan; }
  break;
case 268:
#line 2083 "cs-parser.jay"
  { yyVal = Operator.OpType.GreaterThanOrEqual; }
  break;
case 269:
#line 2084 "cs-parser.jay"
  { yyVal = Operator.OpType.LessThanOrEqual; }
  break;
case 270:
#line 2091 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 271:
  case_271();
  break;
case 272:
#line 2110 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.DefaultValue;
	  }
  break;
case 273:
  case_273();
  break;
case 274:
  case_274();
  break;
case 275:
  case_275();
  break;
case 276:
  case_276();
  break;
case 277:
  case_277();
  break;
case 278:
  case_278();
  break;
case 279:
  case_279();
  break;
case 281:
#line 2213 "cs-parser.jay"
  { current_block = null; yyVal = null; }
  break;
case 284:
#line 2225 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 285:
  case_285();
  break;
case 286:
#line 2235 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 287:
  case_287();
  break;
case 288:
  case_288();
  break;
case 289:
  case_289();
  break;
case 290:
  case_290();
  break;
case 291:
  case_291();
  break;
case 292:
  case_292();
  break;
case 293:
  case_293();
  break;
case 294:
  case_294();
  break;
case 295:
  case_295();
  break;
case 297:
#line 2344 "cs-parser.jay"
  {
	  	++lexer.parsing_block;
	  }
  break;
case 298:
  case_298();
  break;
case 301:
#line 2361 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 302:
#line 2365 "cs-parser.jay"
  {
		current_event_field.AddDeclarator ((FieldDeclarator) yyVals[0+yyTop]);
	  }
  break;
case 303:
  case_303();
  break;
case 304:
#line 2378 "cs-parser.jay"
  {
		++lexer.parsing_block;
	  }
  break;
case 305:
  case_305();
  break;
case 306:
  case_306();
  break;
case 307:
#line 2403 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 310:
  case_310();
  break;
case 311:
  case_311();
  break;
case 312:
  case_312();
  break;
case 313:
  case_313();
  break;
case 314:
  case_314();
  break;
case 315:
  case_315();
  break;
case 316:
  case_316();
  break;
case 317:
  case_317();
  break;
case 319:
  case_319();
  break;
case 320:
  case_320();
  break;
case 321:
  case_321();
  break;
case 322:
  case_322();
  break;
case 324:
  case_324();
  break;
case 325:
  case_325();
  break;
case 328:
#line 2558 "cs-parser.jay"
  {
	  	lbag.AddLocation (yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 330:
  case_330();
  break;
case 331:
  case_331();
  break;
case 332:
  case_332();
  break;
case 333:
  case_333();
  break;
case 334:
#line 2616 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out | ParameterModifierType.Params | ParameterModifierType.DefaultValue;
	  }
  break;
case 335:
  case_335();
  break;
case 336:
#line 2636 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = false;
	  }
  break;
case 337:
  case_337();
  break;
case 339:
  case_339();
  break;
case 341:
  case_341();
  break;
case 343:
  case_343();
  break;
case 344:
  case_344();
  break;
case 346:
  case_346();
  break;
case 347:
  case_347();
  break;
case 348:
  case_348();
  break;
case 349:
  case_349();
  break;
case 350:
#line 2734 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 351:
  case_351();
  break;
case 352:
  case_352();
  break;
case 354:
  case_354();
  break;
case 355:
  case_355();
  break;
case 356:
  case_356();
  break;
case 357:
  case_357();
  break;
case 358:
  case_358();
  break;
case 359:
  case_359();
  break;
case 361:
  case_361();
  break;
case 362:
  case_362();
  break;
case 363:
  case_363();
  break;
case 364:
  case_364();
  break;
case 365:
  case_365();
  break;
case 367:
#line 2852 "cs-parser.jay"
  {
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 368:
#line 2859 "cs-parser.jay"
  {
		lexer.parsing_generic_declaration = true;
	  }
  break;
case 370:
  case_370();
  break;
case 372:
  case_372();
  break;
case 374:
  case_374();
  break;
case 376:
#line 2897 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 377:
  case_377();
  break;
case 378:
#line 2917 "cs-parser.jay"
  {
		yyVal = new ComposedCast (((MemberName) yyVals[-1+yyTop]).GetTypeExpression (), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 379:
  case_379();
  break;
case 380:
#line 2926 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 381:
#line 2930 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 382:
  case_382();
  break;
case 383:
  case_383();
  break;
case 384:
  case_384();
  break;
case 385:
  case_385();
  break;
case 386:
#line 2968 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Object, GetLocation (yyVals[0+yyTop])); }
  break;
case 387:
#line 2969 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.String, GetLocation (yyVals[0+yyTop])); }
  break;
case 388:
#line 2970 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Bool, GetLocation (yyVals[0+yyTop])); }
  break;
case 389:
#line 2971 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Decimal, GetLocation (yyVals[0+yyTop])); }
  break;
case 390:
#line 2972 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Float, GetLocation (yyVals[0+yyTop])); }
  break;
case 391:
#line 2973 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Double, GetLocation (yyVals[0+yyTop])); }
  break;
case 393:
#line 2978 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.SByte, GetLocation (yyVals[0+yyTop])); }
  break;
case 394:
#line 2979 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Byte, GetLocation (yyVals[0+yyTop])); }
  break;
case 395:
#line 2980 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Short, GetLocation (yyVals[0+yyTop])); }
  break;
case 396:
#line 2981 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UShort, GetLocation (yyVals[0+yyTop])); }
  break;
case 397:
#line 2982 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Int, GetLocation (yyVals[0+yyTop])); }
  break;
case 398:
#line 2983 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.UInt, GetLocation (yyVals[0+yyTop])); }
  break;
case 399:
#line 2984 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Long, GetLocation (yyVals[0+yyTop])); }
  break;
case 400:
#line 2985 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.ULong, GetLocation (yyVals[0+yyTop])); }
  break;
case 401:
#line 2986 "cs-parser.jay"
  { yyVal = new TypeExpression (compiler.BuiltinTypes.Char, GetLocation (yyVals[0+yyTop])); }
  break;
case 422:
  case_422();
  break;
case 423:
  case_423();
  break;
case 427:
#line 3033 "cs-parser.jay"
  { yyVal = new NullLiteral (GetLocation (yyVals[0+yyTop])); }
  break;
case 428:
#line 3037 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, true, GetLocation (yyVals[0+yyTop])); }
  break;
case 429:
#line 3038 "cs-parser.jay"
  { yyVal = new BoolLiteral (compiler.BuiltinTypes, false, GetLocation (yyVals[0+yyTop])); }
  break;
case 434:
  case_434();
  break;
case 435:
#line 3071 "cs-parser.jay"
  {
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
	  }
  break;
case 436:
  case_436();
  break;
case 437:
  case_437();
  break;
case 438:
  case_438();
  break;
case 439:
  case_439();
  break;
case 440:
#line 3102 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null,GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 441:
  case_441();
  break;
case 442:
#line 3110 "cs-parser.jay"
  {
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-2+yyTop], null, lexer.Location);
	  }
  break;
case 443:
  case_443();
  break;
case 444:
  case_444();
  break;
case 445:
#line 3126 "cs-parser.jay"
  { yyVal = null; }
  break;
case 447:
  case_447();
  break;
case 448:
  case_448();
  break;
case 449:
#line 3149 "cs-parser.jay"
  { yyVal = null; }
  break;
case 450:
#line 3153 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	}
  break;
case 451:
  case_451();
  break;
case 452:
  case_452();
  break;
case 453:
  case_453();
  break;
case 454:
  case_454();
  break;
case 455:
#line 3185 "cs-parser.jay"
  {
		yyVal = new CompletionElementInitializer (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 456:
  case_456();
  break;
case 457:
  case_457();
  break;
case 458:
  case_458();
  break;
case 461:
#line 3213 "cs-parser.jay"
  { yyVal = null; }
  break;
case 463:
  case_463();
  break;
case 464:
  case_464();
  break;
case 465:
  case_465();
  break;
case 466:
  case_466();
  break;
case 467:
  case_467();
  break;
case 468:
#line 3265 "cs-parser.jay"
  {
		yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 472:
  case_472();
  break;
case 473:
  case_473();
  break;
case 474:
  case_474();
  break;
case 475:
  case_475();
  break;
case 477:
  case_477();
  break;
case 478:
  case_478();
  break;
case 479:
  case_479();
  break;
case 480:
  case_480();
  break;
case 481:
  case_481();
  break;
case 482:
  case_482();
  break;
case 483:
#line 3352 "cs-parser.jay"
  {
	  	yyVal = new Argument ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 485:
#line 3360 "cs-parser.jay"
  {
		yyVal = new This (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 486:
  case_486();
  break;
case 487:
  case_487();
  break;
case 488:
#line 3380 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostIncrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 489:
#line 3387 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PostDecrement, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 490:
  case_490();
  break;
case 491:
  case_491();
  break;
case 492:
  case_492();
  break;
case 493:
  case_493();
  break;
case 494:
  case_494();
  break;
case 495:
  case_495();
  break;
case 496:
  case_496();
  break;
case 497:
#line 3453 "cs-parser.jay"
  {
		++lexer.parsing_type;
	  }
  break;
case 498:
  case_498();
  break;
case 499:
  case_499();
  break;
case 502:
#line 3480 "cs-parser.jay"
  { yyVal = null; }
  break;
case 504:
  case_504();
  break;
case 505:
  case_505();
  break;
case 506:
  case_506();
  break;
case 507:
  case_507();
  break;
case 508:
  case_508();
  break;
case 509:
  case_509();
  break;
case 513:
  case_513();
  break;
case 514:
  case_514();
  break;
case 515:
  case_515();
  break;
case 516:
#line 3556 "cs-parser.jay"
  {
		yyVal = 2;
	  }
  break;
case 517:
#line 3560 "cs-parser.jay"
  {
		yyVal = ((int) yyVals[-1+yyTop]) + 1;
	  }
  break;
case 518:
#line 3567 "cs-parser.jay"
  {
		yyVal = null;
	  }
  break;
case 519:
#line 3571 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 520:
  case_520();
  break;
case 521:
  case_521();
  break;
case 522:
  case_522();
  break;
case 523:
  case_523();
  break;
case 524:
#line 3615 "cs-parser.jay"
  {
	  	lexer.TypeOfParsing = true;
	  }
  break;
case 525:
  case_525();
  break;
case 528:
  case_528();
  break;
case 529:
  case_529();
  break;
case 530:
  case_530();
  break;
case 531:
  case_531();
  break;
case 532:
  case_532();
  break;
case 533:
  case_533();
  break;
case 534:
  case_534();
  break;
case 535:
  case_535();
  break;
case 536:
  case_536();
  break;
case 537:
  case_537();
  break;
case 538:
  case_538();
  break;
case 539:
  case_539();
  break;
case 540:
#line 3728 "cs-parser.jay"
  {
		start_anonymous (false, (ParametersCompiled) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 541:
  case_541();
  break;
case 542:
#line 3744 "cs-parser.jay"
  {
		yyVal = ParametersCompiled.Undefined;
	  }
  break;
case 544:
#line 3752 "cs-parser.jay"
  {
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 545:
  case_545();
  break;
case 546:
  case_546();
  break;
case 548:
#line 3778 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.LogicalNot, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 549:
#line 3782 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.OnesComplement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 551:
  case_551();
  break;
case 553:
#line 3803 "cs-parser.jay"
  { 
	  	yyVal = new Unary (Unary.Operator.UnaryPlus, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 554:
#line 3807 "cs-parser.jay"
  { 
		yyVal = new Unary (Unary.Operator.UnaryNegation, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 555:
#line 3811 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreIncrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 556:
#line 3815 "cs-parser.jay"
  {
		yyVal = new UnaryMutator (UnaryMutator.Mode.PreDecrement, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 557:
#line 3819 "cs-parser.jay"
  {
		yyVal = new Indirection ((Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 558:
#line 3823 "cs-parser.jay"
  {
		yyVal = new Unary (Unary.Operator.AddressOf, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 560:
  case_560();
  break;
case 561:
  case_561();
  break;
case 562:
  case_562();
  break;
case 564:
  case_564();
  break;
case 565:
#line 3855 "cs-parser.jay"
  {
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 566:
  case_566();
  break;
case 567:
#line 3864 "cs-parser.jay"
  {
		yyVal = new As ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 568:
#line 3868 "cs-parser.jay"
  {
		yyVal = new Is ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 570:
  case_570();
  break;
case 571:
  case_571();
  break;
case 573:
  case_573();
  break;
case 574:
  case_574();
  break;
case 575:
  case_575();
  break;
case 576:
  case_576();
  break;
case 578:
  case_578();
  break;
case 579:
  case_579();
  break;
case 581:
  case_581();
  break;
case 583:
  case_583();
  break;
case 585:
  case_585();
  break;
case 587:
  case_587();
  break;
case 589:
  case_589();
  break;
case 591:
  case_591();
  break;
case 593:
  case_593();
  break;
case 594:
#line 3992 "cs-parser.jay"
  {
		yyVal = new SimpleAssign ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 595:
  case_595();
  break;
case 596:
  case_596();
  break;
case 597:
  case_597();
  break;
case 598:
  case_598();
  break;
case 599:
  case_599();
  break;
case 600:
  case_600();
  break;
case 601:
  case_601();
  break;
case 602:
  case_602();
  break;
case 603:
  case_603();
  break;
case 604:
  case_604();
  break;
case 605:
  case_605();
  break;
case 606:
  case_606();
  break;
case 607:
  case_607();
  break;
case 608:
  case_608();
  break;
case 609:
  case_609();
  break;
case 610:
#line 4087 "cs-parser.jay"
  { yyVal = ParametersCompiled.EmptyReadOnlyParameters; }
  break;
case 611:
  case_611();
  break;
case 614:
#line 4102 "cs-parser.jay"
  {
		start_block (lexer.Location);
	  }
  break;
case 615:
  case_615();
  break;
case 617:
  case_617();
  break;
case 618:
  case_618();
  break;
case 619:
  case_619();
  break;
case 620:
  case_620();
  break;
case 621:
  case_621();
  break;
case 622:
  case_622();
  break;
case 628:
#line 4164 "cs-parser.jay"
  {
		yyVal = new ArglistAccess (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 629:
  case_629();
  break;
case 630:
  case_630();
  break;
case 631:
  case_631();
  break;
case 633:
#line 4193 "cs-parser.jay"
  {
		yyVal = new BooleanExpression ((Expression) yyVals[0+yyTop]);
	  }
  break;
case 634:
#line 4206 "cs-parser.jay"
  {
		lexer.ConstraintsParsing = true;
	  }
  break;
case 635:
  case_635();
  break;
case 636:
  case_636();
  break;
case 637:
  case_637();
  break;
case 638:
  case_638();
  break;
case 639:
#line 4245 "cs-parser.jay"
  { yyVal = null; }
  break;
case 640:
#line 4247 "cs-parser.jay"
  { yyVal = yyVals[0+yyTop]; StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[0+yyTop])); }
  break;
case 641:
  case_641();
  break;
case 644:
  case_644();
  break;
case 645:
  case_645();
  break;
case 646:
  case_646();
  break;
case 647:
  case_647();
  break;
case 648:
  case_648();
  break;
case 649:
  case_649();
  break;
case 650:
  case_650();
  break;
case 651:
  case_651();
  break;
case 652:
  case_652();
  break;
case 653:
  case_653();
  break;
case 654:
  case_654();
  break;
case 655:
  case_655();
  break;
case 656:
  case_656();
  break;
case 657:
  case_657();
  break;
case 658:
  case_658();
  break;
case 659:
  case_659();
  break;
case 661:
#line 4367 "cs-parser.jay"
  {
		current_container.AddBasesForPart (current_class, (List<FullNamedExpression>) yyVals[0+yyTop]);
	 }
  break;
case 663:
#line 4375 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 664:
  case_664();
  break;
case 665:
  case_665();
  break;
case 666:
  case_666();
  break;
case 667:
  case_667();
  break;
case 668:
  case_668();
  break;
case 669:
  case_669();
  break;
case 670:
  case_670();
  break;
case 671:
  case_671();
  break;
case 672:
#line 4464 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Class, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 673:
#line 4468 "cs-parser.jay"
  {
		yyVal = new SpecialContraintExpr (SpecialConstraint.Struct, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 674:
#line 4475 "cs-parser.jay"
  {
		yyVal = Variance.None;
	  }
  break;
case 675:
  case_675();
  break;
case 676:
#line 4489 "cs-parser.jay"
  {
		yyVal = Variance.Covariant;
	  }
  break;
case 677:
#line 4493 "cs-parser.jay"
  {
		yyVal = Variance.Contravariant;
	  }
  break;
case 678:
  case_678();
  break;
case 679:
#line 4518 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 680:
  case_680();
  break;
case 681:
  case_681();
  break;
case 682:
  case_682();
  break;
case 683:
  case_683();
  break;
case 688:
#line 4562 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 689:
#line 4566 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 691:
  case_691();
  break;
case 694:
#line 4590 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 695:
#line 4594 "cs-parser.jay"
  {
		current_block.AddStatement ((Statement) yyVals[0+yyTop]);
	  }
  break;
case 724:
  case_724();
  break;
case 725:
  case_725();
  break;
case 726:
  case_726();
  break;
case 727:
  case_727();
  break;
case 728:
  case_728();
  break;
case 731:
  case_731();
  break;
case 732:
  case_732();
  break;
case 733:
  case_733();
  break;
case 734:
  case_734();
  break;
case 735:
#line 4738 "cs-parser.jay"
  {
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 736:
#line 4742 "cs-parser.jay"
  {
		yyVal = new ComposedCast (new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-1+yyTop])), (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }
  break;
case 737:
  case_737();
  break;
case 739:
  case_739();
  break;
case 740:
#line 4763 "cs-parser.jay"
  {
		yyVal = ComposedTypeSpecifier.CreatePointer (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 741:
  case_741();
  break;
case 742:
  case_742();
  break;
case 743:
  case_743();
  break;
case 744:
  case_744();
  break;
case 746:
  case_746();
  break;
case 747:
  case_747();
  break;
case 752:
  case_752();
  break;
case 753:
  case_753();
  break;
case 754:
#line 4852 "cs-parser.jay"
  {
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
	  }
  break;
case 755:
  case_755();
  break;
case 760:
  case_760();
  break;
case 762:
  case_762();
  break;
case 763:
  case_763();
  break;
case 764:
  case_764();
  break;
case 765:
#line 4902 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 766:
#line 4906 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 767:
#line 4907 "cs-parser.jay"
  { yyVal = yyVals[-1+yyTop]; }
  break;
case 768:
  case_768();
  break;
case 769:
  case_769();
  break;
case 770:
  case_770();
  break;
case 773:
  case_773();
  break;
case 774:
  case_774();
  break;
case 775:
#line 4975 "cs-parser.jay"
  {
		start_block (GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 776:
  case_776();
  break;
case 777:
  case_777();
  break;
case 779:
  case_779();
  break;
case 780:
  case_780();
  break;
case 781:
  case_781();
  break;
case 782:
#line 5019 "cs-parser.jay"
  {
		current_block = current_block.CreateSwitchBlock (lexer.Location);
	  }
  break;
case 783:
#line 5023 "cs-parser.jay"
  {
		yyVal = new SwitchSection ((List<SwitchLabel>) yyVals[-2+yyTop], current_block);
	  }
  break;
case 784:
  case_784();
  break;
case 785:
  case_785();
  break;
case 786:
  case_786();
  break;
case 787:
#line 5052 "cs-parser.jay"
  {
		yyVal = new SwitchLabel (null, GetLocation (yyVals[0+yyTop]));
	  }
  break;
case 792:
  case_792();
  break;
case 793:
  case_793();
  break;
case 794:
  case_794();
  break;
case 795:
#line 5091 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 796:
  case_796();
  break;
case 797:
  case_797();
  break;
case 798:
#line 5119 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 800:
  case_800();
  break;
case 801:
  case_801();
  break;
case 803:
#line 5140 "cs-parser.jay"
  { yyVal = null; }
  break;
case 805:
#line 5145 "cs-parser.jay"
  { yyVal = new EmptyStatement (lexer.Location); }
  break;
case 809:
  case_809();
  break;
case 810:
  case_810();
  break;
case 811:
  case_811();
  break;
case 812:
  case_812();
  break;
case 819:
  case_819();
  break;
case 820:
  case_820();
  break;
case 821:
  case_821();
  break;
case 822:
  case_822();
  break;
case 823:
  case_823();
  break;
case 824:
  case_824();
  break;
case 825:
  case_825();
  break;
case 826:
  case_826();
  break;
case 827:
  case_827();
  break;
case 830:
#line 5300 "cs-parser.jay"
  {
		yyVal = new TryCatch ((Block) yyVals[-1+yyTop], (List<Catch>) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]), false);
	  }
  break;
case 831:
  case_831();
  break;
case 832:
  case_832();
  break;
case 833:
  case_833();
  break;
case 834:
  case_834();
  break;
case 835:
  case_835();
  break;
case 838:
#line 5353 "cs-parser.jay"
  {
		yyVal = new Catch ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 839:
  case_839();
  break;
case 840:
#line 5372 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 841:
  case_841();
  break;
case 842:
#line 5390 "cs-parser.jay"
  {
		yyVal = new Checked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 843:
#line 5397 "cs-parser.jay"
  {
		yyVal = new Unchecked ((Block) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }
  break;
case 844:
  case_844();
  break;
case 845:
#line 5407 "cs-parser.jay"
  {
		yyVal = new Unsafe ((Block) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }
  break;
case 846:
  case_846();
  break;
case 847:
  case_847();
  break;
case 848:
  case_848();
  break;
case 849:
  case_849();
  break;
case 850:
  case_850();
  break;
case 851:
  case_851();
  break;
case 852:
  case_852();
  break;
case 853:
  case_853();
  break;
case 854:
#line 5490 "cs-parser.jay"
  {
		report.Error (210, lexer.Location, "You must provide an initializer in a fixed or using statement declaration");
	  }
  break;
case 855:
  case_855();
  break;
case 856:
  case_856();
  break;
case 857:
  case_857();
  break;
case 858:
  case_858();
  break;
case 859:
  case_859();
  break;
case 860:
  case_860();
  break;
case 861:
  case_861();
  break;
case 862:
  case_862();
  break;
case 863:
  case_863();
  break;
case 864:
#line 5590 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 865:
  case_865();
  break;
case 866:
#line 5605 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 867:
  case_867();
  break;
case 868:
  case_868();
  break;
case 870:
  case_870();
  break;
case 871:
#line 5650 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 872:
  case_872();
  break;
case 873:
  case_873();
  break;
case 874:
  case_874();
  break;
case 875:
  case_875();
  break;
case 879:
  case_879();
  break;
case 885:
#line 5709 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 886:
  case_886();
  break;
case 887:
#line 5728 "cs-parser.jay"
  {
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 888:
  case_888();
  break;
case 889:
  case_889();
  break;
case 890:
  case_890();
  break;
case 891:
  case_891();
  break;
case 892:
  case_892();
  break;
case 893:
  case_893();
  break;
case 894:
  case_894();
  break;
case 895:
  case_895();
  break;
case 896:
  case_896();
  break;
case 898:
#line 5872 "cs-parser.jay"
  {
		yyVal = yyVals[0+yyTop];
	  }
  break;
case 899:
#line 5879 "cs-parser.jay"
  {
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }
  break;
case 900:
  case_900();
  break;
case 902:
  case_902();
  break;
case 903:
  case_903();
  break;
case 905:
  case_905();
  break;
case 906:
  case_906();
  break;
case 907:
#line 5925 "cs-parser.jay"
  {
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 908:
  case_908();
  break;
case 909:
  case_909();
  break;
case 910:
#line 5942 "cs-parser.jay"
  {
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[0+yyTop]);	
	  }
  break;
case 911:
  case_911();
  break;
case 912:
  case_912();
  break;
case 914:
  case_914();
  break;
case 915:
  case_915();
  break;
case 918:
  case_918();
  break;
case 919:
  case_919();
  break;
case 927:
#line 6066 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedName = (MemberName) yyVals[0+yyTop];
	  }
  break;
case 928:
#line 6073 "cs-parser.jay"
  {
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
	  }
  break;
case 929:
  case_929();
  break;
case 930:
  case_930();
  break;
case 931:
#line 6090 "cs-parser.jay"
  {
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], new MemberName (MemberCache.IndexerNameAlias));
	  }
  break;
case 932:
#line 6094 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 933:
  case_933();
  break;
case 934:
  case_934();
  break;
case 935:
  case_935();
  break;
case 936:
  case_936();
  break;
case 938:
#line 6130 "cs-parser.jay"
  {
		yyVal = new MemberName (((MemberName) yyVals[-2+yyTop]), (MemberName) yyVals[0+yyTop]);
	  }
  break;
case 940:
#line 6138 "cs-parser.jay"
  {
		valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }
  break;
case 941:
#line 6142 "cs-parser.jay"
  {
		yyVal = yyVals[-1+yyTop];
	  }
  break;
case 942:
#line 6149 "cs-parser.jay"
  {
		yyVal = new List<DocumentationParameter> (0);
	  }
  break;
case 944:
  case_944();
  break;
case 945:
  case_945();
  break;
case 946:
  case_946();
  break;
#line default
        }
        yyTop -= yyLen[yyN];
        yyState = yyStates[yyTop];
        int yyM = yyLhs[yyN];
        if (yyState == 0 && yyM == 0) {
//t          if (debug != null) debug.shift(0, yyFinal);
          yyState = yyFinal;
          if (yyToken < 0) {
            yyToken = yyLex.advance() ? yyLex.token() : 0;
//t            if (debug != null)
//t               debug.lex(yyState, yyToken,yyname(yyToken), yyLex.value());
          }
          if (yyToken == 0) {
//t            if (debug != null) debug.accept(yyVal);
            return yyVal;
          }
          goto continue_yyLoop;
        }
        if (((yyN = yyGindex[yyM]) != 0) && ((yyN += yyState) >= 0)
            && (yyN < yyTable.Length) && (yyCheck[yyN] == yyState))
          yyState = yyTable[yyN];
        else
          yyState = yyDgoto[yyM];
//t        if (debug != null) debug.shift(yyStates[yyTop], yyState);
	 goto continue_yyLoop;
      continue_yyDiscarded: ;	// implements the named-loop continue: 'continue yyDiscarded'
      }
    continue_yyLoop: ;		// implements the named-loop continue: 'continue yyLoop'
    }
  }

/*
 All more than 3 lines long rules are wrapped into a method
*/
void case_6()
#line 387 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			Attributes attrs = (Attributes) yyVals[0+yyTop];
			report.Error (1730, attrs.Attrs [0].Location,
				"Assembly and module attributes must precede all other elements except using clauses and extern alias declarations");
		}
	  }

void case_8()
#line 399 "cs-parser.jay"
{
		if (yyToken == Token.EXTERN_ALIAS)
			report.Error (439, lexer.Location, "An extern alias declaration must precede all other elements");
		else
			Error_SyntaxError (yyToken);
	  }

void case_13()
#line 419 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "alias"){
			syntax_error (lt.Location, "`alias' expected");
		} else if (lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (lt.Location, "external alias");
		} else {
			lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop]; 
			current_namespace.AddUsingExternalAlias (lt.Value, lt.Location, report);
			ubag.AddExternAlias  (GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]), lt, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_17()
#line 445 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_18()
#line 450 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_19()
#line 458 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lang_version != LanguageVersion.ISO_1 && lt.Value == "global") {
			report.Warning (440, 2, lt.Location,
			 "An alias named `global' will not be used when resolving `global::'. The global namespace will be used instead");
		}

		current_namespace.AddUsingAlias (lt.Value, (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		ubag.AddUsingAlias (GetLocation (yyVals[-4+yyTop]), lt, GetLocation (yyVals[-2+yyTop]), (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
		  }

void case_20()
#line 469 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_21()
#line 477 "cs-parser.jay"
{
		current_namespace.AddUsing ((MemberName) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		ubag.AddUsing (GetLocation (yyVals[-2+yyTop]), (MemberName) yyVals[-1+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_22()
#line 490 "cs-parser.jay"
{
		Attributes attrs = (Attributes) yyVals[-2+yyTop];
		MemberName name = (MemberName) yyVals[0+yyTop];
		if (attrs != null) {
			bool valid_global_attrs = true;
			if ((current_namespace.DeclarationFound || current_namespace != file.NamespaceContainer)) {
				valid_global_attrs = false;
			} else {
				foreach (var a in attrs.Attrs) {
					if (a.ExplicitTarget == "assembly" || a.ExplicitTarget == "module")
						continue;
						
					valid_global_attrs = false;
					break;
				}
			}
			
			if (!valid_global_attrs)
				report.Error (1671, name.Location, "A namespace declaration cannot have modifiers or attributes");
		}
	
		module.AddAttributes (attrs, current_namespace);
		
		current_namespace = new NamespaceContainer (name, module, current_namespace, file);
		module.AddTypesContainer (current_namespace);
		current_class = current_namespace.SlaveDeclSpace;
		current_container = current_class.PartialContainer;
		
		ubag.DeclareNamespace (GetLocation (yyVals[-1+yyTop]), name);
	  }

void case_23()
#line 521 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
		ubag.OpenNamespace (GetLocation (yyVals[0+yyTop]));
	  }

void case_24()
#line 527 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			lbag.AddLocation (current_namespace, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		else
			lbag.AddLocation (current_namespace, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		current_namespace = current_namespace.Parent;
		current_class = current_namespace.SlaveDeclSpace;
		current_container = current_class.PartialContainer;
		ubag.CloseNamespace (GetLocation (yyVals[-1+yyTop]));
		ubag.EndNamespace (GetLocation (yyVals[-1+yyTop]));
	  }

void case_25()
#line 543 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName (lt.Value, lt.Location);
	  }

void case_26()
#line 552 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, lt.Location);		
	  }

void case_27()
#line 557 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new MemberName ("<invalid>", lexer.Location);
	  }

void case_32()
#line 575 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[0+yyTop];

		if (name.TypeArguments != null)
			syntax_error (lexer.Location, "namespace name expected");

		yyVal = name;
	  }

void case_41()
#line 607 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			TypeContainer ds = (TypeContainer)yyVals[0+yyTop];

			if ((ds.ModFlags & (Modifiers.PRIVATE | Modifiers.PROTECTED)) != 0){
				report.Error (1527, ds.Location, 
				"Namespace elements cannot be explicitly declared as private, protected or protected internal");
			}

			/* Here is a trick, for explicit attributes we don't know where they belong to until*/
			/* we parse succeeding declaration hence we parse them as normal and re-attach them*/
			/* when we know whether they are global (assembly:, module:) or local (type:).*/
			if (ds.OptAttributes != null) {
				ds.OptAttributes.ConvertGlobalAttributes (ds, current_namespace, !current_namespace.DeclarationFound && current_namespace == file.NamespaceContainer);
			}
		}
		current_namespace.DeclarationFound = true;
	  }

void case_50()
#line 657 "cs-parser.jay"
{
		var sect = (List<Attribute>) yyVals[0+yyTop];
		yyVal = new Attributes (sect);
		lbag.AddLocation (yyVal, savedOpenLocation, savedCloseLocation);
	  }

void case_51()
#line 663 "cs-parser.jay"
{
		Attributes attrs = yyVals[-1+yyTop] as Attributes;
		var sect = (List<Attribute>) yyVals[0+yyTop];
		if (attrs == null)
			attrs = new Attributes (sect);
		else
			attrs.AddAttributes (sect);
		yyVal = attrs;
		lbag.AddLocation (yyVal, savedOpenLocation, savedCloseLocation);
	  }

void case_52()
#line 677 "cs-parser.jay"
{
		lexer.parsing_attribute_section = true;
		savedOpenLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_53()
#line 682 "cs-parser.jay"
{
		lexer.parsing_attribute_section = false;
		yyVal = yyVals[0+yyTop];
	  }

void case_54()
#line 690 "cs-parser.jay"
{
		current_attr_target = (string) yyVals[-1+yyTop];
		if (current_attr_target == "assembly" || current_attr_target == "module") {
			Lexer.check_incorrect_doc_comment ();
		}
	  }

void case_55()
#line 697 "cs-parser.jay"
{
		/* when attribute target is invalid*/
		if (current_attr_target == string.Empty)
			yyVal = new List<Attribute> (0);
		else
			yyVal = yyVals[-2+yyTop];
	  
		current_attr_target = null;
		lexer.parsing_attribute_section = false;
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
 	  }

void case_56()
#line 709 "cs-parser.jay"
{
		yyVal = yyVals[-2+yyTop];
		savedCloseLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_57()
#line 717 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = CheckAttributeTarget (lt.Value, lt.Location);
	  }

void case_60()
#line 724 "cs-parser.jay"
{
		if (yyToken == Token.IDENTIFIER) {
			Error_SyntaxError (yyToken);
			yyVal = null;
		} else {
			string name = GetTokenName (yyToken);
			yyVal = CheckAttributeTarget (name, GetLocation (yyVals[0+yyTop]));
		}
	  }

void case_62()
#line 741 "cs-parser.jay"
{
		var attrs = (List<Attribute>) yyVals[-2+yyTop];
		attrs.Add ((Attribute) yyVals[0+yyTop]);

		yyVal = attrs;
	  }

void case_64()
#line 755 "cs-parser.jay"
{
		--lexer.parsing_block;
		MemberName mname = (MemberName) yyVals[-2+yyTop];
		if (mname.IsGeneric) {
			report.Error (404, lexer.Location,
				      "'<' unexpected: attributes cannot be generic");
		}

		Arguments [] arguments = (Arguments []) yyVals[0+yyTop];
		ATypeNameExpression expr = mname.GetTypeExpression ();
		yyVal = new Attribute (current_attr_target, expr, arguments, mname.Location, lexer.IsEscapedIdentifier (mname));
	  }

void case_69()
#line 785 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);
		yyVal = new Arguments [] { a, null };
	  }

void case_70()
#line 791 "cs-parser.jay"
{
	  	Arguments a = new Arguments (4);
		a.Add ((Argument) yyVals[0+yyTop]);  
		yyVal = new Arguments [] { null, a };
	  }

void case_71()
#line 797 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] != null) {
			report.Error (1016, ((Argument) yyVals[0+yyTop]).Expr.Location, "Named attribute arguments must appear after the positional arguments");
			o [0] = new Arguments (4);
		}
		
		Arguments args = ((Arguments) o [0]);
		if (args.Count > 0 && !(yyVals[0+yyTop] is NamedArgument) && args [args.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
		
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
	  }

void case_72()
#line 812 "cs-parser.jay"
{
		Arguments[] o = (Arguments[]) yyVals[-2+yyTop];
		if (o [1] == null) {
			o [1] = new Arguments (4);
		}

		((Arguments) o [1]).Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (o[1], GetLocation (yyVals[-1+yyTop]));
	  }

void case_76()
#line 837 "cs-parser.jay"
{
	  	--lexer.parsing_block;
	  	var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop]);	  
		lbag.AddLocation (yyVal, GetLocation(yyVals[-2+yyTop]));
	  }

void case_77()
#line 847 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "named argument");
			
		/* Avoid boxing in common case (no modifier)*/
		var arg_mod = yyVals[-1+yyTop] == null ? Argument.AType.None : (Argument.AType) yyVals[-1+yyTop];
			
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new NamedArgument (lt.Value, lt.Location, (Expression) yyVals[0+yyTop], arg_mod);
	  }

void case_95()
#line 894 "cs-parser.jay"
{
		report.Error (1519, lexer.Location, "Unexpected symbol `{0}' in class, struct, or interface member declaration",
			GetSymbolName (yyToken));
		yyVal = null;
		lexer.parsing_generic_declaration = false;
	  }

void case_97()
#line 911 "cs-parser.jay"
{ 
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		push_current_class (new Struct (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
	  }

void case_98()
#line 917 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support)
			current_container.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]));
	  }

void case_99()
#line 928 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_100()
#line 934 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[0+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_102()
#line 946 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_118()
#line 988 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var mod = (Modifiers) yyVals[-3+yyTop];
		current_field = new Const (current_class, (FullNamedExpression) yyVals[-1+yyTop], mod, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
		current_container.AddConstant ((Const) current_field);
		
		if ((mod & Modifiers.STATIC) != 0) {
			report.Error (504, current_field.Location, "The constant `{0}' cannot be marked static", current_field.GetSignatureForError ());
		}
		
		yyVal = current_field;
	  }

void case_119()
#line 1001 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_field = null;
	  }

void case_124()
#line 1031 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_126()
#line 1044 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_127()
#line 1050 "cs-parser.jay"
{
		report.Error (145, lexer.Location, "A const field requires a value to be provided");
		yyVal = null;
	  }

void case_130()
#line 1065 "cs-parser.jay"
{
	  	lexer.parsing_generic_declaration = false;

		FullNamedExpression type = (FullNamedExpression) yyVals[-1+yyTop];
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (670, GetLocation (yyVals[-1+yyTop]), "Fields cannot have void type");
			
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new Field (current_class, type, (Modifiers) yyVals[-2+yyTop], new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-3+yyTop]);
		current_container.AddField (current_field);
		yyVal = current_field;
	  }

void case_131()
#line 1080 "cs-parser.jay"
{ 
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
			
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
		current_field = null;
	  }

void case_132()
#line 1093 "cs-parser.jay"
{ 
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "fixed size buffers");

		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		current_field = new FixedField (current_class, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop],
			new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
			
		current_container.AddField (current_field);
	  }

void case_133()
#line 1104 "cs-parser.jay"
{
		if (doc_support) {
			current_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
	    }

		current_field.Initializer = (ConstInitializer) yyVals[-2+yyTop];	    
		lbag.AddMember (current_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = current_field;
	    current_field = null;
	  }

void case_136()
#line 1127 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_137()
#line 1133 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_field.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendToMember (current_field, GetLocation (yyVals[-2+yyTop]));
		end_block (lexer.Location);
		current_local_parameters = null;
	  }

void case_142()
#line 1160 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_144()
#line 1170 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_149()
#line 1196 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];	  
		yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (ConstInitializer) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_151()
#line 1209 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = new ConstInitializer (current_field, (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_152()
#line 1215 "cs-parser.jay"
{
		report.Error (443, lexer.Location, "Value or constant expected");
		yyVal = null;
	  }

void case_155()
#line 1225 "cs-parser.jay"
{
		/* It has to be here for the parent to safely restore artificial block*/
	  	Error_SyntaxError (yyToken);
	  	yyVal = null;
	  }

void case_156()
#line 1234 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.NotAllowed;

		/* Add it early in the case of body being eof for full aot*/
		current_container.AddMethod ((Method) yyVals[0+yyTop]);
	  }

void case_157()
#line 1242 "cs-parser.jay"
{
		Method method = (Method) yyVals[-2+yyTop];
		method.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface && method.Block != null) {
			report.Error (531, method.Location, "`{0}': interface members cannot have a definition", method.GetSignatureForError ());
		}

		current_local_parameters = null;

		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_160()
#line 1270 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;
		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		GenericMethod generic = null;
		if (name.TypeArguments != null) {
			generic = new GenericMethod (current_namespace, current_class, name,
						     (FullNamedExpression) yyVals[-7+yyTop], current_local_parameters);

			generic.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		} else if (yyVals[0+yyTop] != null) {
			report.Error (80, GetLocation (yyVals[0+yyTop]),
				"Constraints are not allowed on non-generic declarations");
		}

		Method method = new Method (current_class, generic, (FullNamedExpression) yyVals[-7+yyTop], (Modifiers) yyVals[-8+yyTop],
				     name, current_local_parameters, (Attributes) yyVals[-9+yyTop]);
				     
		if (yyVals[0+yyTop] != null && ((method.ModFlags & Modifiers.OVERRIDE) != 0 || method.IsExplicitImpl)) {
			report.Error (460, method.Location,
				"`{0}': Cannot specify constraints for overrides and explicit interface implementation methods",
				method.GetSignatureForError ());
		}

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_163()
#line 1315 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;
		valid_param_mod = 0;

		MemberName name = (MemberName) yyVals[-6+yyTop];
		current_local_parameters = (ParametersCompiled) yyVals[-3+yyTop];

		if (yyVals[-1+yyTop] != null && name.TypeArguments == null)
			report.Error (80, lexer.Location,
				      "Constraints are not allowed on non-generic declarations");

		Method method;
		GenericMethod generic = null;
		if (name.TypeArguments != null) {
			generic = new GenericMethod (current_namespace, current_class, name,
				new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-7+yyTop])),
				current_local_parameters);

			generic.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		}

		var modifiers = (Modifiers) yyVals[-9+yyTop];


		const Modifiers invalid_partial_mod = Modifiers.AccessibilityMask | Modifiers.ABSTRACT | Modifiers.EXTERN |
			Modifiers.NEW | Modifiers.OVERRIDE | Modifiers.SEALED | Modifiers.VIRTUAL;

		if ((modifiers & invalid_partial_mod) != 0) {
			report.Error (750, name.Location, "A partial method cannot define access modifier or " +
       			"any of abstract, extern, new, override, sealed, or virtual modifiers");
			modifiers &= ~invalid_partial_mod;
		}

		if ((current_class.ModFlags & Modifiers.PARTIAL) == 0) {
			report.Error (751, name.Location, "A partial method must be declared within a " +
       			"partial class or partial struct");
		}
		
		modifiers |= Modifiers.PARTIAL | Modifiers.PRIVATE;
		
		method = new Method (current_class, generic, new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[-7+yyTop])),
				     modifiers, name, current_local_parameters, (Attributes) yyVals[-10+yyTop]);

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		/* TODO: lbag, push void*/
		StoreModifierLocation (Modifiers.PARTIAL, GetLocation (yyVals[-8+yyTop]));
		lbag.AddMember (method, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = method;
	  }

void case_164()
#line 1370 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-3+yyTop];
		report.Error (1585, name.Location, 
			"Member modifier `{0}' must precede the member type and name", ModifiersExtensions.Name ((Modifiers) yyVals[-4+yyTop]));

		Method method = new Method (current_class, null, (FullNamedExpression) yyVals[-5+yyTop],
					    0, name, (ParametersCompiled) yyVals[-1+yyTop], (Attributes) yyVals[-7+yyTop]);

		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];

		if (doc_support)
			method.DocComment = Lexer.consume_doc_comment ();

		yyVal = method;
	  }

void case_169()
#line 1399 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
	  	yyVal = new ParametersCompiled (pars_list.ToArray ());
	  	lbag.AddLocation (yyVal, lbag.GetLocations (pars_list));
	  }

void case_170()
#line 1405 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add ((Parameter) yyVals[0+yyTop]);

		yyVal = new ParametersCompiled (pars_list.ToArray ()); 
	  }

void case_171()
#line 1412 "cs-parser.jay"
{
		var pars_list = (List<Parameter>) yyVals[-2+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[0+yyTop])));
		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_172()
#line 1418 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter[] { (Parameter) yyVals[-2+yyTop] } );			
	  }

void case_173()
#line 1425 "cs-parser.jay"
{
		if (yyVals[-2+yyTop] != null)
			report.Error (231, ((Parameter) yyVals[-2+yyTop]).Location, "A params parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_174()
#line 1435 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		yyVal = new ParametersCompiled (new Parameter [] { new ArglistParameter (GetLocation (yyVals[-2+yyTop])) }, true);
	  }

void case_175()
#line 1441 "cs-parser.jay"
{
		report.Error (257, GetLocation (yyVals[-2+yyTop]), "An __arglist parameter must be the last parameter in a formal parameter list");

		var pars_list = (List<Parameter>) yyVals[-4+yyTop];
		pars_list.Add (new ArglistParameter (GetLocation (yyVals[-2+yyTop])));

		yyVal = new ParametersCompiled (pars_list.ToArray (), true);
	  }

void case_178()
#line 1458 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_179()
#line 1466 "cs-parser.jay"
{
		parameters_bucket.Clear ();
		Parameter p = (Parameter) yyVals[0+yyTop];
		parameters_bucket.Add (p);
		
		default_parameter_used = p.HasDefaultValue;
		yyVal = parameters_bucket;
	  }

void case_180()
#line 1475 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter) yyVals[0+yyTop];
		if (p != null) {
			if (p.HasExtensionMethodModifier)
				report.Error (1100, p.Location, "The parameter modifier `this' can only be used on the first parameter");
			else if (!p.HasDefaultValue && default_parameter_used)
				report.Error (1737, p.Location, "Optional parameter cannot precede required parameters");

			default_parameter_used |= p.HasDefaultValue;
			pars.Add (p);
			
			lbag.AppendTo (pars, GetLocation (yyVals[-1+yyTop]));
		}
		
		yyVal = yyVals[-2+yyTop];
	  }

void case_181()
#line 1499 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_182()
#line 1508 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		report.Error (1552, lt.Location, "Array type specifier, [], must appear before parameter name");
		yyVal = new Parameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Parameter.Modifier) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_183()
#line 1518 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
	  	Location l = GetLocation (yyVals[0+yyTop]);
		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], null, (Parameter.Modifier) yyVals[-2+yyTop], (Attributes) yyVals[-3+yyTop], l);
		lbag.AddLocation (yyVal, parameterModifierLocation);
	  }

void case_185()
#line 1533 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		if (lang_version <= LanguageVersion.V_3) {
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "optional parameter");
		}
		
		Parameter.Modifier mod = (Parameter.Modifier) yyVals[-5+yyTop];
		if (mod != Parameter.Modifier.NONE) {
			switch (mod) {
			case Parameter.Modifier.REF:
			case Parameter.Modifier.OUT:
				report.Error (1741, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
				
			case Parameter.Modifier.This:
				report.Error (1743, GetLocation (yyVals[-5+yyTop]), "Cannot specify a default value for the `{0}' parameter",
					Parameter.GetModifierSignature (mod));
				break;
			default:
				throw new NotImplementedException (mod.ToString ());
			}
				
			mod = Parameter.Modifier.NONE;
		}
		
		if ((valid_param_mod & ParameterModifierType.DefaultValue) == 0)
			report.Error (1065, GetLocation (yyVals[-2+yyTop]), "Optional parameter is not valid in this context");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		yyVal = new Parameter ((FullNamedExpression) yyVals[-4+yyTop], lt.Value, mod, (Attributes) yyVals[-6+yyTop], lt.Location);
		lbag.AddLocation (yyVal, parameterModifierLocation, GetLocation (yyVals[-2+yyTop])); /* parameterModifierLocation should be ignored when mod == NONE*/
		
		if (yyVals[0+yyTop] != null)
			((Parameter) yyVal).DefaultValue = new DefaultParameterValueExpression ((Expression) yyVals[0+yyTop]);
	  }

void case_188()
#line 1578 "cs-parser.jay"
{
		yyVal = yyVals[0+yyTop];
		parameterModifierLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_189()
#line 1583 "cs-parser.jay"
{
		Parameter.Modifier p2 = (Parameter.Modifier)yyVals[0+yyTop];
  		Parameter.Modifier mod = (Parameter.Modifier)yyVals[-1+yyTop] | p2;
  		if (((Parameter.Modifier)yyVals[-1+yyTop] & p2) == p2) {
  			Error_DuplicateParameterModifier (lexer.Location, p2);
  		} else {
	  		switch (mod & ~Parameter.Modifier.This) {
  				case Parameter.Modifier.REF:
					report.Error (1101, lexer.Location, "The parameter modifiers `this' and `ref' cannot be used altogether");
  					break;
   				case Parameter.Modifier.OUT:
					report.Error (1102, lexer.Location, "The parameter modifiers `this' and `out' cannot be used altogether");
  					break;
  				default:
 					report.Error (1108, lexer.Location, "A parameter cannot have specified more than one modifier");
 					break;
 			}
  		}
  		yyVal = mod;
	  }

void case_190()
#line 1607 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Ref) == 0)
	  		Error_ParameterModifierNotValid ("ref", GetLocation (yyVals[0+yyTop]));
	  		
	  	yyVal = Parameter.Modifier.REF;
	  }

void case_191()
#line 1614 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Out) == 0)
	  		Error_ParameterModifierNotValid ("out", GetLocation (yyVals[0+yyTop]));
	  
	  	yyVal = Parameter.Modifier.OUT;
	  }

void case_192()
#line 1621 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.This) == 0)
	  		Error_ParameterModifierNotValid ("this", GetLocation (yyVals[0+yyTop]));

	  	if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "extension methods");
	  			
		yyVal = Parameter.Modifier.This;
	  }

void case_193()
#line 1634 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Attributes) yyVals[-3+yyTop], lt.Location);
	  }

void case_194()
#line 1639 "cs-parser.jay"
{
		report.Error (1751, GetLocation (yyVals[-4+yyTop]), "Cannot specify a default value for a parameter array");
		
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new ParamsParameter ((FullNamedExpression) yyVals[-3+yyTop], lt.Value, (Attributes) yyVals[-5+yyTop], lt.Location);		
	  }

void case_195()
#line 1646 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_196()
#line 1654 "cs-parser.jay"
{
		if ((valid_param_mod & ParameterModifierType.Params) == 0)
			report.Error (1670, (GetLocation (yyVals[0+yyTop])), "The `params' modifier is not allowed in current context");
	  }

void case_197()
#line 1659 "cs-parser.jay"
{
		Parameter.Modifier mod = (Parameter.Modifier)yyVals[0+yyTop];
		if ((mod & Parameter.Modifier.This) != 0) {
			report.Error (1104, GetLocation (yyVals[-1+yyTop]), "The parameter modifiers `this' and `params' cannot be used altogether");
		} else {
			report.Error (1611, GetLocation (yyVals[-1+yyTop]), "The params parameter cannot be declared as ref or out");
		}	  
	  }

void case_199()
#line 1675 "cs-parser.jay"
{
	  	if ((valid_param_mod & ParameterModifierType.Arglist) == 0)
	  		report.Error (1669, GetLocation (yyVals[0+yyTop]), "__arglist is not valid in this context");
	  }

void case_200()
#line 1686 "cs-parser.jay"
{
		if (doc_support)
			tmpComment = Lexer.consume_doc_comment ();
	  }

void case_201()
#line 1691 "cs-parser.jay"
{
		var type = (FullNamedExpression) yyVals[-3+yyTop];
		current_property = new Property (current_class, type, (Modifiers) yyVals[-4+yyTop],
			(MemberName) yyVals[-2+yyTop], (Attributes) yyVals[-5+yyTop]);
			
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (547, GetLocation (yyVals[-3+yyTop]), "`{0}': property or indexer cannot have void type", current_property.GetSignatureForError ());					
			
		current_container.AddProperty ((Property)current_property);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[0+yyTop]));
		
		lexer.PropertyParsing = true;
	  }

void case_202()
#line 1705 "cs-parser.jay"
{
		lexer.PropertyParsing = false;
		
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();				
	  }

void case_203()
#line 1712 "cs-parser.jay"
{
		lbag.AppendToMember (current_property, GetLocation (yyVals[0+yyTop]));
		current_property = null;
	  }

void case_205()
#line 1726 "cs-parser.jay"
{
		valid_param_mod = 0;
		var type = (FullNamedExpression) yyVals[-6+yyTop];
		Indexer indexer = new Indexer (current_class, type,
			(MemberName)yyVals[-5+yyTop], (Modifiers) yyVals[-7+yyTop], (ParametersCompiled) yyVals[-2+yyTop], (Attributes) yyVals[-8+yyTop]);
			
		current_property = indexer;

  		current_container.AddIndexer (indexer);
		lbag.AddMember (current_property, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
  		
		if (type.Type != null && type.Type.Kind == MemberKind.Void)
			report.Error (620, GetLocation (yyVals[-6+yyTop]), "`{0}': indexer return type cannot be `void'", indexer.GetSignatureForError ());  		

		if (indexer.Parameters.IsEmpty) {
			report.Error (1551, GetLocation (yyVals[-4+yyTop]), "Indexers must have at least one parameter");
		}

		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		lexer.PropertyParsing = true;
	  }

void case_207()
#line 1756 "cs-parser.jay"
{ 
		if (doc_support)
			current_property.DocComment = ConsumeStoredComment ();
			
		lbag.AppendToMember (current_property, GetLocation (yyVals[-1+yyTop]));
		current_property = null;		
	  }

void case_212()
#line 1772 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_BRACE) {
	  		report.Error (548, lexer.Location, "`{0}': property or indexer must have at least one accessor", current_property.GetSignatureForError ());
		} else {
			if (yyToken == Token.SEMICOLON)
				report.Error (1597, lexer.Location, "Semicolon after method or accessor block is not valid");
			else
				report.Error (1014, GetLocation (yyVals[0+yyTop]), "A get or set accessor expected");
		}
	  }

void case_213()
#line 1786 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
	  
		if (current_property.Get != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
		
		if (current_property is Indexer) {
			current_property.Get = new Indexer.GetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop], ((Indexer)current_property).ParameterInfo.Clone (),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Get = new Property.GetMethod (current_property,
				(Modifiers) yyVals[-1+yyTop], (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}	
	  
		current_local_parameters = current_property.Get.ParameterInfo;	  
		lbag.AddMember (current_property.Get, GetModifierLocations ());
		lexer.PropertyParsing = false;
	  }

void case_214()
#line 1808 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] != null) {
	  		current_property.Get.Block = (ToplevelBlock) yyVals[0+yyTop];			
	  	
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Get.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Get.GetSignatureForError ());
			}		
		}
	  
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support)
			if (Lexer.doc_state == XmlCommentState.Error)
				Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_215()
#line 1829 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != ModifierNone && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "access modifiers on properties");
		}
		
		if (current_property.Set != null) {
			report.Error (1007, GetLocation (yyVals[0+yyTop]), "Property accessor already defined");
		}
	  
		if (current_property is Indexer) {
			current_property.Set = new Indexer.SetIndexerMethod (current_property, (Modifiers) yyVals[-1+yyTop],
				ParametersCompiled.MergeGenerated (compiler,
				((Indexer)current_property).ParameterInfo, true, new Parameter (
					current_property.TypeExpression, "value", Parameter.Modifier.NONE, null, GetLocation (yyVals[0+yyTop])),
					null),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		} else {
			current_property.Set = new Property.SetMethod (current_property, (Modifiers) yyVals[-1+yyTop], 
				ParametersCompiled.CreateImplicitParameter (current_property.TypeExpression, GetLocation (yyVals[0+yyTop])),
				(Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		}
		
		current_local_parameters = current_property.Set.ParameterInfo;	
		lbag.AddMember (current_property.Set, GetModifierLocations ());
		lexer.PropertyParsing = false;
	  }

void case_216()
#line 1856 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {		
			current_property.Set.Block = (ToplevelBlock) yyVals[0+yyTop];
		
			if (current_container.Kind == MemberKind.Interface) {
				report.Error (531, current_property.Set.Block.StartLocation,
					"`{0}': interface members cannot have a definition", current_property.Set.GetSignatureForError ());
			}
		}
		
		current_local_parameters = null;
		lexer.PropertyParsing = true;

		if (doc_support
			&& Lexer.doc_state == XmlCommentState.Error)
			Lexer.doc_state = XmlCommentState.NotAllowed;
	  }

void case_218()
#line 1878 "cs-parser.jay"
{
		lbag.AppendToMember (lbag.LastMember, GetLocation (yyVals[0+yyTop]));
	  	yyVal = null;
	  }

void case_219()
#line 1883 "cs-parser.jay"
{
	  	Error_SyntaxError (1043, yyToken, "Invalid accessor body");
	  	yyVal = null;
	  }

void case_221()
#line 1898 "cs-parser.jay"
{
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		push_current_class (new Interface (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]), yyVals[-3+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-2+yyTop]));		
	  }

void case_222()
#line 1905 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);

		if (doc_support) {
			current_container.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  }

void case_223()
#line 1916 "cs-parser.jay"
{
		--lexer.parsing_declaration;	  
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_224()
#line 1922 "cs-parser.jay"
{
	    lbag.AppendToMember (current_class, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_240()
#line 1974 "cs-parser.jay"
{
		OperatorDeclaration decl = (OperatorDeclaration) yyVals[-2+yyTop];
		if (decl != null) {
			Operator op = new Operator (
				current_class, decl.optype, decl.ret_type, (Modifiers) yyVals[-3+yyTop], 
				current_local_parameters,
				(ToplevelBlock) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop], decl.location);

			if (doc_support) {
				op.DocComment = tmpComment;
				Lexer.doc_state = XmlCommentState.Allowed;
			}

			/* Note again, checking is done in semantic analysis*/
			current_container.AddOperator (op);

			lbag.AddMember (op, GetModifierLocations (), lbag.GetLocations (decl));
		}
		
		current_local_parameters = null;
	  }

void case_244()
#line 2005 "cs-parser.jay"
{
		report.Error (590, GetLocation (yyVals[0+yyTop]), "User-defined operators cannot return void");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_246()
#line 2017 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		Operator.OpType op = (Operator.OpType) yyVals[-4+yyTop];
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];
		
		int p_count = current_local_parameters.Count;
		if (p_count == 1) {
			if (op == Operator.OpType.Addition)
				op = Operator.OpType.UnaryPlus;
			else if (op == Operator.OpType.Subtraction)
				op = Operator.OpType.UnaryNegation;
		}
		
		if (IsUnaryOperator (op)) {
			if (p_count == 2) {
				report.Error (1020, loc, "Overloadable binary operator expected");
			} else if (p_count != 1) {
				report.Error (1535, loc, "Overloaded unary operator `{0}' takes one parameter",
					Operator.GetName (op));
			}
		} else {
			if (p_count > 2) {
				report.Error (1534, loc, "Overloaded binary operator `{0}' takes two parameters",
					Operator.GetName (op));
			} else if (p_count != 2) {
				report.Error (1019, loc, "Overloadable unary operator expected");
			}
		}
		
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (op, (FullNamedExpression) yyVals[-6+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_271()
#line 2093 "cs-parser.jay"
{
		valid_param_mod = 0;

		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_273()
#line 2112 "cs-parser.jay"
{
		valid_param_mod = 0;
		
		Location loc = GetLocation (yyVals[-5+yyTop]);
		current_local_parameters = (ParametersCompiled)yyVals[-1+yyTop];  
		  
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}

		yyVal = new OperatorDeclaration (Operator.OpType.Explicit, (FullNamedExpression) yyVals[-4+yyTop], loc);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_274()
#line 2127 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
		yyVal = new OperatorDeclaration (Operator.OpType.Implicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_275()
#line 2133 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  	yyVal = new OperatorDeclaration (Operator.OpType.Explicit, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_276()
#line 2143 "cs-parser.jay"
{ 
		Constructor c = (Constructor) yyVals[-1+yyTop];
		c.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (doc_support)
			c.DocComment = ConsumeStoredComment ();

		current_container.AddConstructor (c);

		current_local_parameters = null;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_277()
#line 2162 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		valid_param_mod = ParameterModifierType.All;
	  }

void case_278()
#line 2171 "cs-parser.jay"
{
		valid_param_mod = 0;
		current_local_parameters = (ParametersCompiled) yyVals[-1+yyTop];  
		
		/**/
		/* start block here, so possible anonymous methods inside*/
		/* constructor initializer can get correct parent block*/
		/**/
	  	start_block (lexer.Location);
	  }

void case_279()
#line 2182 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-6+yyTop];
		var mods = (Modifiers) yyVals[-7+yyTop];
		ConstructorInitializer ci = (ConstructorInitializer) yyVals[0+yyTop];

		Constructor c = new Constructor (current_class, lt.Value, mods,
			(Attributes) yyVals[-8+yyTop], current_local_parameters, ci, lt.Location);
		
		if (lt.Value != current_container.MemberName.Name) {
			report.Error (1520, c.Location, "Class, struct, or interface method must have a return type");
		} else if ((mods & Modifiers.STATIC) != 0) {
			if ((mods & Modifiers.AccessibilityMask) != 0){
				report.Error (515, c.Location,
					"`{0}': static constructor cannot have an access modifier",
					c.GetSignatureForError ());
			}
			if (ci != null) {
				report.Error (514, c.Location,
					"`{0}': static constructor cannot have an explicit `this' or `base' constructor call",
					c.GetSignatureForError ());
			
			}
		}
		
		lbag.AddMember (c, GetModifierLocations (), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = c;
	  }

void case_285()
#line 2227 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorBaseInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_287()
#line 2237 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		yyVal = new ConstructorThisInitializer ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_288()
#line 2243 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_289()
#line 2251 "cs-parser.jay"
{
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
		
		current_local_parameters = ParametersCompiled.EmptyReadOnlyParameters;
	  }

void case_290()
#line 2260 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		if (lt.Value != current_container.MemberName.Name){
			report.Error (574, lt.Location, "Name of destructor must match name of class");
		} else if (current_container.Kind != MemberKind.Class){
			report.Error (575, lt.Location, "Only class types can contain destructor");
		}
		
		Destructor d = new Destructor (current_class, (Modifiers) yyVals[-6+yyTop],
			ParametersCompiled.EmptyReadOnlyParameters, (Attributes) yyVals[-7+yyTop], lt.Location);
		if (doc_support)
			d.DocComment = ConsumeStoredComment ();
		  
		d.Block = (ToplevelBlock) yyVals[0+yyTop];
		current_container.AddMethod (d);
		lbag.AddMember (d, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[-1+yyTop]));

		current_local_parameters = null;
	  }

void case_291()
#line 2285 "cs-parser.jay"
{
		current_event_field = new EventField (current_class, (FullNamedExpression) yyVals[-1+yyTop], (Modifiers) yyVals[-3+yyTop], (MemberName) yyVals[0+yyTop], (Attributes) yyVals[-4+yyTop]);
		current_container.AddEvent (current_event_field);
		
		if (current_event_field.MemberName.Left != null) {
			report.Error (71, current_event_field.Location, "`{0}': An explicit interface implementation of an event must use property syntax",
			current_event_field.GetSignatureForError ());
		}
		
		yyVal = current_event_field;
	  }

void case_292()
#line 2299 "cs-parser.jay"
{
		if (doc_support) {
			current_event_field.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AddMember (current_event_field, GetModifierLocations (), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		current_event_field = null;
	  }

void case_293()
#line 2312 "cs-parser.jay"
{
		current_event = new EventProperty (current_class, (FullNamedExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-4+yyTop], (MemberName) yyVals[-1+yyTop], (Attributes) yyVals[-5+yyTop]);
		current_container.AddEvent (current_event);
		lbag.AddMember (current_event, GetModifierLocations (), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		
		lexer.EventParsing = true;
	  }

void case_294()
#line 2320 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface)
			report.Error (69, GetLocation (yyVals[-2+yyTop]), "Event in interface cannot have add or remove accessors");
	  
		lexer.EventParsing = false;
	  }

void case_295()
#line 2327 "cs-parser.jay"
{
		if (doc_support) {
			current_event.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
		
		lbag.AppendToMember (current_event, GetLocation (yyVals[-1+yyTop]));
	  	current_event = null;	
		current_local_parameters = null;
	  }

void case_298()
#line 2346 "cs-parser.jay"
{
	  	--lexer.parsing_block;
		current_event_field.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_303()
#line 2370 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), null);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_305()
#line 2380 "cs-parser.jay"
{
		--lexer.parsing_block;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];	  
	  	yyVal = new FieldDeclarator (new SimpleMemberName (lt.Value, lt.Location), (Expression) yyVals[0+yyTop]);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_306()
#line 2389 "cs-parser.jay"
{
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (68, lexer.Location, "`{0}': event in interface cannot have an initializer",
				current_event_field.GetSignatureForError ());
		}
		
	  	if ((current_event_field.ModFlags & Modifiers.ABSTRACT) != 0) {
			report.Error (74, lexer.Location, "`{0}': abstract event cannot have an initializer",
				current_event_field.GetSignatureForError ());
	  	}		
	  }

void case_310()
#line 2410 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_311()
#line 2415 "cs-parser.jay"
{
		report.Error (65, lexer.Location, "`{0}': event property must have both add and remove accessors",
			current_event.GetSignatureForError ());
	  }

void case_312()
#line 2420 "cs-parser.jay"
{ 
		report.Error (1055, GetLocation (yyVals[0+yyTop]), "An add or remove accessor expected");
		yyVal = null;
	  }

void case_313()
#line 2428 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Add = new EventProperty.AddDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Add.ParameterInfo;
		
		lbag.AddMember (current_event.Add, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_314()
#line 2440 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Add.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Add.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Add.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_315()
#line 2456 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] != ModifierNone) {
			report.Error (1609, GetLocation (yyVals[-1+yyTop]), "Modifiers cannot be placed on event accessor declarations");
	  	}
	  	
	  	current_event.Remove = new EventProperty.RemoveDelegateMethod (current_event, (Attributes) yyVals[-2+yyTop], GetLocation (yyVals[0+yyTop]));
		current_local_parameters = current_event.Remove.ParameterInfo;

		lbag.AddMember (current_event.Remove, GetModifierLocations ());
		lexer.EventParsing = false;		
	  }

void case_316()
#line 2468 "cs-parser.jay"
{
		lexer.EventParsing = true;
	  
	  	current_event.Remove.Block = (ToplevelBlock) yyVals[0+yyTop];
		
		if (current_container.Kind == MemberKind.Interface) {
			report.Error (531, current_event.Remove.Block.StartLocation,
				"`{0}': interface members cannot have a definition", current_event.Remove.GetSignatureForError ());
		}
		
		current_local_parameters = null;
	  }

void case_317()
#line 2484 "cs-parser.jay"
{
		report.Error (73, lexer.Location, "An add or remove accessor must have a body");
		yyVal = null;
	  }

void case_319()
#line 2496 "cs-parser.jay"
{
		if (doc_support)
			enumTypeComment = Lexer.consume_doc_comment ();
	  }

void case_320()
#line 2501 "cs-parser.jay"
{
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;

		MemberName name = (MemberName) yyVals[-3+yyTop];
		if (name.IsGeneric) {
			report.Error (1675, name.Location, "Enums cannot have type parameters");
		}
		
		push_current_class (new Enum (current_namespace, current_class, (TypeExpression) yyVals[-2+yyTop], (Modifiers) yyVals[-5+yyTop], MakeName (name), (Attributes) yyVals[-6+yyTop]), null);
	  }

void case_321()
#line 2513 "cs-parser.jay"
{
	  	/* here will be evaluated after CLOSE_BLACE is consumed.*/
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_322()
#line 2519 "cs-parser.jay"
{
		if (doc_support)
			current_class.DocComment = enumTypeComment;
			
		--lexer.parsing_declaration;

/*			if (doc_support)*/
/*				em.DocComment = ev.DocComment;*/

		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-1+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_324()
#line 2536 "cs-parser.jay"
{
	 	var te = yyVals[0+yyTop] as TypeExpression;
		if (te == null || !EnumSpec.IsValidUnderlyingType (te.Type)) {
			Enum.Error_1008 (GetLocation (yyVals[0+yyTop]), report);
			yyVal = null;
		} else {
			yyVal = yyVals[0+yyTop];
		}
	 }

void case_325()
#line 2546 "cs-parser.jay"
{
	 	Error_TypeExpected (GetLocation (yyVals[-1+yyTop]));
		yyVal = null;
	 }

void case_330()
#line 2564 "cs-parser.jay"
{
	  	lbag.AddLocation (yyVals[-2+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	yyVal = yyVals[0+yyTop];
	  }

void case_331()
#line 2572 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
	  	var em = new EnumMember ((Enum) current_class, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-1+yyTop]);
	  	((Enum) current_class).AddEnumMember (em);

		if (doc_support) {
			em.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}

		yyVal = em;
	  }

void case_332()
#line 2585 "cs-parser.jay"
{
	  	++lexer.parsing_block;
		if (doc_support) {
			tmpComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.NotAllowed;
		}
	  }

void case_333()
#line 2593 "cs-parser.jay"
{ 
		--lexer.parsing_block;
		
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
	  	var em = new EnumMember ((Enum) current_class, new MemberName (lt.Value, lt.Location), (Attributes) yyVals[-4+yyTop]);
	  	em.Initializer = new ConstInitializer (em, (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  	((Enum) current_class).AddEnumMember (em);
		
		if (doc_support)
			em.DocComment = ConsumeStoredComment ();

		yyVal = em;
	  }

void case_335()
#line 2618 "cs-parser.jay"
{
		valid_param_mod = 0;

		MemberName name = MakeName ((MemberName) yyVals[-4+yyTop]);
		ParametersCompiled p = (ParametersCompiled) yyVals[-1+yyTop];

		Delegate del = new Delegate (current_namespace, current_class, (FullNamedExpression) yyVals[-5+yyTop],
					     (Modifiers) yyVals[-7+yyTop], name, p, (Attributes) yyVals[-8+yyTop]);

		ubag.PushTypeDeclaration (del);
		ubag.PopTypeDeclaration ();
		current_container.AddDelegate (del);
		current_delegate = del;
		lexer.ConstraintsParsing = true;
	  }

void case_337()
#line 2638 "cs-parser.jay"
{
		if (doc_support) {
			current_delegate.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  
		current_delegate.SetParameterInfo ((List<Constraints>) yyVals[-2+yyTop]);
		lbag.AddMember (current_delegate, GetModifierLocations (), GetLocation (yyVals[-10+yyTop]), GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[0+yyTop]));

		yyVal = current_delegate;

		current_delegate = null;
	  }

void case_339()
#line 2656 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "nullable types");
	  
	  	yyVal = ComposedTypeSpecifier.CreateNullable (GetLocation (yyVals[0+yyTop]));
	  }

void case_341()
#line 2667 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberName (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
	  }

void case_343()
#line 2678 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));		
	  }

void case_344()
#line 2687 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_346()
#line 2699 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");	  
	  
		yyVal = yyVals[-1+yyTop];
	  }

void case_347()
#line 2706 "cs-parser.jay"
{
		Error_TypeExpected (lexer.Location);
		yyVal = new TypeArguments ();
	  }

void case_348()
#line 2714 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_349()
#line 2720 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_351()
#line 2736 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);
	  }

void case_352()
#line 2745 "cs-parser.jay"
{
	  	MemberName mn = (MemberName)yyVals[0+yyTop];
	  	if (mn.TypeArguments != null)
	  		syntax_error (mn.Location, string.Format ("Member `{0}' cannot declare type arguments",
	  			mn.GetSignatureForError ()));
	  }

void case_354()
#line 2756 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-2+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_355()
#line 2765 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;	  
		yyVal = new MemberName (TypeContainer.DefaultIndexerName, GetLocation (yyVals[0+yyTop]));
	  }

void case_356()
#line 2770 "cs-parser.jay"
{
		lexer.parsing_generic_declaration = false;
		yyVal = new MemberName ((MemberName) yyVals[-1+yyTop], TypeContainer.DefaultIndexerName, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_357()
#line 2778 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName (lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_358()
#line 2784 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		
		yyVal = new MemberName (lt1.Value, lt2.Value, (TypeArguments) yyVals[-1+yyTop], lt1.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_359()
#line 2792 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[-1+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_361()
#line 2802 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "generics");
	  
		yyVal = yyVals[-1+yyTop];
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_362()
#line 2813 "cs-parser.jay"
{
		TypeArguments type_args = new TypeArguments ();
		type_args.Add ((FullNamedExpression)yyVals[0+yyTop]);
		yyVal = type_args;
	  }

void case_363()
#line 2819 "cs-parser.jay"
{
		TypeArguments type_args = (TypeArguments) yyVals[-2+yyTop];
		type_args.Add ((FullNamedExpression)yyVals[0+yyTop]);
		yyVal = type_args;
		lbag.AddLocation (yyVals[0+yyTop], GetLocation (yyVals[0+yyTop]));
	  }

void case_364()
#line 2829 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
		yyVal = new TypeParameterName (lt.Value, (Attributes)yyVals[-2+yyTop], (Variance) yyVals[-1+yyTop], lt.Location);
  	  }

void case_365()
#line 2834 "cs-parser.jay"
{
  	  	if (GetTokenName (yyToken) == "type")
			report.Error (81, GetLocation (yyVals[0+yyTop]), "Type parameter declaration must be an identifier not a type");
		else
			Error_SyntaxError (yyToken);
			
  	  	yyVal = new TypeParameterName ("", null, lexer.Location);
  	  }

void case_370()
#line 2868 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_372()
#line 2877 "cs-parser.jay"
{
	  	Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_374()
#line 2886 "cs-parser.jay"
{
	  	report.Error (1536, GetLocation (yyVals[0+yyTop]), "Invalid parameter type `void'");
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_377()
#line 2902 "cs-parser.jay"
{
		MemberName name = (MemberName) yyVals[-1+yyTop];

		if (yyVals[0+yyTop] != null) {
			yyVal = new ComposedCast (name.GetTypeExpression (), (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			if (name.Left == null && name.Name == "var")
				yyVal = new VarExpr (name.Location);
			else
				yyVal = name.GetTypeExpression ();
		}
	  }

void case_379()
#line 2919 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null)
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_382()
#line 2935 "cs-parser.jay"
{
		var types = new List<FullNamedExpression> (2);
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_383()
#line 2941 "cs-parser.jay"
{
		var types = (List<FullNamedExpression>) yyVals[-2+yyTop];
		types.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = types;
	  }

void case_384()
#line 2950 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast) {
			report.Error (1521, GetLocation (yyVals[0+yyTop]), "Invalid base type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
		}
		yyVal = yyVals[0+yyTop];
	  }

void case_385()
#line 2957 "cs-parser.jay"
{
	  	Error_TypeExpected (lexer.Location);
		yyVal = null;
	  }

void case_422()
#line 3019 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new SimpleName (lt.Value, (TypeArguments)yyVals[0+yyTop], lt.Location);	  
	  }

void case_423()
#line 3023 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
	       yyVal = new CompletionSimpleName (MemberName.MakeName (lt.Value, null), lt.Location);
	  }

void case_434()
#line 3064 "cs-parser.jay"
{
		yyVal = new ParenthesizedExpression ((Expression) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_436()
#line 3076 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_437()
#line 3082 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_438()
#line 3088 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_439()
#line 3094 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (TypeArguments) yyVals[0+yyTop], lt1.Location);
	  }

void case_441()
#line 3103 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
	  }

void case_443()
#line 3111 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new CompletionMemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, lt.Location);
 	  }

void case_444()
#line 3119 "cs-parser.jay"
{
		yyVal = new Invocation ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_447()
#line 3132 "cs-parser.jay"
{
	  	if (yyVals[-1+yyTop] == null) {
	  		yyVal = CollectionOrObjectInitializers.Empty;
	  		/* TODO: lbag*/
	  	} else {
	  		yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  	}
	  }

void case_448()
#line 3142 "cs-parser.jay"
{
	  	yyVal = new CollectionOrObjectInitializers ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_451()
#line 3158 "cs-parser.jay"
{
	  	var a = new List<Expression> ();
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_452()
#line 3164 "cs-parser.jay"
{
	  	var a = (List<Expression>)yyVals[-2+yyTop];
	  	a.Add ((Expression) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_453()
#line 3169 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_454()
#line 3177 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
	  	yyVal = new ElementInitializer (lt.Value, (Expression)yyVals[0+yyTop], lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_456()
#line 3186 "cs-parser.jay"
{
		CompletionSimpleName csn = yyVals[-1+yyTop] as CompletionSimpleName;
		if (csn == null)
			yyVal = new CollectionElementInitializer ((Expression)yyVals[-1+yyTop]);
		else
			yyVal = new CompletionElementInitializer (csn.Prefix, csn.Location);
	  }

void case_457()
#line 3194 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] == null)
			yyVal = null;
		else
	  		yyVal = new CollectionElementInitializer ((List<Expression>)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_458()
#line 3201 "cs-parser.jay"
{
	  	report.Error (1920, GetLocation (yyVals[-1+yyTop]), "An element initializer cannot be empty");
		yyVal = null;
	  }

void case_463()
#line 3219 "cs-parser.jay"
{ 
		Arguments list = new Arguments (4);
		list.Add ((Argument) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_464()
#line 3225 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		if (list [list.Count - 1] is NamedArgument)
			Error_NamedArgumentExpected ((NamedArgument) list [list.Count - 1]);
		
		list.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_465()
#line 3235 "cs-parser.jay"
{
		Arguments list = (Arguments) yyVals[-2+yyTop];
		NamedArgument a = (NamedArgument) yyVals[0+yyTop];
		for (int i = 0; i < list.Count; ++i) {
			NamedArgument na = list [i] as NamedArgument;
			if (na != null && na.Name == a.Name)
				report.Error (1740, na.Location, "Named argument `{0}' specified multiple times",
					na.Name);
		}
		
		list.Add (a);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_466()
#line 3250 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[0+yyTop]), "An argument is missing");
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_467()
#line 3255 "cs-parser.jay"
{
	  	report.Error (839, GetLocation (yyVals[-1+yyTop]), "An argument is missing");
	  	yyVal = null;
	  }

void case_472()
#line 3276 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Ref);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_473()
#line 3281 "cs-parser.jay"
{ 
		yyVal = new Argument ((Expression) yyVals[0+yyTop], Argument.AType.Out);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_474()
#line 3286 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist ((Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_475()
#line 3291 "cs-parser.jay"
{
		yyVal = new Argument (new Arglist (GetLocation (yyVals[-2+yyTop])));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_477()
#line 3303 "cs-parser.jay"
{
		yyVal = new ElementAccess ((Expression) yyVals[-3+yyTop], (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_478()
#line 3311 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_479()
#line 3317 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_480()
#line 3323 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = yyVals[-1+yyTop];
	  }

void case_481()
#line 3331 "cs-parser.jay"
{
		Arguments args = new Arguments (4);
		args.Add ((Argument) yyVals[0+yyTop]);
		yyVal = args;
	  }

void case_482()
#line 3337 "cs-parser.jay"
{
		Arguments args = (Arguments) yyVals[-2+yyTop];
		if (args [args.Count - 1] is NamedArgument && !(yyVals[0+yyTop] is NamedArgument))
			Error_NamedArgumentExpected ((NamedArgument) args [args.Count - 1]);
	  
		args.Add ((Argument) yyVals[0+yyTop]);
		lbag.AppendTo (args, GetLocation (yyVals[-1+yyTop]));
		yyVal = args;	  
	  }

void case_486()
#line 3365 "cs-parser.jay"
{
	  	yyVal = new ElementAccess (new BaseThis (GetLocation (yyVals[-3+yyTop])), (Arguments) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_487()
#line 3370 "cs-parser.jay"
{
	  	Error_SyntaxError (yyToken);
		yyVal = new ElementAccess (null, null, GetLocation (yyVals[-1+yyTop]));
	  }

void case_490()
#line 3392 "cs-parser.jay"
{
		if (yyVals[0+yyTop] != null) {
			if (lang_version <= LanguageVersion.ISO_2)
				FeatureIsNotAvailable (GetLocation (yyVals[-5+yyTop]), "object initializers");
				
			yyVal = new NewInitialize ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		} else {
			yyVal = new New ((FullNamedExpression) yyVals[-4+yyTop], (Arguments) yyVals[-2+yyTop], GetLocation (yyVals[-5+yyTop]));
		}
		
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_491()
#line 3405 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "collection initializers");
	  
		yyVal = new NewInitialize ((FullNamedExpression) yyVals[-1+yyTop], null, (CollectionOrObjectInitializers) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_492()
#line 3417 "cs-parser.jay"
{
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], (List<Expression>) yyVals[-3+yyTop],
				new ComposedTypeSpecifier (((List<Expression>) yyVals[-3+yyTop]).Count, GetLocation (yyVals[-4+yyTop])) {
	  				Next = (ComposedTypeSpecifier) yyVals[-1+yyTop]
			  	}, (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_493()
#line 3425 "cs-parser.jay"
{
	  	if (yyVals[0+yyTop] == null)
	  		report.Error (1586, GetLocation (yyVals[-3+yyTop]), "Array creation must have array size or array initializer");

		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-2+yyTop], (ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_494()
#line 3432 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-2+yyTop]), "implicitly typed arrays");
	  
		yyVal = new ImplicitlyTypedArrayCreation ((ComposedTypeSpecifier) yyVals[-1+yyTop], (ArrayInitializer) yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));
	  }

void case_495()
#line 3439 "cs-parser.jay"
{
		report.Error (178, GetLocation (yyVals[-1+yyTop]), "Invalid rank specifier, expecting `,' or `]'");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-5+yyTop], null, GetLocation (yyVals[-6+yyTop]));
	  }

void case_496()
#line 3444 "cs-parser.jay"
{
		Error_SyntaxError (1526, yyToken, "Unexpected symbol");
		yyVal = new ArrayCreation ((FullNamedExpression) yyVals[-1+yyTop], null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_498()
#line 3455 "cs-parser.jay"
{
		--lexer.parsing_type;
		yyVal = yyVals[0+yyTop];
	  }

void case_499()
#line 3463 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
	  		FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "anonymous types");

		yyVal = new NewAnonymousType ((List<AnonymousTypeParameter>) yyVals[-1+yyTop], current_container, GetLocation (yyVals[-3+yyTop]));
		
		/* TODO: lbag comma location*/
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_504()
#line 3486 "cs-parser.jay"
{
	  	var a = new List<AnonymousTypeParameter> (4);
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_505()
#line 3492 "cs-parser.jay"
{
	  	var a = (List<AnonymousTypeParameter>) yyVals[-2+yyTop];
	  	a.Add ((AnonymousTypeParameter) yyVals[0+yyTop]);
	  	yyVal = a;
	  }

void case_506()
#line 3501 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[-2+yyTop];
	  	yyVal = new AnonymousTypeParameter ((Expression)yyVals[0+yyTop], lt.Value, lt.Location);
	  	lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_507()
#line 3507 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken)yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (new SimpleName (lt.Value, lt.Location),
	  		lt.Value, lt.Location);
	  }

void case_508()
#line 3513 "cs-parser.jay"
{
	  	MemberAccess ma = (MemberAccess) yyVals[0+yyTop];
	  	yyVal = new AnonymousTypeParameter (ma, ma.Name, ma.Location);
	  }

void case_509()
#line 3518 "cs-parser.jay"
{
		report.Error (746, lexer.Location,
			"Invalid anonymous type member declarator. Anonymous type members must be a member assignment, simple name or member access expression");
		yyVal = null;
	  }

void case_513()
#line 3533 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_514()
#line 3541 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension (1, GetLocation (yyVals[-1+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_515()
#line 3546 "cs-parser.jay"
{
		yyVal = ComposedTypeSpecifier.CreateArrayDimension ((int)yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_520()
#line 3576 "cs-parser.jay"
{
		var ai = new ArrayInitializer (0, GetLocation (yyVals[-1+yyTop]));
		ai.VariableDeclaration = current_variable;
		lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		yyVal = ai;
	  }

void case_521()
#line 3583 "cs-parser.jay"
{
		var ai = new ArrayInitializer ((List<Expression>) yyVals[-2+yyTop], GetLocation (yyVals[-3+yyTop]));
		ai.VariableDeclaration = current_variable;
		if (yyVals[-1+yyTop] != null) {
			lbag.AddLocation (ai, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (ai, GetLocation (yyVals[0+yyTop]));
		}
		yyVal = ai;
	  }

void case_522()
#line 3597 "cs-parser.jay"
{
		var list = new List<Expression> (4);
		list.Add ((Expression) yyVals[0+yyTop]);
		yyVal = list;
	  }

void case_523()
#line 3603 "cs-parser.jay"
{
		var list = (List<Expression>) yyVals[-2+yyTop];
		list.Add ((Expression) yyVals[0+yyTop]);
		lbag.AppendTo (list, GetLocation (yyVals[-1+yyTop]));
		yyVal = list;
	  }

void case_525()
#line 3617 "cs-parser.jay"
{
	  	lexer.TypeOfParsing = false;
		yyVal = new TypeOf ((FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_528()
#line 3628 "cs-parser.jay"
{
	 	Error_TypeExpected (lexer.Location);
	 	yyVal = null;
	 }

void case_529()
#line 3636 "cs-parser.jay"
{  
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new SimpleName (lt.Value, (int) yyVals[0+yyTop], lt.Location);
	  }

void case_530()
#line 3642 "cs-parser.jay"
{
		var lt1 = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var lt2 = (Tokenizer.LocatedToken) yyVals[-1+yyTop];

		yyVal = new QualifiedAliasMember (lt1.Value, lt2.Value, (int) yyVals[0+yyTop], lt1.Location);
	  }

void case_531()
#line 3649 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-2+yyTop], lt.Value, lt.Location);		
	  }

void case_532()
#line 3655 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		
		yyVal = new MemberAccess ((Expression) yyVals[-3+yyTop], lt.Value, (int) yyVals[0+yyTop], lt.Location);		
	  }

void case_533()
#line 3661 "cs-parser.jay"
{
		var te = ((MemberName) yyVals[-3+yyTop]).GetTypeExpression ();
		if (te.HasTypeArguments)
			Error_TypeExpected (GetLocation (yyVals[0+yyTop]));

		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (te, lt.Value, (int) yyVals[0+yyTop], lt.Location);		
	  }

void case_534()
#line 3673 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "generics");

		yyVal = yyVals[0+yyTop];
	  }

void case_535()
#line 3683 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		if (lang_version == LanguageVersion.ISO_1)
			FeatureIsNotAvailable (lt.Location, "namespace alias qualifier");

		yyVal = lt;		
	  }

void case_536()
#line 3694 "cs-parser.jay"
{ 
		yyVal = new SizeOf ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_537()
#line 3702 "cs-parser.jay"
{
		yyVal = new CheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_538()
#line 3710 "cs-parser.jay"
{
		yyVal = new UnCheckedExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_539()
#line 3718 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberAccess (new Indirection ((Expression) yyVals[-3+yyTop], GetLocation (yyVals[-2+yyTop])), lt.Value, (TypeArguments) yyVals[0+yyTop], lt.Location);
	  }

void case_541()
#line 3730 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		if ((ParametersCompiled) yyVals[-2+yyTop] != ParametersCompiled.Undefined) {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), savedOpenLocation, savedCloseLocation);
		} else {
			lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]));
		}
	  }

void case_545()
#line 3754 "cs-parser.jay"
{
		valid_param_mod = 0;
	  	yyVal = yyVals[-1+yyTop];
	  	savedOpenLocation = GetLocation (yyVals[-3+yyTop]);
	  	savedCloseLocation = GetLocation (yyVals[-2+yyTop]);
	  }

void case_546()
#line 3764 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-3+yyTop]), "default value expression");

		yyVal = new DefaultValueExpression ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_551()
#line 3788 "cs-parser.jay"
{
		yyVal = new Cast ((FullNamedExpression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_560()
#line 3829 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Multiply, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_561()
#line 3834 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Division, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_562()
#line 3839 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Modulus, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_564()
#line 3848 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Addition, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_566()
#line 3857 "cs-parser.jay"
{
	  	/* Shift/Reduce conflict*/
		yyVal = new Binary (Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
  	  }

void case_570()
#line 3874 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LeftShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_571()
#line 3879 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.RightShift, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_573()
#line 3888 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_574()
#line 3893 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThan, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_575()
#line 3898 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LessThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_576()
#line 3903 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.GreaterThanOrEqual, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_578()
#line 3912 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Equality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_579()
#line 3917 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.Inequality, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_581()
#line 3926 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_583()
#line 3935 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.ExclusiveOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_585()
#line 3944 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.BitwiseOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_587()
#line 3953 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalAnd, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_589()
#line 3962 "cs-parser.jay"
{
		yyVal = new Binary (Binary.Operator.LogicalOr, 
			         (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_591()
#line 3971 "cs-parser.jay"
{
		if (lang_version < LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[-1+yyTop]), "null coalescing operator");
			
		yyVal = new Nullable.NullCoalescingOperator ((Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_593()
#line 3982 "cs-parser.jay"
{
		yyVal = new Conditional (new BooleanExpression ((Expression) yyVals[-4+yyTop]), (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_595()
#line 3994 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Multiply, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_596()
#line 3999 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Division, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_597()
#line 4004 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Modulus, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_598()
#line 4009 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Addition, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_599()
#line 4014 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.Subtraction, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_600()
#line 4019 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.LeftShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_601()
#line 4024 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.RightShift, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_602()
#line 4029 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseAnd, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_603()
#line 4034 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.BitwiseOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_604()
#line 4039 "cs-parser.jay"
{
		yyVal = new CompoundAssign (
			Binary.Operator.ExclusiveOr, (Expression) yyVals[-2+yyTop], (Expression) yyVals[0+yyTop], GetLocation (yyVals[-1+yyTop]));
	  }

void case_605()
#line 4047 "cs-parser.jay"
{
		var pars = new List<Parameter> (4);
		pars.Add ((Parameter) yyVals[0+yyTop]);

		yyVal = pars;
	  }

void case_606()
#line 4054 "cs-parser.jay"
{
		var pars = (List<Parameter>) yyVals[-2+yyTop];
		Parameter p = (Parameter)yyVals[0+yyTop];
		if (pars[0].GetType () != p.GetType ()) {
			report.Error (748, p.Location, "All lambda parameters must be typed either explicitly or implicitly");
		}
		
		pars.Add (p);
		yyVal = pars;
	  }

void case_607()
#line 4068 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, (Parameter.Modifier) yyVals[-2+yyTop], null, lt.Location);
	  }

void case_608()
#line 4074 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];

		yyVal = new Parameter ((FullNamedExpression) yyVals[-1+yyTop], lt.Value, Parameter.Modifier.NONE, null, lt.Location);
	  }

void case_609()
#line 4080 "cs-parser.jay"
{
	  	var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		yyVal = new ImplicitLambdaParameter (lt.Value, lt.Location);
	  }

void case_611()
#line 4088 "cs-parser.jay"
{ 
		var pars_list = (List<Parameter>) yyVals[0+yyTop];
		yyVal = new ParametersCompiled (pars_list.ToArray ());
	  }

void case_615()
#line 4104 "cs-parser.jay"
{
		Block b = end_block (lexer.Location);
		b.IsCompilerGenerated = true;
		b.AddStatement (new ContextualReturn ((Expression) yyVals[0+yyTop]));
		yyVal = b;
	  }

void case_617()
#line 4115 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	
		yyVal = EmptyExpression.Null;
	  }

void case_618()
#line 4123 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		Parameter p = new ImplicitLambdaParameter (lt.Value, lt.Location);
		start_anonymous (true, new ParametersCompiled (p), GetLocation (yyVals[-1+yyTop]));
	  }

void case_619()
#line 4129 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
	  }

void case_620()
#line 4134 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.ISO_2)
			FeatureIsNotAvailable (GetLocation (yyVals[0+yyTop]), "lambda expressions");
	  
	  	valid_param_mod = ParameterModifierType.Ref | ParameterModifierType.Out;
	  }

void case_621()
#line 4141 "cs-parser.jay"
{
	  	valid_param_mod = 0;
		start_anonymous (true, (ParametersCompiled) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]));
	  }

void case_622()
#line 4146 "cs-parser.jay"
{
		yyVal = end_anonymous ((ParametersBlock) yyVals[0+yyTop]);
		lbag.AddLocation (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-2+yyTop]));
	  }

void case_629()
#line 4169 "cs-parser.jay"
{
		yyVal = new RefValueExpr ((Expression) yyVals[-3+yyTop], (FullNamedExpression) yyVals[-1+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_630()
#line 4174 "cs-parser.jay"
{
		yyVal = new RefTypeExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_631()
#line 4179 "cs-parser.jay"
{
		yyVal = new MakeRefExpr ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));	  
	  }

void case_635()
#line 4208 "cs-parser.jay"
{
		MemberName name = MakeName ((MemberName) yyVals[0+yyTop]);
		Class c = new Class (current_namespace, current_class, name, (Modifiers) yyVals[-4+yyTop], (Attributes) yyVals[-5+yyTop]);
		if (((c.ModFlags & Modifiers.STATIC) != 0) && lang_version == LanguageVersion.ISO_1) {
			FeatureIsNotAvailable (c.Location, "static classes");
		}
			
		push_current_class (c, yyVals[-3+yyTop]);
	  }

void case_636()
#line 4219 "cs-parser.jay"
{
		lexer.ConstraintsParsing = false;

		current_class.SetParameterInfo ((List<Constraints>) yyVals[0+yyTop]);
		lbag.AddMember (current_class, GetModifierLocations (), GetLocation (yyVals[-5+yyTop]));

		if (doc_support) {
			current_container.DocComment = Lexer.consume_doc_comment ();
			Lexer.doc_state = XmlCommentState.Allowed;
		}
	  }

void case_637()
#line 4231 "cs-parser.jay"
{
		--lexer.parsing_declaration;
		if (doc_support)
			Lexer.doc_state = XmlCommentState.Allowed;
	  }

void case_638()
#line 4237 "cs-parser.jay"
{
		lbag.AppendToMember (current_class, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = pop_current_class ();
	  }

void case_641()
#line 4252 "cs-parser.jay"
{
	    mod_locations = null;
		yyVal = ModifierNone;
	  }

void case_644()
#line 4262 "cs-parser.jay"
{ 
		var m1 = (Modifiers) yyVals[-1+yyTop];
		var m2 = (Modifiers) yyVals[0+yyTop];

		if ((m1 & m2) != 0) {
			report.Error (1004, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"Duplicate `{0}' modifier", ModifiersExtensions.Name (m2));
		} else if ((m2 & Modifiers.AccessibilityMask) != 0 && (m1 & Modifiers.AccessibilityMask) != 0 &&
			((m2 | m1 & Modifiers.AccessibilityMask) != (Modifiers.PROTECTED | Modifiers.INTERNAL))) {
			report.Error (107, lexer.Location - ModifiersExtensions.Name (m2).Length,
				"More than one protection modifier specified");
		}
		
		yyVal = m1 | m2;
	  }

void case_645()
#line 4281 "cs-parser.jay"
{
		yyVal = Modifiers.NEW;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		
		if (current_container == module)
			report.Error (1530, GetLocation (yyVals[0+yyTop]), "Keyword `new' is not allowed on namespace elements");
	  }

void case_646()
#line 4289 "cs-parser.jay"
{
		yyVal = Modifiers.PUBLIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_647()
#line 4294 "cs-parser.jay"
{
		yyVal = Modifiers.PROTECTED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_648()
#line 4299 "cs-parser.jay"
{
		yyVal = Modifiers.INTERNAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_649()
#line 4304 "cs-parser.jay"
{
		yyVal = Modifiers.PRIVATE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_650()
#line 4309 "cs-parser.jay"
{
		yyVal = Modifiers.ABSTRACT;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_651()
#line 4314 "cs-parser.jay"
{
		yyVal = Modifiers.SEALED;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_652()
#line 4319 "cs-parser.jay"
{
		yyVal = Modifiers.STATIC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_653()
#line 4324 "cs-parser.jay"
{
		yyVal = Modifiers.READONLY;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_654()
#line 4329 "cs-parser.jay"
{
		yyVal = Modifiers.VIRTUAL;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_655()
#line 4334 "cs-parser.jay"
{
		yyVal = Modifiers.OVERRIDE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_656()
#line 4339 "cs-parser.jay"
{
		yyVal = Modifiers.EXTERN;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_657()
#line 4344 "cs-parser.jay"
{
		yyVal = Modifiers.VOLATILE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_658()
#line 4349 "cs-parser.jay"
{
		yyVal = Modifiers.UNSAFE;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_659()
#line 4356 "cs-parser.jay"
{
		yyVal = Modifiers.ASYNC;
		StoreModifierLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_664()
#line 4377 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	 }

void case_665()
#line 4385 "cs-parser.jay"
{
		var constraints = new List<Constraints> (1);
		constraints.Add ((Constraints) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_666()
#line 4391 "cs-parser.jay"
{
		var constraints = (List<Constraints>) yyVals[-1+yyTop];
		Constraints new_constraint = (Constraints)yyVals[0+yyTop];

		foreach (Constraints c in constraints) {
			if (new_constraint.TypeParameter.Value == c.TypeParameter.Value) {
				report.Error (409, new_constraint.Location,
					"A constraint clause has already been specified for type parameter `{0}'",
					new_constraint.TypeParameter.Value);
			}
		}

		constraints.Add (new_constraint);
		yyVal = constraints;
	  }

void case_667()
#line 4410 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		yyVal = new Constraints (new SimpleMemberName (lt.Value, lt.Location), (List<FullNamedExpression>) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
	  }

void case_668()
#line 4418 "cs-parser.jay"
{
		var constraints = new List<FullNamedExpression> (1);
		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_669()
#line 4424 "cs-parser.jay"
{
		var constraints = (List<FullNamedExpression>) yyVals[-2+yyTop];
		var prev = constraints [constraints.Count - 1] as SpecialContraintExpr;
		if (prev != null && (prev.Constraint & SpecialConstraint.Constructor) != 0) {			
			report.Error (401, GetLocation (yyVals[-1+yyTop]), "The `new()' constraint must be the last constraint specified");
		}
		
		prev = yyVals[0+yyTop] as SpecialContraintExpr;
		if (prev != null) {
			if ((prev.Constraint & (SpecialConstraint.Class | SpecialConstraint.Struct)) != 0) {
				report.Error (449, prev.Location, "The `class' or `struct' constraint must be the first constraint specified");			
			} else {
			 	prev = constraints [0] as SpecialContraintExpr;
			 	if (prev != null && (prev.Constraint & SpecialConstraint.Struct) != 0) {			
					report.Error (451, GetLocation (yyVals[0+yyTop]), "The `new()' constraint cannot be used with the `struct' constraint");
				}
			}
		}

		constraints.Add ((FullNamedExpression) yyVals[0+yyTop]);
		yyVal = constraints;
	  }

void case_670()
#line 4450 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is ComposedCast)
			report.Error (706, GetLocation (yyVals[0+yyTop]), "Invalid constraint type `{0}'", ((ComposedCast)yyVals[0+yyTop]).GetSignatureForError ());
	  
	  	yyVal = yyVals[0+yyTop];
	  }

void case_671()
#line 4457 "cs-parser.jay"
{
		yyVal = new SpecialContraintExpr (SpecialConstraint.Constructor, GetLocation (yyVals[-2+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_675()
#line 4477 "cs-parser.jay"
{
		if (lang_version <= LanguageVersion.V_3)
			FeatureIsNotAvailable (lexer.Location, "generic type variance");

		yyVal = yyVals[0+yyTop];
	  }

void case_678()
#line 4511 "cs-parser.jay"
{
		++lexer.parsing_block;
		start_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_680()
#line 4523 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_681()
#line 4528 "cs-parser.jay"
{
	 	--lexer.parsing_block;
		yyVal = end_block (lexer.Location);
	  }

void case_682()
#line 4537 "cs-parser.jay"
{
		++lexer.parsing_block;
		current_block.StartLocation = GetLocation (yyVals[0+yyTop]);
	  }

void case_683()
#line 4542 "cs-parser.jay"
{
		--lexer.parsing_block;
		yyVal = end_block (GetLocation (yyVals[0+yyTop]));
	  }

void case_691()
#line 4569 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_724()
#line 4633 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_725()
#line 4638 "cs-parser.jay"
{
		  report.Error (1023, GetLocation (yyVals[0+yyTop]), "An embedded statement may not be a declaration or labeled statement");
		  yyVal = null;
	  }

void case_726()
#line 4643 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_727()
#line 4651 "cs-parser.jay"
{
		/* Uses lexer.Location because semicolon location is not kept in quick mode*/
		yyVal = new EmptyStatement (lexer.Location);
	  }

void case_728()
#line 4659 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		LabeledStatement labeled = new LabeledStatement (lt.Value, current_block, lt.Location);

		current_block.AddLabel (labeled);
		current_block.AddStatement (labeled);
	  }

void case_731()
#line 4672 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] is VarExpr)
			yyVals[-1+yyTop] = new SimpleName ("var", ((VarExpr) yyVals[-1+yyTop]).Location);
	  
		yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_732()
#line 4688 "cs-parser.jay"
{ 
		/* Ok, the above "primary_expression" is there to get rid of*/
		/* both reduce/reduce and shift/reduces in the grammar, it should*/
		/* really just be "type_name".  If you use type_name, a reduce/reduce*/
		/* creeps up.  If you use namespace_or_type_name (which is all we need*/
		/* really) two shift/reduces appear.*/
		/* */

		/* So the super-trick is that primary_expression*/
		/* can only be either a SimpleName or a MemberAccess. */
		/* The MemberAccess case arises when you have a fully qualified type-name like :*/
		/* Foo.Bar.Blah i;*/
		/* SimpleName is when you have*/
		/* Blah i;*/
		
		Expression expr = (Expression) yyVals[-1+yyTop];
		if (yyVals[0+yyTop] == null) {
			SimpleName sn = expr as SimpleName;
			if (sn != null && sn.Name == "var")
				yyVal = new VarExpr (sn.Location);
			else
				yyVal = yyVals[-1+yyTop];
		} else if (expr is ATypeNameExpression) {
			yyVal = new ComposedCast ((ATypeNameExpression)expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName (expr);
			yyVal = null;
		}
	  }

void case_733()
#line 4718 "cs-parser.jay"
{
		ATypeNameExpression expr = yyVals[-1+yyTop] as ATypeNameExpression;

		if (expr != null) {
			yyVal = new ComposedCast (expr, (ComposedTypeSpecifier) yyVals[0+yyTop]);
		} else {
			Error_ExpectingTypeName ((Expression)yyVals[-1+yyTop]);
			yyVal = expr;
		}
	  }

void case_734()
#line 4729 "cs-parser.jay"
{
		if (yyVals[0+yyTop] == null)
			yyVal = yyVals[-1+yyTop];
		else
			yyVal = new ComposedCast ((FullNamedExpression) yyVals[-1+yyTop], (ComposedTypeSpecifier) yyVals[0+yyTop]);
	  }

void case_737()
#line 4744 "cs-parser.jay"
{
		Expression.Error_VoidInvalidInTheContext (GetLocation (yyVals[0+yyTop]), report);
		yyVal = new TypeExpression (compiler.BuiltinTypes.Void, GetLocation (yyVals[0+yyTop]));
	  }

void case_739()
#line 4753 "cs-parser.jay"
{
	  	((ComposedTypeSpecifier) yyVals[-1+yyTop]).Next = (ComposedTypeSpecifier) yyVals[0+yyTop];
	  	yyVal = yyVals[-1+yyTop];
	  }

void case_741()
#line 4768 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_742()
#line 4775 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
		lbag.AppendTo (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_743()
#line 4781 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockConstantDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_744()
#line 4788 "cs-parser.jay"
{
		if (current_variable.Initializer != null) {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), savedLocation, GetLocation (yyVals[0+yyTop]));
		} else {
			lbag.AddLocation (current_variable, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[0+yyTop]));
		}
		yyVal = current_variable;;
		current_variable = null;
	  }

void case_746()
#line 4802 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		lbag.AppendTo (current_variable, GetLocation (yyVals[-1+yyTop]));
	  }

void case_747()
#line 4807 "cs-parser.jay"
{
	  	if (yyToken == Token.OPEN_BRACKET_EXPR) {
			report.Error (650, lexer.Location,
				"Syntax error, bad array declarator. To declare a managed array the rank specifier precedes the variable's identifier. To declare a fixed size buffer field, use the fixed keyword before the field type");
		} else {
			Error_SyntaxError (yyToken);
		}
	  }

void case_752()
#line 4829 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, null);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-1+yyTop]));
	  }

void case_753()
#line 4838 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_variable.Variable, lt.Value, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_755()
#line 4854 "cs-parser.jay"
{
		savedLocation = GetLocation (yyVals[-1+yyTop]);
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
	  }

void case_760()
#line 4872 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];	  
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.Constant, lt.Location);
		var d = new BlockVariableDeclaration.Declarator (li, (Expression) yyVals[0+yyTop]);
		current_variable.AddDeclarator (d);
		current_block.AddLocalName (li);
	  	lbag.AddLocation (d, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_762()
#line 4885 "cs-parser.jay"
{
		yyVal = new StackAlloc ((Expression) yyVals[-3+yyTop], (Expression) yyVals[-1+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_763()
#line 4890 "cs-parser.jay"
{
		report.Error (1575, GetLocation (yyVals[-1+yyTop]), "A stackalloc expression requires [] after type");
		yyVal = new StackAlloc ((Expression) yyVals[0+yyTop], null, GetLocation (yyVals[-1+yyTop]));		
	  }

void case_764()
#line 4898 "cs-parser.jay"
{
		yyVal = yyVals[-1+yyTop];
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_768()
#line 4916 "cs-parser.jay"
{
		ExpressionStatement s = yyVals[0+yyTop] as ExpressionStatement;
		if (s == null) {
			Expression.Error_InvalidExpressionStatement (report, GetLocation (yyVals[0+yyTop]));
			s = EmptyExpressionStatement.Instance;
		}

		yyVal = new StatementExpression (s);
	  }

void case_769()
#line 4929 "cs-parser.jay"
{
		Expression expr = (Expression) yyVals[0+yyTop];
		ExpressionStatement s;

	        s = new OptionalAssign (new SimpleName ("$retval", lexer.Location), expr, lexer.Location);
		yyVal = new StatementExpression (s);
	  }

void case_770()
#line 4937 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = new EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_773()
#line 4951 "cs-parser.jay"
{ 
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
		
		yyVal = new If ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_774()
#line 4960 "cs-parser.jay"
{
		yyVal = new If ((BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		
		if (yyVals[-2+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[-2+yyTop]));
		if (yyVals[0+yyTop] is EmptyStatement)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  }

void case_776()
#line 4977 "cs-parser.jay"
{
		yyVal = new Switch ((Expression) yyVals[-5+yyTop], (ExplicitBlock) current_block.Explicit, (List<SwitchSection>) yyVals[-1+yyTop], GetLocation (yyVals[-7+yyTop]));	
		end_block (GetLocation (yyVals[0+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_777()
#line 4986 "cs-parser.jay"
{
		report.Warning (1522, 1, current_block.StartLocation, "Empty switch block"); 
		yyVal = new List<SwitchSection> ();
	  }

void case_779()
#line 4995 "cs-parser.jay"
{
		var sections = new List<SwitchSection> (4);

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_780()
#line 5002 "cs-parser.jay"
{
		var sections = (List<SwitchSection>) yyVals[-1+yyTop];

		sections.Add ((SwitchSection) yyVals[0+yyTop]);
		yyVal = sections;
	  }

void case_781()
#line 5009 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);	  
		yyVal = new List<SwitchSection> ();
	  }

void case_784()
#line 5028 "cs-parser.jay"
{
		var labels = new List<SwitchLabel> (2);

		labels.Add ((SwitchLabel) yyVals[0+yyTop]);
		yyVal = labels;
	  }

void case_785()
#line 5035 "cs-parser.jay"
{
		var labels = (List<SwitchLabel>) (yyVals[-1+yyTop]);
		labels.Add ((SwitchLabel) yyVals[0+yyTop]);

		yyVal = labels;
	  }

void case_786()
#line 5045 "cs-parser.jay"
{
	 	yyVal = new SwitchLabel ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
	 	lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	 }

void case_792()
#line 5064 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new While ((BooleanExpression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_793()
#line 5076 "cs-parser.jay"
{
		yyVal = new Do ((Statement) yyVals[-5+yyTop], (BooleanExpression) yyVals[-2+yyTop], GetLocation (yyVals[-6+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_794()
#line 5084 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[0+yyTop]));
		current_block.IsCompilerGenerated = true;
	  }

void case_796()
#line 5100 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		For f = new For ((Statement) yyVals[-6+yyTop], (BooleanExpression) yyVals[-4+yyTop], (Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, current_block.StartLocation, GetLocation (yyVals[-5+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));

		yyVal = end_block (GetLocation (yyVals[-5+yyTop]));
	  }

void case_797()
#line 5112 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = end_block (current_block.StartLocation);
	  }

void case_800()
#line 5125 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new BlockVariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_801()
#line 5132 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_809()
#line 5156 "cs-parser.jay"
{
	  	var sl = yyVals[-2+yyTop] as StatementList;
	  	if (sl == null) {
	  		sl = new StatementList ((Statement) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop]);
			lbag.AddStatement (sl, GetLocation (yyVals[-1+yyTop]));
	  	} else {
	  		sl.Add ((Statement) yyVals[0+yyTop]);
	  		lbag.AppendTo (sl, GetLocation (yyVals[-1+yyTop]));
	  	}
	  		
		yyVal = sl;
	  }

void case_810()
#line 5172 "cs-parser.jay"
{
		report.Error (230, GetLocation (yyVals[-5+yyTop]), "Type and identifier are both required in a foreach statement");
		yyVal = null;
	  }

void case_811()
#line 5177 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-5+yyTop]));
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.ForeachVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		yyVal = li;
	  }

void case_812()
#line 5186 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Foreach f = new Foreach ((Expression) yyVals[-6+yyTop], (LocalVariable) yyVals[-1+yyTop], (Expression) yyVals[-3+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-8+yyTop]));
		current_block.AddStatement (f);
		
		lbag.AddStatement (f, GetLocation (yyVals[-7+yyTop]), GetLocation (yyVals[-4+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_819()
#line 5209 "cs-parser.jay"
{
		yyVal = new Break (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_820()
#line 5217 "cs-parser.jay"
{
		yyVal = new Continue (GetLocation (yyVals[-1+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_821()
#line 5225 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new Goto (lt.Value, GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_822()
#line 5231 "cs-parser.jay"
{
		yyVal = new GotoCase ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_823()
#line 5236 "cs-parser.jay"
{
		yyVal = new GotoDefault (GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_824()
#line 5244 "cs-parser.jay"
{
		yyVal = new Return ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_825()
#line 5252 "cs-parser.jay"
{
		yyVal = new Throw ((Expression) yyVals[-1+yyTop], GetLocation (yyVals[-2+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_826()
#line 5260 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (yyVals[-1+yyTop] == null) {
			report.Error (1627, GetLocation (yyVals[0+yyTop]), "Expression expected after yield return");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new Yield ((Expression) yyVals[-1+yyTop], lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-2+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_827()
#line 5276 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		string s = lt.Value;
		if (s != "yield"){
			report.Error (1003, lt.Location, "; expected");
		} else if (lang_version == LanguageVersion.ISO_1){
			FeatureIsNotAvailable (lt.Location, "iterators");
		}
		
		current_block.ParametersBlock.TopBlock.IsIterator = true;
		yyVal = new YieldBreak (lt.Location);
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]), GetLocation (yyVals[0+yyTop]));
	  }

void case_831()
#line 5302 "cs-parser.jay"
{
		yyVal = new TryFinally ((Statement) yyVals[-2+yyTop], (Block) yyVals[0+yyTop], GetLocation (yyVals[-3+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_832()
#line 5307 "cs-parser.jay"
{
		yyVal = new TryFinally (new TryCatch ((Block) yyVals[-3+yyTop], (List<Catch>) yyVals[-2+yyTop], GetLocation (yyVals[-4+yyTop]), true), (Block) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-1+yyTop]));
	  }

void case_833()
#line 5312 "cs-parser.jay"
{
		report.Error (1524, GetLocation (yyVals[-2+yyTop]), "Expected catch or finally");
		yyVal = null;
	  }

void case_834()
#line 5320 "cs-parser.jay"
{
		var l = new List<Catch> (2);

		l.Add ((Catch) yyVals[0+yyTop]);
		yyVal = l;
	  }

void case_835()
#line 5327 "cs-parser.jay"
{
		var l = (List<Catch>) yyVals[-1+yyTop];
		
		Catch c = (Catch) yyVals[0+yyTop];
		if (l [0].IsGeneral) {
			report.Error (1017, c.loc, "Try statement already has an empty catch block");
		} else {
			if (c.IsGeneral)
				l.Insert (0, c);
			else
				l.Add (c);
		}
		
		yyVal = l;
	  }

void case_839()
#line 5355 "cs-parser.jay"
{
		start_block (GetLocation (yyVals[-3+yyTop]));
		var c = new Catch (current_block, GetLocation (yyVals[-4+yyTop]));
		c.TypeExpression = (FullNamedExpression) yyVals[-2+yyTop];

		if (yyVals[-1+yyTop] != null) {
			var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
			c.Variable = new LocalVariable (current_block, lt.Value, lt.Location);
			current_block.AddLocalName (c.Variable);
		}

		lbag.AddLocation (c, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		yyVal = c;
	  }

void case_841()
#line 5374 "cs-parser.jay"
{
	  	if (yyToken == Token.CLOSE_PARENS) {
			report.Error (1015, lexer.Location,
				"A type that derives from `System.Exception', `object', or `string' expected");
		} else {
			Error_SyntaxError (yyToken);
		}
		
		yyVal = new Catch (null, GetLocation (yyVals[-2+yyTop]));
	  }

void case_844()
#line 5402 "cs-parser.jay"
{
		if (!settings.Unsafe)
			Error_UnsafeCodeNotAllowed (GetLocation (yyVals[0+yyTop]));
	  }

void case_846()
#line 5412 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		yyVal = new Lock ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (yyVal, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
	  }

void case_847()
#line 5423 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.FixedVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Fixed.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_848()
#line 5433 "cs-parser.jay"
{
		yyVal = current_variable;
		current_variable = null;
	  }

void case_849()
#line 5438 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Fixed f = new Fixed ((Fixed.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		current_block.AddStatement (f);
		lbag.AddStatement (f, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_850()
#line 5451 "cs-parser.jay"
{
	    start_block (GetLocation (yyVals[-2+yyTop]));
	    
		current_block.IsCompilerGenerated = true;
		var lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
		var li = new LocalVariable (current_block, lt.Value, LocalVariable.Flags.UsingVariable | LocalVariable.Flags.Used, lt.Location);
		current_block.AddLocalName (li);
		current_variable = new Using.VariableDeclaration ((FullNamedExpression) yyVals[-1+yyTop], li);
	  }

void case_851()
#line 5461 "cs-parser.jay"
{
		yyVal = current_variable;	  
		current_variable = null;
	  }

void case_852()
#line 5466 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Using.VariableDeclaration) yyVals[-1+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-9+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-8+yyTop]), GetLocation (yyVals[-2+yyTop]));
		current_block.AddStatement (u);
		yyVal = end_block (GetLocation (yyVals[-2+yyTop]));
	  }

void case_853()
#line 5476 "cs-parser.jay"
{
		if (yyVals[0+yyTop] is EmptyStatement && lexer.peek_token () == Token.OPEN_BRACE)
			Warning_EmptyStatement (GetLocation (yyVals[0+yyTop]));
	  
		Using u = new Using ((Expression) yyVals[-2+yyTop], (Statement) yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddStatement (u, GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[-1+yyTop]));
		yyVal = u;
	  }

void case_855()
#line 5492 "cs-parser.jay"
{
		current_variable.Initializer = (Expression) yyVals[0+yyTop];
		yyVal = current_variable;
	  }

void case_856()
#line 5503 "cs-parser.jay"
{
		lexer.query_parsing = false;
			
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_857()
#line 5515 "cs-parser.jay"
{
		Linq.AQueryClause from = yyVals[-1+yyTop] as Linq.AQueryClause;
			
		from.Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = from;
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_858()
#line 5526 "cs-parser.jay"
{
	        lexer.query_parsing = false;
		yyVal = yyVals[-1+yyTop];

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_859()
#line 5533 "cs-parser.jay"
{
	        yyVal = yyVals[-1+yyTop];
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_860()
#line 5542 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop])));
	  }

void case_861()
#line 5550 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (
			new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
			}
		);
	  }

void case_862()
#line 5565 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-3+yyTop])));
	  }

void case_863()
#line 5573 "cs-parser.jay"
{
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.QueryExpression (
			new Linq.QueryStartClause ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], rv, GetLocation (yyVals[-4+yyTop])) {
				IdentifierType = (FullNamedExpression)yyVals[-3+yyTop]
			}
		);
	  }

void case_865()
#line 5592 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_867()
#line 5607 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);

		yyVal = new Linq.SelectMany ((Linq.QueryBlock)current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop])) {
			IdentifierType = (FullNamedExpression)yyVals[-4+yyTop]
		};
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_868()
#line 5624 "cs-parser.jay"
{
	  	Linq.AQueryClause head = (Linq.AQueryClause)yyVals[-1+yyTop];
		
		if (yyVals[0+yyTop] != null)
			head.Next = (Linq.AQueryClause)yyVals[0+yyTop];
				
		if (yyVals[-2+yyTop] != null) {
			Linq.AQueryClause clause = (Linq.AQueryClause)yyVals[-2+yyTop];
			clause.Tail.Next = head;
			head = clause;
		}
		
		yyVal = head;
	  }

void case_870()
#line 5640 "cs-parser.jay"
{
		Error_SyntaxError (yyToken);
		yyVal = null;
	  }

void case_872()
#line 5652 "cs-parser.jay"
{
		yyVal = new Linq.Select ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_873()
#line 5659 "cs-parser.jay"
{
	  	if (linq_clause_blocks == null)
	  		linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
	  	current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  	linq_clause_blocks.Push ((Linq.QueryBlock)current_block);
	  }

void case_874()
#line 5667 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_875()
#line 5674 "cs-parser.jay"
{
		yyVal = new Linq.GroupBy ((Linq.QueryBlock)current_block, (Expression)yyVals[-3+yyTop], linq_clause_blocks.Pop (), (Expression)yyVals[0+yyTop], GetLocation (yyVals[-5+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-1+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_879()
#line 5691 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-1+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-1+yyTop];
	  }

void case_886()
#line 5711 "cs-parser.jay"
{
		var lt = (Tokenizer.LocatedToken) yyVals[-3+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
	  	yyVal = new Linq.Let ((Linq.QueryBlock) current_block, sn, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-4+yyTop]));
		lbag.AddLocation (yyVal, GetLocation (yyVals[-2+yyTop]));
		
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
		
		((Linq.QueryBlock)current_block).AddRangeVariable (sn);
	  }

void case_888()
#line 5730 "cs-parser.jay"
{
		yyVal = new Linq.Where ((Linq.QueryBlock)current_block, (Expression)yyVals[0+yyTop], GetLocation (yyVals[-2+yyTop]));

		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  }

void case_889()
#line 5740 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_890()
#line 5748 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_891()
#line 5756 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_892()
#line 5764 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();

		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];	
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-11+yyTop]));
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]));
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
			
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location);

			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-11+yyTop]));	
			lbag.AddLocation (yyVal, GetLocation (yyVals[-9+yyTop]), GetLocation (yyVals[-6+yyTop]), GetLocation (yyVals[-3+yyTop]), GetLocation (yyVals[0+yyTop]));
		}

		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);
	  }

void case_893()
#line 5802 "cs-parser.jay"
{
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_894()
#line 5810 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);
	  }

void case_895()
#line 5818 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;

		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_896()
#line 5826 "cs-parser.jay"
{
		current_block.AddStatement (new ContextualReturn ((Expression) yyVals[-1+yyTop]));
		current_block.SetEndLocation (lexer.Location);
	  
		var outer_selector = linq_clause_blocks.Pop ();
		var block = linq_clause_blocks.Pop ();
		
		var lt = (Tokenizer.LocatedToken) yyVals[-10+yyTop];
		var sn = new Linq.RangeVariable (lt.Value, lt.Location);
		Linq.RangeVariable into;
		
		if (yyVals[0+yyTop] == null) {
			into = sn;		
	  		yyVal = new Linq.Join (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};
		} else {
			/**/
			/* Set equals right side parent to beginning of linq query, it is not accessible therefore cannot cause name collisions*/
			/**/
			var parent = block.Parent;
			while (parent is Linq.QueryBlock) {
				parent = parent.Parent;
			}
			current_block.Parent = parent;
		
			((Linq.QueryBlock)current_block).AddRangeVariable (sn);
		
			lt = (Tokenizer.LocatedToken) yyVals[0+yyTop];
			into = new Linq.RangeVariable (lt.Value, lt.Location); /* TODO:*/
			
			yyVal = new Linq.GroupJoin (block, sn, (Expression)yyVals[-7+yyTop], outer_selector, (Linq.QueryBlock) current_block, into, GetLocation (yyVals[-12+yyTop])) {
	  			IdentifierType = (FullNamedExpression)yyVals[-11+yyTop]
	  		};			
		}
		
		current_block = block.Parent;
		((Linq.QueryBlock)current_block).AddRangeVariable (into);		
	  }

void case_900()
#line 5881 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		yyVal = yyVals[0+yyTop];
	  }

void case_902()
#line 5892 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
	  }

void case_903()
#line 5899 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	  }

void case_905()
#line 5908 "cs-parser.jay"
{
		current_block.SetEndLocation (lexer.Location);
		current_block = current_block.Parent;
	  
		current_block = new Linq.QueryBlock ((Linq.QueryBlock) current_block, lexer.Location);	 
	 }

void case_906()
#line 5915 "cs-parser.jay"
{
		((Linq.AQueryClause)yyVals[-3+yyTop]).Tail.Next = (Linq.AQueryClause)yyVals[0+yyTop];
		yyVal = yyVals[-3+yyTop];
	 }

void case_908()
#line 5927 "cs-parser.jay"
{
		yyVal = new Linq.OrderByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_909()
#line 5932 "cs-parser.jay"
{
		yyVal = new Linq.OrderByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_911()
#line 5944 "cs-parser.jay"
{
		yyVal = new Linq.ThenByAscending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_912()
#line 5949 "cs-parser.jay"
{
		yyVal = new Linq.ThenByDescending ((Linq.QueryBlock) current_block, (Expression)yyVals[-1+yyTop]);	
		lbag.AddLocation (yyVal, GetLocation (yyVals[0+yyTop]));
	  }

void case_914()
#line 5959 "cs-parser.jay"
{
		/* query continuation block is not linked with query block but with block*/
		/* before. This means each query can use same range variable names for*/
		/* different identifiers.*/

		current_block.SetEndLocation (GetLocation (yyVals[-1+yyTop]));
		current_block = current_block.Parent;
	
		current_block = new Linq.QueryBlock (current_block, lexer.Location);
		
		if (linq_clause_blocks == null)
			linq_clause_blocks = new Stack<Linq.QueryBlock> ();
	  		
		linq_clause_blocks.Push ((Linq.QueryBlock) current_block);		
	  }

void case_915()
#line 5975 "cs-parser.jay"
{
		var current_block = linq_clause_blocks.Pop ();	  
		var lt = (Tokenizer.LocatedToken) yyVals[-2+yyTop];
		var rv = new Linq.RangeVariable (lt.Value, lt.Location);
  		yyVal = new Linq.QueryStartClause ((Linq.QueryBlock)current_block, null, rv, GetLocation (yyVals[-3+yyTop])) {
  			next = (Linq.AQueryClause)yyVals[0+yyTop]
  		};
	  }

void case_918()
#line 6002 "cs-parser.jay"
{ 
		current_container = new Class (current_namespace, current_class, new MemberName ("<InteractiveExpressionClass>"), Modifiers.PUBLIC, null);
		current_class = current_container;

		/* (ref object retval)*/
		Parameter [] mpar = new Parameter [1];
		mpar [0] = new Parameter (new TypeExpression (compiler.BuiltinTypes.Object, Location.Null), "$retval", Parameter.Modifier.REF, null, Location.Null);

		ParametersCompiled pars = new ParametersCompiled (mpar);
		var mods = Modifiers.PUBLIC | Modifiers.STATIC;
		if (settings.Unsafe)
			mods |= Modifiers.UNSAFE;

		current_local_parameters = pars;
		Method method = new Method (
			current_class,
			null, /* generic*/
			new TypeExpression (compiler.BuiltinTypes.Void, Location.Null),
			mods,
			new MemberName ("Host"),
			pars,
			null /* attributes */);
			
		current_container.AddMethod (method);			

		oob_stack.Push (method);
		++lexer.parsing_block;
		start_block (lexer.Location);
	  }

void case_919()
#line 6032 "cs-parser.jay"
{
		--lexer.parsing_block;
		Method method = (Method) oob_stack.Pop ();

		method.Block = (ToplevelBlock) end_block(lexer.Location);

		InteractiveResult = (Class) pop_current_class ();
		current_local_parameters = null;
	  }

void case_929()
#line 6075 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-1+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		yyVal = null;
	  }

void case_930()
#line 6081 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedBuiltinType = (TypeExpression)yyVals[-3+yyTop];
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[0+yyTop];
		var lt = (Tokenizer.LocatedToken) yyVals[-1+yyTop];
		yyVal = new MemberName (lt.Value);
	  }

void case_933()
#line 6096 "cs-parser.jay"
{
		module.DocumentationBuilder.ParsedParameters = (List<DocumentationParameter>)yyVals[-1+yyTop];
		yyVal = new MemberName ((MemberName) yyVals[-6+yyTop], new MemberName (MemberCache.IndexerNameAlias));
	  }

void case_934()
#line 6101 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Explicit;
		yyVal = null;
	  }

void case_935()
#line 6109 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		p.Add (new DocumentationParameter ((FullNamedExpression) yyVals[-1+yyTop]));
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = Operator.OpType.Implicit;
		yyVal = null;
	  }

void case_936()
#line 6117 "cs-parser.jay"
{
		var p = (List<DocumentationParameter>)yyVals[0+yyTop] ?? new List<DocumentationParameter> (1);
		module.DocumentationBuilder.ParsedParameters = p;
		module.DocumentationBuilder.ParsedOperator = (Operator.OpType) yyVals[-1+yyTop];
		yyVal = null;
	  }

void case_944()
#line 6155 "cs-parser.jay"
{
		var parameters = new List<DocumentationParameter> ();
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_945()
#line 6161 "cs-parser.jay"
{
		var parameters = yyVals[-2+yyTop] as List<DocumentationParameter>;
		parameters.Add ((DocumentationParameter) yyVals[0+yyTop]);
		yyVal = parameters;
	  }

void case_946()
#line 6170 "cs-parser.jay"
{
		if (yyVals[-1+yyTop] != null)
			yyVal = new DocumentationParameter ((Parameter.Modifier) yyVals[-1+yyTop], (FullNamedExpression) yyVals[0+yyTop]);
		else
			yyVal = new DocumentationParameter ((FullNamedExpression) yyVals[0+yyTop]);
	  }

#line default
   static readonly short [] yyLhs  = {              -1,
    0,    4,    0,    0,    1,    1,    1,    1,    2,    2,
   11,   11,   12,   12,   13,   13,   14,   14,   15,   15,
   16,   21,   22,   19,   20,   20,   20,   24,   24,   25,
   25,   18,    7,    7,    6,    6,   23,   23,    8,    8,
   26,   26,   27,   27,   27,   27,   27,    9,    9,   10,
   10,   35,   33,   38,   34,   34,   36,   36,   36,   36,
   37,   37,   42,   39,   40,   41,   41,   43,   43,   43,
   43,   43,   44,   44,   48,   45,   47,   49,   49,   49,
   50,   50,   51,   51,   52,   52,   52,   52,   52,   52,
   52,   52,   52,   52,   52,   65,   67,   70,   71,   29,
   29,   73,   69,   72,   72,   74,   74,   75,   75,   75,
   75,   75,   75,   75,   75,   75,   75,   78,   53,   79,
   79,   80,   80,   81,   83,   77,   77,   82,   82,   88,
   54,   92,   54,   54,   87,   95,   87,   89,   89,   96,
   96,   97,   98,   97,   93,   93,   99,   99,  100,  101,
   91,   91,   94,   94,   94,  104,   55,  107,  108,  102,
  109,  110,  102,  102,  103,  103,  106,  106,  113,  113,
  113,  113,  113,  113,  113,  113,  113,  113,  114,  114,
  117,  117,  117,  120,  117,  118,  118,  121,  121,  122,
  122,  122,  115,  115,  115,  123,  123,  123,  116,  125,
  127,  128,   56,  130,  131,  132,   58,  126,  126,  126,
  126,  126,  136,  133,  137,  134,  135,  135,  135,  138,
  139,  140,  142,   30,   30,  141,  141,  143,  143,  144,
  144,  144,  144,  144,  144,  144,  144,  144,  147,   59,
  146,  146,  148,  148,  151,  145,  145,  150,  150,  150,
  150,  150,  150,  150,  150,  150,  150,  150,  150,  150,
  150,  150,  150,  150,  150,  150,  150,  150,  150,  153,
  152,  154,  152,  152,  152,   60,  157,  159,  155,  156,
  156,  158,  158,  163,  161,  164,  161,  161,  165,   61,
  167,   57,  170,  171,   57,  166,  173,  166,  168,  168,
  174,  174,  175,  176,  175,  177,  172,  169,  169,  169,
  169,  169,  181,  178,  182,  179,  180,  180,  184,  186,
  187,   31,  183,  183,  183,  185,  185,  185,  188,  188,
  189,  190,  189,  191,  192,  193,   32,  194,  194,   17,
   17,  195,  195,  198,  197,  197,  197,  199,  199,  201,
   64,  124,  105,  105,  129,  129,  202,  202,  202,  200,
  200,  203,  203,  204,  204,  206,  206,   86,   76,   76,
   90,   90,  119,  119,  149,  149,  207,  207,  207,  207,
  207,  211,  211,  212,  212,  210,  210,  210,  210,  210,
  210,  210,  213,  213,  213,  213,  213,  213,  213,  213,
  213,  214,  214,  214,  214,  214,  214,  214,  214,  214,
  214,  214,  214,  214,  214,  214,  214,  214,  214,  214,
  214,  215,  215,  215,  216,  216,  216,  236,  236,  237,
  237,  238,  238,  218,  218,  235,  235,  235,  235,  235,
  235,  235,  235,  220,  239,  239,  240,  240,  241,  241,
  243,  243,  243,  244,  244,  244,  244,  244,  245,  245,
  162,  162,  249,  249,  249,  249,  249,  251,  251,  250,
  250,  252,  252,  252,  252,  253,  221,  248,  248,  248,
  254,  254,  255,  255,  222,  223,  223,  224,  225,  226,
  226,  217,  217,  217,  217,  217,  260,  256,  227,  261,
  261,  262,  262,  263,  263,  264,  264,  264,  264,  257,
  257,  208,  208,  259,  259,  265,  265,  258,  258,   85,
   85,  266,  266,  267,  228,  268,  268,  268,  269,  269,
  269,  269,  269,  270,  196,  229,  230,  231,  232,  272,
  233,  271,  271,  274,  273,  219,  275,  275,  275,  275,
  277,  276,  276,  276,  276,  276,  276,  276,  278,  278,
  278,  278,  279,  279,  279,  279,  279,  279,  280,  280,
  280,  281,  281,  281,  281,  281,  282,  282,  282,  283,
  283,  284,  284,  285,  285,  286,  286,  287,  287,  288,
  288,  289,  289,  290,  290,  290,  290,  290,  290,  290,
  290,  290,  290,  290,  291,  291,  292,  292,  292,  293,
  293,  294,  294,  297,  295,  296,  296,  299,  298,  300,
  301,  298,   46,   46,  246,  246,  246,  246,  234,  234,
  234,   84,  303,  304,  305,  306,  307,   28,   63,   63,
   62,   62,  111,  111,  308,  308,  308,  308,  308,  308,
  308,  308,  308,  308,  308,  308,  308,  308,  308,   66,
   66,   68,   68,   68,  309,  309,  310,  311,  311,  312,
  312,  312,  312,  205,  205,  313,  313,  315,  112,  316,
  316,  317,  160,  314,  314,  318,  318,  319,  319,  319,
  319,  323,  323,  324,  324,  324,  321,  321,  321,  321,
  321,  321,  321,  321,  321,  321,  321,  321,  321,  325,
  325,  325,  325,  325,  325,  325,  325,  325,  325,  325,
  325,  325,  339,  339,  339,  339,  326,  340,  322,  341,
  341,  342,  342,  342,  342,  342,  342,  209,  209,  343,
  345,  320,  348,  320,  344,  344,  344,  346,  346,  351,
  351,  352,  352,  347,  347,  349,  349,  353,  353,  354,
  350,  350,  350,  327,  327,  338,  338,  355,  356,  356,
  328,  328,  357,  357,  360,  358,  359,  359,  361,  361,
  361,  364,  362,  363,  363,  365,  365,  329,  329,  329,
  329,  366,  367,  371,  368,  370,  370,  372,  372,  376,
  375,  375,  373,  373,  374,  374,  378,  377,  377,  369,
  379,  369,  330,  330,  330,  330,  330,  330,  380,  381,
  382,  382,  382,  383,  384,  385,  385,  386,  386,  331,
  331,  331,  331,  387,  387,  389,  389,  388,  390,  388,
  388,  332,  333,  391,  336,  334,  393,  394,  337,  395,
  396,  335,  335,  392,  392,  302,  302,  302,  302,  397,
  397,  399,  399,  401,  400,  402,  400,  398,  398,  398,
  406,  404,  407,  408,  404,  403,  403,  409,  409,  410,
  410,  410,  410,  410,  415,  411,  416,  412,  417,  418,
  419,  413,  421,  422,  423,  413,  420,  420,  425,  414,
  424,  428,  424,  427,  430,  427,  426,  426,  426,  429,
  429,  429,  405,  431,  405,    3,    3,  432,    3,    3,
  433,  433,  247,  247,  242,  242,    5,  434,  434,  434,
  434,  438,  434,  434,  434,  434,  435,  435,  436,  439,
  436,  437,  437,  440,  440,  441,
  };
   static readonly short [] yyLen = {           2,
    2,    0,    3,    1,    2,    4,    3,    1,    0,    1,
    1,    2,    4,    2,    1,    2,    1,    1,    5,    2,
    3,    0,    0,   11,    1,    3,    1,    0,    1,    0,
    1,    1,    0,    1,    0,    1,    0,    1,    1,    2,
    1,    1,    1,    1,    1,    1,    1,    0,    1,    1,
    2,    0,    3,    0,    6,    3,    1,    1,    1,    1,
    1,    3,    0,    3,    1,    0,    3,    0,    1,    1,
    3,    3,    1,    1,    0,    4,    4,    0,    1,    1,
    0,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    0,    0,    0,    0,   13,
    5,    0,    4,    0,    1,    1,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    0,    9,    0,
    1,    1,    2,    3,    0,    3,    1,    1,    1,    0,
    8,    0,    9,    6,    0,    0,    3,    0,    1,    1,
    2,    2,    0,    5,    0,    1,    1,    2,    3,    0,
    4,    2,    1,    1,    1,    0,    3,    0,    0,   10,
    0,    0,   11,    8,    1,    1,    0,    1,    1,    3,
    3,    3,    5,    3,    5,    1,    1,    1,    1,    3,
    4,    6,    4,    0,    7,    0,    1,    1,    2,    1,
    1,    1,    4,    6,    4,    1,    2,    2,    1,    0,
    0,    0,   10,    0,    0,    0,   13,    1,    2,    1,
    2,    1,    0,    5,    0,    5,    1,    1,    1,    0,
    0,    0,    0,   15,    5,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    0,    5,
    1,    1,    1,    1,    0,    7,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    7,    0,    7,    2,    2,    2,    0,    0,    9,    1,
    1,    0,    1,    0,    6,    0,    6,    1,    0,    8,
    0,    9,    0,    0,   10,    0,    0,    3,    0,    1,
    1,    2,    2,    0,    5,    0,    2,    2,    2,    1,
    1,    1,    0,    5,    0,    5,    1,    1,    0,    0,
    0,   12,    0,    2,    2,    0,    1,    2,    1,    3,
    2,    0,    5,    0,    0,    0,   13,    0,    1,    1,
    3,    1,    4,    2,    0,    3,    2,    1,    3,    0,
    3,    1,    1,    3,    1,    2,    3,    4,    4,    0,
    3,    1,    3,    3,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    2,    2,    2,    2,    2,
    2,    1,    3,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    3,    3,    4,    4,    4,    3,    3,
    4,    3,    4,    4,    0,    1,    3,    4,    0,    1,
    1,    3,    2,    3,    1,    2,    3,    2,    1,    1,
    0,    1,    1,    3,    3,    2,    2,    1,    1,    1,
    1,    2,    2,    4,    3,    1,    4,    1,    3,    2,
    1,    3,    1,    1,    1,    4,    3,    2,    2,    6,
    3,    7,    4,    3,    7,    3,    0,    2,    4,    1,
    2,    0,    1,    1,    3,    3,    1,    1,    1,    0,
    1,    1,    2,    2,    3,    1,    2,    0,    1,    2,
    4,    1,    3,    0,    5,    1,    1,    1,    2,    3,
    3,    4,    4,    1,    2,    4,    4,    4,    4,    0,
    4,    0,    1,    0,    4,    4,    1,    2,    2,    1,
    4,    1,    2,    2,    2,    2,    2,    2,    1,    3,
    3,    3,    1,    3,    3,    3,    3,    3,    1,    3,
    3,    1,    3,    3,    3,    3,    1,    3,    3,    1,
    3,    1,    3,    1,    3,    1,    3,    1,    3,    1,
    3,    1,    5,    3,    3,    3,    3,    3,    3,    3,
    3,    3,    3,    3,    1,    3,    3,    2,    1,    0,
    1,    1,    1,    0,    2,    1,    1,    0,    4,    0,
    0,    7,    1,    1,    1,    1,    1,    1,    6,    4,
    4,    1,    1,    0,    0,    0,    0,   15,    0,    1,
    0,    1,    1,    2,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    0,
    2,    0,    1,    1,    1,    2,    4,    1,    3,    1,
    3,    1,    1,    0,    1,    1,    1,    0,    4,    1,
    1,    0,    4,    0,    1,    1,    2,    1,    1,    1,
    1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    0,    4,    1,
    2,    2,    2,    2,    2,    2,    1,    1,    2,    1,
    0,    6,    0,    7,    0,    2,    1,    0,    1,    1,
    2,    2,    4,    0,    2,    0,    1,    1,    2,    4,
    1,    5,    2,    2,    2,    2,    2,    1,    1,    1,
    1,    1,    5,    7,    0,    8,    0,    1,    1,    2,
    1,    0,    3,    1,    2,    3,    1,    1,    1,    1,
    1,    5,    7,    0,    4,    7,    1,    0,    1,    0,
    5,    1,    0,    1,    0,    1,    1,    1,    3,    6,
    0,    9,    1,    1,    1,    1,    1,    1,    2,    2,
    3,    4,    3,    3,    3,    4,    3,    0,    1,    3,
    4,    5,    3,    1,    2,    0,    1,    2,    0,    7,
    3,    2,    2,    0,    3,    5,    0,    0,   10,    0,
    0,   10,    5,    0,    2,    2,    2,    2,    2,    4,
    5,    4,    5,    0,    5,    0,    6,    3,    2,    1,
    0,    3,    0,    0,    6,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    0,    5,    0,    3,    0,    0,
    0,   12,    0,    0,    0,   13,    0,    2,    0,    3,
    1,    0,    4,    1,    0,    4,    1,    2,    2,    1,
    2,    2,    0,    0,    4,    2,    3,    0,    4,    2,
    2,    3,    0,    1,    1,    1,    2,    2,    2,    4,
    3,    0,    7,    4,    4,    3,    1,    3,    0,    0,
    4,    0,    1,    1,    3,    2,
  };
   static readonly short [] yyDefRed = {            0,
    8,    0,    0,    0,    0,    0,    0,    0,    2,    4,
    0,    0,   11,   14,    0,  916,    0,    0,  920,    0,
    0,   15,   17,   18,  388,  394,  401,  389,  391,    0,
  390,    0,  397,  399,  386,    0,  393,  395,  387,  398,
  400,  396,  350,  937,    0,  392,  927,    0,   10,    1,
    0,    0,    0,   12,    0,  770,    0,    0,    0,    0,
    0,    0,    0,    0,  429,    0,    0,    0,    0,    0,
    0,    0,  427,    0,    0,    0,  485,    0,  428,    0,
  524,    0,  844,    0,    0,    0,  628,    0,    0,    0,
    0,    0,  678,    0,  727,    0,    0,    0,    0,    0,
    0,    0,    0,  426,    0,  620,    0,  769,  710,    0,
    0,    0,    0,  403,  404,    0,  406,  407,  408,  409,
  410,  411,  412,  413,  414,  415,  416,  417,  418,  419,
  420,  421,  424,  425,  624,  552,    0,  550,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  625,
  623,  626,  627,  694,  696,    0,  692,  695,  711,  713,
  714,  715,  716,  717,  718,  719,  720,  721,  722,  712,
    0,    0,    0,  771,  772,  788,  789,  790,  791,  813,
  814,  815,  816,  817,  818,    0,    0,    0,   20,    0,
    0,    0,  340,    0,  342,  924,   16,  917,    0,    0,
  253,  252,  249,  254,  255,  248,  267,  266,  259,  260,
  256,  258,  257,  261,  250,  251,  262,  263,  269,  268,
  264,  265,    0,    0,  940,    0,  929,    0,  928,    3,
   52,    0,    0,    0,   42,   39,   41,   43,   44,   45,
   46,   47,   50,   13,    0,    0,    0,  819,  430,  431,
  842,    0,    0,    0,    0,    0,  405,    0,  820,    0,
  544,  540,  543,  726,  768,  697,  724,  723,  725,  698,
  699,  700,  701,  702,  703,  704,  705,  706,  707,  708,
  709,    0,    0,    0,  794,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  829,    0,  402,
    0,    0,    0,    0,    0,    0,  843,    0,    0,    0,
  740,  736,    0,    0,    0,    0,    0,    0,  369,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  549,  553,
  554,  548,  558,  557,  555,  556,    0,    0,  618,  728,
  535,    0,  423,  422,    0,    0,    0,    0,  339,    0,
  734,  735,    0,  488,  489,    0,    0,    0,  732,  733,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  919,  693,  741,  731,    0,  766,
  767,  870,  887,    0,    0,    0,  899,  858,  856,  880,
    0,    0,  878,  881,  882,  883,  884,  859,  857,    0,
    0,    0,  344,    0,   21,    0,    0,    0,  936,    0,
  351,    0,    0,    0,  938,    0,    0,   40,  650,  656,
  648,    0,  645,  655,  649,  647,  646,  653,  651,  652,
  658,  654,  657,  659,    0,    0,  643,   51,  487,    0,
    0,  483,  484,    0,  481,    0,  743,    0,    0,    0,
    0,  764,  765,    0,    0,    0,  632,    0,  823,  821,
  633,    0,    0,  509,    0,    0,    0,  500,    0,  504,
  514,  516,    0,  496,    0,    0,    0,    0,    0,  491,
    0,  494,    0,  498,  371,  824,    0,    0,  825,  833,
    0,    0,    0,  834,    0,    0,  845,    0,    0,  739,
    0,  381,    0,  377,  378,    0,  376,  379,  380,    0,
    0,    0,  559,    0,    0,  691,    0,    0,  686,  688,
  689,  690,  434,  435,  827,    0,    0,    0,  347,  348,
    0,  191,  190,  192,    0,    0,    0,    0,  373,    0,
  605,    0,    0,  439,    0,  442,    0,  440,    0,    0,
    0,    0,    0,    0,  468,  471,    0,    0,  463,  470,
  469,    0,  594,  595,  596,  597,  598,  599,  600,  601,
  602,  604,  603,  560,  562,  561,  567,  568,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  591,    0,    0,  513,    0,    0,    0,
    0,    0,    0,    0,  871,  873,  869,    0,  879,    0,
    0,  341,  934,  935,  365,    0,    0,  362,    0,    0,
  188,    0,    0,  944,  930,  932,   60,   58,   59,    0,
    0,   53,    0,    0,   61,   63,   27,   25,    0,    0,
    0,  640,    0,  644,  438,    0,  486,    0,  537,    0,
  546,  178,  199,    0,    0,  168,    0,    0,    0,  179,
  541,    0,  847,  797,    0,  808,  795,    0,  799,    0,
    0,    0,  822,    0,    0,    0,  499,    0,  515,  517,
    0,    0,  455,    0,    0,  451,    0,    0,  478,    0,
  519,  493,    0,  155,  520,  153,  154,  522,    0,  536,
    0,  838,    0,  831,    0,  835,  528,    0,    0,    0,
  366,    0,  526,    0,    0,  538,    0,  850,    0,  862,
    0,  860,    0,    0,  630,  631,  680,  681,  679,  687,
  826,  613,  619,  612,    0,  729,    0,  346,  608,    0,
    0,    0,  551,  443,  437,  441,  436,  539,  477,  476,
  473,  472,    0,  467,  432,  433,  444,    0,    0,  747,
    0,    0,  888,  864,    0,  889,    0,  885,    0,  900,
    0,    0,    0,    0,  868,   19,  343,  677,  676,    0,
  675,    0,  361,  946,  189,  941,    0,    0,   54,    0,
    0,    0,    0,    0,    0,  368,    0,  634,    0,    0,
   80,   79,    0,  482,    0,    0,    0,    0,    0,  545,
    0,    0,    0,    0,    0,  800,    0,    0,    0,    0,
    0,  846,  506,  505,  458,    0,    0,  925,  926,  447,
  453,    0,  456,    0,  480,    0,    0,    0,    0,    0,
  775,  841,    0,  832,  534,  529,    0,    0,  525,    0,
  853,    0,  792,  863,  861,    0,  617,  616,  615,  349,
  607,  606,  621,  475,    0,  465,  464,  593,    0,  761,
  746,    0,    0,    0,  750,    0,  866,    0,  893,    0,
  908,  909,  902,  872,  874,  914,  364,  363,  945,    0,
    0,   62,   56,    0,   64,   26,   23,    0,    0,  319,
    0,  225,    0,  101,    0,   77,  755,  128,  129,    0,
    0,    0,  758,  197,  198,    0,    0,    0,    0,  171,
  180,  172,  174,    0,    0,    0,    0,  804,    0,  809,
  810,    0,    0,  457,  459,  460,  454,  448,  452,    0,
  511,    0,  479,  490,  446,  523,  521,    0,  837,    0,
    0,  530,    0,    0,  629,    0,  474,    0,    0,  742,
  751,  865,    0,    0,    0,  886,    0,    0,    0,  933,
    0,    0,    0,   69,   70,   73,   74,    0,  334,  325,
  324,    0,  635,  221,   97,    0,  744,  759,  183,    0,
  195,    0,    0,    0,  793,  855,    0,    0,    0,  811,
  774,  495,  492,  781,    0,  787,    0,    0,  779,    0,
  784,  839,  533,  532,    0,  622,    0,    0,  867,  890,
    0,    0,    0,  904,    0,  915,    0,   75,   67,    0,
    0,    0,  320,    0,    0,    0,    0,    0,  184,    0,
  175,  173,  848,  801,    0,    0,  806,    0,    0,  776,
  780,    0,  785,    0,  851,    0,  753,    0,  894,  911,
  912,  905,  875,   55,    0,   71,   72,    0,    0,    0,
    0,    0,    0,    0,  760,  182,    0,  194,    0,    0,
  812,  786,    0,  682,  840,    0,  762,    0,    0,    0,
   76,    0,    0,  335,    0,  321,    0,  329,  385,  384,
    0,  382,  664,    0,  636,    0,  665,  222,   98,  185,
  849,  796,    0,  852,  891,    0,  906,    0,    0,    0,
    0,    0,    0,    0,    0,  666,    0,    0,    0,    0,
  895,   29,   24,  336,    0,    0,  330,  383,    0,    0,
    0,  102,   99,  683,    0,    0,    0,    0,  322,  672,
    0,  673,  670,    0,  668,   95,    0,   94,    0,    0,
   83,   85,   86,   87,   88,   89,   90,   91,   92,   93,
  156,    0,    0,  238,  230,  231,  232,  233,  234,  235,
  236,  237,    0,    0,  228,    0,    0,    0,  892,    0,
  337,  333,    0,    0,    0,  637,   84,    0,  281,  276,
  280,    0,  223,  229,  116,  108,  109,  110,  111,  112,
  113,  114,  115,  117,    0,    0,  106,  100,  898,  896,
  671,  669,    0,    0,    0,    0,    0,    0,    0,  289,
    0,    0,  239,    0,    0,  247,    0,  166,  157,  165,
    0,  103,  107,    0,    0,  275,    0,    0,  274,    0,
    0,    0,    0,  355,    0,  353,    0,    0,  200,    0,
    0,    0,    0,    0,  638,  224,  118,    0,  352,    0,
    0,    0,    0,  132,    0,    0,    0,    0,    0,    0,
  158,    0,    0,  204,    0,  356,    0,  242,  241,  240,
    0,    0,  293,    0,  272,  134,    0,  270,  161,    0,
    0,  136,    0,  357,    0,    0,  201,    0,    0,    0,
  354,  245,  127,  125,    0,    0,  297,    0,    0,    0,
    0,    0,    0,    0,  278,    0,    0,    0,    0,  140,
    0,    0,    0,    0,  358,  359,    0,    0,    0,    0,
    0,  122,  312,    0,  294,    0,    0,  306,    0,    0,
    0,  301,    0,  152,    0,    0,    0,    0,  147,    0,
    0,  290,    0,  137,    0,  131,  141,  159,  164,  212,
    0,  202,    0,    0,    0,    0,  126,    0,  119,  123,
    0,    0,    0,  308,    0,  309,  298,    0,    0,  292,
  302,  273,    0,    0,  133,  148,  271,  162,  288,    0,
  279,  283,  143,    0,    0,    0,  209,  211,  205,  246,
  124,  313,  315,  295,    0,    0,  307,  304,  151,  149,
    0,    0,    0,    0,  160,  213,  215,  203,    0,    0,
    0,  306,  163,  284,  286,  144,    0,    0,  206,  317,
  318,  314,  316,  305,    0,    0,  219,  218,  217,  214,
  216,    0,    0,    0,  207,  285,  287,
  };
  protected static readonly short [] yyDgoto  = {             7,
    8,   50,    9,   51,   10,   11,   52,  232,  674,  421,
   12,   13,   53,   22,   23,   24,  317,  192,  235,  659,
  814,  998, 1113, 1460,  811,  236,  237,  238,  239,  240,
  241,  242,  243,  652,  436,  653,  654,  911,  655,  656,
  915,  812,  993,  994,  995,  265,  576, 1085,  823, 1179,
 1180, 1181, 1182, 1183, 1184, 1185, 1186, 1187, 1188, 1189,
 1190,  455,  663, 1276,  925, 1092, 1056, 1125, 1163, 1148,
 1207, 1235, 1206, 1236, 1237, 1120, 1335, 1312, 1360, 1361,
 1362,  927, 1358,  928,  717, 1252, 1323, 1299, 1348,  504,
 1341, 1317, 1377,  890, 1346, 1349, 1350, 1444, 1378, 1379,
 1375, 1191, 1259, 1218, 1277,  675, 1325, 1424, 1343, 1441,
  456,  266,  676,  677,  678,  679,  680,  639,  557, 1097,
  640,  641,  829, 1279, 1303, 1392, 1353, 1426, 1280, 1328,
 1449, 1472, 1393, 1394, 1470, 1457, 1458,  923, 1055, 1147,
 1203, 1261, 1204, 1205, 1253, 1310, 1283, 1254,  319,  223,
 1357, 1256, 1342, 1339, 1192, 1220, 1273, 1421, 1383, 1105,
 1422,  577, 1465, 1466, 1272, 1338, 1314, 1370, 1365, 1336,
 1402, 1407, 1368, 1371, 1372, 1452, 1408, 1366, 1367, 1462,
 1450, 1451,  920, 1002, 1116, 1090, 1141, 1117, 1118, 1155,
 1052, 1139, 1167,  524,  193,  110,  423,  195,  551,  431,
  224, 1291,  637,  638,  800,  816,  320,  398,  522,  299,
 1121, 1122,   46,  112,  300,  114,  115,  116,  117,  118,
  119,  120,  121,  122,  123,  124,  125,  126,  127,  128,
  129,  130,  131,  132,  133,  134,  252,  777,  964,  500,
  704,  850,  705,  706,  957,  135,  198,  710,  578,  579,
  580,  581,  771,  464,  465,  294,  962,  712,  399,  296,
  487,  488,  489,  490,  493,  719,  306,  734,  735,  866,
  262,  470,  263,  469,  136,  137,  138,  139,  140,  141,
  142,  143,  144,  145,  146,  147,  148,  149,  150,  151,
  560,  561,  562,  753,  754,  879,  755,  152,  547,  345,
  976,  153,  482,  921, 1054, 1145, 1257,  457, 1126, 1127,
 1174, 1175,  801,  537,  327,  749, 1133,  538,  539,  267,
  268,  269,  156,  157,  158,  270,  271,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  170,  282,  548,
  171,  172,  313,  782,  616,  893,  826,  670,  931,  891,
  894,  895,  932,  933,  283,  173,  174,  175, 1027,  968,
 1028, 1029, 1030, 1072, 1031,  176,  177,  178,  179,  687,
  475,  688,  949, 1065,  689,  947,  690, 1067, 1068,  180,
  181,  182,  183,  184,  185,  301,  513,  514,  970, 1074,
  309,  946,  835, 1099,  872, 1106,  186,  409,  187,  410,
  896,  983,  411,  628,  795,  792,  793,  988,  412,  413,
  414,  415,  416,  417,  900,  618,  898, 1078, 1150, 1209,
  985, 1109, 1166,  790,  624,  791, 1043,  987, 1044, 1110,
  989,   17,   19,   47,   48,  227,  642,  808,  432,  643,
  644,
  };
  protected static readonly short [] yySindex = {         -159,
    0, -192, -124, -184,   -8,11425,    0,  185,    0,    0,
   -8, -184,    0,    0,   45,    0, 6321,   -8,    0, -186,
 -241,    0,    0,    0,    0,    0,    0,    0,    0,  198,
    0,  238,    0,    0,    0, 2124,    0,    0,    0,    0,
    0,    0,    0,    0,  344,    0,    0,  591,    0,    0,
  185,  194,   -8,    0,  190,    0,  128,  206,   89,10941,
  251,  170,  263, 6477,    0,  170,  170,  170, -203,  170,
  170,  613,    0,10036,  170,  170,    0,10036,    0,  278,
    0,   89,    0,  170,  270,  170,    0,11436,11507,  306,
  170,  170,    0,10036,    0,10711,10711,10711,10711,10711,
10711,10711,10711,    0, -128,    0,11518,    0,    0,  272,
  358,  595,  168,    0,    0,  339,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  930,    0,  743,   72,
  619,  634,  435,  311,  349,  356,  323,  -32,  359,    0,
    0,    0,    0,    0,    0, 3174,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  362,  387,   99,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, -196, -181,  194,    0,  464,
  498,  512,    0,  473,    0,    0,    0,    0,11518,11518,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  539,  518,    0,  520,    0,   13,    0,    0,
    0,  194,12469,  194,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  691,  554,10171,    0,    0,    0,
    0,10036,  170,  170,  390,  595,    0,  567,    0,11518,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  657,  117,10941,    0,11518,10036,  664,  672,10036,
10036,  956,  400, -185,  689,11589,   78,    0,  706,    0,
  711,11518,10036,  731,  540,  170,    0,10036,  278, 9496,
    0,    0,  270,10036,  270, -132,  489,  666,    0,  387,
  168, -103,  684,10036,10036,10036, 6633,  -52,    0,    0,
    0,    0,    0,    0,    0,    0,  764,10036,    0,    0,
    0, 4209,    0,    0,11354,  241,  798,  777,    0,  208,
    0,    0,  264,    0,    0,  758,10171, 9226,    0,    0,
10711,10036,10036,10036,10036,10036,10036,10036,10036,10036,
10036,10036,10711,10711,10711,11518,11518,10711,10711,10711,
10711,10711,10711,10711,10711,10711,10711,10711,10711,10711,
10711,10711,10711,10036,    0,    0,    0,    0,  387,    0,
    0,    0,    0,11600,11671,  793,    0,    0,    0,    0,
    9,  808,    0,    0,    0,    0,    0,    0,    0,  194,
  194,  796,    0,  821,    0,  777,  539,  539,    0, -147,
    0,  651,  539,  825,    0, -200,12469,    0,    0,    0,
    0, -173,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -166,12504,    0,    0,    0,  777,
  237,    0,    0,  560,    0,  881,    0,  886, -180,  278,
  170,    0,    0,  849, 7550, -208,    0,  892,    0,    0,
    0,  899,  900,    0,  233,    0,  906,    0,  903,    0,
    0,    0,  638,    0, 7685,  654,10036,  689, 9226,    0,
 7101,    0,  270,    0,    0,    0,  908,  909,    0,    0,
   89,  278,  260,    0, 4367,  911,    0,  913,  860,    0,
  918,    0,10036,    0,    0,  997,    0,    0,    0,10036,
  998,  920,    0,  925,  926,    0, -259, 6633,    0,    0,
    0,    0,    0,    0,    0,  923,  278, 6633,    0,    0,
  144,    0,    0,    0,  270,  241,  882,11682,    0,  927,
    0,  932,10711,    0,  319,    0,  377,    0,  777,  669,
10036,10036,  931, 1048,    0,    0,   15,  933,    0,    0,
    0,  743,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  743,  743,
   72,   72,  619,  619,  619,  619,  634,  634,  435,  311,
  349,  356,  323,    0,  934, -187,    0,10036,    6,  895,
   48,  896,  929,10036,    0,    0,    0,  958,    0, -245,
  777,    0,    0,    0,    0, -140,  286,    0,11682,  651,
    0,  944,  946,    0,    0,    0,    0,    0,    0,  241,
  498,    0,  948,  947,    0,    0,    0,    0,  951,11753,
  910,    0,  205,    0,    0,  316,    0,10171,    0,  962,
    0,    0,    0,  697,  957,    0,  970,  971,  972,    0,
    0,10036,    0,    0,  936,    0,    0,  973,    0,  974,
10036, 1052,    0, 6477, 6477, 7843,    0,  956,    0,    0,
 9631,  355,    0, -236, -163,    0,  921,  928,    0,  -53,
    0,    0,  983,    0,    0,    0,    0,    0,  982,    0,
  990,    0, 7118,    0,  278,    0,    0,  270,  460,  553,
    0,  940,    0,  991,  989,    0, 6477,    0, 6477,    0,
10036,    0,10036,11518,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 7999,    0,11518,    0,    0,  949,
11354, 1020,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 9091,    0,    0,    0,    0, 9361,10036,    0,
 7257,  992,    0,    0, 1070,    0, 1073,    0,  735,    0,
  995,10036,10036,  952,    0,    0,    0,    0,    0,  953,
    0, -147,    0,    0,    0,    0,  651,  651,    0,  796,
 1002, 1004,  961, 1013,  910,    0, 1006,    0, 1125, 1126,
    0,    0,10036,    0, 9766, 1010,  697,11682,11518,    0,
 -231, 1130, 1131, 1017, 1009,    0,10036,10036, 1032,10036,
 1124,    0,    0,    0,    0,  -89, 9901,    0,    0,    0,
    0, 7392,    0, 1153,    0,  387,10036, 1044, 7843, 1045,
    0,    0,  994,    0,    0,    0,  999, -117,    0, 1001,
    0, 1009,    0,    0,    0, 1043,    0,    0,    0,    0,
    0,    0,    0,    0,  696,    0,    0,    0,11589,    0,
    0, 1005, 1049,  992,    0,10036,    0,10036,    0,10036,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1054,
  796,    0,    0,10306,    0,    0,    0, 1055, 7274,    0,
  910,    0,  910,    0,  910,    0,    0,    0,    0, 1011,
 1051, 1010,    0,    0,    0, -169, -157, 1060, 1061,    0,
    0,    0,    0, 1064, 7843,  992, -187,    0, 1065,    0,
    0, 1071, 6477,    0,    0,    0,    0,    0,    0, 1072,
    0,  689,    0,    0,    0,    0,    0, -205,    0, 1079,
 -117,    0, 1031,  992,    0,  278,    0, 1033, 1074,    0,
    0,    0,10036, 1109,10036,    0,10036, 1106,  334,    0,
  947,  451,  725,    0,    0,    0,    0, -184,    0,    0,
    0, 1095,    0,    0,    0, 1083,    0,    0,    0,  532,
    0, 1084, 1209, 1210,    0,    0, 1096,  992,10036,    0,
    0,    0,    0,    0,10036,    0, 1102, -194,    0, -194,
    0,    0,    0,    0, 1099,    0,10036, 7257,    0,    0,
 1129,  762, 1098,    0,10036,    0, 1103,    0,    0,10306,
   -8, -180,    0, 1104, 1104, 1104, 9766, 1108,    0,10036,
    0,    0,    0,    0, 1111,  974,    0, 6477, 1105,    0,
    0, 6633,    0, 1107,    0, 1115,    0,10036,    0,    0,
    0,    0,    0,    0,10036,    0,    0,  194, 1119,  194,
 7567, -150, -150, -150,    0,    0,10036,    0, 6477, 6477,
    0,    0, 6633,    0,    0, 6477,    0, 1132,10036,10036,
    0,  194, 1128,    0, 1075,    0, 1118,    0,    0,    0,
 1133,    0,    0, 1080,    0, 1160,    0,    0,    0,    0,
    0,    0, 6633,    0,    0, 1156,    0, 1134, -150,    0,
 1138,  194, 7567, 1136, 1141,    0, 1145, 1147, 1148,10036,
    0,    0,    0,    0, 1137, 1134,    0,    0,10782,  -79,
  194,    0,    0,    0, 1158,10036, 1143,10036,    0,    0,
 1149,    0,    0, 1150,    0,    0,12504,    0, 1154,  -79,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  452,12504,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1155,  194,    0,  194, 1134, 1114,    0, 1158,
    0,    0, 1157,10782,11126,    0,    0,  485,    0,    0,
    0,11194,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1165,  194,    0,    0,    0,    0,
    0,    0,11518,11518,  300,11589,  342,  270, 1183,    0,
  241, 8991,    0, 1220,    0,    0, 1134,    0,    0,    0,
 1134,    0,    0, 1116, 1117,    0,11518, -149,    0,11518,
 1117, 1135, 1166,    0,  241,    0, 1178, 9021,    0, 1181,
 1139,   14,  528, 2124,    0,    0,    0,  241,    0, 1185,
 1142, 1184, 1180,    0, 1197, 1200, 1211, -180, 1173, 1232,
    0, 1235, 1241,    0,  777,    0,  789,    0,    0,    0,
 1239, -160,    0, 1231,    0,    0, 1244,    0,    0, 1243,
 1247,    0, 1242,    0, -180, -180,    0, -180, 1248, 1249,
    0,    0,    0,    0, 1250,   56,    0, 1256, -180, 1366,
 1259, -180, -180,  485,    0, 7843, 1224, 1267, 1242,    0,
 1272, 1273,   58, 1277,    0,    0, -180, 9766, 1236, 1281,
 1250,    0,    0,12504,    0,  194,  194,    0, 1240, 1283,
 1256,    0, 1290,    0,10036, 1251, 1291, 1259,    0, 1294,
 1296,    0, -168,    0, 1289,    0,    0,    0,    0,    0,
12504,    0,   58,   58, 1304, 1300,    0, -160,    0,    0,
 -151, 1305,12504,    0,12504,    0,    0, 7843, 1293,    0,
    0,    0, 1306, 1244,    0,    0,    0,    0,    0, -129,
    0,    0,    0, -150,  843, 1310,    0,    0,    0,    0,
    0,    0,    0,    0, 1365, 1418,    0,    0,    0,    0,
 -150, 1313, 1326, 7843,    0,    0,    0,    0,   58,  555,
  555,    0,    0,    0,    0,    0,  -83,  -83,    0,    0,
    0,    0,    0,    0, 9226, 9226,    0,    0,    0,    0,
    0, 1331, 1328, 1332,    0,    0,    0,
  };
  protected static readonly short [] yyRindex = {         2744,
    0,    0, 6789, 2744,    0,    0,    0, 1702,    0,    0,
 2899, 2675,    0,    0,    0,    0,    0, 2899,    0,    0,
   44,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1706,    0,    0, 1706,    0,    0,
 1702,  307, 2787,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1341,    0,    0,    0,    0,    0,    0,    0,
    0,11764,    0, 1333,    0,    0,    0, 1333,    0,    0,
    0,    0,    0,    0,  231,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3642,    0,    0,    0,    0,    0,
  301, 4366, 3800,    0,    0, 4208,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 4521,    0, 4588, 4928,
 5129, 5464, 5665, 5799, 5933, 1046, 4451, 6201, 2295,    0,
    0,    0,    0,    0,    0,   44,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1292,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  776,  776, 2942,    0,  149,
 1335,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1706,  113,    0,    0,    0,    0,    0,    0,
    0, 3009,  708, 3052,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 3260,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1344,    0,    0,    0,    0, 3260,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1806,    0, 2338,  385, 1935,    0,    0, 2064,
 1935,  385,    0,    0,    0,    0,    7,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 1333,    0,    0,
    0,    0,    0,    0, 1342, 2193,    0, 3260,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   26,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1191,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   23,    0,    0,    0,    0,    0,    0,    0, 3095,
 2495,    0,    0,    0,    0, 1654, 1706, 1706,    0, -215,
    0, 7860, 1706, 1712,    0,    0,  218,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  338,10859,    0,    0,    0, 3260,
 3958,    0,    0,    0,    0,    0,    0,    0,11226,    0,
    0,    0,    0,    0, 1339,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  712,  786,    0,    0, 1348,    0,
    0,    0,    0,    0,   12,    0,    0, 3734, 1345,    0,
    0,    0,  322,    0,    0,    0,    0,    0,    0,    0,
    0,    0, 1360,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   17,    0,    0,
    0,    0,    0,    0,    0,    0, 8155,    0,    0,    0,
    0,    0,    0,    0, -189,  285,    0,    0,    0, 1346,
    0,    0,    0,    0, 3260,    0, 3260,    0, 3892,    0,
    0,    0,   94,    0,    0,    0,    0,   95,    0,    0,
    0, 4691,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 4758, 4861,
 4995, 5062, 5196, 5263, 5330, 5397, 5531, 5598, 5732, 5866,
 6000, 6067, 6134,    0,    0,  771,    0,    0,  385,    0,
  385,    0,    0,    0,    0,    0,    0, 3538,    0,    0,
 1654,    0,    0,    0,    0, 1301,    0,    0,    0,11835,
    0,    0,  794,    0,    0,    0,    0,    0,    0,  740,
  496,    0,    0, 1350,    0,    0,    0,    0, 1357,    0,
    0,    0,    0,    0,    0,10441,    0,    0,    0,  782,
    0,    0,    0,11846,    0,    0,  799,  811,  814,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1349,
    0,    0,    0,    0,    0,    0,    0, 1358,    0,    0,
    0, 3326,    0,    0,   53,    0,   61, 3418,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0, 1361,    0,
    0,    0,    0,    0,    0,    0,    0,  177,  587,   65,
    0,    0,    0,    0, 1362,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  159,    0,    0,
    0, 1354,    0,    0,    0,    0,    0,    0,  439,    0,
  596,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -215,    0,    0,    0,    0,11846, 8016,    0, 1363,
    0,  680,    0,    0,    0,    0, 1368,    0, 1314, 1323,
    0,    0,    0,    0,    0, 1367,11917,    0,    0,    0,
11310,    0,    0,    0,  815,    0, 1369,    0,    0,    0,
 1526,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 3576,    0, 4050, 1374,    0,
    0,    0, 1375,    0,    0,    0,    0,  587,    0,    0,
    0,  815,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  683,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  816,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 1372,    0,    0,    0,    0,    0,  829,  830,    0,
    0,    0,    0,    0,    0, 1377,  771,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, 3734,    0,    0,    0,    0,    0, 1382,    0,    0,
  587,    0,  846, 1377,    0, 8155,    0,  542,  621,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   42,    0,
 1350, 8205,    0,    0,    0,    0,    0,11948,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  726,
    0,  751,    0,    0,    0,    0,    0, 1354, 1379,    0,
    0,    0,    0,    0,    0,    0,    0, 1386,    0, 6945,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  461,  649,    0,    0,    0,    0,    0,    0,    0,
12016,11226,    0, -161, -161, -161,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1383,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,12170,    0, -242,
    0, 1389, 1389, 1389,    0,    0,    0,    0,    0,    0,
    0,    0, -214,    0,    0,    0,    0,    0,    0,    0,
    0,12213,    0,    0,    0,    0, 1390,    0,    0,    0,
   21,    0,    0,    0,    0,  561,    0,    0,    0,    0,
    0,    0, 1391,    0,    0,    0,    0, 2830, 1381,  404,
    0,  127,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 2607,    0,    0,    0, 8358,
 8722,    0,    0,    0,  713,    0,    0,    0,    0,    0,
    0,    0,    0,  420,    0,    0,11012,    0,    0, 8449,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,11094,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 8813,    0, 8540, 2607,    0,    0,  713,
    0,    0,    0,    0,  338,    0,    0,    0,    0,    0,
    0,  338,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 8631,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0, 8926,  340,    0,
 8857,    0,    0,    0, 8956,    0, 2607,    0,    0,    0,
 2607,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  770,    0, 1393,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  801,    0,  661,
    0,    0,    0,    0,    0,    0,    0,11226,  841,    0,
    0,    0,    0,    0, 1388,    0,  870,    0,    0,    0,
    0,    0,    0,  864,    0,    0,    0,    0,    0,    0,
    0,    0, 1387,    0,11226,11226,    0,11270,    0,    0,
    0,    0,    0,    0, 1392,12439,    0, 1394,11226,10576,
 1395,11226,11226,    0,    0,    0,    0,    0, 1396,    0,
    0,    0,12380,    0,    0,    0,11226,    0,    0,    0,
 1397,    0,    0,   70,    0, 4526,12350,    0,    0,    0,
 1398,    0,    0,    0,    0,    0,    0, 1399,    0,    0,
    0,    0,  603,    0,  873,    0,    0,    0,    0,    0,
  861,    0,12256,12291,    0,    0,    0,    0,    0,    0,
    0,    0, 1446,    0, 1500,    0,    0,    0,  874,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  643,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  643,    0,    0,    0,    0,    0,    0,    0,12380,12059,
12102,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1345, 1345,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,
  };
  protected static readonly short [] yyGindex = {            0,
    0, 1713,    0,    0,    0,    2,  -16, -177,  -42, 1714,
    0, 1753, 1763,   81,    0,    0,    5,    0,    0,    0,
    0,    0,    0, -832, -680, -220, -565,    0,    0,    0,
    0,    0, -176,    0,    0,    0,  869,    0,  965,    0,
    0,    0,    0,  734,  736,  -17, -229,    0,    0,    0,
    0,  605, -604, -407, -368, -322, -318, -302, -254, -253,
 -869,-1115,    0,    1,    0,  173,    0,-1058,    0,    0,
    0,    0,    0,    0,  551,  -48,  391,    0,    0,    0,
  434,-1023,    0, -273, -294, 1152,    0,    0,    0, -856,
  384,    0,    0, -488,    0,    0,  458,    0,    0,  430,
    0,    0,  465,    0, -246, -592,    0,    0,    0,    0,
  558,  -14,    0,    0,  988,  993,  996, 1146, -515,    0,
    0, -308, 1007,  557,    0,-1304,    0,    0,    0,    0,
    0,    0,    0,    0,  365,    0,    0,    0,    0,    0,
    0,    0,    0,  627,    0,    0,    0,    0, -317,  548,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  641,
    0, -491,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  383,    0,    0,  466,    0,    0,  469,  472,  388,
    0,    0,    0,    0,    0,    0,    0,    0,  699,    0,
    0,    0,    0,  -64,    0,  216,  -96,    0,    0,  536,
    0,  594,    0, 1047,    0, 1347, -292, -270,  -58,  162,
    0,  704,    0,  -31,  -12,    0,    0,  474,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -266,    0,  637,    0,    0, -522,
    0,    0,    0, 1012,    0, -301, -125, 1164, 1100,    0,
 1090,    0, 1297, 1515, 1206,    0,    0,  914, 1803,    0,
    0,    0,    0, 1179,    0,    0,    0,    0,    0, -776,
    0,    0,    0,    0,    0,   20,    0,  484,  883,  690,
  868, 1490, 1491, 1489, 1492, 1493,    0, 1488,    0,    0,
    0, 1121,    0,  915,    0,    0,    0,    0,    0,    0,
    0,    0, -268,    0,    0,    0,    0, -441,    0,  763,
    0,  670,    0,  757,    0,    0,    0,  822, -518,   -1,
 -305,    4,    0, 1739,    0,   55,    0,   63,   67,   68,
   83,   84,   86,  115,  119,  123,  124,    0, -590,    0,
  -28,    0,    0,  950,    0, -848,    0,    0,    0,  862,
    0, 1014,    0,  966, -456,    0,    0,    0,    0,    0,
    0,  871,    0,    0,  876,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  888,    0,    0,    0,
    0,    0,    0,    0,    0,  -36,    0, 1400,    0,    0,
    0, 1040,    0,    0,    0,    0,    0, -170,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, 1502,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  709,
    0,    0,    0,    0,    0,    0,    0,    0,  810,    0,
    0,    0,    0,    0,    0,  -10, 1113,    0,    0,    0,
 1120,
  };
  protected static readonly short [] yyTable = {           108,
  502,  188,  109,  505,  113,   18,   44,  713,  344,  233,
  420,  438,  718,  478,  664,  154,  419,  463,  686,  750,
  155,  541,  532,  498,  191,  486,  312,  559,  256,  756,
  395,  258,  978, 1095, 1128, 1129,  558,  229,  860,  318,
  323,  304,  760,  923,  251,  521,  351,  113,  359,  527,
 1024,  113,  352,  783,  360,  647,  298,  458,  347,  402,
  298, 1215, 1025,   14,  287,  305,  374,  307,  780,  189,
  494,  159,  288, 1025,  402,  672,  328, 1222,   48,  160,
 1154,  648,  657,  161,  162,  691, 1009, 1419, 1427, 1428,
   48,  972,  851,   20,  660, 1333,    1, 1017, 1011,  163,
  164,  197,  165,  841,  842, 1123, 1293,  747,  635,  938,
  660, 1432,  360,  649,  661,  329,  330,  331,  332,  333,
  334,  335,  336,  804,  326, 1035,  424,  463,  617,  796,
  848,  166,   16,  197, 1442,  167,  231,  337,  108,  168,
  169,  109,  403,  113, 1459,  233,  871,  404,  873,  405,
  427,  428,  783,  798,  154,  406,  407,  403,  344,  155,
  673,  523,  404, 1433,  405,  799,  855,   45,  748, 1064,
  406,  407, 1467,    2,   48,  662, 1176,  660,  111,  374,
  495,  374,  496,  374,  249,  338,  196,  231, 1124,  437,
  530,  849,  781,  707, 1033, 1443, 1034,  731,    2,  438,
  344,   48,  855,  711,  660, 1420,  783,  843,  692,  852,
  159,  468,  429,  289,  339, 1026,  650,    6,  160, 1334,
  231,  111,  161,  162,   15,  111, 1026,  374,  435,  462,
  190,  408,  541,  250,  466,  194,  497,  476,  163,  164,
  559,  165,  541,  658,  458,  340,  418, 1010, 1401,  321,
  321,  564,  256,  507,  520,  474,  528,  341,  525, 1012,
  256,  341,  529,    3,    4,    5,    6, 1294,  321,  477,
  166,  113,  481,  483,  167, 1425,  661,  954,  168,  169,
  342,  519,   93,  857,  342,  508,  341, 1435,  231, 1436,
  516, 1468,  518,  550,  517,  342,  481,  113,  343,  784,
  923,  546,  865,  194,  194, 1153,    5,  534,  535,  342,
 1047, 1363,  936, 1390,  113,  856,  923,  111,  543,  857,
  298,  559,  194, 1169,  956,  540,   20,  597,  598,  632,
  542,  805,  641,  376, 1397,  965, 1234,  434, 1306,  462,
  575,  786,  731,  533,  583,  584,  585,  586,  587,  588,
  589,  590,  591,  592,  593,  620,  622,  625,  626,  661,
  321,  321, 1021,  665,  344, 1445, 1234,  392,  360,  377,
  966,  877,  877,  684, 1238,  544,  615,  233,  449,  393,
  533,  950, 1453,  685,  641,  775,  661,  636,  344, 1268,
  876,  876,  594,  595,  596,  341,  461,  533,  533,  533,
  533,  533,  533,  533,  533,  533,  533,  533,  533,  533,
  533,  533,  533,  834,  194,  194,  633,  634,  342,  450,
  339,  321,  645,  231, 1285,  231,  630,  923, 1286,   43,
 1307,  486,  338,  923,  684,  338,  627,  341,  463,  449,
  651,   49,  776,  559,  685,  111,  685,  321,  378,  379,
  877,  360,  558,  461,   93,  681, 1016,  321,  249, 1089,
  342,   55,  113,  321,  628,  462,  628,  341,  765,  876,
  767,  111,  768,  400,    6,  194,  818, 1101,  360,  709,
  450,  575,  360,  716,  360,  360,  360,  360,  111,  641,
  342,  472,  360,  328,  641,  245,  722,  724,  641,  246,
  819,  194,  199,  321,  343,  740,  321,  250, 1131, 1132,
  559,  194,  742,  641,  533, 1134,  757,  194,  934,  730,
  345,  628,  462,  345,  349,  113,  401,  820,  511,  466,
  929,  466,  752,  257,  797,  113,  540,  321,  321,  249,
  641,  542,  200,   48,  473,  725,  540,  367,  886,  247,
  707,  542,  311,  770,  770, 1266, 1195,  194,  758,  641,
  194,  231,  686,    5,  244,  321,  321,   48,  948,  257,
  257,  257,  257,  257,  257,  257,  257,  372,   48,  339,
  248,  853,  763,   48,  750,  961,  466,   48,  250,  402,
   48,  194,  194,  367, 1178, 1194,  505, 1269,  737, 1195,
  783, 1226,   48,   48, 1267,  344,  789,   48,   48,  639,
  666,  640,  696,   48, 1178,   48,   48,   48,   48,  194,
  194,  821,  341,   48,  565,  259,  341,   48,  822,   48,
  341, 1226,  261,  639,  566,  640,  111,  194, 1194,   48,
 1225,  345,   48,   93,   48,  342, 1270,  737,   48,  342,
  462,  194,  345,  342,  311,  609,  345,  609,  802,  343,
  639,  817,  640,  343,  481,   48,  256,  711,  338,  345,
 1225,  525,  403,  839,  863,  324,  321,  404,  716,  405,
  567,  113,  113,  709,  997,  406,  407,  372,  348,  372,
  568,  372,  372,  388,  372,  876,  372,  339,  260,  111,
  803,  345,  284,  285,  286, 1321,  290,  291,  880,  111,
  864,  302,  303,  225,  349,  226,  361,  338,  308,  321,
  310,  391,  314,  874,  113,  875,  113,  325,  326,  350,
  732,  342, 1351, 1352,  847, 1354,  389,  878,  372,  390,
  372,  345,  311,  372,  341,  764, 1373,  394,  358, 1380,
 1381, 1069,  345, 1196,  293,  575,  345,  257,  667,  636,
  575,  888,  929,  716, 1396,  257,  541,  342,  491,  345,
  331,  632,  492,  194,  904,  905,  331,  907,  397,  341,
  937,  343,  907,  332,  907,  667, 1098,  907,  907,  342,
  907,  907, 1197,  339,  667,  510, 1196,  541, 1227,  910,
  321,  345,  342,  766,  910,  926,  910,  477,  511,  910,
  910,  907,  910,  910,  651,  918,  343, 1104, 1046,  481,
  997,  321,  952, 1130,  666,  512, 1219,  541, 1227,  955,
 1048,  386,  387,  910,  257, 1197,  664, 1228, 1198,  963,
  341,  716, 1199,  422,  582,  349,  257,  257,  257,  341,
   93,  257,  257,  341,  194,  111,  111, 1384, 1200, 1258,
  424,  599,  600,  342,   65,   65,  907, 1228,   65,  424,
 1001,  533,  342,  311,  797,  194,  342,  343,  982,  865,
  984, 1198,  986, 1229,  321, 1199,  425, 1230,  910,  426,
  308,  438,  358,   93, 1212,  344,  996, 1255,  111, 1058,
  111, 1200, 1308, 1231, 1255,  321, 1201, 1202,  225,  349,
 1112, 1059,  763, 1229,  763,  651,  763, 1230,  321, 1437,
   93, 1003,  321, 1004,  867, 1005,  663,  716,  667, 1152,
  499,  430,  668, 1231,  901,  663,  433,  311,  194,  901,
  113,  901,  515,  345,  901,  901,  459,  901,  901, 1201,
 1202, 1232, 1233,  505,  345, 1456,  552,  345,  345,  194,
  225,  752,  228,  553,  249, 1039,  353, 1041,  282, 1042,
  460,  345,  194, 1473, 1474,  554,  194,  282,  292,  641,
  293, 1232, 1233,  467,  641,  354,  355,  903,  641,  321,
  321,  752,  903,  752,  903,  752,  471,  903,  903, 1051,
  903,  903,  552,  641,  827,  356,  699,  477,  662,  553,
  700,  380,  381,  250,  382,  383,  357,  662, 1289, 1076,
  716,  554,  708,  901, 1296,  194,  492, 1083,  384,  385,
  641, 1302,  996,  291, 1088,  291,  257,  769,  479,  477,
  291,  668,  477,  194,  194,  233,  480, 1115,   66,  641,
  321,  897,   66,  749,  501,  113,  897,  749,  897,  113,
 1108,  897,  897,  929,  897,  897,  977, 1111,  778,  233,
  540,  603,  604,  605,  606,  542,  903,  350,  507,  477,
  321,  345,  526,  345,  507,  506,  113,  113,  901,  902,
  113, 1136, 1042,  113,  181, 1049,  181, 1050,  181, 1115,
  531,  540,  345,  345,  194,  509,  542,  682,  345,  345,
 1173,  345,  345,   57,  111, 1080, 1081, 1177, 1193,  193,
  113,  193,  345,  193,  876,  876,  194,  373,  374,  375,
  345,  540, 1165,  345,  194,  350,  542, 1177,  545,  350,
  897,  345,  130,  745,  130,  745,  403,  723, 1210,  130,
  477,  404,  508,  405,  754,  424,  754,  424,  508,  406,
  407, 1193,  943, 1177,  943, 1173,  350,  169,  563,  169,
  350,  257,  345,  350,  569,  350,  424,  424, 1300,  176,
  350,  176,  177,  350,  177,  854,   68,  854,   68,  342,
  512, 1300,  646, 1177, 1264, 1265,  424,  199,  170,  199,
  170,  342,  430, 1260,  424, 1446, 1447,  424, 1329,  623,
 1330,  484,  346,  135,  350,  135,  531,  531, 1292,   57,
   25, 1295,   26,  641,  641,   27,  253, 1093, 1094,  111,
   28,   62,   63,  111,   29,  360,  296,  631,  296,  360,
   65,  345,  360,   31,  360,  142,  303,  142,  303,  360,
   33,  669,  321,  607,  608,   34,  671,   72,   73,   35,
  111,  111,  601,  602,  111,  683,  693,  111, 1309,  694,
  695,   37,  697,   38,   75,  698,  738,   39,  720,  721,
   77,  736,   79,  737,   81,   40,   41,  254,  739,   42,
  741,  743,  744, 1364,  111,  745,  746,  751,  759,  761,
  773,  586,  762,  774,  321,  778,  194,  779,  788,  362,
 1391,  785,  787,  794,  806,   90,   91,   92,  807,  810,
  321,  809,  813, 1403, 1405,   94,   43,  830,  716, 1260,
  363,  364,  365,  366,  367,  368,  369,  370,  371,  372,
  477,  825,  831,  832,  833,  840,  838,  837,  196,  854,
 1391, 1391,  836,  858,  859,  861,  868, 1413,  194,  830,
  870,  869,  883,  897,  892,  881,  899,  903,  906,  907,
  913,  104,  485,  914,  194,  321,  321,  916,  917,  919,
  922,  924,  930,  321,  586,  942,  943,  944,  945,  586,
  716,  586,  586,  586,  586,  586,  586,  586,  586,  586,
  586,  586,  951,  953,  321,  321, 1391,  321,  960,  495,
  969,  967,  586,  975,  586,  971,  586,  973,  586,  586,
  586,  979,  990,  980,  999, 1007,  716, 1006,  321,  194,
  194,  321, 1013, 1014,  586, 1461, 1461,  194, 1015, 1019,
 1022, 1020, 1469, 1469,  586,  586,  512,  575,  575, 1032,
  865,  512,  512, 1038, 1037, 1040, 1045,  586,  194,  194,
 1053,  194, 1057, 1060, 1061, 1062, 1063, 1281, 1070, 1075,
 1082, 1084, 1104,  586,  512, 1079, 1096, 1091, 1102, 1135,
 1281, 1100,  194, 1107,  512,  194, 1281,  512,  512, 1114,
 1142, 1140,  512, 1281, 1138,  512, 1144,  512, 1124,  512,
  512,  512,  512, 1151, 1156, 1143, 1160,  512, 1152, 1159,
 1161,  512, 1162, 1208, 1164,  512, 1168, 1211, 1213, 1271,
 1216, 1223, 1214,  512, 1284,  773,  512, 1241,  512,  512,
 1239, 1262, 1287, 1288,  512, 1298,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512, 1301, 1304,  512,
 1313, 1297, 1322, 1315, 1316, 1305,  512,  512, 1307,  512,
  512,  512,  512,  512,  512,  512, 1318,  512,  512, 1319,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
 1320,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512,  512,  512,  512,  512,  512,  512,  512,
  512,  512,  512, 1324, 1326,  512, 1327,  512, 1332,  512,
 1337, 1340,  512, 1344, 1347,  830,  830, 1345,  512, 1355,
 1356, 1374, 1359,  830,  830,  830,  830,  830, 1369,  830,
  830, 1376,  830,  830,  830,  830,  830,  830,  830,  830,
 1385, 1386, 1388, 1389,  830, 1395,  830,  830,  830,  830,
  830,  830, 1398,  345,  830, 1399, 1409, 1410,  830,  830,
 1412,  830,  830,  830, 1417, 1415, 1418, 1414, 1423, 1429,
 1430, 1434, 1438,  830, 1439,  830, 1448,  830,  830, 1433,
 1432,  830, 1454,  830,  830,  830,  830,  830,  830,  830,
  830,  830,  830,  830,  830, 1455,  830, 1475, 1476,  830,
  830,    9, 1477,  830,  830,  939,  542,  828,  730,   32,
  502,  931,  610,  798,  503,  461,  611,  674,   30,  830,
  830,  830,   22,  802,  501,  830,  830,   30,  748,  830,
  220,   31,  527,  323,  830,  830,  830,  830,  830,   96,
   31,  756,  830,  803,  830,  836,  757,  748,  777,  805,
  830,  830,  778,  807,  662,  662,  327,  684,  352,  345,
  641,  138,  641,  230,   54,  234,  120,   21,  299,  145,
  139,  121,  300,  146,  912,  830,  830,  830,  830,  991,
  830,  773,  773, 1086, 1217, 1087, 1263,  830, 1431,  773,
  773,  773,  773,  773, 1400,  773,  773, 1440,  773,  773,
  773,  773,  773,  773,  773,  738, 1387, 1416, 1382, 1278,
  773,  815,  773,  773,  773,  773,  773,  773,  939,  828,
  773, 1290, 1471,  940,  773,  773,  941,  773,  773,  773,
 1224, 1311, 1221,  935, 1464, 1406, 1411, 1404, 1463,  773,
 1157,  773, 1331,  773,  773, 1282, 1158,  773,  908,  773,
  773,  773,  773,  773,  773,  773,  773,  773,  773,  773,
  773,  733,  773,  959,  846,  773,  773,  887,  772,  773,
  773,  570,  885,  824,  295, 1023,  844,  609,  611,  610,
  614,  882,  612, 1242,  613,  773,  773,  773, 1146, 1149,
 1036,  773,  773, 1103,  396,  773, 1018, 1008, 1071, 1077,
  773,  773,  773,  773,  773, 1073, 1066,  981,  773,  345,
  773,  974,  726,  629,  345,  345,  773,  773, 1240, 1137,
  910,    0,    0,    0,    0,    0,  909,    0,    0,    0,
    0,    0,    0,    0,  338,    0,    0,  345,    0,    0,
    0,  773,  773,  773,  773,    0,  773,  345,    0,    0,
  345,  345,    0,  773,    0,  345,    0,    0,  345,    0,
  345,    0,  345,  345,  345,  345,    0,    0,    0,    0,
  345,    0,    0,    0,  345,    0,    0,    0,  345,    0,
    0,    0,    0,    0,    0,    0,  345,    0,    0,  345,
    0,  345,  345,    0,    0,    0,    0,  345,    0,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,    0,  345,    0,    0,    0,    0,    0,    0,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,    0,
  345,  345,    0,    0,  345,  345,  345,  345,  345,    0,
    0,  345,  345,    0,    0,    0,  345,  345,  345,  345,
  345,  345,  345,  345,    0,    0,    0,    0,    0,    0,
    0,  738,    0,  375,    0,  345,  738,  738,  345,    0,
  345,    0,  345,    0,    0,  345,    0,    0,    0,    0,
    0,  345,    0,    0,    0,    0,    0,    0,    0,  738,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  738,
    0,    0,  738,  738,    0,    0,    0,  738,    0,    0,
  738,    0,  738,    0,  738,  738,  738,  738,    0,    0,
    0,    0,  738,    0,    0,    0,  738,    0,    0,    0,
  738,    0,    0,    0,    0,    0,    0,    0,  738,    0,
    0,  738,    0,  738,  738,    0,    0,    0,    0,  738,
    0,  738,  738,  738,  738,  738,  738,  738,  738,  738,
  738,  738,    0,    0,  738,    0,    0,    0,    0,    0,
    0,  738,  738,  738,  738,  738,  738,    0,  738,  738,
  738,    0,  738,  738,    0,    0,  738,  738,  738,  738,
  338,    0,  345,  738,  738,  338,  338,    0,  738,  738,
  738,  738,  738,  738,  738,  738,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  738,  338,    0,
  738,    0,  738,    0,  738,    0,    0,  738,  338,    0,
    0,  338,  338,  738,    0,    0,  338,    0,    0,  338,
    0,  338,    0,  338,  338,  338,  338,    0,    0,    0,
    0,  338,    0,    0,    0,  338,    0,    0,    0,  338,
    0,    0,    0,    0,    0,    0,    0,  338,    0,    0,
  338,    0,  338,  338,    0,    0,    0,    0,  338,    0,
  338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
  338,    0,    0,  338,    0,    0,    0,    0,    0,    0,
  338,  338,  338,  338,  338,  338,    0,  338,  338,  338,
    0,  338,  338,    0,    0,  338,  338,  338,  338,  375,
    0,    0,  338,  338,  375,  375,    0,  338,  338,  338,
  338,  338,  338,  338,  338,    0,    0,  370,    0,    0,
    0,    0,    0,    0,    0,    0,  338,  375,    0,  338,
    0,  338,    0,  338,    0,    0,  338,  375,    0,    0,
  375,  375,  338,    0,    0,  375,    0,    0,  375,    0,
  375,    0,  375,  375,  375,  375,    0,    0,    0,    0,
  375,    0,    0,    0,  375,    0,    0,    0,  375,    0,
    0,    0,    0,    0,    0,    0,  375,    0,    0,  375,
    0,  375,  375,    0,    0,    0,    0,  375,  201,  375,
  375,  375,  375,  375,  375,  375,  375,  375,  375,  375,
    0,    0,  375,    0,    0,    0,    0,    0,    0,  375,
  375,    0,  375,  375,  375,    0,  375,  375,  375,    0,
  375,  375,    0,    0,  375,  375,  375,  375,  345,    0,
  202,  375,  375,    0,  345,    0,  375,  375,  375,  375,
  375,  375,  375,  375,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  375,    0,    0,  375,    0,
  375,    0,    0,    0,    0,    0,  345,    0,    0,    0,
  345,  375,    0,    0,   49,    0,    0,    0,    0,  203,
  204,  205,  206,    0,  207,  208,  209,  210,  211,  212,
  213,  214,    0,    0,  215,  216,  217,  218,  219,  220,
  221,  222,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  345,    0,    0,    0,    0,  345,    0,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  592,    0,    0,    0,    0,    0,    0,    0,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,    0,  345,
  345,    0,    0,  345,  345,  345,  345,  345,    0,    0,
  345,  345,    0,    0,    0,  345,  345,  345,  345,  345,
  345,  345,  345,  370,    0,    0,    0,    0,    0,  370,
    0,    0,    0,    0,  345,    0,   28,  345,    0,  345,
    0,  345,    0,    0,  345,    0,    0,    0,    0,    0,
  345,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  370,    0,  592,    0,  370,    0,    0,  592,    0,
  592,  592,  592,  592,  592,  592,  592,  592,  592,  592,
  592,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  592,    0,  592,    0,  592,    0,  592,  592,  592,
    0,    0,    0,    0,   36,    0,  370,    0,    0,    0,
    0,  370,    0,  370,  370,  370,  370,  370,  370,  370,
  370,  370,  370,  370,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  370,  370,    0,  370,  370,  370,    0,
  370,  370,  370,    0,  370,  370,    0,    0,  370,  370,
  370,  370,  592,    0,    0,  370,  370,    0,    0,    0,
  370,  370,  370,  370,  370,  370,  370,  370,    0,    0,
    0,    0,    0,   35,    0,    0,    0,    0,    0,  370,
    0,   49,  370,    0,  370,   49,    0,   49,    0,   49,
    0,   49,    0,    0,   49,  370,   49,   49,    0,   49,
    0,   49,    0,   49,    0,   49,   49,   49,   49,    0,
    0,   49,   49,    0,    0,    0,   34,   49,   49,   49,
   49,   49,    0,    0,   49,   49,   49,    0,   49,    0,
   49,   49,   49,   49,   49,   49,   49,   49,    0,   49,
   49,   49,   49,    0,    0,   49,   49,   49,    0,   49,
    0,    0,    0,    0,   49,   49,    0,   49,   49,   28,
   49,   49,   49,    0,    0,    0,   49,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   49,    0,    0,    0,   49,   49,    0,
    0,    0,   28,   28,    0,    0,    0,   28,    0,    0,
   49,   28,    0,   28,    0,    0,   28,    0,   28,   28,
    0,   28,    0,   28,    0,   28,    0,   28,   28,   28,
   28,    0,    0,   28,   28,    0,    0,    0,   33,   28,
    0,   28,   28,   28,    0,    0,   28,   28,   28,    0,
   28,   49,    0,   28,    0,   28,   28,   28,   28,    0,
    0,    0,   28,   28,   28,    0,    0,   28,   28,   28,
    0,   36,    0,    0,    0,   36,   28,   28,    0,   28,
   28,  921,   28,   28,   28,    0,   36,    0,   28,    0,
    0,   36,    0,    0,    0,   36,    0,    0,   36,    0,
    0,    0,    0,    0,    0,   28,    0,    0,    0,    0,
   36,   36,    0,   28,   28,   36,   36,    0,    0,    0,
    0,   36,   28,   36,   36,   36,   36,    0,    0,    0,
    0,   36,    0,    0,    0,   36,    0,   36,    0,    0,
   35,    0,    0,    0,   35,    0,    0,   36,   48,   36,
   36,    0,   36,    0,    0,   35,   36,    0,    0,    0,
   35,    0,    0,   28,   35,    0,    0,   35,    0,    0,
    0,    0,    0,   36,    0,    0,    0,    0,    0,   35,
   35,   36,   36,   34,   35,   35,    0,   34,    0,    0,
   35,    7,   35,   35,   35,   35,    0,    0,   34,    0,
   35,    0,    0,   34,   35,    0,   35,   34,    0,    0,
   34,    0,    0,    0,    0,    0,   35,    0,   35,   35,
    0,   35,   34,   34,    0,   35,   28,   34,   34,    0,
   28,    0,    0,   34,  922,   34,   34,   34,   34,    0,
    0,   28,   35,   34,    0,    0,   28,   34,    0,   34,
   28,   35,    0,   28,    0,    0,    0,    0,    0,   34,
    0,    0,   34,    0,   34,   28,   28,    0,   34,    0,
   28,   28,    0,    0,    0,    0,   28,    0,   28,   28,
   28,   28,    0,    0,    0,   34,   28,    0,    0,    0,
   28,    0,   28,   34,   34,   33,    0,    0,    0,   33,
    0,    0,   28,    0,    0,   28,    0,   28,    0,    0,
   33,   28,    0,    0,    0,   33,    0,    0,    0,   33,
    0,    0,   33,    0,    0,    0,    0,    0,   28,    0,
    0,    0,    0,    0,   33,   33,   28,   28,  921,   33,
   33,    0,   48,    0,    0,   33,    0,   33,   33,   33,
   33,    0,    0,   48,    0,   33,    0,    0,   48,   33,
    0,   33,   48,    0,    0,   48,    0,    0,    0,    0,
    0,   33,    0,    0,   33,    0,   33,   48,   48,    0,
   33,    0,   48,   48,    0,    0,    0,    0,   48,    0,
   48,   48,   48,   48,    0,    0,    0,   33,   48,    0,
    0,    0,   48,    0,   48,   48,   33,    0,    0,   48,
    0,    0,    0,    0,   48,    0,    0,   48,    0,   48,
   48,    0,    0,   48,    0,   48,    0,    0,    0,   48,
    0,    0,   48,    0,    0,    0,    0,    0,    0,    0,
   48,    0,    0,    0,   48,   48,    0,    0,    7,   48,
   48,    0,   49,    0,    0,   48,    0,   48,   48,   48,
   48,    0,    0,   49,    0,   48,    0,    0,   49,   48,
    0,   48,   49,    0,    0,   49,    0,    0,    0,    0,
    0,   48,    0,    0,   48,    0,   48,   49,   49,    0,
   48,  922,   49,   49,    0,   48,    0,    0,   49,    0,
   49,   49,   49,   49,    0,    0,   48,   48,   49,    0,
    0,   48,   49,    0,   49,   48,    0,    0,   48,    0,
    0,    0,    0,    0,   49,    0,    0,   49,    0,   49,
   48,   48,    0,   49,    0,   48,   48,    0,    0,    0,
    0,   48,    0,   48,   48,   48,   48,    0,    0,    0,
   49,   48,    0,    0,    0,   48,    0,   48,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   48,    0,   56,
   48,    0,   48,    0,    0,    0,   48,   57,   25,   58,
   26,    0,    0,   27,   59,    0,   60,   61,   28,   62,
   63,   64,   29,   48,    0,    0,    0,    0,   65,    0,
   66,   31,   67,   68,   69,   70,    0,    0,   33,    0,
    0,    0,   71,   34,    0,   72,   73,   35,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   74,    0,   37,
    0,   38,   75,    0,    0,   39,    0,   76,   77,   78,
   79,   80,   81,   40,   41,   82,   83,   42,   84,    0,
   85,    0,    0,   86,   87,  345,    0,   88,   89,    0,
    0,  345,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   90,   91,   92,    0,    0,    0,   93,
    0,    0,    0,   94,    0,    0,    0,    0,   95,   96,
   97,   98,   99,    0,    0,    0,  100,  345,  101,    0,
    0,    0,    0,    0,  102,  103,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  345,    0,    0,    0,    0,    0,  345,    0,  104,
  105,  106,  107,    0,    0,    0,    0,    0,  345,    0,
    0,  196,    0,  345,    0,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,    0,    0,    0,
    0,    0,    0,  345,    0,    0,  345,  345,  345,  345,
  345,  345,  345,  345,  345,    0,  345,  345,    0,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,    0,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,    0,  514,    0,    0,  345,    0,  345,  514,
    0,  345,    0,    0,    0,    0,    0,  345,    0,    0,
    0,    0,  345,    0,    0,  345,    0,  345,  345,    0,
    0,    0,  345,  345,    0,    0,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  514,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  345,  345,    0,    0,
    0,    0,    0,    0,  345,    0,    0,  345,    0,    0,
    0,    0,    0,  345,    0,    0,  514,    0,    0,    0,
    0,  514,    0,  514,  514,  514,  514,  514,  514,  514,
  514,  514,  514,  514,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  514,  514,  514,  514,  514,  514,  514,
  514,  514,  514,  913,  514,  514,    0,  514,  514,  514,
  514,  514,  514,  514,  514,  514,  514,    0,  514,  514,
  514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
  514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
    0,  510,    0,    0,    0,    0,  514,  510,    0,    0,
    0,    0,    0,    0,    0,  514,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  510,    0,    0,  913,    0,    0,    0,
    0,  913,    0,  913,  913,  913,  913,  913,  913,  913,
  913,  913,  913,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  345,  913,    0,  913,    0,  913,    0,
  913,  913,  913,    0,  510,    0,    0,    0,    0,  510,
    0,  510,  510,  510,  510,  510,  510,  510,  510,  510,
  510,  510,    0,    0,    0,    0,    0,    0,    0,  345,
    0,  510,  510,    0,  510,  510,  510,  510,  510,  510,
  510,    0,  510,  510,    0,  510,  510,  510,  510,  510,
  510,  510,  510,  510,  510,  913,  510,  510,  510,  510,
  510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
  510,  510,  510,  510,  510,  510,  510,  510,    0,  518,
    0,    0,    0,    0,  510,  518,    0,  510,  345,    0,
    0,    0,    0,  510,    0,    0,    0,    0,    0,  345,
    0,  345,    0,  345,    0,    0,  345,    0,  345,  345,
    0,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  518,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,    0,    0,    0,    0,  345,    0,
  345,  402,    0,  345,    0,    0,    0,    0,    0,  345,
    0,    0,  518,    0,    0,    0,    0,  518,    0,  518,
  518,  518,  518,  518,  518,  518,  518,  518,  518,  518,
    0,    0,    0,    0,    0,    0,    0,  402,    0,    0,
  518,    0,  518,  518,  518,  518,  518,  518,  518,    0,
  518,  518,    0,  518,  518,  518,  518,  518,  518,  518,
  518,  518,  518,    0,  518,  518,  518,  518,  518,  518,
  518,  518,  518,  518,  518,  518,  518,  518,  518,  518,
  518,  518,  518,  518,  518,  518,    0,  345,    0,    0,
    0,    0,  518,  345,    0,  518,    0,    0,    0,    0,
    0,  518,    0,    0,    0,    0,    0,  338,    0,  402,
  402,  402,  402,    0,  402,    0,  402,  402,    0,  402,
  402,  402,  402,  402,    0,  402,  402,  402,  402,  345,
  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
  402,  402,  402,  402,  402,  402,  402,  402,  402,  402,
  402,  402,    0,    0,    0,    0,  338,    0,  402,  345,
    0,  402,    0,    0,    0,    0,    0,  402,    0,    0,
  345,    0,    0,    0,    0,  345,    0,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,    0,    0,
    0,    0,    0,    0,    0,  345,    0,    0,  345,    0,
  345,  345,  345,  345,  345,  345,  345,    0,  345,  345,
    0,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,    0,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,    0,  445,    0,    0,    0,    0,
  345,  445,    0,  345,    0,    0,    0,    0,    0,  345,
    0,    0,    0,    0,    0,    0,  345,  345,  345,  345,
  345,    0,    0,    0,  345,  345,    0,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  445,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
    0,    0,    0,    0,    0,    0,  345,    0,    0,  345,
    0,    0,    0,    0,    0,  345,    0,    0,  445,    0,
    0,    0,    0,  445,    0,  445,  445,  445,  445,  445,
  445,  445,  445,  445,  445,  445,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  445,    0,  445,  445,
  445,  445,  445,  445,  445,    0,  445,  445,    0,  445,
  445,  445,  445,  445,  445,  445,  445,  445,  445,    0,
  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,
  445,  445,  445,  445,  445,  445,  445,  445,  445,  445,
  445,  445,    0,  405,  549,    0,    0,    0,  445,  405,
    0,  445,    0,   25,    0,   26,    0,  445,   27,    0,
    0,    0,    0,   28,    0,    0,    0,   29,    0,    0,
    0,    0,    0,    0,    0,    0,   31,    0,    0,    0,
    0,    0,    0,   33,    0,  405,    0,    0,   34,    0,
    0,    0,   35,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   37,    0,   38,    0,    0,    0,
   39,    0,    0,    0,    0,    0,    0,    0,   40,   41,
    0,    0,   42,    0,    0,  315,  405,    0,    0,    0,
    0,  405,    0,  405,  405,  405,  405,  405,  405,  405,
  405,  405,  405,  405,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  405,    0,  405,  405,  405,  405,
  405,  405,  405,    0,  405,    0,    0,  405,  405,  405,
  405,  405,  405,  405,  405,  405,  405,    0,  405,  405,
  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,
  405,  405,  405,  405,  405,  405,  405,  405,  405,  405,
    0,  547,  727,    0,    0,  346,  405,  547,    0,  405,
    0,   25,    0,   26,    0,  405,   27,    0,    0,    0,
    0,   28,    0,    0,    0,   29,    0,    0,    0,    0,
    0,    0,    0,    0,   31,    0,    0,    0,    0,    0,
    0,   33,    0,  547,    0,    0,   34,    0,    0,    0,
   35,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   37,    0,   38,    0,    0,    0,   39,    0,
    0,    0,    0,    0,    0,    0,   40,   41,    0,    0,
   42,    0,    0,  728,  547,    0,  588,    0,    0,  547,
    0,  547,  547,  547,  547,  547,  547,  547,  547,  547,
  547,  547,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  547,    0,  547,    0,  547,    0,  547,  547,
  547,    0,  547,  547,    0,  547,  547,  547,  547,  547,
  547,  547,  547,  547,  547,    0,    0,    0,  547,  547,
  547,  547,  547,  547,  547,  547,  547,  547,  547,  547,
  547,  547,  547,  547,  547,  547,  559,  547,    0,    0,
    0,    0,  559,  729,    0,    0,   48,    0,    0,  588,
    0,    0,    0,  547,  588,    0,  588,  588,  588,  588,
  588,  588,  588,  588,  588,  588,  588,    0,    0,   48,
    0,    0,    0,    0,    0,    0,    0,  588,  559,  588,
    0,  588,   48,  588,  588,  588,    0,   48,    0,    0,
    0,    0,   48,    0,   48,   48,   48,   48,    0,  588,
   48,    0,   48,  563,    0,    0,   48,    0,    0,  563,
  588,    0,    0,    0,    0,    0,    0,    0,   48,  559,
    0,   48,  588,   48,  559,    0,  559,  559,  559,  559,
  559,  559,  559,  559,  559,  559,  559,    0,  588,    0,
    0,    0,    0,    0,   48,  563,    0,  559,    0,  559,
    0,  559,  310,  559,  559,  559,    0,  559,  559,    0,
    0,  559,  559,  559,  559,  559,  559,  559,  559,  559,
    0,    0,    0,  559,  559,  559,  559,  559,  559,  559,
  559,    0,    0,    0,    0,    0,  563,    0,    0,    0,
    0,  563,  559,  563,  563,  563,  563,  563,  563,  563,
  563,  563,  563,  563,    0,    0,  566,    0,  559,    0,
    0,    0,  566,    0,  563,    0,  563,    0,  563,    0,
  563,  563,  563,    0,  563,  563,    0,    0,  563,  563,
  563,  563,    0,    0,    0,  563,  563,    0,    0,    0,
  563,  563,  563,  563,  563,  563,  563,  563,  566,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  563,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  564,    0,  563,    0,    0,    0,  564,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  566,
    0,    0,    0,    0,  566,    0,  566,  566,  566,  566,
  566,  566,  566,  566,  566,  566,  566,    0,    0,    0,
    0,    0,    0,    0,    0,  564,    0,  566,    0,  566,
    0,  566,    0,  566,  566,  566,    0,  566,  566,    0,
    0,  566,  566,  566,  566,    0,    0,    0,  566,  566,
    0,    0,    0,  566,  566,  566,  566,  566,  566,  566,
  566,    0,    0,    0,    0,    0,  564,    0,    0,    0,
    0,  564,  566,  564,  564,  564,  564,  564,  564,  564,
  564,  564,  564,  564,    0,    0,  565,    0,  566,    0,
    0,    0,  565,    0,  564,    0,  564,    0,  564,    0,
  564,  564,  564,    0,  564,  564,    0,    0,  564,  564,
  564,  564,    0,    0,    0,  564,  564,    0,    0,    0,
  564,  564,  564,  564,  564,  564,  564,  564,  565,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  564,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  569,    0,  564,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  565,
    0,    0,    0,    0,  565,    0,  565,  565,  565,  565,
  565,  565,  565,  565,  565,  565,  565,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  565,    0,  565,
    0,  565,    0,  565,  565,  565,    0,  565,  565,    0,
    0,  565,  565,  565,  565,    0,    0,    0,  565,  565,
  570,    0,    0,  565,  565,  565,  565,  565,  565,  565,
  565,    0,    0,    0,    0,    0,  569,    0,    0,    0,
    0,  569,  565,  569,  569,  569,  569,  569,  569,  569,
  569,  569,  569,  569,    0,    0,    0,    0,  565,    0,
    0,    0,    0,    0,  569,    0,  569,    0,  569,    0,
  569,  569,  569,    0,    0,    0,    0,    0,  569,  569,
  569,  569,    0,    0,    0,  569,  569,  571,    0,    0,
  569,  569,  569,  569,  569,  569,  569,  569,    0,    0,
    0,    0,    0,  570,    0,    0,    0,    0,  570,  569,
  570,  570,  570,  570,  570,  570,  570,  570,  570,  570,
  570,    0,    0,    0,    0,  569,    0,    0,    0,    0,
    0,  570,    0,  570,    0,  570,    0,  570,  570,  570,
    0,    0,    0,    0,    0,  570,  570,  570,  570,    0,
    0,    0,  570,  570,  572,    0,    0,  570,  570,  570,
  570,  570,  570,  570,  570,    0,    0,    0,    0,    0,
  571,    0,    0,    0,    0,  571,  570,  571,  571,  571,
  571,  571,  571,  571,  571,  571,  571,  571,    0,    0,
    0,    0,  570,    0,    0,    0,    0,    0,  571,    0,
  571,    0,  571,    0,  571,  571,  571,    0,    0,    0,
    0,    0,  571,  571,  571,  571,    0,    0,    0,  571,
  571,  573,    0,    0,  571,  571,  571,  571,  571,  571,
  571,  571,    0,    0,    0,    0,    0,  572,    0,    0,
    0,    0,  572,  571,  572,  572,  572,  572,  572,  572,
  572,  572,  572,  572,  572,    0,    0,    0,    0,  571,
    0,    0,    0,    0,    0,  572,    0,  572,    0,  572,
    0,  572,  572,  572,    0,    0,    0,    0,    0,  572,
  572,  572,  572,    0,    0,    0,  572,  572,  574,    0,
    0,    0,    0,  572,  572,  572,  572,  572,  572,    0,
    0,    0,    0,    0,  573,    0,    0,    0,    0,  573,
  572,  573,  573,  573,  573,  573,  573,  573,  573,  573,
  573,  573,    0,    0,    0,    0,  572,    0,    0,    0,
    0,    0,  573,    0,  573,    0,  573,    0,  573,  573,
  573,    0,    0,    0,    0,    0,  573,  573,  573,  573,
    0,    0,    0,  573,  573,  575,    0,    0,    0,    0,
  573,  573,  573,  573,  573,  573,    0,    0,    0,    0,
    0,  574,    0,    0,    0,    0,  574,  573,  574,  574,
  574,  574,  574,  574,  574,  574,  574,  574,  574,    0,
    0,    0,    0,  573,    0,    0,    0,    0,    0,  574,
    0,  574,    0,  574,    0,  574,  574,  574,    0,    0,
    0,    0,    0,  574,  574,  574,  574,    0,    0,    0,
  574,  574,  576,    0,    0,    0,    0,  574,  574,  574,
  574,  574,  574,    0,    0,    0,    0,    0,  575,    0,
    0,    0,    0,  575,  574,  575,  575,  575,  575,  575,
  575,  575,  575,  575,  575,  575,    0,    0,    0,    0,
  574,    0,    0,    0,    0,    0,  575,    0,  575,    0,
  575,    0,  575,  575,  575,    0,    0,    0,    0,    0,
  575,  575,  575,  575,    0,    0,    0,  575,  575,  577,
    0,    0,    0,    0,  575,  575,  575,  575,  575,  575,
    0,    0,    0,    0,    0,  576,    0,    0,    0,    0,
  576,  575,  576,  576,  576,  576,  576,  576,  576,  576,
  576,  576,  576,    0,    0,    0,    0,  575,    0,    0,
    0,    0,    0,  576,    0,  576,    0,  576,    0,  576,
  576,  576,    0,    0,    0,    0,    0,  576,  576,  576,
  576,    0,    0,    0,  576,  576,  578,    0,    0,    0,
    0,  576,  576,  576,  576,  576,  576,    0,    0,    0,
    0,    0,  577,    0,    0,    0,    0,  577,  576,  577,
  577,  577,  577,  577,  577,  577,  577,  577,  577,  577,
    0,    0,    0,    0,  576,    0,    0,    0,    0,    0,
  577,    0,  577,    0,  577,    0,  577,  577,  577,    0,
    0,    0,    0,    0,    0,    0,  577,  577,    0,    0,
    0,  577,  577,  579,    0,    0,    0,    0,    0,    0,
  577,  577,  577,  577,    0,    0,    0,    0,    0,  578,
    0,    0,    0,    0,  578,  577,  578,  578,  578,  578,
  578,  578,  578,  578,  578,  578,  578,    0,    0,    0,
    0,  577,    0,    0,    0,    0,    0,  578,    0,  578,
    0,  578,    0,  578,  578,  578,    0,    0,    0,    0,
    0,    0,    0,  578,  578,    0,    0,    0,  578,  578,
  580,    0,    0,    0,    0,    0,    0,  578,  578,  578,
  578,    0,    0,    0,    0,    0,  579,    0,    0,    0,
    0,  579,  578,  579,  579,  579,  579,  579,  579,  579,
  579,  579,  579,  579,    0,    0,    0,    0,  578,    0,
    0,    0,    0,    0,  579,    0,  579,    0,  579,    0,
  579,  579,  579,    0,    0,    0,    0,    0,    0,    0,
  579,  579,    0,    0,    0,  579,  579,  581,    0,    0,
    0,    0,    0,    0,  579,  579,  579,  579,    0,    0,
    0,    0,    0,  580,    0,    0,    0,    0,  580,  579,
  580,  580,  580,  580,  580,  580,  580,  580,  580,  580,
  580,    0,    0,    0,    0,  579,    0,    0,    0,    0,
    0,  580,    0,  580,    0,  580,    0,  580,  580,  580,
    0,    0,    0,    0,    0,    0,    0,  580,  580,    0,
    0,    0,  580,  580,  582,    0,    0,    0,    0,    0,
    0,    0,    0,  580,  580,    0,    0,    0,    0,    0,
  581,    0,    0,    0,    0,  581,  580,  581,  581,  581,
  581,  581,  581,  581,  581,  581,  581,  581,    0,    0,
    0,    0,  580,    0,    0,    0,    0,    0,  581,    0,
  581,    0,  581,    0,  581,  581,  581,    0,    0,    0,
    0,    0,    0,    0,  581,  581,    0,    0,    0,  581,
  581,  583,    0,    0,    0,    0,    0,    0,    0,    0,
  581,  581,    0,    0,    0,    0,    0,  582,    0,    0,
    0,    0,  582,  581,  582,  582,  582,  582,  582,  582,
  582,  582,  582,  582,  582,    0,    0,    0,    0,  581,
    0,    0,    0,    0,    0,  582,    0,  582,    0,  582,
    0,  582,  582,  582,    0,    0,    0,    0,    0,    0,
    0,    0,  582,    0,    0,    0,  582,  582,  584,    0,
    0,    0,    0,    0,    0,    0,    0,  582,  582,    0,
    0,    0,    0,    0,  583,    0,    0,    0,    0,  583,
  582,  583,  583,  583,  583,  583,  583,  583,  583,  583,
  583,  583,    0,    0,    0,    0,  582,    0,    0,    0,
    0,    0,  583,    0,  583,    0,  583,    0,  583,  583,
  583,    0,    0,    0,    0,    0,    0,    0,    0,  583,
    0,    0,    0,  583,  583,  585,    0,    0,    0,    0,
    0,    0,    0,    0,  583,  583,    0,    0,    0,    0,
    0,  584,    0,    0,    0,    0,  584,  583,  584,  584,
  584,  584,  584,  584,  584,  584,  584,  584,  584,    0,
    0,    0,    0,  583,    0,    0,    0,    0,    0,  584,
    0,  584,    0,  584,    0,  584,  584,  584,    0,    0,
    0,    0,    0,    0,    0,    0,  584,    0,    0,    0,
    0,  584,  587,    0,    0,    0,    0,    0,    0,    0,
    0,  584,  584,    0,    0,    0,    0,    0,  585,    0,
    0,    0,    0,  585,  584,  585,  585,  585,  585,  585,
  585,  585,  585,  585,  585,  585,    0,    0,    0,    0,
  584,    0,    0,    0,    0,    0,  585,    0,  585,    0,
  585,    0,  585,  585,  585,    0,    0,    0,    0,    0,
    0,    0,    0,  585,    0,    0,    0,    0,  585,  589,
    0,    0,    0,    0,    0,    0,    0,    0,  585,  585,
    0,    0,    0,    0,    0,  587,    0,    0,    0,    0,
  587,  585,  587,  587,  587,  587,  587,  587,  587,  587,
  587,  587,  587,    0,    0,    0,    0,  585,    0,    0,
    0,    0,    0,  587,    0,  587,    0,  587,    0,  587,
  587,  587,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  587,  590,    0,    0,    0,
    0,    0,    0,    0,    0,  587,  587,    0,    0,    0,
    0,    0,  589,    0,    0,    0,    0,  589,  587,  589,
  589,  589,  589,  589,  589,  589,  589,  589,  589,  589,
    0,    0,    0,    0,  587,    0,    0,    0,    0,    0,
  589,    0,  589,    0,  589,    0,  589,  589,  589,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  589,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  589,    0,    0,    0,    0,    0,  590,
    0,    0,    0,    0,  590,  589,  590,  590,  590,  590,
  590,  590,  590,  590,  590,  590,  590,    0,    0,    0,
    0,  589,    0,    0,    0,    0,    0,  590,    0,  590,
    0,  590,    0,  590,  590,  590,   56,    0,    0,    0,
    0,    0,    0,    0,   57,   25,   58,   26,    0,  590,
   27,   59,    0,   60,   61,   28,   62,   63,   64,   29,
    0,    0,    0,    0,    0,   65,    0,   66,   31,   67,
   68,   69,   70,    0,    0,   33,    0,    0,    0,   71,
   34,    0,   72,   73,   35,    0,    0,    0,  590,    0,
    0,    0,    0,    0,   74,    0,   37,    0,   38,   75,
    0,    0,   39,    0,   76,   77,   78,   79,   80,   81,
   40,   41,   82,   83,   42,   84,    0,   85,    0,    0,
   86,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,    0,    0,    0,   93,    0,    0,    0,
   94,    0,    0,    0,    0,   95,   96,   97,   98,   99,
    0,    0,    0,  100,    0,  101,    0,    0,    0,    0,
    0,  102,  103,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  264,    0,    0,    0,  104,  105,  106,  107,
   57,   25,   58,   26,    0,    0,   27,   59,    0,   60,
   61,   28,   62,   63,   64,   29,    0,    0,    0,    0,
    0,   65,    0,   66,   31,   67,   68,   69,   70,    0,
    0,   33,    0,    0,    0,   71,   34,    0,   72,   73,
   35,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   74,    0,   37,    0,   38,   75,    0,    0,   39,    0,
   76,   77,   78,   79,   80,   81,   40,   41,   82,   83,
   42,   84,    0,   85,    0,    0,   86,   87,    0,    0,
   88,   89,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   90,   91,   92,    0,
    0,    0,   93,    0,    0,    0,   94,    0,    0,    0,
    0,   95,   96,   97,   98,   99,    0,    0,    0,  100,
    0,  101,    0,    0,    0,    0,    0,  102,  103,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  536,    0,
    0,    0,  104,  105,  106,  107,   57,   25,   58,   26,
    0,    0,   27,   59,    0,   60,   61,   28,   62,   63,
   64,   29,    0,    0,    0,    0,    0,   65,    0,   66,
   31,   67,   68,   69,   70,    0,    0,   33,    0,    0,
    0,   71,   34,    0,   72,   73,   35,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   74,    0,   37,    0,
   38,   75,    0,    0,   39,    0,   76,   77,   78,   79,
   80,   81,   40,   41,   82,   83,   42,   84,    0,   85,
    0,    0,   86,   87,    0,    0,   88,   89,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   90,   91,   92,    0,    0,    0,   93,    0,
    0,    0,   94,    0,    0,    0,    0,   95,   96,   97,
   98,   99,    0,    0,    0,  100,    0,  101,    0,    0,
    0,    0,    0,  102,  103,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  918,    0,    0,    0,  104,  105,
  106,  107,  918,  918,  918,  918,    0,    0,  918,  918,
    0,  918,  918,  918,  918,  918,  918,  918,    0,    0,
    0,    0,    0,  918,    0,  918,  918,  918,  918,  918,
  918,    0,    0,  918,    0,    0,    0,  918,  918,    0,
  918,  918,  918,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  918,    0,  918,    0,  918,  918,    0,    0,
  918,    0,  918,  918,  918,  918,  918,  918,  918,  918,
  918,  918,  918,  918,    0,  918,    0,    0,  918,  918,
    0,    0,  918,  918,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  918,  918,
  918,    0,    0,    0,  918,    0,    0,    0,  918,    0,
    0,    0,    0,  918,  918,  918,  918,  918,    0,    0,
    0,  918,    0,  918,    0,    0,    0,    0,    0,  918,
  918,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  782,    0,    0,    0,  918,  918,  918,  918,  782,  782,
  782,  782,    0,    0,  782,  782,    0,  782,  782,  782,
  782,  782,  782,  782,    0,    0,    0,    0,    0,  782,
    0,  782,  782,  782,  782,  782,  782,    0,    0,  782,
    0,    0,    0,  782,  782,    0,  782,  782,  782,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  782,    0,
  782,    0,  782,  782,    0,    0,  782,    0,  782,  782,
  782,  782,  782,  782,  782,  782,  782,  782,  782,  782,
    0,  782,    0,    0,  782,  782,    0,    0,  782,  782,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  782,  782,  782,    0,    0,    0,
  782,    0,    0,    0,  782,    0,    0,    0,    0,  782,
  782,  782,  782,  782,    0,    0,    0,  782,    0,  782,
    0,    0,    0,    0,    0,  782,  782,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  714,    0,    0,    0,
  782,  782,  782,  782,   57,   25,    0,   26,    0,    0,
   27,  253,    0,  862,    0,   28,   62,   63,    0,   29,
    0,    0,   25,    0,   26,   65,    0,   27,   31,    0,
    0,    0,   28,    0,    0,   33,   29,    0,    0,    0,
   34,    0,   72,   73,   35,   31,    0,    0,    0,    0,
    0,    0,   33,    0,    0,    0,   37,   34,   38,   75,
    0,   35,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  254,   37,   42,   38,    0,    0,    0,   39,
    0,   87,    0,    0,   88,   89,    0,   40,   41,    0,
    0,   42,    0,    0,  315,    0,    0,    0,    0,    0,
   90,   91,   92,    0,    0,    0,  501,  715,    0,    0,
   94,    0,    0,    0,    0,    0,   96,   97,   98,   99,
    0,    0,    0,  100,    0,  101,    0,    0,    0,    0,
    0,  102,  103,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  714,    0,    0,    0,  104,  297,  106,  107,
   57,   25,    0,   26,    0,    0,   27,  253,    0, 1000,
    0,   28,   62,   63,  346,   29,    0,    0,   25,    0,
   26,   65,    0,   27,   31,    0,    0,    0,   28,    0,
    0,   33,   29,    0,    0,    0,   34,    0,   72,   73,
   35,   31,    0,    0,    0,    0,    0,    0,   33,    0,
    0,    0,   37,   34,   38,   75,  889,   35,   39,    0,
    0,   77,    0,   79,    0,   81,   40,   41,  254,   37,
   42,   38,    0,    0,    0,   39,    0,   87,    0,    0,
   88,   89,    0,   40,   41,    0,    0,   42,    0,    0,
  315,    0,    0,    0,    0,    0,   90,   91,   92,    0,
    0,    0,  501,    0,    0,    0,   94,    0,    0,    0,
    0,    0,   96,   97,   98,   99,    0,    0,    0,  100,
    0,  101,    0,    0,    0,    0,    0,  102,  103,    0,
    0,    0,    0,    0,    0,   57,   25,    0,   26,    0,
    0,   27,  253,    0,    0,    0,   28,   62,   63,    0,
   29,    0,  104,  297,  106,  107,   65,    0,    0,   31,
    0,    0,    0,    0,    0,    0,   33,    0,    0,    0,
  346,   34,    0,   72,   73,   35,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,   37,    0,   38,
   75,    0,    0,   39,    0,    0,   77,    0,   79,    0,
   81,   40,   41,  254,    0,   42,    0,    0,    0,    0,
    0,    0,   87,    0,    0,   88,   89,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   90,   91,   92,    0,    0,    0,  701,  958,    0,
    0,   94,    0,    0,    0,    0,    0,   96,   97,   98,
   99,    0,    0,    0,  100,    0,  101,    0,    0,    0,
    0,    0,  102,  103,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  684,    0,  104,  702,  106,
  107,    0,    0,   57,   25,    0,   26,    0,  703,   27,
  253,    0, 1119,    0,   28,   62,   63,    0,   29,    0,
    0,   25,    0,   26,   65,    0,   27,   31,    0,    0,
    0,   28,    0,    0,   33,   29,    0,    0,    0,   34,
    0,   72,   73,   35,   31,    0,    0,    0,    0,    0,
    0,   33,    0,    0,    0,   37,   34,   38,   75,    0,
   35,   39,    0,    0,   77,    0,   79,    0,   81,   40,
   41,  254,   37,   42,   38,    0,   85,    0,   39,    0,
   87,    0,    0,   88,   89,    0,   40,   41,    0,    0,
   42,    0,    0,  315,    0,    0,    0,    0,    0,   90,
   91,   92,    0,    0,    0,    0,    0,    0,    0,   94,
    0,    0,    0,    0,    0,   96,   97,   98,   99,    0,
    0,    0,  100,    0,  101,    0,    0,    0,    0,    0,
  102,  103,    0,    0,    0,    0,    0,    0,   57,   25,
    0,   26,    0,    0,   27,  253,    0,    0,    0,   28,
   62,   63,    0,   29,    0,  104,  297,  106,  107,   65,
    0,    0,   31,    0,    0,    0,    0,    0,    0,   33,
    0,    0,    0,  346,   34,    0,   72,   73,   35,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   37,    0,   38,   75,    0,    0,   39,    0,    0,   77,
    0,   79,    0,   81,   40,   41,  254,    0,   42,    0,
    0,    0,    0,    0,    0,   87,    0,    0,   88,   89,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   90,   91,   92,    0,    0,    0,
  701,    0,    0,    0,   94,    0,    0,    0,    0,    0,
   96,   97,   98,   99,    0,    0,    0,  100,    0,  101,
    0,    0,    0,    0,    0,  102,  103,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,  714,    0,
  104,  702,  106,  107,    0,    0,   57,   25,    0,   26,
    0,  703,   27,  253,    0,    0,    0,   28,   62,   63,
    0,   29,    0,    0,  186,    0,  186,   65,    0,  186,
   31,    0,    0,    0,  186,    0,    0,   33,  186,    0,
    0,    0,   34,    0,   72,   73,   35,  186,    0,    0,
    0,    0,    0,    0,  186,    0,    0,    0,   37,  186,
   38,   75,    0,  186,   39,    0,    0,   77,    0,   79,
    0,   81,   40,   41,  254,  186,   42,  186,    0,    0,
    0,  186,    0,   87,    0,    0,   88,   89,    0,  186,
  186,    0,    0,  186,    0,    0,  186,    0,    0,    0,
    0,    0,   90,   91,   92,    0,    0,    0,  501,    0,
    0,    0,   94,    0,    0,    0,    0,    0,   96,   97,
   98,   99,    0,    0,    0,  100,    0,  101,    0,    0,
  942,    0,    0,  102,  103,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  877,    0,    0,    0,  104,  297,
  106,  107,   57,   25,    0,   26,    0,    0,   27,  253,
    0,    0,    0,   28,   62,   63,  186,   29,    0,    0,
  186,    0,  186,   65,    0,  186,   31,    0,    0,    0,
  186,    0,    0,   33,  186,    0,    0,    0,   34,    0,
   72,   73,   35,  186,    0,    0,    0,    0,    0,    0,
  186,    0,    0,    0,   37,  186,   38,   75,    0,  186,
   39,    0,    0,   77,    0,   79,    0,   81,   40,   41,
  254,  186,   42,  186,    0,    0,    0,  186,    0,   87,
    0,    0,   88,   89,    0,  186,  186,    0,    0,  186,
    0,    0,  186,    0,    0,    0,    0,    0,   90,   91,
   92,    0,    0,    0,    0,    0,    0,    0,   94,    0,
    0,    0,    0,    0,   96,   97,   98,   99,    0,    0,
    0,  100,    0,  101,  942,    0,    0,    0,    0,  102,
  103,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  614,    0,    0,    0,  104,  297,  106,  107,  614,  614,
    0,  614,    0,    0,  614,  614,    0,    0,    0,  614,
  614,  614,  186,  614,    0,    0,    0,    0,    0,  614,
    0,    0,  614,    0,    0,    0,    0,    0,    0,  614,
    0,    0,    0,    0,  614,    0,  614,  614,  614,    0,
    0,    0,    0,    0,    0,    0,  345,    0,    0,    0,
  614,    0,  614,  614,    0,    0,  614,    0,    0,  614,
    0,  614,    0,  614,  614,  614,  614,    0,  614,    0,
    0,    0,    0,    0,    0,  614,    0,    0,  614,  614,
    0,    0,  345,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  614,  614,  614,    0,    0,    0,
    0,    0,    0,    0,  614,    0,    0,    0,    0,    0,
  614,  614,  614,  614,    0,    0,    0,  614,    0,  614,
    0,    0,    0,    0,    0,  614,  614,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
  614,  614,  614,  614,  345,  345,  345,  345,    0,    0,
    0,  345,  345,    0,    0,  345,  345,  345,  345,  345,
  345,  345,  345,  345,    0,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
  345,  345,  345,  345,  345,  345,  345,    0,   48,    0,
    0,    0,   48,  345,   48,    0,  345,   48,    0,   48,
   48,    0,   48,    0,   48,    0,   48,    0,   48,   48,
   48,   48,    0,    0,   48,   48,    0,    0,    0,    0,
   48,    0,   48,   48,   48,    0,    0,   48,    0,   48,
    0,   48,    0,    0,   48,    0,   48,   48,   48,   48,
    0,    0,    0,   48,   48,   48,    0,    0,   48,   48,
   48,    0,    0,    0,    0,    0,    0,   48,   48,    0,
   48,   48,    0,   48,   48,   48,    0,    0,    0,   48,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   48,
    0,    0,    0,   48,    0,   48,   48,    0,   48,    0,
   48,   48,    0,   48,   81,   48,    0,   48,    0,   48,
   48,   48,   48,   48,    0,   48,   48,    0,    0,    0,
    0,   48,    0,   48,   48,   48,    0,    0,   48,    0,
   48,    0,   48,    0,    0,   48,    0,   48,   48,   48,
   48,    0,    0,    0,   48,   48,   48,    0,    0,   48,
   48,   48,    0,    0,   48,    0,    0,    0,   48,   48,
    0,   48,   48,    0,   48,   48,   48,    0,    0,    0,
   48,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   48,    0,    0,    0,   48,    0,   48,   48,    0,   48,
    0,   48,   48,    0,   48,   82,   48,    0,   48,    0,
   48,   48,   48,   48,   48,    0,   48,   48,    0,    0,
    0,    0,   48,    0,   48,   48,   48,    0,    0,   48,
    0,   48,    0,   48,    0,    0,   48,    0,   48,   48,
   48,   48,    0,    0,    0,   48,   48,   48,    0,    0,
   48,   48,   48,    0,    0,   48,    0,    0,    0,   48,
   48,    0,   48,   48,    0,   48,   48,   48,    0,    0,
    0,   48,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   48,    0,    0,    0,   48,    0,   48,   48,    0,
   48,    0,   48,   48,    0,   48,  104,   48,    0,   48,
    0,   48,   48,   48,   48,   48,    0,   48,   48,    0,
    0,    0,    0,   48,    0,   48,   48,   48,    0,    0,
   48,    0,   48,    0,   48,    0,    0,   48,    0,   48,
   48,   48,   48,    0,    0,    0,   48,   48,   48,    0,
    0,   48,   48,   48,    0,    0,   48,    0,    0,    0,
   48,   48,    0,   48,   48,    0,   48,   48,   48,    0,
    0,    0,   48,    0,    0,    0,    0,    0,    0,    0,
    0,    0,   48,    0,    0,    0,   48,    0,   48,   48,
    0,   48,    0,   48,   48,    0,   48,  105,   48,    0,
   48,    0,   48,   48,   48,   48,   48,    0,   48,   48,
    0,    0,    0,    0,   48,    0,   48,   48,   48,    0,
    0,   48,    0,   48,    0,   48,    0,    0,   48,    0,
   48,   48,   48,   48,    0,    0,    0,   48,   48,   48,
    0,    0,   48,   48,   48,    0,    0,   48,    0,    0,
    0,   48,   48,    0,   48,   48,    0,   48,   48,   48,
    0,    0,    0,   48,    0,    0,    0,    0,    0,    0,
    0,    0,    0,   48,    0,    0,    0,   48,    0,   48,
   48,    0,   48,    0,   48,   48,    0,   48,  226,   48,
    0,   48,    0,   48,   48,   48,   48,    0,    0,   48,
   48,    0,    0,    0,    0,   48,    0,   48,   48,   48,
    0,    0,   48,    0,   48,    0,   48,  345,    0,   48,
    0,   48,   48,   48,   48,    0,    0,    0,   48,   48,
   48,    0,    0,   48,   48,   48,    0,    0,   48,    0,
  345,    0,   48,   48,    0,   48,   48,    0,   48,   48,
   48,    0,    0,  345,   48,    0,    0,    0,  345,    0,
    0,  345,    0,  345,    0,  345,  345,  345,  345,    0,
    0,   48,    0,  345,    0,    0,    0,  345,    0,  227,
    0,  345,    0,    0,    0,    0,  367,    0,    0,  345,
    0,    0,  345,    0,  345,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,  367,
    0,    0,    0,  345,    0,  345,  366,    0,    0,    0,
    0,    0,  367,    0,  345,    0,  277,  367,  345,   48,
  244,    0,  367,    0,  367,  367,  367,  367,    0,  366,
    0,  345,  367,    0,    0,    0,  367,    0,    0,    0,
  367,  439,  366,    0,    0,    0,    0,  366,  367,    0,
  243,  367,  366,  367,  366,  366,  366,  366,    0,    0,
    0,    0,  366,  345,  440,    0,  366,    0,    0,    0,
  366,  439,    0,    0,  367,    0,    0,  441,  366,    0,
    0,  366,  443,  366,    0,    0,    0,  444,    0,  445,
  446,  447,  448,    0,  440,    0,    0,  449,    0,    0,
    0,  450,    0,    0,  366, 1274,    0,  441,    0,    0,
    0,    0,  443,  451,    0,    0,  452,  444,  453,  445,
  446,  447,  448,    0,    0,    0,    0,  449,    0,    0,
    0,  450,  367,    0,    0,    0,    0,    0,    0,  454,
    0,    0,    0,  451,   57,   25,  452,   26,  453,    0,
   27,  253,    0,    0,    0,   28,   62,   63,    0,   29,
    0,    0,  366,    0,    0,   65,    0,    0,   31,  454,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,  571,    0,    0,    0,
    0,    0,    0,  572,    0,    0,   37, 1275,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  254,    0,   42,    0,    0,    0,    0,    0,
    0,  573,    0,    0,   88,   89,    0, 1288,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,    0,    0,    0,    0,    0,    0,    0,
   94,  884,    0,  574,    0,    0,   96,   97,   98,   99,
    0,    0,    0,  100,    0,  101,    0,    0,    0,    0,
    0,  102,  103,    0,    0,    0,    0,    0,    0,   57,
   25,    0,   26,    0,    0,   27,  253,    0,    0,    0,
   28,   62,   63,    0,   29,    0,  104,  461,  106,  107,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,    0,    0,    0,    0,   34,    0,   72,   73,   35,
    0,  571,    0,    0,    0,    0,    0,    0,  572,    0,
    0,   37,    0,   38,   75,    0,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  254,    0,   42,
    0,    0,    0,    0,    0,    0,  573,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,    0,    0,
    0,    0,    0,    0,    0,   94,    0,    0,  574,    0,
    0,   96,   97,   98,   99,    0,    0,    0,  100,    0,
  101,    0,    0,    0,    0,    0,  102,  103,    0,    0,
    0,    0,    0,    0,   57,   25,    0,   26,    0,    0,
   27,  253,    0,    0,    0,   28,   62,   63,    0,   29,
    0,  104,  461,  106,  107,   65,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,  571,    0,    0,    0,
    0,    0,    0,  572,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  254,    0,   42,    0,    0,    0,    0,    0,
    0,  573,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,    0,    0,    0,    0,    0,    0,    0,
   94,    0,    0,    0,    0,    0,   96,   97,   98,   99,
    0,    0,    0,  100,    0,  101,    0,    0,    0,    0,
    0,  102,  103,    0,    0,    0,    0,    0,    0,   57,
   25,    0,   26,    0,    0,   27,  253,    0,    0,    0,
   28,   62,   63,    0,   29,    0,  104,  461,  106,  107,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,    0,    0,    0,    0,   34,    0,   72,   73,   35,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   37,    0,   38,   75,    0,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  254,    0,   42,
    0,    0,   85,    0,    0,    0,   87,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,    0,    0,
    0,    0,    0,    0,    0,   94,    0,    0,    0,    0,
    0,   96,   97,   98,   99,    0,    0,    0,  100,    0,
  101,    0,    0,    0,    0,    0,  102,  103,    0,    0,
    0,    0,    0,    0,   57,   25,    0,   26,    0,    0,
   27,  253,    0,    0,    0,   28,   62,   63,    0,   29,
    0,  104,  297,  106,  107,   65,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  254,    0,   42,    0,    0,    0,    0,    0,
    0,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,    0,    0,    0,    0,  845,    0,    0,
   94,    0,    0,    0,    0,    0,   96,   97,   98,   99,
    0,    0,    0,  100,    0,  101,    0,    0,    0,    0,
    0,  102,  103,    0,    0,    0,    0,    0,    0,   57,
   25,    0,   26,    0,    0,   27,  253,    0,    0,    0,
   28,   62,   63,    0,   29,    0,  104,  297,  106,  107,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,    0,    0,    0,    0,   34,    0,   72,   73,   35,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   37,    0,   38,   75,    0,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  254,    0,   42,
    0,    0,    0,    0,    0,    0,   87,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,    0,    0,
    0,  501,    0,    0,    0,   94,    0,    0,    0,    0,
    0,   96,   97,   98,   99,    0,    0,    0,  100,    0,
  101,    0,    0,    0,    0,    0,  102,  103,    0,    0,
    0,    0,    0,    0,   57,   25,    0,   26,    0,    0,
   27,  253,    0,    0,    0,   28,   62,   63,    0,   29,
    0,  104,  297,  106,  107,   65,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  254,    0,   42,    0,    0,    0,    0,    0,
    0,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,    0,    0,    0,  495,    0,    0,    0,
   94,    0,    0,    0,    0,    0,   96,   97,   98,   99,
    0,    0,    0,  100,    0,  101,    0,    0,    0,    0,
    0,  102,  103,    0,    0,    0,    0,    0,    0,   57,
   25,    0,   26,    0,    0,   27,  253,    0,    0,    0,
   28,   62,   63,    0,   29,    0,  104,  297,  106,  107,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,    0,    0,    0,    0,   34,    0,   72,   73,   35,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   37,    0,   38,   75,    0,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  254,    0,   42,
    0,    0,    0,    0,    0,    0,   87,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,    0,    0,
    0,    0,    0,    0,    0,   94,    0,    0,    0,    0,
    0,   96,   97,   98,   99,    0,    0,    0,  100,    0,
  101,    0,    0,    0,    0,    0,  102,  103,    0,    0,
    0,    0,    0,    0,   57,   25,    0,   26,    0,    0,
   27,  253,    0,    0,    0,   28,   62,   63,    0,   29,
    0,  104,  297,  106,  107,   65,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  254,    0,   42,    0,    0,    0,    0,    0,
    0,   87,    0,    0,   88,   89,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   90,   91,   92,    0,    0,    0,    0,    0,    0,    0,
   94,    0,    0,    0,    0,    0,   96,   97,   98,   99,
    0,    0,    0,  100,    0,  101,    0,    0,    0,    0,
    0,  102,  103,    0,    0,    0,    0,    0,    0,   57,
   25,    0,   26,    0,    0,   27,  253,    0,    0,    0,
   28,   62,   63,    0,   29,    0,  104,  461,  106,  107,
   65,    0,    0,   31,    0,    0,    0,    0,    0,    0,
   33,    0,    0,    0,    0,   34,    0,   72,   73,   35,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,   37,    0,   38,   75,    0,    0,   39,    0,    0,
   77,    0,   79,    0,   81,   40,   41,  254,    0,   42,
    0,    0,    0,    0,    0,    0,   87,    0,    0,   88,
   89,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   90,   91,   92,    0,    0,
    0,    0,    0,    0,    0,   94,    0,    0,    0,    0,
    0,   96,   97,   98,   99,    0,    0,    0,  100,    0,
  101,    0,    0,    0,    0,    0,  102,  103,    0,    0,
    0,    0,    0,    0,   78,   78,    0,   78,    0,    0,
   78,   78,    0,    0,    0,   78,   78,   78,    0,   78,
    0,  104,  992,  106,  107,   78,    0,    0,   78,    0,
    0,    0,    0,    0,    0,   78,    0,    0,    0,    0,
   78,    0,   78,   78,   78,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   78,    0,   78,   78,
    0,    0,   78,    0,    0,   78,    0,   78,    0,   78,
   78,   78,   78,    0,   78,    0,    0,    0,    0,    0,
    0,   78,    0,    0,   78,   78,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   78,   78,   78,    0,    0,    0,    0,    0,    0,    0,
   78,    0,    0,    0,    0,    0,   78,   78,   78,   78,
    0,    0,    0,   78,    0,   78,    0,    0,    0,    0,
    0,   78,   78,    0,    0,    0,    0,    0,    0,  150,
  150,    0,  150,    0,    0,  150,  150,    0,    0,    0,
  150,  150,  150,    0,  150,    0,   78,   78,   78,   78,
  150,    0,    0,  150,    0,    0,    0,    0,    0,    0,
  150,    0,    0,    0,    0,  150,    0,  150,  150,  150,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  150,    0,  150,  150,    0,    0,  150,    0,    0,
  150,    0,  150,    0,  150,  150,  150,  150,    0,  150,
    0,    0,    0,    0,    0,    0,  150,    0,    0,  150,
  150,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  150,  150,  150,    0,    0,
    0,    0,    0,    0,    0,  150,    0,    0,    0,    0,
    0,  150,  150,  150,  150,    0,    0,    0,  150,    0,
  150,    0,    0,    0,    0,    0,  150,  150,    0,    0,
    0,    0,    0,    0,   57,   25,    0,   26,    0,    0,
   27,  253,    0,    0,    0,   28,   62,   63,    0,   29,
    0,  150,  150,  150,  150,   65,    0,    0,   31,    0,
    0,    0,    0,    0,    0,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  254,    0,   42,    0,   25,    0,   26,    0,
    0,   27,    0, 1170,    0,    0,   28,    0,    0,    0,
   29,    0,    0,    0,    0,    0,    0,    0,    0,   31,
   90,   91,   92,    0,    0,    0,   33,    0,    0,    0,
   94,   34,    0, 1171,    0,   35,   96,   97,   98,   99,
    0,    0,    0,  100,    0,  101,    0,   37,    0,   38,
    0,  102,  103,   39, 1172,    0,    0,    0,    0,    0,
    0,   40,   41,    0,    0,   42,    0,    0,  315,    0,
    0,  642,    0,  642,    0,  642,  104,  255,  642,  107,
  642,  642,    0,  642,    0,  642,    0,  642,    0,  642,
  642,  642,    0,    0,    0,  642,  642,    0,    0,    0,
    0,  642,    0,  642,  642,    0,    0,    0,  642,    0,
    0,    0,  642,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  642,  642,    0,  642,    0,    0,    0,
  642,  642,    0,    0,    0,    0,    0,    0,  642,  642,
    0,    0,  642,    0,    0,  642,    0,    0,  346,    0,
  642,    0,    0,    0,   57,   25,    0,   26,    0,    0,
   27,  253,    0,    0,    0,   28,   62,   63,    0,   29,
    0,  642,  642,    0,    0,   65,    0,    0,   31,    0,
    0,    0,    0,    0,  642,   33,    0,    0,    0,    0,
   34,    0,   72,   73,   35,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   37,    0,   38,   75,
    0,    0,   39,    0,    0,   77,    0,   79,    0,   81,
   40,   41,  254,    0,   42,  642,  641,   85,  641,    0,
    0,  641,    0,  641,  641,    0,  641,    0,  641,    0,
  641,    0,  641,  641,  641,    0,    0,    0,  641,  641,
   90,   91,   92,    0,  641,    0,  641,  641,    0,    0,
   94,  641,    0,    0,    0,  641,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,  641,    0,  641,
    0,    0,    0,  641,  641,    0,    0,    0,    0,    0,
    0,  641,  641,    0,    0,  641,    0,    0,  641,    0,
    0,    0,    0,  641,    0,    0,  104,  255,  641,    0,
  641,    0,    0,  641,    0,  641,  641,    0,  641,    0,
  641,    0,  641,    0,  641,  641,  641,    0,    0,    0,
  641,  641,    0,    0,    0,    0,  641,  641,  641,  641,
   25,    0,   26,  641,    0,   27,    0,  641, 1243,    0,
   28,    0,  660,    0,   29,    0,  661, 1244, 1245,  641,
    0,  641, 1246,   31,    0,  641,  641,    0, 1247,    0,
   33,    0,    0,  641,  641,   34,    0,  641,  641,   35,
  641,    0,    0,    0,    0,  641,    0,    0,    0,    0,
    0,   37,    0,   38,    0,    0,    0,   39,    0,    0,
    0,    0,    0,    0,    0,   40,   41,    0,   25,   42,
   26,    0, 1248,   27,    0,    0, 1243, 1249,   28,    0,
  660,    0,   29,    0,  661, 1244, 1245,    0,    0,    0,
 1246,   31,    0,    0,    0,    0, 1247,    0,   33,    0,
   48,    0,   48,   34,    0,   48,    0,   35,    0,    0,
   48, 1250,    0,    0,   48,    0,    0,    0,    0,   37,
  641,   38,    0,   48,    0,   39,    0,    0,    0,    0,
   48,    0,    0,   40,   41,   48,    0,   42,    0,   48,
 1248,   48,    0,   48,   48, 1249,   48,    0,   48,   48,
    0,   48, 1251,   48,   48,    0,    0,   48,   48,    0,
   48,    0,    0,    0,    0,   48,   48,   48,    0,   48,
    0,    0,   48,    0,   48,    0,    0,    0,    0,   48,
    0,    0,    0,   48,   48,   48,   48,   48,    0,   48,
    0,    0,   48,    0,   48,   48,    0,   48,   48,    0,
    0,   48,    0,    0,   48,    0,  167,   48,    0,   48,
   48,    0,    0,   48,   48,    0,   48,    0,    0,   48,
 1251,    0,    0,   48,    0,   48,    0,   48,   25,    0,
   26,    0,   48,   27,    0,   48,    0,   48,   28,    0,
    0,   48,   29,    0,   48,    0,    0,    0,  167,   48,
   48,   31,   48,   48,    0,    0,   48,    0,   33,    0,
    0,    0,    0,   34,    0,    0,    0,   35,    0,  552,
    0,    0,    0,    0,    0,    0,  553,    0,    0,   37,
    0,   38,    0,    0,    0,   39,    0,    0,  554,    0,
    0,    0,    0,   40,   41,    0,   48,   42,    0,   25,
  555,   26,    0,    0,   27,    0,    0,    0,    0,   28,
   25,    0,   26,   29,    0,   27,    0,   30,    0,    0,
   28,    0,   31,    0,   29,    0,    0,   32,    0,   33,
    0,    0,    0,   31,   34,    0,   48,    0,   35,   36,
   33,    0,    0,    0,    0,   34,    0,    0,    0,   35,
   37,    0,   38,    0,    0,    0,   39,    0,    0,    0,
    0,   37,    0,   38,   40,   41,    0,   39,   42,    0,
    0,    0,    0,    0,    0,   40,   41,    0,    0,   42,
  556,   25,  315,   26,    0,    0,   27,    0,    0,    0,
    0,   28,   25,    0,   26,   29,    0,   27,    0,    0,
    0,    0,   28,    0,   31,    0,   29,    0,    0,    0,
    0,   33,    0,    0,    0,   31,   34,    0,    0,    0,
   35,    0,   33,    0,    0,    0,    0,   34,    0,    0,
    0,   35,   37,    0,   38,    0,    0,    0,   39,    0,
    0,    0,    0,   37,    0,   38,   40,   41,    0,   39,
   42,   43,    0,  315,    0,    0,    0,   40,   41,    0,
    0,   42,  316,   25,  315,   26,    0,    0,   27,    0,
    0,    0,    0,   28,   25,    0,   26,   29,    0,   27,
    0,    0,    0,    0,   28,    0,   31,    0,   29,    0,
    0,    0,    0,   33,    0,    0,    0,   31,   34,    0,
    0,    0,   35,    0,   33,    0,    0,    0,    0,   34,
    0,    0,    0,   35,   37,    0,   38,    0,    0,    0,
   39,    0,    0,    0,    0,   37,    0,   38,   40,   41,
    0,   39,   42,  322,    0,  503,    0,    0,    0,   40,
   41,    0,    0,   42,  346,   25,  315,   26,    0,    0,
   27,    0,    0,    0,    0,   28,   25,    0,   26,   29,
    0,   27,    0,    0,    0,    0,   28,    0,   31,    0,
   29,    0,    0,    0,    0,   33,    0,    0,    0,   31,
   34,    0,    0,    0,   35,    0,   33,    0,    0,    0,
    0,   34,    0,    0,    0,   35,   37,    0,   38,    0,
    0,    0,   39,    0,    0,    0,    0,   37,    0,   38,
   40,   41,    0,   39,   42,  346,    0,  315,    0,    0,
    0,   40,   41,    0,    0,   42,  619,   25,  555,   26,
    0,    0,   27,    0,    0,    0,    0,   28,  497,    0,
  497,   29,    0,  497,    0,    0,    0,    0,  497,    0,
   31,    0,  497,    0,    0,    0,    0,   33,    0,    0,
    0,  497,   34,    0,    0,    0,   35,    0,  497,    0,
    0,    0,    0,  497,    0,    0,    0,  497,   37,    0,
   38,    0,    0,    0,   39,    0,    0,    0,    0,  497,
    0,  497,   40,   41,    0,  497,   42,  621,    0,  728,
    0,    0,    0,  497,  497,    0,    0,  497,  346,  187,
  497,  187,    0,    0,  187,    0,    0,    0,    0,  187,
  186,    0,  186,  187,    0,  186,    0,    0,    0,    0,
  186,    0,  187,    0,  186,    0,    0,    0,    0,  187,
    0,    0,    0,  186,  187,    0,    0,    0,  187,    0,
  186,    0,    0,    0,    0,  186,    0,    0,    0,  186,
  187,    0,  187,    0,    0,    0,  187,    0,    0,    0,
    0,  186,    0,  186,  187,  187,    0,  186,  187,  346,
    0,  187,    0,    0,    0,  186,  186,    0,    0,  186,
  497,  196,  186,  196,    0,    0,  196,    0,    0,    0,
    0,  196,    0,    0,    0,  196,    0,    0,    0,    0,
    0,    0,    0,    0,  196,    0,    0,    0,   35,    0,
    0,  196,    0,    0,    0,    0,  196,    0,    0,   35,
  196,    0,    0,    0,   35,    0,    0,    0,   35,    0,
    0,   35,  196,    0,  196,    0,    0,    0,  196,    0,
    0,    0,    0,   35,   35,    0,  196,  196,   35,   35,
  196,  187,    0,  196,   35,    0,   35,   35,   35,   35,
    0,    0,  186,    0,   35,    0,    0,    0,   35,    0,
   35,    0,    0,    0,    0,    0,   33,    0,    0,    0,
   35,    0,   35,   35,    0,   35,    0,   33,    0,   35,
    0,    0,   33,    0,    0,    0,   33,    0,    0,   33,
    0,    0,    0,    0,    0,    0,   35,    0,    0,    0,
    0,   33,   33,    0,   35,   35,   33,   33,    0,   28,
    0,    0,   33,    0,   33,   33,   33,   33,    0,    0,
    0,    0,   33,  196,    0,    0,   33,    0,   33,    0,
    0,    0,   28,    0,    0,    0,    0,    0,   33,    0,
    0,   33,    0,   33,    0,   28,    0,   33,    0,    0,
   28,    0,   28,    0,   28,   28,    0,   28,   28,   28,
   28,    0,    0,   28,   33,   28,    0,    0,    0,   28,
    0,    0,   33,   33,    0,   28,    0,    0,    0,    0,
    0,   28,    0,    0,   28,    0,   28,    0,   28,    0,
    0,    0,    0,   28,    0,    0,    0,    0,   28,    0,
   28,   28,   28,   28,    0,    0,    0,   28,   28,    0,
    0,    0,   28,    0,    0,   28,   28,    0,    0,    0,
   48,    0,    0,    0,   28,    0,    0,   28,    0,   28,
    0,   48,    0,    0,    0,    0,   48,    0,    0,    0,
   48,    0,    0,   48,    0,    0,    0,    0,    0,    0,
   28,    0,    0,    0,    0,   48,   48,    0,   28,   28,
   48,   48,    0,   48,    0,    0,   48,    0,   48,   48,
   48,   48,    0,    0,   48,    0,   48,    0,    0,   48,
   48,    0,   48,   48,    0,    0,   48,    0,    0,    0,
    0,    0,   48,    0,    0,   48,    0,   48,   48,   48,
    0,   48,    0,   48,   48,    0,   48,    0,    0,   48,
    0,   48,   48,   48,   48,    0,    0,    0,   48,   48,
    0,    0,    0,   48,    0,   48,   37,    0,    0,   48,
    0,    0,    0,    0,    0,   48,    0,    0,   48,    0,
   48,   48,   48,    0,   48,    0,    0,   48,    0,    0,
    0,    0,   48,    0,   48,   48,   48,   48,    0,    0,
    0,   48,   48,    0,   48,    0,   48,    0,    0,   38,
    0,    0,    0,    0,    0,    0,    0,   48,   48,    0,
    0,   48,   48,   48,    0,    0,    0,   48,    0,   48,
   48,   48,   48,    0,    0,    0,    0,   48,    0,    0,
   48,   48,   48,    0,   48,    0,    0,    0,   48,   48,
    0,    0,  208,   48,    0,    0,   48,    0,   48,    0,
    0,    0,    0,   48,    0,    0,    0,    0,    0,    0,
   48,    0,    0,    0,    0,    0,   48,    0,    0,   48,
    0,   48,    0,   48,   48,    0,   48,  210,   48,   48,
   48,   48,    0,   48,    0,    0,   48,    0,    0,    0,
   48,    0,    0,    0,    0,    0,   48,    0,    0,    0,
    0,   48,   48,    0,    0,   48,   48,   48,   48,   48,
   48,   48,    0,    0,    0,    0,   48,    0,    0,   48,
   48,   48,    0,    0,    0,    0,    0,    0,   48,    0,
    0,    0,   48,    0,    0,   48,  311,   48,    0,    0,
    0,    0,   48,    0,    0,    0,    0,    0,    0,  439,
    0,    0,    0,    0,    0,   48,    0,    0,   48,    0,
   48,    0,   48,   48,    0,   48,    0,   48,   48,   48,
   48,    0,  440,   48,    0,   48,    0,    0,    0,   48,
    0,    0,    0,    0,  439,  441,    0,    0,    0,  442,
  443,   48,    0,    0,   48,  444,   48,  445,  446,  447,
  448,    0,    0,    0,    0,  449,    0,  440,    0,  450,
    0,    0,    0,    0,    0,    0,    0,   48,    0,    0,
  441,  451,    0,    0,  452,  443,  453,    0,    0,    0,
  444,    0,  445,  446,  447,  448,    0,    0,    0,    0,
  449,    0,    0,    0,  450,    0,    0,  454,    0,    0,
    0,    0,    0,    0,    0,    0,  451,    0,    0,  452,
    0,  453,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  454,
  };
  protected static readonly short [] yyCheck = {            17,
  295,   18,   17,  296,   17,    4,    6,  499,  105,   52,
  188,  232,  501,  287,  456,   17,  187,  247,  475,  538,
   17,  327,  324,  294,   20,  292,   85,  345,   60,  548,
  156,   60,  889, 1057, 1093, 1094,  345,   48,  719,   88,
   89,   78,  558,    0,   59,  314,  111,   60,  113,  320,
  256,   64,  111,  268,  113,  256,   74,  234,  107,  256,
   78, 1177,  268,  256,  268,   80,  256,   82,  256,  256,
  256,   17,  276,  268,  256,  256,   94, 1193,  294,   17,
 1139,  282,  256,   17,   17,  294,  256,  256, 1393, 1394,
  306,  868,  256,  335,  256,  256,  256,  946,  256,   17,
   17,   21,   17,  694,  695,  256,  256,  367,  256,  341,
  277,  263,    0,  314,  281,   96,   97,   98,   99,  100,
  101,  102,  103,  639,  367,  974,  372,  357,  399,  375,
  367,   17,  257,   53,  264,   17,  368,  266,  156,   17,
   17,  156,  339,  156, 1449,  188,  737,  344,  739,  346,
  199,  200,  367,  294,  156,  352,  353,  339,  255,  156,
  341,  294,  344,  315,  346,  306,  256,    6,  428, 1018,
  352,  353,  256,  358,  417,  342,  256,  339,   17,  369,
  366,  371,  368,  373,  370,  314,  428,  368,  339,  232,
  294,  428,  380,  495,  971,  325,  973,  515,  358,  420,
  297,  417,  256,  498,  366,  374,  421,  696,  417,  373,
  156,  260,  223,  417,  343,  421,  417,    0,  156,  380,
  368,   60,  156,  156,  417,   64,  421,  417,  228,  247,
  417,  428,  538,  419,  252,   20,  422,  286,  156,  156,
  558,  156,  548,  417,  421,  374,  428,  417, 1364,   88,
   89,  348,  284,  302,  313,  284,  321,  390,  317,  417,
  292,  390,  321,  423,  424,  425,  426,  417,  107,  287,
  156,  284,  290,  291,  156, 1391,  256,  367,  156,  156,
  413,  310,  366,  373,  413,  303,  390, 1403,  368, 1405,
  308,  375,  310,  342,  309,  413,  314,  310,  427,  294,
  257,  338,  420,   88,   89, 1138,    0,  325,  326,  413,
  991,  256,  828,  256,  327,  369,  256,  156,  371,  373,
  338,  639,  107, 1156,  847,  327,  335,  376,  377,  426,
  327,  640,  263,  262, 1358,  858, 1206,  325,  325,  357,
  358,  294,  660,  324,  362,  363,  364,  365,  366,  367,
  368,  369,  370,  371,  372,  404,  405,  349,  350,  339,
  199,  200,  953,  460,  461, 1424, 1236,  400,  256,  298,
  859,  349,  350,  367, 1207,  428,  394,  420,  367,  412,
  361,  838, 1441,  367,  315,  371,  366,  430,  485, 1246,
  349,  350,  373,  374,  375,  390,  371,  378,  379,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,  390,
  391,  392,  393,  682,  199,  200,  427,  428,  413,  367,
  343,  260,  433,  368, 1257,  368,  422,  367, 1261,  417,
  417,  698,  368,  373,  428,  371,  428,  390,  668,  428,
  436,  257,  428,  761,  428,  284,  475,  286,  377,  378,
  428,  339,  761,  428,  366,  470,  945,  296,  370, 1052,
  413,  417,  475,  302,  371,  371,  373,  390,  565,  428,
  567,  310,  569,  375,  257,  260,  272, 1068,  366,  497,
  428,  499,  370,  501,  372,  373,  374,  375,  327,  272,
  413,  375,  380,  367,  277,  368,  511,  512,  281,  372,
  296,  286,  305,  342,  427,  523,  345,  419, 1099, 1100,
  828,  296,  530,  296,  495, 1106,  373,  302,  827,  515,
  372,  428,  428,  375,  357,  538,  428,  323,  269,  371,
  825,  373,  547,   60,  631,  548,  538,  376,  377,  370,
  323,  538,  305,  417,  428,  286,  548,  371,  778,  422,
  852,  548,  385,  571,  572,  256, 1161,  342,  415,  342,
  345,  368, 1019,  257,  375,  404,  405,  261,  837,   96,
   97,   98,   99,  100,  101,  102,  103,  256,  272,  343,
  375,  707,  563,  277, 1103,  856,  428,  281,  419,  256,
  284,  376,  377,  417, 1160, 1161,  889,  256,  368, 1204,
  618, 1206,  296,  297,  305,  702,  624,  301,  302,  272,
  374,  272,  380,  307, 1180,  309,  310,  311,  312,  404,
  405,  306,  390,  317,  417,  375,  390,  321,  313,  323,
  390, 1236,  370,  296,  427,  296,  475,  422, 1204,  333,
 1206,  357,  336,  366,  338,  413,  305,  417,  342,  413,
  668,  436,  368,  413,  385,  371,  372,  373,  373,  427,
  323,  661,  323,  427,  682,  359,  698,  962,  368,  385,
 1236,  730,  339,  691,  723,  370,  515,  344,  696,  346,
  417,  694,  695,  701,  914,  352,  353,  366,  417,  368,
  427,  370,  371,  383,  373,  744,  375,  343,   62,  538,
  415,  417,   66,   67,   68, 1298,   70,   71,  757,  548,
  725,   75,   76,  370,  357,  372,  378,  417,   82,  558,
   84,  399,   86,  741,  737,  743,  739,   91,   92,  372,
  515,  413, 1325, 1326,  380, 1328,  388,  755,  417,  384,
  419,  357,  385,  422,  390,  427, 1339,  389,  112, 1342,
 1343, 1025,  368, 1161,  368,  773,  372,  284,  339,  802,
  778,  779, 1057,  781, 1357,  292, 1072,  413,  369,  385,
  367,  868,  373,  558,  792,  793,  373,  339,  417,  390,
  829,  427,  344,  380,  346,  366, 1060,  349,  350,  413,
  352,  353, 1161,  343,  375,  256, 1204, 1103, 1206,  339,
  639,  417,  413,  427,  344,  823,  346,  825,  269,  349,
  350,  373,  352,  353,  810,  815,  427,  366,  989,  837,
 1050,  660,  840, 1097,  374,  286,  375, 1133, 1236,  847,
  380,  397,  398,  373,  361, 1204, 1278, 1206, 1161,  857,
  390,  859, 1161,  380,  361,  357,  373,  374,  375,  390,
  366,  378,  379,  390,  639,  694,  695, 1346, 1161,  375,
  372,  378,  379,  413,  369,  370,  428, 1236,  373,  372,
  919,  852,  413,  385,  971,  660,  413,  427,  896,  420,
  898, 1204,  900, 1206,  723, 1204,  375, 1206,  428,  417,
  254, 1112,  256,  366, 1168,  992,  914, 1215,  737,  368,
  739, 1204,  375, 1206, 1222,  744, 1161, 1161,  370,  357,
 1088,  380,  371, 1236,  373,  911,  375, 1236,  757, 1408,
  366,  921,  761,  923,  372,  925,  366,  945,  369,  375,
  294,  414,  373, 1236,  339,  375,  417,  385,  723,  344,
  953,  346,  306,  357,  349,  350,  256,  352,  353, 1204,
 1204, 1206, 1206, 1246,  368, 1444,  306,  371,  372,  744,
  370,  976,  372,  313,  370,  983,  372,  985,  366,  987,
  417,  385,  757, 1465, 1466,  325,  761,  375,  366,  272,
  368, 1236, 1236,  417,  277,  391,  392,  339,  281,  828,
  829,  371,  344,  373,  346,  375,  340,  349,  350,  998,
  352,  353,  306,  296,  308,  411,  369, 1025,  366,  313,
  373,  393,  394,  419,  381,  382,  422,  375, 1265, 1037,
 1038,  325,  369,  428, 1271,  810,  373, 1045,  395,  396,
  323, 1278, 1050,  373, 1051,  375,  563,  369,  375, 1057,
  380,  373, 1060,  828,  829, 1088,  375, 1090,  369,  342,
  889,  339,  373,  371,  366, 1068,  344,  375,  346, 1072,
 1078,  349,  350, 1358,  352,  353,  371, 1085,  373, 1112,
 1072,  382,  383,  384,  385, 1072,  428,  372,  367, 1097,
  919,  370,  417,  372,  373,  375, 1099, 1100,  354,  355,
 1103, 1109, 1110, 1106,  369,  371,  371,  373,  373, 1142,
  417, 1103,  391,  392,  889,  375, 1103,  471,  369,  370,
 1159,  372,  373,  374,  953,  354,  355, 1160, 1161,  369,
 1133,  371,  411,  373,  349,  350,  911,  385,  386,  387,
  419, 1133, 1150,  422,  919,  366, 1133, 1180,  375,  370,
  428,  372,  373,  373,  375,  375,  339,  511, 1166,  380,
 1168,  344,  367,  346,  373,  370,  375,  372,  373,  352,
  353, 1204,  369, 1206,  371, 1214,  366,  369,  371,  371,
  370,  698,  372,  373,  417,  375,  391,  392, 1275,  369,
  380,  371,  369,  414,  371,  371,  371,  373,  373,  413,
    0, 1288,  368, 1236, 1243, 1244,  411,  369,  369,  371,
  371,  413,  414, 1218,  419,  363,  364,  422, 1305,  417,
 1307,  256,  417,  373,  414,  375,  371,  372, 1267,  264,
  265, 1270,  267,  363,  364,  270,  271, 1055, 1056, 1068,
  275,  276,  277, 1072,  279,  366,  373,  417,  375,  370,
  285,  372,  373,  288,  375,  373,  373,  375,  375,  380,
  295,  371, 1091,  386,  387,  300,  371,  302,  303,  304,
 1099, 1100,  380,  381, 1103,  417,  375, 1106, 1283,  371,
  371,  316,  367,  318,  319,  373,  417,  322,  371,  371,
  325,  371,  327,  371,  329,  330,  331,  332,  371,  334,
  294,  294,  373, 1336, 1133,  371,  371,  375,  417,  373,
  370,  256,  371,  256, 1143,  373, 1091,  374,  380,  380,
 1353,  417,  417,  356,  371,  360,  361,  362,  373,  373,
 1159,  374,  372, 1366, 1367,  370,  417,  371, 1346, 1344,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
 1358,  380,  373,  373,  373,  294,  373,  375,  428,  422,
 1393, 1394,  417,  371,  373,  366,  417, 1375, 1143,    0,
  372,  371,  343,  294,  373,  417,  294,  373,  417,  417,
  369,  416,  417,  370, 1159, 1214, 1215,  417,  366,  374,
  256,  256,  373, 1222,  339,  256,  256,  371,  380,  344,
 1408,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,  371,  280, 1243, 1244, 1449, 1246,  256,  366,
  417,  367,  367,  371,  369,  417,  371,  417,  373,  374,
  375,  417,  369,  375,  370,  375, 1444,  417, 1267, 1214,
 1215, 1270,  373,  373,  389, 1450, 1451, 1222,  375,  375,
  369,  371, 1457, 1458,  399,  400,  256, 1465, 1466,  371,
  420,  261,  262,  380,  422,  347,  351,  412, 1243, 1244,
  366, 1246,  380,  380,  256,  256,  371, 1252,  367,  371,
  373,  369,  366,  428,  284,  347,  369,  374,  374,  348,
 1265,  371, 1267,  369,  294, 1270, 1271,  297,  298,  371,
  373,  417,  302, 1278,  367,  305,  417,  307,  339,  309,
  310,  311,  312,  348,  367,  373,  366,  317,  375,  374,
  366,  321,  366,  356,  367,  325,  380,  375,  370,  337,
  367,  367,  373,  333,  305,    0,  336,  371,  338,  339,
  417,  367,  417,  417,  344,  370,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,  370,  368,  359,
  366,  417,  380,  370,  375,  417,  366,  367,  417,  369,
  370,  371,  372,  373,  374,  375,  370,  377,  378,  370,
  380,  381,  382,  383,  384,  385,  386,  387,  388,  389,
  370,  391,  392,  393,  394,  395,  396,  397,  398,  399,
  400,  401,  402,  403,  404,  405,  406,  407,  408,  409,
  410,  411,  412,  372,  370,  415,  366,  417,  370,  419,
  380,  368,  422,  371,  373,  256,  257,  371,  428,  372,
  372,  256,  373,  264,  265,  266,  267,  268,  373,  270,
  271,  373,  273,  274,  275,  276,  277,  278,  279,  280,
  417,  375,  371,  371,  285,  369,  287,  288,  289,  290,
  291,  292,  417,    0,  295,  375,  417,  375,  299,  300,
  371,  302,  303,  304,  371,  375,  371,  417,  380,  366,
  371,  367,  380,  314,  369,  316,  367,  318,  319,  315,
  263,  322,  370,  324,  325,  326,  327,  328,  329,  330,
  331,  332,  333,  334,  335,  370,  337,  367,  371,  340,
  341,    0,  371,  344,  345,    0,  366,  375,  417,  375,
  367,    0,  371,  375,  367,  371,  371,  417,  369,  360,
  361,  362,  366,  375,  367,  366,  367,  367,  375,  370,
  417,  369,  371,  366,  375,  376,  377,  378,  379,  417,
  367,  375,  383,  375,  385,  371,  375,  371,  367,  371,
  391,  392,  367,  371,  366,  375,  367,  367,  366,  372,
  315,  375,  263,   51,   12,   52,  375,    5,  375,  375,
  375,  375,  375,  375,  810,  416,  417,  418,  419,  911,
  421,  256,  257, 1050, 1180, 1050, 1236,  428, 1398,  264,
  265,  266,  267,  268, 1361,  270,  271, 1414,  273,  274,
  275,  276,  277,  278,  279,    0, 1349, 1378, 1344, 1252,
  285,  660,  287,  288,  289,  290,  291,  292,  831,  674,
  295, 1265, 1458,  831,  299,  300,  831,  302,  303,  304,
 1204, 1284, 1192,  827, 1452, 1367, 1371, 1366, 1451,  314,
 1142,  316, 1307,  318,  319, 1252, 1143,  322,  802,  324,
  325,  326,  327,  328,  329,  330,  331,  332,  333,  334,
  335,  515,  337,  852,  701,  340,  341,  778,  572,  344,
  345,  357,  773,  668,   72,  962,  698,  388,  390,  389,
  393,  761,  391, 1214,  392,  360,  361,  362, 1126, 1133,
  976,  366,  367, 1072,  156,  370,  947,  932, 1028, 1038,
  375,  376,  377,  378,  379, 1030, 1019,  894,  383,  256,
  385,  872,  513,  412,  261,  262,  391,  392, 1210, 1110,
  808,   -1,   -1,   -1,   -1,   -1,  807,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,    0,   -1,   -1,  284,   -1,   -1,
   -1,  416,  417,  418,  419,   -1,  421,  294,   -1,   -1,
  297,  298,   -1,  428,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
  357,   -1,  359,   -1,   -1,   -1,   -1,   -1,   -1,  366,
  367,  368,  369,  370,  371,  372,  373,  374,  375,   -1,
  377,  378,   -1,   -1,  381,  382,  383,  384,  385,   -1,
   -1,  388,  389,   -1,   -1,   -1,  393,  394,  395,  396,
  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,    0,   -1,  412,  261,  262,  415,   -1,
  417,   -1,  419,   -1,   -1,  422,   -1,   -1,   -1,   -1,
   -1,  428,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  294,
   -1,   -1,  297,  298,   -1,   -1,   -1,  302,   -1,   -1,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,  359,   -1,   -1,   -1,   -1,   -1,
   -1,  366,  367,  368,  369,  370,  371,   -1,  373,  374,
  375,   -1,  377,  378,   -1,   -1,  381,  382,  383,  384,
  256,   -1,    0,  388,  389,  261,  262,   -1,  393,  394,
  395,  396,  397,  398,  399,  400,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,  284,   -1,
  415,   -1,  417,   -1,  419,   -1,   -1,  422,  294,   -1,
   -1,  297,  298,  428,   -1,   -1,  302,   -1,   -1,  305,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,
  336,   -1,  338,  339,   -1,   -1,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,  359,   -1,   -1,   -1,   -1,   -1,   -1,
  366,  367,  368,  369,  370,  371,   -1,  373,  374,  375,
   -1,  377,  378,   -1,   -1,  381,  382,  383,  384,  256,
   -1,   -1,  388,  389,  261,  262,   -1,  393,  394,  395,
  396,  397,  398,  399,  400,   -1,   -1,    0,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  412,  284,   -1,  415,
   -1,  417,   -1,  419,   -1,   -1,  422,  294,   -1,   -1,
  297,  298,  428,   -1,   -1,  302,   -1,   -1,  305,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,  325,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,  339,   -1,   -1,   -1,   -1,  344,  285,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,  359,   -1,   -1,   -1,   -1,   -1,   -1,  366,
  367,   -1,  369,  370,  371,   -1,  373,  374,  375,   -1,
  377,  378,   -1,   -1,  381,  382,  383,  384,  256,   -1,
  327,  388,  389,   -1,  262,   -1,  393,  394,  395,  396,
  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  412,   -1,   -1,  415,   -1,
  417,   -1,   -1,   -1,   -1,   -1,  294,   -1,   -1,   -1,
  298,  428,   -1,   -1,    0,   -1,   -1,   -1,   -1,  376,
  377,  378,  379,   -1,  381,  382,  383,  384,  385,  386,
  387,  388,   -1,   -1,  391,  392,  393,  394,  395,  396,
  397,  398,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,  357,
  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  366,  367,
  368,  369,  370,  371,  372,  373,  374,  375,   -1,  377,
  378,   -1,   -1,  381,  382,  383,  384,  385,   -1,   -1,
  388,  389,   -1,   -1,   -1,  393,  394,  395,  396,  397,
  398,  399,  400,  256,   -1,   -1,   -1,   -1,   -1,  262,
   -1,   -1,   -1,   -1,  412,   -1,    0,  415,   -1,  417,
   -1,  419,   -1,   -1,  422,   -1,   -1,   -1,   -1,   -1,
  428,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  294,   -1,  339,   -1,  298,   -1,   -1,  344,   -1,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,
   -1,   -1,   -1,   -1,    0,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  366,  367,   -1,  369,  370,  371,   -1,
  373,  374,  375,   -1,  377,  378,   -1,   -1,  381,  382,
  383,  384,  428,   -1,   -1,  388,  389,   -1,   -1,   -1,
  393,  394,  395,  396,  397,  398,  399,  400,   -1,   -1,
   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,  412,
   -1,  257,  415,   -1,  417,  261,   -1,  263,   -1,  265,
   -1,  267,   -1,   -1,  270,  428,  272,  273,   -1,  275,
   -1,  277,   -1,  279,   -1,  281,  282,  283,  284,   -1,
   -1,  287,  288,   -1,   -1,   -1,    0,  293,  294,  295,
  296,  297,   -1,   -1,  300,  301,  302,   -1,  304,   -1,
  306,  307,  308,  309,  310,  311,  312,  313,   -1,  315,
  316,  317,  318,   -1,   -1,  321,  322,  323,   -1,  325,
   -1,   -1,   -1,   -1,  330,  331,   -1,  333,  334,    0,
  336,  337,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  359,   -1,   -1,   -1,  363,  364,   -1,
   -1,   -1,  256,  257,   -1,   -1,   -1,  261,   -1,   -1,
  376,  265,   -1,  267,   -1,   -1,  270,   -1,  272,  273,
   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,
  284,   -1,   -1,  287,  288,   -1,   -1,   -1,    0,  293,
   -1,  295,  296,  297,   -1,   -1,  300,  301,  302,   -1,
  304,  417,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,  323,
   -1,  257,   -1,   -1,   -1,  261,  330,  331,   -1,  333,
  334,    0,  336,  337,  338,   -1,  272,   -1,  342,   -1,
   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,
  296,  297,   -1,  367,  368,  301,  302,   -1,   -1,   -1,
   -1,  307,  376,  309,  310,  311,  312,   -1,   -1,   -1,
   -1,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,
  257,   -1,   -1,   -1,  261,   -1,   -1,  333,    0,  335,
  336,   -1,  338,   -1,   -1,  272,  342,   -1,   -1,   -1,
  277,   -1,   -1,  417,  281,   -1,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,   -1,  296,
  297,  367,  368,  257,  301,  302,   -1,  261,   -1,   -1,
  307,    0,  309,  310,  311,  312,   -1,   -1,  272,   -1,
  317,   -1,   -1,  277,  321,   -1,  323,  281,   -1,   -1,
  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,  335,  336,
   -1,  338,  296,  297,   -1,  342,  257,  301,  302,   -1,
  261,   -1,   -1,  307,    0,  309,  310,  311,  312,   -1,
   -1,  272,  359,  317,   -1,   -1,  277,  321,   -1,  323,
  281,  368,   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,  296,  297,   -1,  342,   -1,
  301,  302,   -1,   -1,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,  359,  317,   -1,   -1,   -1,
  321,   -1,  323,  367,  368,  257,   -1,   -1,   -1,  261,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,   -1,   -1,
  272,  342,   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,  359,   -1,
   -1,   -1,   -1,   -1,  296,  297,  367,  368,  257,  301,
  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  272,   -1,  317,   -1,   -1,  277,  321,
   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,
  342,   -1,  301,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  359,  317,   -1,
   -1,   -1,  321,   -1,  323,  257,  368,   -1,   -1,  261,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  272,   -1,   -1,  342,   -1,  277,   -1,   -1,   -1,  281,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  359,   -1,   -1,   -1,  296,  297,   -1,   -1,  257,  301,
  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  272,   -1,  317,   -1,   -1,  277,  321,
   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,   -1,
  342,  257,  301,  302,   -1,  261,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,  272,  359,  317,   -1,
   -1,  277,  321,   -1,  323,  281,   -1,   -1,  284,   -1,
   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
  296,  297,   -1,  342,   -1,  301,  302,   -1,   -1,   -1,
   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,
  359,  317,   -1,   -1,   -1,  321,   -1,  323,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,  256,
  336,   -1,  338,   -1,   -1,   -1,  342,  264,  265,  266,
  267,   -1,   -1,  270,  271,   -1,  273,  274,  275,  276,
  277,  278,  279,  359,   -1,   -1,   -1,   -1,  285,   -1,
  287,  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,
   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,
   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,
  327,  328,  329,  330,  331,  332,  333,  334,  335,   -1,
  337,   -1,   -1,  340,  341,  256,   -1,  344,  345,   -1,
   -1,  262,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,  366,
   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,  375,  376,
  377,  378,  379,   -1,   -1,   -1,  383,  298,  385,   -1,
   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  256,   -1,   -1,   -1,   -1,   -1,  262,   -1,  416,
  417,  418,  419,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,  428,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,  357,   -1,   -1,   -1,
   -1,   -1,   -1,  298,   -1,   -1,  367,  368,  369,  370,
  371,  372,  373,  374,  375,   -1,  377,  378,   -1,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,   -1,
  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,   -1,  256,   -1,   -1,  417,   -1,  419,  262,
   -1,  422,   -1,   -1,   -1,   -1,   -1,  428,   -1,   -1,
   -1,   -1,  367,   -1,   -1,  370,   -1,  372,  373,   -1,
   -1,   -1,  377,  378,   -1,   -1,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  298,  391,  392,  393,  394,
  395,  396,  397,  398,  399,  400,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  411,  412,   -1,   -1,
   -1,   -1,   -1,   -1,  419,   -1,   -1,  422,   -1,   -1,
   -1,   -1,   -1,  428,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  366,  367,  368,  369,  370,  371,  372,
  373,  374,  375,  256,  377,  378,   -1,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,   -1,  391,  392,
  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
   -1,  256,   -1,   -1,   -1,   -1,  419,  262,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  428,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  298,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  262,  367,   -1,  369,   -1,  371,   -1,
  373,  374,  375,   -1,  339,   -1,   -1,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,
   -1,  366,  367,   -1,  369,  370,  371,  372,  373,  374,
  375,   -1,  377,  378,   -1,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,  428,  391,  392,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  411,  412,   -1,  256,
   -1,   -1,   -1,   -1,  419,  262,   -1,  422,  357,   -1,
   -1,   -1,   -1,  428,   -1,   -1,   -1,   -1,   -1,  368,
   -1,  370,   -1,  372,   -1,   -1,  375,   -1,  377,  378,
   -1,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,  298,  391,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,   -1,   -1,   -1,   -1,  417,   -1,
  419,  262,   -1,  422,   -1,   -1,   -1,   -1,   -1,  428,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,   -1,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,
  367,   -1,  369,  370,  371,  372,  373,  374,  375,   -1,
  377,  378,   -1,  380,  381,  382,  383,  384,  385,  386,
  387,  388,  389,   -1,  391,  392,  393,  394,  395,  396,
  397,  398,  399,  400,  401,  402,  403,  404,  405,  406,
  407,  408,  409,  410,  411,  412,   -1,  256,   -1,   -1,
   -1,   -1,  419,  262,   -1,  422,   -1,   -1,   -1,   -1,
   -1,  428,   -1,   -1,   -1,   -1,   -1,  368,   -1,  370,
  371,  372,  373,   -1,  375,   -1,  377,  378,   -1,  380,
  381,  382,  383,  384,   -1,  386,  387,  388,  389,  298,
  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,   -1,   -1,   -1,   -1,  417,   -1,  419,  262,
   -1,  422,   -1,   -1,   -1,   -1,   -1,  428,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  298,   -1,   -1,  367,   -1,
  369,  370,  371,  372,  373,  374,  375,   -1,  377,  378,
   -1,  380,  381,  382,  383,  384,  385,  386,  387,  388,
  389,   -1,  391,  392,  393,  394,  395,  396,  397,  398,
  399,  400,  401,  402,  403,  404,  405,  406,  407,  408,
  409,  410,  411,  412,   -1,  256,   -1,   -1,   -1,   -1,
  419,  262,   -1,  422,   -1,   -1,   -1,   -1,   -1,  428,
   -1,   -1,   -1,   -1,   -1,   -1,  369,  370,  371,  372,
  373,   -1,   -1,   -1,  377,  378,   -1,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,  298,  391,  392,
  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
   -1,   -1,   -1,   -1,   -1,   -1,  419,   -1,   -1,  422,
   -1,   -1,   -1,   -1,   -1,  428,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,  370,
  371,  372,  373,  374,  375,   -1,  377,  378,   -1,  380,
  381,  382,  383,  384,  385,  386,  387,  388,  389,   -1,
  391,  392,  393,  394,  395,  396,  397,  398,  399,  400,
  401,  402,  403,  404,  405,  406,  407,  408,  409,  410,
  411,  412,   -1,  256,  256,   -1,   -1,   -1,  419,  262,
   -1,  422,   -1,  265,   -1,  267,   -1,  428,  270,   -1,
   -1,   -1,   -1,  275,   -1,   -1,   -1,  279,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,
   -1,   -1,   -1,  295,   -1,  298,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,
  322,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,  339,   -1,   -1,   -1,
   -1,  344,   -1,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  367,   -1,  369,  370,  371,  372,
  373,  374,  375,   -1,  377,   -1,   -1,  380,  381,  382,
  383,  384,  385,  386,  387,  388,  389,   -1,  391,  392,
  393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
  403,  404,  405,  406,  407,  408,  409,  410,  411,  412,
   -1,  256,  256,   -1,   -1,  417,  419,  262,   -1,  422,
   -1,  265,   -1,  267,   -1,  428,  270,   -1,   -1,   -1,
   -1,  275,   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,  298,   -1,   -1,  300,   -1,   -1,   -1,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  316,   -1,  318,   -1,   -1,   -1,  322,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,  339,   -1,  256,   -1,   -1,  344,
   -1,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,
  375,   -1,  377,  378,   -1,  380,  381,  382,  383,  384,
  385,  386,  387,  388,  389,   -1,   -1,   -1,  393,  394,
  395,  396,  397,  398,  399,  400,  401,  402,  403,  404,
  405,  406,  407,  408,  409,  410,  256,  412,   -1,   -1,
   -1,   -1,  262,  417,   -1,   -1,  261,   -1,   -1,  339,
   -1,   -1,   -1,  428,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,  298,  369,
   -1,  371,  297,  373,  374,  375,   -1,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,  389,
  315,   -1,  317,  256,   -1,   -1,  321,   -1,   -1,  262,
  400,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,  339,
   -1,  336,  412,  338,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,  428,   -1,
   -1,   -1,   -1,   -1,  359,  298,   -1,  367,   -1,  369,
   -1,  371,  367,  373,  374,  375,   -1,  377,  378,   -1,
   -1,  381,  382,  383,  384,  385,  386,  387,  388,  389,
   -1,   -1,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  412,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,  256,   -1,  428,   -1,
   -1,   -1,  262,   -1,  367,   -1,  369,   -1,  371,   -1,
  373,  374,  375,   -1,  377,  378,   -1,   -1,  381,  382,
  383,  384,   -1,   -1,   -1,  388,  389,   -1,   -1,   -1,
  393,  394,  395,  396,  397,  398,  399,  400,  298,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,  428,   -1,   -1,   -1,  262,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  298,   -1,  367,   -1,  369,
   -1,  371,   -1,  373,  374,  375,   -1,  377,  378,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,  389,
   -1,   -1,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  412,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,  256,   -1,  428,   -1,
   -1,   -1,  262,   -1,  367,   -1,  369,   -1,  371,   -1,
  373,  374,  375,   -1,  377,  378,   -1,   -1,  381,  382,
  383,  384,   -1,   -1,   -1,  388,  389,   -1,   -1,   -1,
  393,  394,  395,  396,  397,  398,  399,  400,  298,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  412,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,  428,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,   -1,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,
   -1,  371,   -1,  373,  374,  375,   -1,  377,  378,   -1,
   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,  389,
  256,   -1,   -1,  393,  394,  395,  396,  397,  398,  399,
  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  412,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  428,   -1,
   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,
  373,  374,  375,   -1,   -1,   -1,   -1,   -1,  381,  382,
  383,  384,   -1,   -1,   -1,  388,  389,  256,   -1,   -1,
  393,  394,  395,  396,  397,  398,  399,  400,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  428,   -1,   -1,   -1,   -1,
   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,
   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,   -1,
   -1,   -1,  388,  389,  256,   -1,   -1,  393,  394,  395,
  396,  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  412,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  428,   -1,   -1,   -1,   -1,   -1,  367,   -1,
  369,   -1,  371,   -1,  373,  374,  375,   -1,   -1,   -1,
   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,  388,
  389,  256,   -1,   -1,  393,  394,  395,  396,  397,  398,
  399,  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  412,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  428,
   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,
   -1,  373,  374,  375,   -1,   -1,   -1,   -1,   -1,  381,
  382,  383,  384,   -1,   -1,   -1,  388,  389,  256,   -1,
   -1,   -1,   -1,  395,  396,  397,  398,  399,  400,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  412,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  428,   -1,   -1,   -1,
   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,
  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,  384,
   -1,   -1,   -1,  388,  389,  256,   -1,   -1,   -1,   -1,
  395,  396,  397,  398,  399,  400,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  428,   -1,   -1,   -1,   -1,   -1,  367,
   -1,  369,   -1,  371,   -1,  373,  374,  375,   -1,   -1,
   -1,   -1,   -1,  381,  382,  383,  384,   -1,   -1,   -1,
  388,  389,  256,   -1,   -1,   -1,   -1,  395,  396,  397,
  398,  399,  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  412,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  428,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,
  371,   -1,  373,  374,  375,   -1,   -1,   -1,   -1,   -1,
  381,  382,  383,  384,   -1,   -1,   -1,  388,  389,  256,
   -1,   -1,   -1,   -1,  395,  396,  397,  398,  399,  400,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  412,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  428,   -1,   -1,
   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,
  374,  375,   -1,   -1,   -1,   -1,   -1,  381,  382,  383,
  384,   -1,   -1,   -1,  388,  389,  256,   -1,   -1,   -1,
   -1,  395,  396,  397,  398,  399,  400,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  428,   -1,   -1,   -1,   -1,   -1,
  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  383,  384,   -1,   -1,
   -1,  388,  389,  256,   -1,   -1,   -1,   -1,   -1,   -1,
  397,  398,  399,  400,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  412,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  428,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,
   -1,  371,   -1,  373,  374,  375,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  383,  384,   -1,   -1,   -1,  388,  389,
  256,   -1,   -1,   -1,   -1,   -1,   -1,  397,  398,  399,
  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,
   -1,  344,  412,  346,  347,  348,  349,  350,  351,  352,
  353,  354,  355,  356,   -1,   -1,   -1,   -1,  428,   -1,
   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,
  373,  374,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  383,  384,   -1,   -1,   -1,  388,  389,  256,   -1,   -1,
   -1,   -1,   -1,   -1,  397,  398,  399,  400,   -1,   -1,
   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,
  346,  347,  348,  349,  350,  351,  352,  353,  354,  355,
  356,   -1,   -1,   -1,   -1,  428,   -1,   -1,   -1,   -1,
   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  383,  384,   -1,
   -1,   -1,  388,  389,  256,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  399,  400,   -1,   -1,   -1,   -1,   -1,
  339,   -1,   -1,   -1,   -1,  344,  412,  346,  347,  348,
  349,  350,  351,  352,  353,  354,  355,  356,   -1,   -1,
   -1,   -1,  428,   -1,   -1,   -1,   -1,   -1,  367,   -1,
  369,   -1,  371,   -1,  373,  374,  375,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  383,  384,   -1,   -1,   -1,  388,
  389,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  399,  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,
   -1,   -1,  344,  412,  346,  347,  348,  349,  350,  351,
  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,  428,
   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,  371,
   -1,  373,  374,  375,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  384,   -1,   -1,   -1,  388,  389,  256,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  399,  400,   -1,
   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,
  412,  346,  347,  348,  349,  350,  351,  352,  353,  354,
  355,  356,   -1,   -1,   -1,   -1,  428,   -1,   -1,   -1,
   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,  374,
  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  384,
   -1,   -1,   -1,  388,  389,  256,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  399,  400,   -1,   -1,   -1,   -1,
   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,  347,
  348,  349,  350,  351,  352,  353,  354,  355,  356,   -1,
   -1,   -1,   -1,  428,   -1,   -1,   -1,   -1,   -1,  367,
   -1,  369,   -1,  371,   -1,  373,  374,  375,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  384,   -1,   -1,   -1,
   -1,  389,  256,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  399,  400,   -1,   -1,   -1,   -1,   -1,  339,   -1,
   -1,   -1,   -1,  344,  412,  346,  347,  348,  349,  350,
  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,   -1,
  428,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,   -1,
  371,   -1,  373,  374,  375,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  384,   -1,   -1,   -1,   -1,  389,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  399,  400,
   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,   -1,   -1,
  344,  412,  346,  347,  348,  349,  350,  351,  352,  353,
  354,  355,  356,   -1,   -1,   -1,   -1,  428,   -1,   -1,
   -1,   -1,   -1,  367,   -1,  369,   -1,  371,   -1,  373,
  374,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  389,  256,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  399,  400,   -1,   -1,   -1,
   -1,   -1,  339,   -1,   -1,   -1,   -1,  344,  412,  346,
  347,  348,  349,  350,  351,  352,  353,  354,  355,  356,
   -1,   -1,   -1,   -1,  428,   -1,   -1,   -1,   -1,   -1,
  367,   -1,  369,   -1,  371,   -1,  373,  374,  375,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  389,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  400,   -1,   -1,   -1,   -1,   -1,  339,
   -1,   -1,   -1,   -1,  344,  412,  346,  347,  348,  349,
  350,  351,  352,  353,  354,  355,  356,   -1,   -1,   -1,
   -1,  428,   -1,   -1,   -1,   -1,   -1,  367,   -1,  369,
   -1,  371,   -1,  373,  374,  375,  256,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,  266,  267,   -1,  389,
  270,  271,   -1,  273,  274,  275,  276,  277,  278,  279,
   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,  288,  289,
  290,  291,  292,   -1,   -1,  295,   -1,   -1,   -1,  299,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,  428,   -1,
   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,  324,  325,  326,  327,  328,  329,
  330,  331,  332,  333,  334,  335,   -1,  337,   -1,   -1,
  340,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,   -1,   -1,   -1,  366,   -1,   -1,   -1,
  370,   -1,   -1,   -1,   -1,  375,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,
   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  416,  417,  418,  419,
  264,  265,  266,  267,   -1,   -1,  270,  271,   -1,  273,
  274,  275,  276,  277,  278,  279,   -1,   -1,   -1,   -1,
   -1,  285,   -1,  287,  288,  289,  290,  291,  292,   -1,
   -1,  295,   -1,   -1,   -1,  299,  300,   -1,  302,  303,
  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  314,   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,
  324,  325,  326,  327,  328,  329,  330,  331,  332,  333,
  334,  335,   -1,  337,   -1,   -1,  340,  341,   -1,   -1,
  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,
   -1,   -1,  366,   -1,   -1,   -1,  370,   -1,   -1,   -1,
   -1,  375,  376,  377,  378,  379,   -1,   -1,   -1,  383,
   -1,  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
   -1,   -1,  416,  417,  418,  419,  264,  265,  266,  267,
   -1,   -1,  270,  271,   -1,  273,  274,  275,  276,  277,
  278,  279,   -1,   -1,   -1,   -1,   -1,  285,   -1,  287,
  288,  289,  290,  291,  292,   -1,   -1,  295,   -1,   -1,
   -1,  299,  300,   -1,  302,  303,  304,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,  316,   -1,
  318,  319,   -1,   -1,  322,   -1,  324,  325,  326,  327,
  328,  329,  330,  331,  332,  333,  334,  335,   -1,  337,
   -1,   -1,  340,  341,   -1,   -1,  344,  345,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,   -1,   -1,   -1,  366,   -1,
   -1,   -1,  370,   -1,   -1,   -1,   -1,  375,  376,  377,
  378,  379,   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,
   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  416,  417,
  418,  419,  264,  265,  266,  267,   -1,   -1,  270,  271,
   -1,  273,  274,  275,  276,  277,  278,  279,   -1,   -1,
   -1,   -1,   -1,  285,   -1,  287,  288,  289,  290,  291,
  292,   -1,   -1,  295,   -1,   -1,   -1,  299,  300,   -1,
  302,  303,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  314,   -1,  316,   -1,  318,  319,   -1,   -1,
  322,   -1,  324,  325,  326,  327,  328,  329,  330,  331,
  332,  333,  334,  335,   -1,  337,   -1,   -1,  340,  341,
   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,   -1,   -1,   -1,  366,   -1,   -1,   -1,  370,   -1,
   -1,   -1,   -1,  375,  376,  377,  378,  379,   -1,   -1,
   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  416,  417,  418,  419,  264,  265,
  266,  267,   -1,   -1,  270,  271,   -1,  273,  274,  275,
  276,  277,  278,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,  287,  288,  289,  290,  291,  292,   -1,   -1,  295,
   -1,   -1,   -1,  299,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  314,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,  324,  325,
  326,  327,  328,  329,  330,  331,  332,  333,  334,  335,
   -1,  337,   -1,   -1,  340,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
  366,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,  375,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,
  416,  417,  418,  419,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,  256,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,
   -1,   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,
   -1,   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,
   -1,  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,  316,  334,  318,   -1,   -1,   -1,  322,
   -1,  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,
   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,   -1,   -1,   -1,  366,  367,   -1,   -1,
  370,   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,
   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  256,   -1,   -1,   -1,  416,  417,  418,  419,
  264,  265,   -1,  267,   -1,   -1,  270,  271,   -1,  256,
   -1,  275,  276,  277,  417,  279,   -1,   -1,  265,   -1,
  267,  285,   -1,  270,  288,   -1,   -1,   -1,  275,   -1,
   -1,  295,  279,   -1,   -1,   -1,  300,   -1,  302,  303,
  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,
   -1,   -1,  316,  300,  318,  319,  320,  304,  322,   -1,
   -1,  325,   -1,  327,   -1,  329,  330,  331,  332,  316,
  334,  318,   -1,   -1,   -1,  322,   -1,  341,   -1,   -1,
  344,  345,   -1,  330,  331,   -1,   -1,  334,   -1,   -1,
  337,   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,
   -1,   -1,  366,   -1,   -1,   -1,  370,   -1,   -1,   -1,
   -1,   -1,  376,  377,  378,  379,   -1,   -1,   -1,  383,
   -1,  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,
   -1,   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,
   -1,  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,
  279,   -1,  416,  417,  418,  419,  285,   -1,   -1,  288,
   -1,   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,
  417,  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
  319,   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,
  329,  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,
   -1,   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  360,  361,  362,   -1,   -1,   -1,  366,  367,   -1,
   -1,  370,   -1,   -1,   -1,   -1,   -1,  376,  377,  378,
  379,   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,
   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  256,   -1,  416,  417,  418,
  419,   -1,   -1,  264,  265,   -1,  267,   -1,  427,  270,
  271,   -1,  256,   -1,  275,  276,  277,   -1,  279,   -1,
   -1,  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,
   -1,  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,
   -1,  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,
  304,  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,
  331,  332,  316,  334,  318,   -1,  337,   -1,  322,   -1,
  341,   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,
  334,   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,  360,
  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,
   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,   -1,
   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,   -1,
  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,   -1,  279,   -1,  416,  417,  418,  419,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  417,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
  366,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  416,  417,  418,  419,   -1,   -1,  264,  265,   -1,  267,
   -1,  427,  270,  271,   -1,   -1,   -1,  275,  276,  277,
   -1,  279,   -1,   -1,  265,   -1,  267,  285,   -1,  270,
  288,   -1,   -1,   -1,  275,   -1,   -1,  295,  279,   -1,
   -1,   -1,  300,   -1,  302,  303,  304,  288,   -1,   -1,
   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  316,  300,
  318,  319,   -1,  304,  322,   -1,   -1,  325,   -1,  327,
   -1,  329,  330,  331,  332,  316,  334,  318,   -1,   -1,
   -1,  322,   -1,  341,   -1,   -1,  344,  345,   -1,  330,
  331,   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,   -1,
   -1,   -1,  360,  361,  362,   -1,   -1,   -1,  366,   -1,
   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,  376,  377,
  378,  379,   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,
  371,   -1,   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  256,   -1,   -1,   -1,  416,  417,
  418,  419,  264,  265,   -1,  267,   -1,   -1,  270,  271,
   -1,   -1,   -1,  275,  276,  277,  417,  279,   -1,   -1,
  265,   -1,  267,  285,   -1,  270,  288,   -1,   -1,   -1,
  275,   -1,   -1,  295,  279,   -1,   -1,   -1,  300,   -1,
  302,  303,  304,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,  316,  300,  318,  319,   -1,  304,
  322,   -1,   -1,  325,   -1,  327,   -1,  329,  330,  331,
  332,  316,  334,  318,   -1,   -1,   -1,  322,   -1,  341,
   -1,   -1,  344,  345,   -1,  330,  331,   -1,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,   -1,   -1,  360,  361,
  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  370,   -1,
   -1,   -1,   -1,   -1,  376,  377,  378,  379,   -1,   -1,
   -1,  383,   -1,  385,  369,   -1,   -1,   -1,   -1,  391,
  392,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  256,   -1,   -1,   -1,  416,  417,  418,  419,  264,  265,
   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,  275,
  276,  277,  417,  279,   -1,   -1,   -1,   -1,   -1,  285,
   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  262,   -1,   -1,   -1,
  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,  325,
   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  345,
   -1,   -1,  298,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,   -1,
  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,  385,
   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  416,  417,  418,  419,  370,  371,  372,  373,   -1,   -1,
   -1,  377,  378,   -1,   -1,  381,  382,  383,  384,  385,
  386,  387,  388,  389,   -1,  391,  392,  393,  394,  395,
  396,  397,  398,  399,  400,  401,  402,  403,  404,  405,
  406,  407,  408,  409,  410,  411,  412,   -1,  261,   -1,
   -1,   -1,  265,  419,  267,   -1,  422,  270,   -1,  272,
  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,  282,
  283,  284,   -1,   -1,  287,  288,   -1,   -1,   -1,   -1,
  293,   -1,  295,  296,  297,   -1,   -1,  300,   -1,  302,
   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,  312,
   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,  322,
  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,
  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,  342,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  261,
   -1,   -1,   -1,  265,   -1,  267,  359,   -1,  270,   -1,
  272,  273,   -1,  275,  367,  277,   -1,  279,   -1,  281,
  282,  283,  284,  376,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,  296,  297,   -1,   -1,  300,   -1,
  302,   -1,  304,   -1,   -1,  307,   -1,  309,  310,  311,
  312,   -1,   -1,   -1,  316,  317,  318,   -1,   -1,  321,
  322,  323,   -1,   -1,  417,   -1,   -1,   -1,  330,  331,
   -1,  333,  334,   -1,  336,  337,  338,   -1,   -1,   -1,
  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  261,   -1,   -1,   -1,  265,   -1,  267,  359,   -1,  270,
   -1,  272,  273,   -1,  275,  367,  277,   -1,  279,   -1,
  281,  282,  283,  284,  376,   -1,  287,  288,   -1,   -1,
   -1,   -1,  293,   -1,  295,  296,  297,   -1,   -1,  300,
   -1,  302,   -1,  304,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,   -1,  316,  317,  318,   -1,   -1,
  321,  322,  323,   -1,   -1,  417,   -1,   -1,   -1,  330,
  331,   -1,  333,  334,   -1,  336,  337,  338,   -1,   -1,
   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  261,   -1,   -1,   -1,  265,   -1,  267,  359,   -1,
  270,   -1,  272,  273,   -1,  275,  367,  277,   -1,  279,
   -1,  281,  282,  283,  284,  376,   -1,  287,  288,   -1,
   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,   -1,
  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,   -1,
   -1,  321,  322,  323,   -1,   -1,  417,   -1,   -1,   -1,
  330,  331,   -1,  333,  334,   -1,  336,  337,  338,   -1,
   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  261,   -1,   -1,   -1,  265,   -1,  267,  359,
   -1,  270,   -1,  272,  273,   -1,  275,  367,  277,   -1,
  279,   -1,  281,  282,  283,  284,  376,   -1,  287,  288,
   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,   -1,
   -1,  300,   -1,  302,   -1,  304,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,  318,
   -1,   -1,  321,  322,  323,   -1,   -1,  417,   -1,   -1,
   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,  338,
   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  261,   -1,   -1,   -1,  265,   -1,  267,
  359,   -1,  270,   -1,  272,  273,   -1,  275,  367,  277,
   -1,  279,   -1,  281,  282,  283,  284,   -1,   -1,  287,
  288,   -1,   -1,   -1,   -1,  293,   -1,  295,  296,  297,
   -1,   -1,  300,   -1,  302,   -1,  304,  261,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  316,  317,
  318,   -1,   -1,  321,  322,  323,   -1,   -1,  417,   -1,
  284,   -1,  330,  331,   -1,  333,  334,   -1,  336,  337,
  338,   -1,   -1,  297,  342,   -1,   -1,   -1,  302,   -1,
   -1,  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,
   -1,  359,   -1,  317,   -1,   -1,   -1,  321,   -1,  367,
   -1,  325,   -1,   -1,   -1,   -1,  261,   -1,   -1,  333,
   -1,   -1,  336,   -1,  338,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  284,
   -1,   -1,   -1,  357,   -1,  359,  261,   -1,   -1,   -1,
   -1,   -1,  297,   -1,  368,   -1,  370,  302,  372,  417,
  305,   -1,  307,   -1,  309,  310,  311,  312,   -1,  284,
   -1,  385,  317,   -1,   -1,   -1,  321,   -1,   -1,   -1,
  325,  261,  297,   -1,   -1,   -1,   -1,  302,  333,   -1,
  305,  336,  307,  338,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,  417,  284,   -1,  321,   -1,   -1,   -1,
  325,  261,   -1,   -1,  359,   -1,   -1,  297,  333,   -1,
   -1,  336,  302,  338,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,  284,   -1,   -1,  317,   -1,   -1,
   -1,  321,   -1,   -1,  359,  325,   -1,  297,   -1,   -1,
   -1,   -1,  302,  333,   -1,   -1,  336,  307,  338,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
   -1,  321,  417,   -1,   -1,   -1,   -1,   -1,   -1,  359,
   -1,   -1,   -1,  333,  264,  265,  336,  267,  338,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,   -1,  417,   -1,   -1,  285,   -1,   -1,  288,  359,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,  306,   -1,   -1,   -1,
   -1,   -1,   -1,  313,   -1,   -1,  316,  417,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,  417,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  370,  371,   -1,  373,   -1,   -1,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,
   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  416,  417,  418,  419,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,  306,   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,  373,   -1,
   -1,  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,
  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,  306,   -1,   -1,   -1,
   -1,   -1,   -1,  313,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  370,   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,
   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  416,  417,  418,  419,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,  337,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,
  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,   -1,   -1,   -1,   -1,  367,   -1,   -1,
  370,   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,
   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  416,  417,  418,  419,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,
   -1,  366,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,
  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,   -1,   -1,   -1,  366,   -1,   -1,   -1,
  370,   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,
   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  416,  417,  418,  419,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,
  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  370,   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,
   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  416,  417,  418,  419,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,
  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,   -1,   -1,   -1,   -1,
   -1,  341,   -1,   -1,  344,  345,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  360,  361,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  370,   -1,   -1,   -1,   -1,   -1,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,   -1,   -1,   -1,
   -1,  391,  392,   -1,   -1,   -1,   -1,   -1,   -1,  264,
  265,   -1,  267,   -1,   -1,  270,  271,   -1,   -1,   -1,
  275,  276,  277,   -1,  279,   -1,  416,  417,  418,  419,
  285,   -1,   -1,  288,   -1,   -1,   -1,   -1,   -1,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,  302,  303,  304,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,  319,   -1,   -1,  322,   -1,   -1,
  325,   -1,  327,   -1,  329,  330,  331,  332,   -1,  334,
   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,
  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  360,  361,  362,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  370,   -1,   -1,   -1,   -1,
   -1,  376,  377,  378,  379,   -1,   -1,   -1,  383,   -1,
  385,   -1,   -1,   -1,   -1,   -1,  391,  392,   -1,   -1,
   -1,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  416,  417,  418,  419,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,   -1,  265,   -1,  267,   -1,
   -1,  270,   -1,  272,   -1,   -1,  275,   -1,   -1,   -1,
  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  288,
  360,  361,  362,   -1,   -1,   -1,  295,   -1,   -1,   -1,
  370,  300,   -1,  302,   -1,  304,  376,  377,  378,  379,
   -1,   -1,   -1,  383,   -1,  385,   -1,  316,   -1,  318,
   -1,  391,  392,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,
   -1,  263,   -1,  265,   -1,  267,  416,  417,  270,  419,
  272,  273,   -1,  275,   -1,  277,   -1,  279,   -1,  281,
  282,  283,   -1,   -1,   -1,  287,  288,   -1,   -1,   -1,
   -1,  293,   -1,  295,  296,   -1,   -1,   -1,  300,   -1,
   -1,   -1,  304,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  315,  316,   -1,  318,   -1,   -1,   -1,
  322,  323,   -1,   -1,   -1,   -1,   -1,   -1,  330,  331,
   -1,   -1,  334,   -1,   -1,  337,   -1,   -1,  417,   -1,
  342,   -1,   -1,   -1,  264,  265,   -1,  267,   -1,   -1,
  270,  271,   -1,   -1,   -1,  275,  276,  277,   -1,  279,
   -1,  363,  364,   -1,   -1,  285,   -1,   -1,  288,   -1,
   -1,   -1,   -1,   -1,  376,  295,   -1,   -1,   -1,   -1,
  300,   -1,  302,  303,  304,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,  319,
   -1,   -1,  322,   -1,   -1,  325,   -1,  327,   -1,  329,
  330,  331,  332,   -1,  334,  417,  265,  337,  267,   -1,
   -1,  270,   -1,  272,  273,   -1,  275,   -1,  277,   -1,
  279,   -1,  281,  282,  283,   -1,   -1,   -1,  287,  288,
  360,  361,  362,   -1,  293,   -1,  295,  296,   -1,   -1,
  370,  300,   -1,   -1,   -1,  304,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  316,   -1,  318,
   -1,   -1,   -1,  322,  323,   -1,   -1,   -1,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,   -1,   -1,  337,   -1,
   -1,   -1,   -1,  342,   -1,   -1,  416,  417,  265,   -1,
  267,   -1,   -1,  270,   -1,  272,  273,   -1,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,  376,  295,  296,
  265,   -1,  267,  300,   -1,  270,   -1,  304,  273,   -1,
  275,   -1,  277,   -1,  279,   -1,  281,  282,  283,  316,
   -1,  318,  287,  288,   -1,  322,  323,   -1,  293,   -1,
  295,   -1,   -1,  330,  331,  300,   -1,  334,  417,  304,
  337,   -1,   -1,   -1,   -1,  342,   -1,   -1,   -1,   -1,
   -1,  316,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,  265,  334,
  267,   -1,  337,  270,   -1,   -1,  273,  342,  275,   -1,
  277,   -1,  279,   -1,  281,  282,  283,   -1,   -1,   -1,
  287,  288,   -1,   -1,   -1,   -1,  293,   -1,  295,   -1,
  265,   -1,  267,  300,   -1,  270,   -1,  304,   -1,   -1,
  275,  376,   -1,   -1,  279,   -1,   -1,   -1,   -1,  316,
  417,  318,   -1,  288,   -1,  322,   -1,   -1,   -1,   -1,
  295,   -1,   -1,  330,  331,  300,   -1,  334,   -1,  304,
  337,  306,   -1,  308,  265,  342,  267,   -1,  313,  270,
   -1,  316,  417,  318,  275,   -1,   -1,  322,  279,   -1,
  325,   -1,   -1,   -1,   -1,  330,  331,  288,   -1,  334,
   -1,   -1,  337,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,   -1,   -1,  304,  265,  306,  267,  308,   -1,  270,
   -1,   -1,  313,   -1,  275,  316,   -1,  318,  279,   -1,
   -1,  322,   -1,   -1,  325,   -1,  371,  288,   -1,  330,
  331,   -1,   -1,  334,  295,   -1,  337,   -1,   -1,  300,
  417,   -1,   -1,  304,   -1,  306,   -1,  308,  265,   -1,
  267,   -1,  313,  270,   -1,  316,   -1,  318,  275,   -1,
   -1,  322,  279,   -1,  325,   -1,   -1,   -1,  369,  330,
  331,  288,  417,  334,   -1,   -1,  337,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,   -1,  306,
   -1,   -1,   -1,   -1,   -1,   -1,  313,   -1,   -1,  316,
   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,  325,   -1,
   -1,   -1,   -1,  330,  331,   -1,  417,  334,   -1,  265,
  337,  267,   -1,   -1,  270,   -1,   -1,   -1,   -1,  275,
  265,   -1,  267,  279,   -1,  270,   -1,  283,   -1,   -1,
  275,   -1,  288,   -1,  279,   -1,   -1,  293,   -1,  295,
   -1,   -1,   -1,  288,  300,   -1,  417,   -1,  304,  305,
  295,   -1,   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,
  316,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,
   -1,  316,   -1,  318,  330,  331,   -1,  322,  334,   -1,
   -1,   -1,   -1,   -1,   -1,  330,  331,   -1,   -1,  334,
  417,  265,  337,  267,   -1,   -1,  270,   -1,   -1,   -1,
   -1,  275,  265,   -1,  267,  279,   -1,  270,   -1,   -1,
   -1,   -1,  275,   -1,  288,   -1,  279,   -1,   -1,   -1,
   -1,  295,   -1,   -1,   -1,  288,  300,   -1,   -1,   -1,
  304,   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,   -1,
   -1,  304,  316,   -1,  318,   -1,   -1,   -1,  322,   -1,
   -1,   -1,   -1,  316,   -1,  318,  330,  331,   -1,  322,
  334,  417,   -1,  337,   -1,   -1,   -1,  330,  331,   -1,
   -1,  334,  417,  265,  337,  267,   -1,   -1,  270,   -1,
   -1,   -1,   -1,  275,  265,   -1,  267,  279,   -1,  270,
   -1,   -1,   -1,   -1,  275,   -1,  288,   -1,  279,   -1,
   -1,   -1,   -1,  295,   -1,   -1,   -1,  288,  300,   -1,
   -1,   -1,  304,   -1,  295,   -1,   -1,   -1,   -1,  300,
   -1,   -1,   -1,  304,  316,   -1,  318,   -1,   -1,   -1,
  322,   -1,   -1,   -1,   -1,  316,   -1,  318,  330,  331,
   -1,  322,  334,  417,   -1,  337,   -1,   -1,   -1,  330,
  331,   -1,   -1,  334,  417,  265,  337,  267,   -1,   -1,
  270,   -1,   -1,   -1,   -1,  275,  265,   -1,  267,  279,
   -1,  270,   -1,   -1,   -1,   -1,  275,   -1,  288,   -1,
  279,   -1,   -1,   -1,   -1,  295,   -1,   -1,   -1,  288,
  300,   -1,   -1,   -1,  304,   -1,  295,   -1,   -1,   -1,
   -1,  300,   -1,   -1,   -1,  304,  316,   -1,  318,   -1,
   -1,   -1,  322,   -1,   -1,   -1,   -1,  316,   -1,  318,
  330,  331,   -1,  322,  334,  417,   -1,  337,   -1,   -1,
   -1,  330,  331,   -1,   -1,  334,  417,  265,  337,  267,
   -1,   -1,  270,   -1,   -1,   -1,   -1,  275,  265,   -1,
  267,  279,   -1,  270,   -1,   -1,   -1,   -1,  275,   -1,
  288,   -1,  279,   -1,   -1,   -1,   -1,  295,   -1,   -1,
   -1,  288,  300,   -1,   -1,   -1,  304,   -1,  295,   -1,
   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,  316,   -1,
  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,   -1,  316,
   -1,  318,  330,  331,   -1,  322,  334,  417,   -1,  337,
   -1,   -1,   -1,  330,  331,   -1,   -1,  334,  417,  265,
  337,  267,   -1,   -1,  270,   -1,   -1,   -1,   -1,  275,
  265,   -1,  267,  279,   -1,  270,   -1,   -1,   -1,   -1,
  275,   -1,  288,   -1,  279,   -1,   -1,   -1,   -1,  295,
   -1,   -1,   -1,  288,  300,   -1,   -1,   -1,  304,   -1,
  295,   -1,   -1,   -1,   -1,  300,   -1,   -1,   -1,  304,
  316,   -1,  318,   -1,   -1,   -1,  322,   -1,   -1,   -1,
   -1,  316,   -1,  318,  330,  331,   -1,  322,  334,  417,
   -1,  337,   -1,   -1,   -1,  330,  331,   -1,   -1,  334,
  417,  265,  337,  267,   -1,   -1,  270,   -1,   -1,   -1,
   -1,  275,   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  288,   -1,   -1,   -1,  261,   -1,
   -1,  295,   -1,   -1,   -1,   -1,  300,   -1,   -1,  272,
  304,   -1,   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,
   -1,  284,  316,   -1,  318,   -1,   -1,   -1,  322,   -1,
   -1,   -1,   -1,  296,  297,   -1,  330,  331,  301,  302,
  334,  417,   -1,  337,  307,   -1,  309,  310,  311,  312,
   -1,   -1,  417,   -1,  317,   -1,   -1,   -1,  321,   -1,
  323,   -1,   -1,   -1,   -1,   -1,  261,   -1,   -1,   -1,
  333,   -1,  335,  336,   -1,  338,   -1,  272,   -1,  342,
   -1,   -1,  277,   -1,   -1,   -1,  281,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,
   -1,  296,  297,   -1,  367,  368,  301,  302,   -1,  261,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,   -1,  317,  417,   -1,   -1,  321,   -1,  323,   -1,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,  333,   -1,
   -1,  336,   -1,  338,   -1,  297,   -1,  342,   -1,   -1,
  302,   -1,  261,   -1,  263,  307,   -1,  309,  310,  311,
  312,   -1,   -1,  315,  359,  317,   -1,   -1,   -1,  321,
   -1,   -1,  367,  368,   -1,  284,   -1,   -1,   -1,   -1,
   -1,  333,   -1,   -1,  336,   -1,  338,   -1,  297,   -1,
   -1,   -1,   -1,  302,   -1,   -1,   -1,   -1,  307,   -1,
  309,  310,  311,  312,   -1,   -1,   -1,  359,  317,   -1,
   -1,   -1,  321,   -1,   -1,  367,  368,   -1,   -1,   -1,
  261,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,  338,
   -1,  272,   -1,   -1,   -1,   -1,  277,   -1,   -1,   -1,
  281,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
  359,   -1,   -1,   -1,   -1,  296,  297,   -1,  367,  368,
  301,  302,   -1,  261,   -1,   -1,  307,   -1,  309,  310,
  311,  312,   -1,   -1,  272,   -1,  317,   -1,   -1,  277,
  321,   -1,  323,  281,   -1,   -1,  284,   -1,   -1,   -1,
   -1,   -1,  333,   -1,   -1,  336,   -1,  338,  296,  297,
   -1,  342,   -1,  301,  302,   -1,  261,   -1,   -1,  307,
   -1,  309,  310,  311,  312,   -1,   -1,   -1,  359,  317,
   -1,   -1,   -1,  321,   -1,  323,  367,   -1,   -1,  284,
   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,   -1,
  338,  261,  297,   -1,  342,   -1,   -1,  302,   -1,   -1,
   -1,   -1,  307,   -1,  309,  310,  311,  312,   -1,   -1,
   -1,  359,  317,   -1,  284,   -1,  321,   -1,   -1,  367,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297,  333,   -1,
   -1,  336,  302,  338,   -1,   -1,   -1,  307,   -1,  309,
  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,
  261,  321,  263,   -1,  359,   -1,   -1,   -1,  363,  364,
   -1,   -1,  367,  333,   -1,   -1,  336,   -1,  338,   -1,
   -1,   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,
  261,   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,  359,
   -1,  302,   -1,  363,  364,   -1,  307,  367,  309,  310,
  311,  312,   -1,  284,   -1,   -1,  317,   -1,   -1,   -1,
  321,   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1,
   -1,  302,  333,   -1,   -1,  336,  307,  338,  309,  310,
  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1,  261,
  321,  263,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,
   -1,   -1,  333,   -1,   -1,  336,  367,  338,   -1,   -1,
   -1,   -1,  284,   -1,   -1,   -1,   -1,   -1,   -1,  261,
   -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,  359,   -1,
  302,   -1,  363,  364,   -1,  307,   -1,  309,  310,  311,
  312,   -1,  284,  315,   -1,  317,   -1,   -1,   -1,  321,
   -1,   -1,   -1,   -1,  261,  297,   -1,   -1,   -1,  301,
  302,  333,   -1,   -1,  336,  307,  338,  309,  310,  311,
  312,   -1,   -1,   -1,   -1,  317,   -1,  284,   -1,  321,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,
  297,  333,   -1,   -1,  336,  302,  338,   -1,   -1,   -1,
  307,   -1,  309,  310,  311,  312,   -1,   -1,   -1,   -1,
  317,   -1,   -1,   -1,  321,   -1,   -1,  359,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1,  336,
   -1,  338,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,  359,
  };

#line 6179 "cs-parser.jay"

// <summary>
//  A class used to hold info about an operator declarator
// </summary>
class OperatorDeclaration {
	public readonly Operator.OpType optype;
	public readonly FullNamedExpression ret_type;
	public readonly Location location;

	public OperatorDeclaration (Operator.OpType op, FullNamedExpression ret_type, Location location)
	{
		optype = op;
		this.ret_type = ret_type;
		this.location = location;
	}
}

void Error_ExpectingTypeName (Expression expr)
{
	if (expr is Invocation){
		report.Error (1002, expr.Location, "Expecting `;'");
	} else {
		Expression.Error_InvalidExpressionStatement (report, expr.Location);
	}
}

void Error_ParameterModifierNotValid (string modifier, Location loc)
{
	report.Error (631, loc, "The parameter modifier `{0}' is not valid in this context",
			              modifier);
}

void Error_DuplicateParameterModifier (Location loc, Parameter.Modifier mod)
{
	report.Error (1107, loc, "Duplicate parameter modifier `{0}'",
  		Parameter.GetModifierSignature (mod));
}

void Error_TypeExpected (Location loc)
{
	report.Error (1031, loc, "Type expected");
}

void Error_UnsafeCodeNotAllowed (Location loc)
{
	report.Error (227, loc, "Unsafe code requires the `unsafe' command line option to be specified");
}

void Warning_EmptyStatement (Location loc)
{
	report.Warning (642, 3, loc, "Possible mistaken empty statement");
}

void Error_NamedArgumentExpected (NamedArgument a)
{
	report.Error (1738, a.Location, "Named arguments must appear after the positional arguments");
}

void push_current_class (TypeContainer tc, object partial_token)
{
	if (module.Evaluator != null){
		tc.Definition.Modifiers = tc.ModFlags = (tc.ModFlags & ~Modifiers.AccessibilityMask) | Modifiers.PUBLIC;
		if (undo == null)
			undo = new Undo ();
		undo.AddTypeContainer (current_container, tc);
	}

	if (partial_token != null)
		current_container = current_container.AddPartial (tc);
	else
		current_container = current_container.AddTypeContainer (tc);

	++lexer.parsing_declaration;
	current_class = tc;
	ubag.PushTypeDeclaration (tc);
}

DeclSpace pop_current_class ()
{
	DeclSpace retval = current_class;

	current_class = current_class.Parent;
	current_container = current_class.PartialContainer;
	ubag.PopTypeDeclaration ();
	
	return retval;
}

// <summary>
//   Given the @class_name name, it creates a fully qualified name
//   based on the containing declaration space
// </summary>
MemberName
MakeName (MemberName class_name)
{
	Namespace ns = current_namespace.NS;

	if (current_container == module) {
		if (ns.Name.Length != 0)
			return new MemberName (ns.MemberName, class_name);
		else
			return class_name;
	} else {
		return new MemberName (current_container.MemberName, class_name);
	}
}

[System.Diagnostics.Conditional ("FULL_AST")]
void StoreModifierLocation (object token, Location loc)
{
	if (lbag == null)
		return;

	if (mod_locations == null)
  		mod_locations = new List<Tuple<Modifiers, Location>> ();

	mod_locations.Add (Tuple.Create ((Modifiers) token, loc));
}

List<Tuple<Modifiers, Location>> GetModifierLocations ()
{
	var result = mod_locations;
	mod_locations = null;
	return result;
}

string CheckAttributeTarget (string a, Location l)
{
	switch (a) {
	case "assembly" : case "module" : case "field" : case "method" : case "param" : case "property" : case "type" :
			return a;
	}

	report.Warning (658, 1, l,
		 "`{0}' is invalid attribute target. All attributes in this attribute section will be ignored", a);
	return string.Empty;
}

static bool IsUnaryOperator (Operator.OpType op)
{
	switch (op) {
		
	case Operator.OpType.LogicalNot: 
	case Operator.OpType.OnesComplement: 
	case Operator.OpType.Increment:
	case Operator.OpType.Decrement:
	case Operator.OpType.True: 
	case Operator.OpType.False: 
	case Operator.OpType.UnaryPlus: 
	case Operator.OpType.UnaryNegation:
		return true;
	}
	return false;
}

void syntax_error (Location l, string msg)
{
	report.Error (1003, l, "Syntax error, " + msg);
}

Tokenizer lexer;

public Tokenizer Lexer {
	get {
		return lexer;
	}
}		   

static CSharpParser ()
{
	oob_stack = new Stack<object> ();
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file)
	: this (reader, file, file.NamespaceContainer.Module.Compiler.Report)
{
}

public CSharpParser (SeekableStreamReader reader, CompilationSourceFile file, Report report)
{
	this.file = file;
	current_namespace = file.NamespaceContainer;
	
	this.module = current_namespace.Module;
	this.compiler = module.Compiler;
	this.settings = compiler.Settings;
	this.report = report;
	
	lang_version = settings.Version;
	doc_support = settings.DocumentationFile != null;
	current_class = current_namespace.SlaveDeclSpace;
	current_container = current_class.PartialContainer; // == RootContest.ToplevelTypes
	oob_stack.Clear ();
	lexer = new Tokenizer (reader, file, compiler);
	
	use_global_stacks = true;
}

public void parse ()
{
	eof_token = Token.EOF;
	Tokenizer.LocatedToken.Initialize ();
	
	try {
		if (yacc_verbose_flag > 1)
			yyparse (lexer, new yydebug.yyDebugSimple ());
		else
			yyparse (lexer);
			
		Tokenizer tokenizer = lexer as Tokenizer;
		tokenizer.cleanup ();		
	} catch (Exception e){
	  	if (e is yyParser.yyUnexpectedEof) {
			Error_SyntaxError (yyToken);
			UnexpectedEOF = true;
			return;
		}
			
		if (e is yyParser.yyException) {
			report.Error (-25, lexer.Location, "Parsing error");
		} else {
			// Used by compiler-tester to test internal errors
			if (yacc_verbose_flag > 0)
				throw;
		
			report.Error (589, lexer.Location, "Internal compiler error during parsing");
		}
	}
}

void CheckToken (int error, int yyToken, string msg, Location loc)
{
	if (yyToken >= Token.FIRST_KEYWORD && yyToken <= Token.LAST_KEYWORD)
		report.Error (error, loc, "{0}: `{1}' is a keyword", msg, GetTokenName (yyToken));
	else
		report.Error (error, loc, msg);
}

string ConsumeStoredComment ()
{
	string s = tmpComment;
	tmpComment = null;
	Lexer.doc_state = XmlCommentState.Allowed;
	return s;
}

void FeatureIsNotAvailable (Location loc, string feature)
{
	report.FeatureIsNotAvailable (compiler, loc, feature);
}

Location GetLocation (object obj)
{
	var lt = obj as Tokenizer.LocatedToken;
	if (lt != null)
		return lt.Location;
		
	var mn = obj as MemberName;
	if (mn != null)
		return mn.Location;
		
	var expr = obj as Expression;
	if (expr != null)
		return expr.Location;

	return lexer.Location;
}

public LocationsBag LocationsBag {
	get {
		return lbag;
	}
	set {
		lbag = value;
	}
}

public UsingsBag UsingsBag {
	get {
		return ubag;
	}
	set {
		ubag = value;
	}
}

void start_block (Location loc)
{
	if (current_block == null) {
		current_block = new ToplevelBlock (compiler, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else if (parsing_anonymous_method) {
		current_block = new ParametersBlock (current_block, current_local_parameters, loc);
		parsing_anonymous_method = false;
	} else {
		current_block = new ExplicitBlock (current_block, loc, Location.Null);
	}
}

Block
end_block (Location loc)
{
	Block retval = current_block.Explicit;
	retval.SetEndLocation (loc);
	current_block = retval.Parent;
	return retval;
}

void start_anonymous (bool lambda, ParametersCompiled parameters, Location loc)
{
	if (lang_version == LanguageVersion.ISO_1){
		FeatureIsNotAvailable (loc, "anonymous methods");
	}

	oob_stack.Push (current_anonymous_method);
	oob_stack.Push (current_local_parameters);
	oob_stack.Push (current_variable);

	current_local_parameters = parameters;

	current_anonymous_method = lambda 
		? new LambdaExpression (loc) 
		: new AnonymousMethodExpression (loc);

	// Force the next block to be created as a ToplevelBlock
	parsing_anonymous_method = true;
}

/*
 * Completes the anonymous method processing, if lambda_expr is null, this
 * means that we have a Statement instead of an Expression embedded 
 */
AnonymousMethodExpression end_anonymous (ParametersBlock anon_block)
{
	AnonymousMethodExpression retval;

	current_anonymous_method.Block = anon_block;
	retval = current_anonymous_method;

	current_variable = (BlockVariableDeclaration) oob_stack.Pop ();
	current_local_parameters = (ParametersCompiled) oob_stack.Pop ();
	current_anonymous_method = (AnonymousMethodExpression) oob_stack.Pop ();

	return retval;
}

void Error_SyntaxError (int token)
{
	Error_SyntaxError (0, token, "Unexpected symbol");
}

void Error_SyntaxError (int error_code, int token, string msg)
{
	// An error message has been reported by tokenizer
	if (token == Token.ERROR)
		return;

	string symbol = GetSymbolName (token);
	string expecting = GetExpecting ();
	var loc = lexer.Location - symbol.Length;
	
	if (error_code == 0) {
		if (expecting == "`identifier'") {
			if (token > Token.FIRST_KEYWORD && token < Token.LAST_KEYWORD) {
				report.Error (1041, loc, "Identifier expected, `{0}' is a keyword", symbol);
				return;
			}
			
			error_code = 1001;
			expecting = "identifier";
		} else if (expecting == "`)'") {
			error_code = 1026;
		} else {
			error_code = 1525;
		}
	}
	
	if (string.IsNullOrEmpty (expecting))
		report.Error (error_code, loc, "{1} `{0}'", symbol, msg);
	else
		report.Error (error_code, loc, "{2} `{0}', expecting {1}", symbol, expecting, msg);	  
}

string GetExpecting ()
{
	int [] tokens = yyExpectingTokens (yyExpectingState);
	var names = new List<string> (tokens.Length);
	bool has_type = false;
	bool has_identifier = false;
	for (int i = 0; i < tokens.Length; i++){
		int token = tokens [i];
		has_identifier |= token == Token.IDENTIFIER;
		
		string name = GetTokenName (token);
		if (name == "<internal>")
			continue;
			
		has_type |= name == "type";
		if (names.Contains (name))
			continue;
		
		names.Add (name);
	}

	//
	// Too many tokens to enumerate
	//
	if (names.Count > 8)
		return null;

	if (has_type && has_identifier)
		names.Remove ("identifier");

	if (names.Count == 1)
		return "`" + GetTokenName (tokens [0]) + "'";
	
	StringBuilder sb = new StringBuilder ();
	names.Sort ();
	int count = names.Count;
	for (int i = 0; i < count; i++){
		bool last = i + 1 == count;
		if (last)
			sb.Append ("or ");
		sb.Append ('`');
		sb.Append (names [i]);
		sb.Append (last ? "'" : count < 3 ? "' " : "', ");
	}
	return sb.ToString ();
}


string GetSymbolName (int token)
{
	switch (token){
	case Token.LITERAL:
		return ((Constant)lexer.Value).GetValue ().ToString ();
	case Token.IDENTIFIER:
		return ((Tokenizer.LocatedToken)lexer.Value).Value;

	case Token.BOOL:
		return "bool";
	case Token.BYTE:
		return "byte";
	case Token.CHAR:
		return "char";
	case Token.VOID:
		return "void";
	case Token.DECIMAL:
		return "decimal";
	case Token.DOUBLE:
		return "double";
	case Token.FLOAT:
		return "float";
	case Token.INT:
		return "int";
	case Token.LONG:
		return "long";
	case Token.SBYTE:
		return "sbyte";
	case Token.SHORT:
		return "short";
	case Token.STRING:
		return "string";
	case Token.UINT:
		return "uint";
	case Token.ULONG:
		return "ulong";
	case Token.USHORT:
		return "ushort";
	case Token.OBJECT:
		return "object";
		
	case Token.PLUS:
		return "+";
	case Token.UMINUS:
	case Token.MINUS:
		return "-";
	case Token.BANG:
		return "!";
	case Token.BITWISE_AND:
		return "&";
	case Token.BITWISE_OR:
		return "|";
	case Token.STAR:
		return "*";
	case Token.PERCENT:
		return "%";
	case Token.DIV:
		return "/";
	case Token.CARRET:
		return "^";
	case Token.OP_INC:
		return "++";
	case Token.OP_DEC:
		return "--";
	case Token.OP_SHIFT_LEFT:
		return "<<";
	case Token.OP_SHIFT_RIGHT:
		return ">>";
	case Token.OP_LT:
		return "<";
	case Token.OP_GT:
		return ">";
	case Token.OP_LE:
		return "<=";
	case Token.OP_GE:
		return ">=";
	case Token.OP_EQ:
		return "==";
	case Token.OP_NE:
		return "!=";
	case Token.OP_AND:
		return "&&";
	case Token.OP_OR:
		return "||";
	case Token.OP_PTR:
		return "->";
	case Token.OP_COALESCING:	
		return "??";
	case Token.OP_MULT_ASSIGN:
		return "*=";
	case Token.OP_DIV_ASSIGN:
		return "/=";
	case Token.OP_MOD_ASSIGN:
		return "%=";
	case Token.OP_ADD_ASSIGN:
		return "+=";
	case Token.OP_SUB_ASSIGN:
		return "-=";
	case Token.OP_SHIFT_LEFT_ASSIGN:
		return "<<=";
	case Token.OP_SHIFT_RIGHT_ASSIGN:
		return ">>=";
	case Token.OP_AND_ASSIGN:
		return "&=";
	case Token.OP_XOR_ASSIGN:
		return "^=";
	case Token.OP_OR_ASSIGN:
		return "|=";
	}

	return GetTokenName (token);
}

static string GetTokenName (int token)
{
	switch (token){
	case Token.ABSTRACT:
		return "abstract";
	case Token.AS:
		return "as";
	case Token.ADD:
		return "add";
	case Token.ASYNC:
		return "async";
	case Token.BASE:
		return "base";
	case Token.BREAK:
		return "break";
	case Token.CASE:
		return "case";
	case Token.CATCH:
		return "catch";
	case Token.CHECKED:
		return "checked";
	case Token.CLASS:
		return "class";
	case Token.CONST:
		return "const";
	case Token.CONTINUE:
		return "continue";
	case Token.DEFAULT:
		return "default";
	case Token.DELEGATE:
		return "delegate";
	case Token.DO:
		return "do";
	case Token.ELSE:
		return "else";
	case Token.ENUM:
		return "enum";
	case Token.EVENT:
		return "event";
	case Token.EXPLICIT:
		return "explicit";
	case Token.EXTERN:
	case Token.EXTERN_ALIAS:
		return "extern";
	case Token.FALSE:
		return "false";
	case Token.FINALLY:
		return "finally";
	case Token.FIXED:
		return "fixed";
	case Token.FOR:
		return "for";
	case Token.FOREACH:
		return "foreach";
	case Token.GOTO:
		return "goto";
	case Token.IF:
		return "if";
	case Token.IMPLICIT:
		return "implicit";
	case Token.IN:
		return "in";
	case Token.INTERFACE:
		return "interface";
	case Token.INTERNAL:
		return "internal";
	case Token.IS:
		return "is";
	case Token.LOCK:
		return "lock";
	case Token.NAMESPACE:
		return "namespace";
	case Token.NEW:
		return "new";
	case Token.NULL:
		return "null";
	case Token.OPERATOR:
		return "operator";
	case Token.OUT:
		return "out";
	case Token.OVERRIDE:
		return "override";
	case Token.PARAMS:
		return "params";
	case Token.PRIVATE:
		return "private";
	case Token.PROTECTED:
		return "protected";
	case Token.PUBLIC:
		return "public";
	case Token.READONLY:
		return "readonly";
	case Token.REF:
		return "ref";
	case Token.RETURN:
		return "return";
	case Token.REMOVE:
		return "remove";
	case Token.SEALED:
		return "sealed";
	case Token.SIZEOF:
		return "sizeof";
	case Token.STACKALLOC:
		return "stackalloc";
	case Token.STATIC:
		return "static";
	case Token.STRUCT:
		return "struct";
	case Token.SWITCH:
		return "switch";
	case Token.THIS:
		return "this";
	case Token.THROW:
		return "throw";
	case Token.TRUE:
		return "true";
	case Token.TRY:
		return "try";
	case Token.TYPEOF:
		return "typeof";
	case Token.UNCHECKED:
		return "unchecked";
	case Token.UNSAFE:
		return "unsafe";
	case Token.USING:
		return "using";
	case Token.VIRTUAL:
		return "virtual";
	case Token.VOLATILE:
		return "volatile";
	case Token.WHERE:
		return "where";
	case Token.WHILE:
		return "while";
	case Token.ARGLIST:
		return "__arglist";
	case Token.REFVALUE:
		return "__refvalue";
	case Token.REFTYPE:
		return "__reftype";
	case Token.MAKEREF:
		return "__makeref";
	case Token.PARTIAL:
		return "partial";
	case Token.ARROW:
		return "=>";
	case Token.FROM:
	case Token.FROM_FIRST:
		return "from";
	case Token.JOIN:
		return "join";
	case Token.ON:
		return "on";
	case Token.EQUALS:
		return "equals";
	case Token.SELECT:
		return "select";
	case Token.GROUP:
		return "group";
	case Token.BY:
		return "by";
	case Token.LET:
		return "let";
	case Token.ORDERBY:
		return "orderby";
	case Token.ASCENDING:
		return "ascending";
	case Token.DESCENDING:
		return "descending";
	case Token.INTO:
		return "into";
	case Token.GET:
		return "get";
	case Token.SET:
		return "set";
	case Token.OPEN_BRACE:
		return "{";
	case Token.CLOSE_BRACE:
		return "}";
	case Token.OPEN_BRACKET:
	case Token.OPEN_BRACKET_EXPR:
		return "[";
	case Token.CLOSE_BRACKET:
		return "]";
	case Token.OPEN_PARENS_CAST:
	case Token.OPEN_PARENS_LAMBDA:
	case Token.OPEN_PARENS:
		return "(";
	case Token.CLOSE_PARENS:
		return ")";
	case Token.DOT:
		return ".";
	case Token.COMMA:
		return ",";
	case Token.DEFAULT_COLON:
		return "default:";
	case Token.COLON:
		return ":";
	case Token.SEMICOLON:
		return ";";
	case Token.TILDE:
		return "~";
		
	case Token.PLUS:
	case Token.UMINUS:
	case Token.MINUS:
	case Token.BANG:
	case Token.OP_LT:
	case Token.OP_GT:
	case Token.BITWISE_AND:
	case Token.BITWISE_OR:
	case Token.STAR:
	case Token.PERCENT:
	case Token.DIV:
	case Token.CARRET:
	case Token.OP_INC:
	case Token.OP_DEC:
	case Token.OP_SHIFT_LEFT:
	case Token.OP_SHIFT_RIGHT:
	case Token.OP_LE:
	case Token.OP_GE:
	case Token.OP_EQ:
	case Token.OP_NE:
	case Token.OP_AND:
	case Token.OP_OR:
	case Token.OP_PTR:
	case Token.OP_COALESCING:	
	case Token.OP_MULT_ASSIGN:
	case Token.OP_DIV_ASSIGN:
	case Token.OP_MOD_ASSIGN:
	case Token.OP_ADD_ASSIGN:
	case Token.OP_SUB_ASSIGN:
	case Token.OP_SHIFT_LEFT_ASSIGN:
	case Token.OP_SHIFT_RIGHT_ASSIGN:
	case Token.OP_AND_ASSIGN:
	case Token.OP_XOR_ASSIGN:
	case Token.OP_OR_ASSIGN:
		return "<operator>";

	case Token.BOOL:
	case Token.BYTE:
	case Token.CHAR:
	case Token.VOID:
	case Token.DECIMAL:
	case Token.DOUBLE:
	case Token.FLOAT:
	case Token.INT:
	case Token.LONG:
	case Token.SBYTE:
	case Token.SHORT:
	case Token.STRING:
	case Token.UINT:
	case Token.ULONG:
	case Token.USHORT:
	case Token.OBJECT:
		return "type";
	
	case Token.ASSIGN:
		return "=";
	case Token.OP_GENERICS_LT:
	case Token.GENERIC_DIMENSION:
		return "<";
	case Token.OP_GENERICS_GT:
		return ">";
	case Token.INTERR:
	case Token.INTERR_NULLABLE:
		return "?";
	case Token.DOUBLE_COLON:
		return "::";
	case Token.LITERAL:
		return "value";
	case Token.IDENTIFIER:
		return "identifier";

	case Token.EOF:
		return "end-of-file";

		// All of these are internal.
	case Token.NONE:
	case Token.ERROR:
	case Token.FIRST_KEYWORD:
	case Token.EVAL_COMPILATION_UNIT_PARSER:
	case Token.EVAL_USING_DECLARATIONS_UNIT_PARSER:
	case Token.EVAL_STATEMENT_PARSER:
	case Token.LAST_KEYWORD:
	case Token.GENERATE_COMPLETION:
	case Token.COMPLETE_COMPLETION:
		return "<internal>";

		// A bit more robust.
	default:
		return yyNames [token];
        }
}

/* end end end */
}
#line default
namespace yydebug {
        using System;
	 internal interface yyDebug {
		 void push (int state, Object value);
		 void lex (int state, int token, string name, Object value);
		 void shift (int from, int to, int errorFlag);
		 void pop (int state);
		 void discard (int state, int token, string name, Object value);
		 void reduce (int from, int to, int rule, string text, int len);
		 void shift (int from, int to);
		 void accept (Object value);
		 void error (string message);
		 void reject ();
	 }
	 
	 class yyDebugSimple : yyDebug {
		 void println (string s){
			 Console.Error.WriteLine (s);
		 }
		 
		 public void push (int state, Object value) {
			 println ("push\tstate "+state+"\tvalue "+value);
		 }
		 
		 public void lex (int state, int token, string name, Object value) {
			 println("lex\tstate "+state+"\treading "+name+"\tvalue "+value);
		 }
		 
		 public void shift (int from, int to, int errorFlag) {
			 switch (errorFlag) {
			 default:				// normally
				 println("shift\tfrom state "+from+" to "+to);
				 break;
			 case 0: case 1: case 2:		// in error recovery
				 println("shift\tfrom state "+from+" to "+to
					     +"\t"+errorFlag+" left to recover");
				 break;
			 case 3:				// normally
				 println("shift\tfrom state "+from+" to "+to+"\ton error");
				 break;
			 }
		 }
		 
		 public void pop (int state) {
			 println("pop\tstate "+state+"\ton error");
		 }
		 
		 public void discard (int state, int token, string name, Object value) {
			 println("discard\tstate "+state+"\ttoken "+name+"\tvalue "+value);
		 }
		 
		 public void reduce (int from, int to, int rule, string text, int len) {
			 println("reduce\tstate "+from+"\tuncover "+to
				     +"\trule ("+rule+") "+text);
		 }
		 
		 public void shift (int from, int to) {
			 println("goto\tfrom state "+from+" to "+to);
		 }
		 
		 public void accept (Object value) {
			 println("accept\tvalue "+value);
		 }
		 
		 public void error (string message) {
			 println("error\t"+message);
		 }
		 
		 public void reject () {
			 println("reject");
		 }
		 
	 }
}
// %token constants
 class Token {
  public const int EOF = 257;
  public const int NONE = 258;
  public const int ERROR = 259;
  public const int FIRST_KEYWORD = 260;
  public const int ABSTRACT = 261;
  public const int AS = 262;
  public const int ADD = 263;
  public const int BASE = 264;
  public const int BOOL = 265;
  public const int BREAK = 266;
  public const int BYTE = 267;
  public const int CASE = 268;
  public const int CATCH = 269;
  public const int CHAR = 270;
  public const int CHECKED = 271;
  public const int CLASS = 272;
  public const int CONST = 273;
  public const int CONTINUE = 274;
  public const int DECIMAL = 275;
  public const int DEFAULT = 276;
  public const int DELEGATE = 277;
  public const int DO = 278;
  public const int DOUBLE = 279;
  public const int ELSE = 280;
  public const int ENUM = 281;
  public const int EVENT = 282;
  public const int EXPLICIT = 283;
  public const int EXTERN = 284;
  public const int FALSE = 285;
  public const int FINALLY = 286;
  public const int FIXED = 287;
  public const int FLOAT = 288;
  public const int FOR = 289;
  public const int FOREACH = 290;
  public const int GOTO = 291;
  public const int IF = 292;
  public const int IMPLICIT = 293;
  public const int IN = 294;
  public const int INT = 295;
  public const int INTERFACE = 296;
  public const int INTERNAL = 297;
  public const int IS = 298;
  public const int LOCK = 299;
  public const int LONG = 300;
  public const int NAMESPACE = 301;
  public const int NEW = 302;
  public const int NULL = 303;
  public const int OBJECT = 304;
  public const int OPERATOR = 305;
  public const int OUT = 306;
  public const int OVERRIDE = 307;
  public const int PARAMS = 308;
  public const int PRIVATE = 309;
  public const int PROTECTED = 310;
  public const int PUBLIC = 311;
  public const int READONLY = 312;
  public const int REF = 313;
  public const int RETURN = 314;
  public const int REMOVE = 315;
  public const int SBYTE = 316;
  public const int SEALED = 317;
  public const int SHORT = 318;
  public const int SIZEOF = 319;
  public const int STACKALLOC = 320;
  public const int STATIC = 321;
  public const int STRING = 322;
  public const int STRUCT = 323;
  public const int SWITCH = 324;
  public const int THIS = 325;
  public const int THROW = 326;
  public const int TRUE = 327;
  public const int TRY = 328;
  public const int TYPEOF = 329;
  public const int UINT = 330;
  public const int ULONG = 331;
  public const int UNCHECKED = 332;
  public const int UNSAFE = 333;
  public const int USHORT = 334;
  public const int USING = 335;
  public const int VIRTUAL = 336;
  public const int VOID = 337;
  public const int VOLATILE = 338;
  public const int WHERE = 339;
  public const int WHILE = 340;
  public const int ARGLIST = 341;
  public const int PARTIAL = 342;
  public const int ARROW = 343;
  public const int FROM = 344;
  public const int FROM_FIRST = 345;
  public const int JOIN = 346;
  public const int ON = 347;
  public const int EQUALS = 348;
  public const int SELECT = 349;
  public const int GROUP = 350;
  public const int BY = 351;
  public const int LET = 352;
  public const int ORDERBY = 353;
  public const int ASCENDING = 354;
  public const int DESCENDING = 355;
  public const int INTO = 356;
  public const int INTERR_NULLABLE = 357;
  public const int EXTERN_ALIAS = 358;
  public const int ASYNC = 359;
  public const int REFVALUE = 360;
  public const int REFTYPE = 361;
  public const int MAKEREF = 362;
  public const int GET = 363;
  public const int SET = 364;
  public const int LAST_KEYWORD = 365;
  public const int OPEN_BRACE = 366;
  public const int CLOSE_BRACE = 367;
  public const int OPEN_BRACKET = 368;
  public const int CLOSE_BRACKET = 369;
  public const int OPEN_PARENS = 370;
  public const int CLOSE_PARENS = 371;
  public const int DOT = 372;
  public const int COMMA = 373;
  public const int COLON = 374;
  public const int SEMICOLON = 375;
  public const int TILDE = 376;
  public const int PLUS = 377;
  public const int MINUS = 378;
  public const int BANG = 379;
  public const int ASSIGN = 380;
  public const int OP_LT = 381;
  public const int OP_GT = 382;
  public const int BITWISE_AND = 383;
  public const int BITWISE_OR = 384;
  public const int STAR = 385;
  public const int PERCENT = 386;
  public const int DIV = 387;
  public const int CARRET = 388;
  public const int INTERR = 389;
  public const int DOUBLE_COLON = 390;
  public const int OP_INC = 391;
  public const int OP_DEC = 392;
  public const int OP_SHIFT_LEFT = 393;
  public const int OP_SHIFT_RIGHT = 394;
  public const int OP_LE = 395;
  public const int OP_GE = 396;
  public const int OP_EQ = 397;
  public const int OP_NE = 398;
  public const int OP_AND = 399;
  public const int OP_OR = 400;
  public const int OP_MULT_ASSIGN = 401;
  public const int OP_DIV_ASSIGN = 402;
  public const int OP_MOD_ASSIGN = 403;
  public const int OP_ADD_ASSIGN = 404;
  public const int OP_SUB_ASSIGN = 405;
  public const int OP_SHIFT_LEFT_ASSIGN = 406;
  public const int OP_SHIFT_RIGHT_ASSIGN = 407;
  public const int OP_AND_ASSIGN = 408;
  public const int OP_XOR_ASSIGN = 409;
  public const int OP_OR_ASSIGN = 410;
  public const int OP_PTR = 411;
  public const int OP_COALESCING = 412;
  public const int OP_GENERICS_LT = 413;
  public const int OP_GENERICS_LT_DECL = 414;
  public const int OP_GENERICS_GT = 415;
  public const int LITERAL = 416;
  public const int IDENTIFIER = 417;
  public const int OPEN_PARENS_LAMBDA = 418;
  public const int OPEN_PARENS_CAST = 419;
  public const int GENERIC_DIMENSION = 420;
  public const int DEFAULT_COLON = 421;
  public const int OPEN_BRACKET_EXPR = 422;
  public const int EVAL_STATEMENT_PARSER = 423;
  public const int EVAL_COMPILATION_UNIT_PARSER = 424;
  public const int EVAL_USING_DECLARATIONS_UNIT_PARSER = 425;
  public const int DOC_SEE = 426;
  public const int GENERATE_COMPLETION = 427;
  public const int COMPLETE_COMPLETION = 428;
  public const int UMINUS = 429;
  public const int yyErrorCode = 256;
 }
 namespace yyParser {
  using System;
  /** thrown for irrecoverable syntax errors and stack overflow.
    */
  internal class yyException : System.Exception {
    public yyException (string message) : base (message) {
    }
  }
  internal class yyUnexpectedEof : yyException {
    public yyUnexpectedEof (string message) : base (message) {
    }
    public yyUnexpectedEof () : base ("") {
    }
  }

  /** must be implemented by a scanner object to supply input to the parser.
    */
  internal interface yyInput {
    /** move on to next token.
        @return false if positioned beyond tokens.
        @throws IOException on input error.
      */
    bool advance (); // throws java.io.IOException;
    /** classifies current token.
        Should not be called if advance() returned false.
        @return current %token or single character.
      */
    int token ();
    /** associated with current token.
        Should not be called if advance() returned false.
        @return value for token().
      */
    Object value ();
  }
 }
} // close outermost namespace, that MUST HAVE BEEN opened in the prolog
