# Generated by Django 4.1.7 on 2023-05-11 13:12
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


def migrate_to_assignments(apps, schema_editor):
    from django.contrib.contenttypes.models import ContentType
    SupportContractDeviceAssignment = apps.get_model('netbox_lifecycle', 'SupportContractDeviceAssignment')
    SupportContractAssignment = apps.get_model('netbox_lifecycle', 'SupportContractAssignment')
    Device = apps.get_model('dcim', 'Device')
    assigned_object_type = ContentType.objects.get_for_model(Device)

    for contract in SupportContractDeviceAssignment.objects.all():
        assignment = SupportContractAssignment.objects.create(
            id=contract.id,
            created=contract.created,
            last_updated=contract.last_updated,
            custom_field_data=contract.custom_field_data,
            assigned_object_type_id=assigned_object_type.pk,
            assigned_object_id=contract.device.pk,
            contract=contract.contract,
        )


def migrate_from_assignments(apps, schema_editor):
    SupportContractDeviceAssignment = apps.get_model('netbox_lifecycle', 'SupportContractDeviceAssignment')
    SupportContractAssignment = apps.get_model('netbox_lifecycle', 'SupportContractAssignment')
    Device = apps.get_model('dcim', 'Device')
    for contract in SupportContractAssignment.objects.all():
        if isinstance(contract.assigned_object, Device):
            assignment = SupportContractDeviceAssignment.objects.create(
                id=contract.id,
                created=contract.created,
                last_updated=contract.last_updated,
                custom_field_data=contract.custom_field_data,
                device_id=contract.assigned_object_id,
                contract=contract.contract,
            )


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('extras', '0092_delete_jobresult'),
        ('netbox_lifecycle', '0003_remove_supportcontract_devices_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='SupportContractAssignment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, null=True)),
                ('last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('custom_field_data', models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ('assigned_object_id', models.PositiveBigIntegerField(blank=True, null=True)),
                ('assigned_object_type', models.ForeignKey(blank=True, limit_choices_to=('dcim.Device', 'netbox_lifecycle.License'), null=True, on_delete=django.db.models.deletion.PROTECT, related_name='+', to='contenttypes.contenttype')),
                ('contract', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='netbox_lifecycle.supportcontract')),
                ('tags', taggit.managers.TaggableManager(through='extras.TaggedItem', to='extras.Tag')),
            ],
            options={
                'ordering': ['contract', 'assigned_object_type', 'assigned_object_id'],
            },
        ),
        migrations.RunPython(migrate_to_assignments, migrate_from_assignments),
        migrations.DeleteModel(
            name='SupportContractDeviceAssignment',
        ),
    ]
