// libeasysave

/*
MIT License

Copyright (c) 2019 Jonathan Archer

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#include "easysave/ini.hpp"

using namespace easysave;

/// Returns the value of a given key in a given section. If the key does not exist, then a empty string will be returned.
std::string ini::fetch(std::string section, std::string key_name) {
  return fetch(section, key_name, "");
}

/// Returns the value of a given key in a given section. If the key does not exist, then the specified default value will be returned.
std::string ini::fetch(std::string section, std::string key_name,
                       std::string default_value) {
  int section_index = m_match_section_index(section);
  if (section_index < 0)
    return default_value;

  int key_index = m_match_key_index(section_index, key_name);
  if (key_index < 0) {
    // Key does not exist. Let's make it and return the default value
    set(section, key_name, default_value);
    return default_value;
  }

  // Remove leading and trailing quotes
  if (m_keys[key_index].data[0] == '\"' &&
      m_keys[key_index].data[m_keys[key_index].data.size() - 1] == '\"')
    return m_keys[key_index].data.substr(1, m_keys[key_index].data.size() - 2);
  return m_keys[key_index].data;
}