# 甲壳虫 接口文档

## 端口 //localhost:10001

```
登录接口：
  1.请求地址：/login

  2.请求方式：POST

  3.请求参数：
    email: string 必需
    password: staring 必需
    示例：email="aaa@aaa.com"&password="a1232131"

  4.状态码：
    1030 登录成功
    1031 登录失败
    1032 用户不存在
    1033 用户名或者密码不正确

  5.返回结果示例：
    {
      msg: "登录成功",
      status: 1030,
      // 用户的token建议存放于cookie
      data: [
        mama12: "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9"
        mama20: "vhNextohFzTtjFuu6F-CZY7p9eujwiKD-Z4U5Wwi8HE"
        nana19: "uyTrgabciOGHgsadrtjhaCI6Ik98EwahbvD"
        nana20: "eyJkYXRhIjoiX3VpZDE2MTQ4NjgxNjY2NzQiLCJp"
      ]
    }

```

```
注册接口：
  1.请求地址：/register

  2.请求方式：POST

  3.请求参数：
    email: string 必需
    password: staring 必需
    codeId: string 必需
    validcode： string 必需
    示例：email="dcanmera@outlook.com"&password="a1232131"&codeId="cid1615019697754"&validcode="343222"

  4.状态码：
    1000 注册成功
    1001 注册失败
    1002 该邮箱已经被注册

  5.返回结果示例：
    {
      msg: "注册成功",
      status: 1000,
      result: {
        avatar: "default.jpg"
        createdAt: "2021-03-06T08:35:40.371Z"
        email: "dcanmera@outlook.com"
        id: 2
        nickName: "绿竹_uid1615019740370"
        password: "107c703bb51820d3fb80aac6e6bc139b"
        phone: null
        sex: 2
        updatedAt: "2021-03-06T08:35:40.371Z"
        userId: "_uid1615019740370"
      }
    }

```

```
发送验证码接口：
  1.请求地址：/email

  2.请求方式：POST

  3.请求参数：
    email: string 必需
    示例：email="dcanmera@outlook.com"

  4.状态码：
    1010 注册成功
    1011 注册失败

  5.返回结果示例：
    {
      msg: "验证码已发至dcanmera@outlook.com",
      status: 1010,
      cid: "cid1615019697754"
    }

```

```
校正验证码接口：
  1.请求地址：/jadgeCode

  2.请求方式：POST

  3.请求参数：
    email: string 必需
    codeId: string 必需
    validcode: string 必需
    示例：email="dcanmera@outlook.com"&codeId="cid1615019697754"&validcode="344344"

  4.状态码：
    1035 验证通过
    1031 验证码错误

  5.返回结果示例：
    {
      msg: "验证通过",
      status: 1035
    }

```

```
获取用户信息接口：
  1.请求地址：/getUserInfo

  2.请求方式：GET

  3.请求参数：
    token：string 必需 --请求头设置
    userId: string 必需
    示例：userId="_uid1615019740370"

  4.状态码：
    1040 查询用户信息成功
    1041 查询用户信息失败

  5.返回结果示例：
    {
      msg: "查询用户信息成功",
      status: 1040,
      data: {
        result: {
          avatar: "default.jpg"
          createdAt: "2021-03-06T08:35:40.371Z"
          email: "dcanmera@outlook.com"
          id: 2
          nickName: "绿竹_uid1615019740370"
          password: "107c703bb51820d3fb80aac6e6bc139b"
          phone: null
          sex: 2
          updatedAt: "2021-03-06T08:35:40.371Z"
          userId: "_uid1615019740370"
        },
        url: "http://localhost:10001"
      }
    }

```

```
邮箱获取用户信息接口：
  1.请求地址：/getUserInfoForEmail

  2.请求方式：GET

  3.请求参数：
    email: string 必需
    示例：email="dcanmera@outlook.com"

  4.状态码：
    1040 查询用户信息成功
    1041 查询用户信息失败

  5.返回结果示例：
    {
      msg: "查询用户信息成功",
      status: 1040,
      data: {
        result: {
          avatar: "default.jpg"
          createdAt: "2021-03-06T08:35:40.371Z"
          email: "dcanmera@outlook.com"
          id: 2
          nickName: "绿竹_uid1615019740370"
          password: "107c703bb51820d3fb80aac6e6bc139b"
          phone: null
          sex: 2
          updatedAt: "2021-03-06T08:35:40.371Z"
          userId: "_uid1615019740370"
        },
        url: "http://localhost:10001"
      }
    }

```

```
更新用户信息接口：
  1.请求地址：/updateUserInfo

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    userId: string 必需
    password: string 可选
    nickName: string 可选
    phone: string 可选
    sex: string 可选
    avatar: string 可选
    示例：email="dcanmera@outlook.com"

  4.状态码：
    1042 更新成功
    1043 更新失败

  5.返回结果示例：
    {
      msg: "更新成功",
      status: 1042
    }

```

```
获取商品类型接口：
  1.请求地址：/type

  2.请求方式：GET

  3.请求参数：无

  4.状态码：
    1050 查询类型成功
    1051 查询类型失败

  5.返回结果示例：
    {
      msg: "查询类型成功",
      status: 1050,
      result: [
        {
          typeId: "a0001",
          title: "数码产品",
          icon: "shuma.png",
          home: 1
        },
        ...
      ]
    }

```

```
发布商品接口：
  1.请求地址：/postProduct

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    img: string 必需
    detailImg: string 必需
    email: string 必需
    ...

  4.状态码：
    1060 发布商品成功
    1061 发布商品失败

  5.返回结果示例：
    {
      msg: "发布商品成功",
      status: 1060,
      result:
    }

```

```
搜索商品接口：
  1.请求地址：/search

  2.请求方式：GET

  3.请求参数：
    token：string 必需 --请求头设置
    userId：string 必需
    offset: number 可选
    count: number 可选
    name: string 可选
    type_id: string 可选
    status: string 可选
    updated_at: string 可选

  4.状态码：
    1070 查询商品成功
    1071 查询商品失败

  5.返回结果示例：
    {
      msg: "查询商品成功",
      status: 1070,
      data: {
        url："http://localhost:10001",
        result:[
          商品数据
        ]
      }
    }

```

```
查询商品数目接口：
  1.请求地址：/count

  2.请求方式：GET

  3.请求参数：
    token：string 必需 --请求头设置
    userId：string 必需
    name: string 可选
    type_id: string 可选
    status: string 可选
    updated_at: string 可选

  4.状态码：
    1080 查询商品数目成功
    1081 查询商品数目失败

  5.返回结果示例：
    {
      msg: "查询商品数目成功",
      status: 1080,
      result: 23
    }

```

```
上下架接口：
  1.请求地址：/updown

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    pid：string 必需
    status: string 可选

  4.状态码：
    1090 更新商品状态成功
    1091 更新商品状态失败

  5.返回结果示例：
    {
      msg: "更新商品状态成功",
      status: 1090,
      result: 商品数据
    }

```

```
根据商品pid查询商品信息接口：
  1.请求地址：/probyid

  2.请求方式：GET

  3.请求参数：
    pid：string 必需
    userId: string 可选

  4.状态码：
    1070 查询商品成功
    1071 查询商品失败

  5.返回结果示例：
    {
      msg: "查询商品成功",
      status: 1070,
      data: {
        url："http://localhost:10001",
        result: 商品数据
      }
    }

```

```
更新商品数据接口：
  1.请求地址：/updateProduct

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    pid：string 必需
    userId: string 必需
    ...

  4.状态码：
    1100 更新商品数据成功
    1101 更新商品数据失败

  5.返回结果示例：
    {
      msg: "更新商品数据成功",
      status: 1100,
      result:
    }

```

```
删除商品接口：
  1.请求地址：/remove

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    pid：string 必需
    userId: string 必需

  4.状态码：
    1110 删除商品数据成功
    1111 删除商品数据失败

  5.返回结果示例：
    {
      msg: "删除商品数据成功",
      status: 1110
    }

```

```
查询客户端首页的推荐商品接口：
  1.请求地址：/clientHomeProduct

  2.请求方式：GET

  3.请求参数：
    name：string 可选
    type_id: string 可选

  4.状态码：
    1120 查询商品成功
    1121 查询商品失败

  5.返回结果示例：
    {
      msg: "查询商品成功",
      status: 1120,
      url: "http://localhost:10001",
      result: 商品数据
    }

```

```
查询首页类别数据接口：
  1.请求地址：/category

  2.请求方式：GET

  3.请求参数：无
  4.状态码：
    1130 查询类别成功
    1131 查询类别失败

  5.返回结果示例：
    {
      msg: "查询类别成功",
      status: 1130,
      url: "http://localhost:10001",
      result: 类别数据
    }

```

```
搜索商品接口：
  1.请求地址：/clientSearch

  2.请求方式：GET

  3.请求参数：
    keyword：string 必需

  4.状态码：
    1140 搜索商品成功
    1141 搜索商品失败

  5.返回结果示例：
    {
      msg: "搜索商品成功",
      status: 1140,
      url: "http://localhost:10001",
      result: 商品数据
    }

```

```
客户端根据商品pid查询商品详情信息(不包含用户和商品类型信息)接口：
  1.请求地址：/productDetail

  2.请求方式：GET

  3.请求参数：
    pid：string 必需

  4.状态码：
    1150 查询商品详情成功
    1151 查询商品详情失败

  5.返回结果示例：
    {
      msg: "搜索商品成功",
      status: 1150,
      url: "http://localhost:10001",
      result: 商品数据
    }

```

```
客户端收藏商品接口：
  1.请求地址：/like

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    pid：string 必需
    userId: string 必需

  4.状态码：
    1160 收藏商品成功
    1161 收藏商品失败

  5.返回结果示例：
    {
      msg: "收藏商品成功",
      status: 1160
    }

```

```
删除收藏商品接口：
  1.请求地址：/removeLike

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    pid：string 必需
    userId: string 必需

  4.状态码：
    1162 取消收藏商品成功
    1163 取消收藏商品失败

  5.返回结果示例：
    {
      msg: "取消收藏商品成功",
      status: 1162
    }

```

```
查询指定商品是否已收藏接口：
  1.请求地址：/findLike

  2.请求方式：GET

  3.请求参数：
    token：string 必需 --请求头设置
    userId: string 必需
    offset：number 必需
    count：number 必需
    pid：string 可选 不填则查找所有

  4.状态码：
    1164 查询收藏商品成功
    1165 查询收藏商品失败

  5.返回结果示例：
    {
      msg: "查询收藏商品成功",
      status: 1164,
      result: 商品数据
    }

```

```
收藏商品条目接口：
  1.请求地址：/likeCount

  2.请求方式：GET

  3.请求参数：
    token：string 必需 --请求头设置
    userId: string 必需

  4.状态码：
    1166 查询收藏商品条目成功
    1167 查询收藏商品条目失败

  5.返回结果示例：
    {
      msg: "查询收藏商品条目成功",
      status: 1166,
      result: 1
    }

```

```
加入购物车接口：
  1.请求地址：/addShopcart

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    pid：string 必需
    userId: string 必需
    count: number 必需

  4.状态码：
    1170 加入购物车成功
    1171 加入购物车失败

  5.返回结果示例：
    {
      msg: "加入购物车成功",
      status: 1170,
      result: 1
    }

```

```
删除加购商品接口：
  1.请求地址：/removeShopcart

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    pid：string 必需
    userId: string 必需

  4.状态码：
    1172 取消加购商品成功
    1173 取消加购商品失败

  5.返回结果示例：
    {
      msg: "取消加购商品成功",
      status: 1172
    }

```

```
查询购物车记录数接口：
  1.请求地址：/shopcartCount

  2.请求方式：POST

  3.请求参数：
    token：string 必需 --请求头设置
    userId: string 必需

  4.状态码：
    1174 查询购物车记录数成功
    1175 查询购物车记录数失败

  5.返回结果示例：
    {
      msg: "查询购物车记录数成功",
      status: 1174,
      result: 1
    }

```

```
查询购物车商品接口：
  1.请求地址：/shopcartProducts

  2.请求方式：GET

  3.请求参数：
    token：string 必需 --请求头设置
    userId: string 必需

  4.状态码：
    1176 查询购物车商品成功
    1177 查询购物车商品成功失败

  5.返回结果示例：
    {
      msg: "查询购物车商品成功",
      status: 1176,
      result: 商品数据
    }

```
