/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    public static void main(String[] args) {
        try {
            XmlNode node = XmlUtils.parseXml("<msg><op id='5'><username>yinxin3326</username></op></msg>");
            System.out.println(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static XmlNode parseXml(String xml) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        ByteArrayInputStream tInputStringStream = new ByteArrayInputStream(xml.getBytes());
        Document doc = builder.parse(tInputStringStream);
        Element root = doc.getDocumentElement();
        return XmlUtils.parse(root);
    }

    public static XmlNode parse(String path) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new File(path));
        Element root = doc.getDocumentElement();
        return XmlUtils.parse(root);
    }

    public static XmlNode parse(Element element) {
        XmlNode xmlNode = new XmlNode();
        String nodeName = element.getNodeName();
        xmlNode.setNodeName(nodeName);
        Map<String, String> attrMap = XmlUtils.parseAttr(element);
        xmlNode.setAttr(attrMap);
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = nodeList.item(i);
                short nodeType = node.getNodeType();
                if (nodeType == 1) {
                    xmlNode.childs.add(XmlUtils.parse((Element)node));
                    continue;
                }
                if (nodeType == 3) {
                    xmlNode.setNodeText(node.getNodeValue());
                    continue;
                }
                if (nodeType != 8) continue;
                xmlNode.setNodeText(node.getNodeValue());
            }
        }
        return xmlNode;
    }

    public static Map<String, String> parseAttr(Element element) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        NamedNodeMap attrMap = element.getAttributes();
        if (attrMap != null && attrMap.getLength() > 0) {
            int length = attrMap.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = attrMap.item(i);
                String attrName = attr.getNodeName();
                String attrValue = attr.getNodeValue();
                attrs.put(attrName, attrValue);
            }
        }
        return attrs;
    }

    public static class XmlNode {
        private String nodeName;
        private String nodeText;
        private Map<String, String> attr = new HashMap<String, String>();
        private List<XmlNode> childs = new ArrayList<XmlNode>();

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeText() {
            return this.nodeText;
        }

        public void setNodeText(String nodeText) {
            this.nodeText = nodeText;
        }

        public Map<String, String> getAttr() {
            return this.attr;
        }

        public void setAttr(Map<String, String> attr) {
            this.attr = attr;
        }

        public List<XmlNode> getChilds() {
            return this.childs;
        }

        public void setChilds(List<XmlNode> childs) {
            this.childs = childs;
        }
    }
}

