/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.other.LogHelper;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SystemUtils {
    private static final LogHelper logger = LogHelper.getLogger(SystemUtils.class);
    private static final String SPECIFICATION_NAME = SystemUtils.get("java.specification.name");
    private static final String VERSION = SystemUtils.get("java.version");
    private static final String SPECIFICATION_VERSION = SystemUtils.get("java.specification.version");
    private static final String HOME = SystemUtils.get("java.home");
    private static final String LIBRARY_PATH = SystemUtils.get("java.library.path");
    private static final String TMPDIR = SystemUtils.get("java.io.tmpdir");
    private static final String COMPILER = SystemUtils.get("java.compiler");
    private static final String EXT_DIRS = SystemUtils.get("java.ext.dirs");
    private static final String JAVA_VM_NAME = SystemUtils.get("java.vm.name");
    private static final String JAVA_VM_SPECIFICATION_NAME = SystemUtils.get("java.vm.specification.name");
    private static final String JAVA_VM_VERSION = SystemUtils.get("java.vm.version");
    private static final String JAVA_VM_SPECIFICATION_VERSION = SystemUtils.get("java.vm.specification.version");
    private static final String JAVA_VM_INFO = SystemUtils.get("java.vm.info", false);
    private static final String CLASS_VERSION = SystemUtils.get("java.class.version");
    private static final String CLASS_PATH = SystemUtils.get("java.class.path");
    private static final String OS_NAME = SystemUtils.get("os.name");
    private static final String OS_ARCH = SystemUtils.get("os.arch");
    private static final String OS_VERSION = SystemUtils.get("os.version");
    private static final String FILE_SEPRATOR = SystemUtils.get("file.separator");
    private static final String PATH_SEPRATOR = SystemUtils.get("path.separator");
    private static final String LINE_SEPRATOR = SystemUtils.get("line.separator");
    private static final String USER_NAME = SystemUtils.get("user.name");
    private static final String USER_HOME = SystemUtils.get("user.home");
    private static final String USER_DIR = SystemUtils.get("user.dir");
    private static String HOST_NAME = null;
    private static String HOST_ADDRESS = null;

    public static String getHostName() {
        if (HOST_NAME == null) {
            String hostName;
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                hostName = localhost.getHostName();
            }
            catch (UnknownHostException e) {
                hostName = "localhost";
            }
            HOST_NAME = hostName;
        }
        return HOST_NAME;
    }

    public static String getHostAddress() {
        if (HOST_ADDRESS == null) {
            String hostAddress;
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                hostAddress = localhost.getHostAddress();
            }
            catch (UnknownHostException e) {
                hostAddress = "127.0.0.1";
            }
            HOST_ADDRESS = hostAddress;
        }
        return HOST_ADDRESS;
    }

    public static String get(String name, boolean quiet) {
        try {
            return System.getProperty(name);
        }
        catch (SecurityException e) {
            if (!quiet) {
                logger.error("Caught a SecurityException reading the system property '" + name + "'; the SystemUtil property value will default to null.");
            }
            return null;
        }
    }

    public static String get(String name) {
        return SystemUtils.get(name, true);
    }

    public static boolean isWindow() {
        return SystemUtils.get(OS_NAME).toLowerCase().startsWith("win");
    }

    public static boolean isLinux() {
        return SystemUtils.get(OS_NAME).toLowerCase().startsWith("linux");
    }

    public static final String getSpecificationName() {
        return SPECIFICATION_NAME;
    }

    public static final String getVersion() {
        return VERSION;
    }

    public static final String getSpecificationVersion() {
        return SPECIFICATION_VERSION;
    }

    public static final String getJavaHome() {
        return HOME;
    }

    public static final String getLibraryPath() {
        return LIBRARY_PATH;
    }

    public static final String getTmpdir() {
        return TMPDIR;
    }

    public static final String getCompiler() {
        return COMPILER;
    }

    public static final String getExtDirs() {
        return EXT_DIRS;
    }

    public static final String getJavaVmName() {
        return JAVA_VM_NAME;
    }

    public static final String getJavaVmSpecificationName() {
        return JAVA_VM_SPECIFICATION_NAME;
    }

    public static final String getJavaVmVersion() {
        return JAVA_VM_VERSION;
    }

    public static final String getJavaVmSpecificationVersion() {
        return JAVA_VM_SPECIFICATION_VERSION;
    }

    public static final String getClassVersion() {
        return CLASS_VERSION;
    }

    public static final String getClassPath() {
        return CLASS_PATH;
    }

    public static final String getOsName() {
        return OS_NAME;
    }

    public static final String getOsArch() {
        return OS_ARCH;
    }

    public static final String getOsVersion() {
        return OS_VERSION;
    }

    public static final String getFileSeprator() {
        return FILE_SEPRATOR;
    }

    public static final String getPathSeprator() {
        return PATH_SEPRATOR;
    }

    public static final String getLineSeprator() {
        return LINE_SEPRATOR;
    }

    public static final String getUserName() {
        return USER_NAME;
    }

    public static final String getUserHome() {
        return USER_HOME;
    }

    public static final String getUserDir() {
        return USER_DIR;
    }

    public static final String getJavaVmInfo() {
        return JAVA_VM_INFO;
    }

    public static final String getSystemInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("java.specification.name").append("=").append(SystemUtils.getSpecificationName()).append("\r\n");
        sb.append("java.version").append("=").append(SystemUtils.getVersion()).append("\r\n");
        sb.append("java.specification.version").append("=").append(SystemUtils.getSpecificationVersion()).append("\r\n");
        sb.append("java.home").append("=").append(SystemUtils.getJavaHome()).append("\r\n");
        sb.append("java.library.path").append("=").append(SystemUtils.getLibraryPath()).append("\r\n");
        sb.append("java.io.tmpdir").append("=").append(SystemUtils.getTmpdir()).append("\r\n");
        sb.append("java.compiler").append("=").append(SystemUtils.getCompiler()).append("\r\n");
        sb.append("java.ext.dirs").append("=").append(SystemUtils.getExtDirs()).append("\r\n");
        sb.append("java.vm.name").append("=").append(SystemUtils.getJavaVmName()).append("\r\n");
        sb.append("java.vm.specification.name").append("=").append(SystemUtils.getJavaVmSpecificationName()).append("\r\n");
        sb.append("java.vm.version").append("=").append(SystemUtils.getVersion()).append("\r\n");
        sb.append("java.vm.info").append("=").append(SystemUtils.getJavaVmInfo()).append("\r\n");
        sb.append("java.vm.specification.version").append("=").append(SystemUtils.getJavaVmSpecificationVersion()).append("\r\n");
        sb.append("java.class.version").append("=").append(SystemUtils.getClassVersion()).append("\r\n");
        sb.append("java.class.path").append("=").append(SystemUtils.getClassPath()).append("\r\n");
        sb.append("os.name").append("=").append(SystemUtils.getOsName()).append("\r\n");
        sb.append("os.arch").append("=").append(SystemUtils.getOsArch()).append("\r\n");
        sb.append("os.version").append("=").append(SystemUtils.getOsVersion()).append("\r\n");
        sb.append("file.separator").append("=").append(SystemUtils.getFileSeprator()).append("\r\n");
        sb.append("path.separator").append("=").append(SystemUtils.getPathSeprator()).append("\r\n");
        sb.append("user.name").append("=").append(SystemUtils.getUserName()).append("\r\n");
        sb.append("user.home").append("=").append(SystemUtils.getUserHome()).append("\r\n");
        sb.append("user.dir").append("=").append(SystemUtils.getUserDir());
        return sb.toString();
    }

    public static void main(String[] args) {
        logger.info(SystemUtils.getHostName());
        logger.info(SystemUtils.getSystemInfo());
    }
}

