/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.utils.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class ObjectUtils {
    public static void transfer(OutputStream optstream, Object obj) throws IOException {
        ObjectOutputStream oout = new ObjectOutputStream(optstream);
        oout.writeObject(obj);
        oout.flush();
        oout.close();
    }

    public static <T> String objectToFile(T t, String filePath) throws IOException {
        FileOutputStream out = new FileOutputStream(new File(filePath));
        ObjectUtils.transfer(out, t);
        return filePath;
    }

    public static <T> T fileToObject(T t, String filPath) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream oin = new ObjectInputStream(new FileInputStream(filPath));
        t = oin.readObject();
        oin.close();
        return t;
    }

    public static String getJarDir(String url) {
        if (url != null && url.startsWith("file")) {
            url = url.substring(6);
            url = url.substring(0, url.indexOf("!"));
            File jar = new File(url);
            url = jar.getParentFile().getPath();
        } else {
            url = url.substring(0, url.lastIndexOf("/"));
        }
        return url;
    }

    public static String getBaseDir() {
        String url = ObjectUtils.class.getResource("/log4j.properties").getPath();
        url = CommonUtils.stringUncode(url);
        if ((url = ObjectUtils.getJarDir(url)).startsWith("/") && url.indexOf(":") != -1) {
            url = url.substring(1);
        }
        url = url.replaceAll("\\\\", "/");
        return url;
    }
}

