/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.other.LogHelper;
import com.yinsin.utils.FileUtils;
import com.yinsin.utils.ObjectUtils;
import com.yinsin.utils.SystemUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class IniUtils {
    private static LogHelper logger = LogHelper.getLogger(IniUtils.class);
    public static HashMap<String, HashMap<String, HashMap<String, String>>> sections = new HashMap();
    private String currentSecion;
    private String currTag;
    private HashMap<String, HashMap<String, String>> current;
    private HashMap<String, String> cfgMap;
    private static String file = "/cfg.ini";
    private static boolean isinited = false;
    static String baseDir = "/";

    private IniUtils() {
    }

    public static final IniUtils getInstance() {
        return IniUtilsHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String fileName) {
        try {
            Class<IniUtils> clazz = IniUtils.class;
            synchronized (IniUtils.class) {
                if (!isinited) {
                    if (SystemUtils.isWindow()) {
                        if (fileName.indexOf(":") != -1) {
                            file = fileName;
                        } else {
                            baseDir = ObjectUtils.getBaseDir();
                            file = baseDir + fileName;
                        }
                    } else if (SystemUtils.isLinux()) {
                        file = fileName;
                    }
                    FileUtils.createDir(baseDir);
                    FileUtils.createFile(file);
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    this.read(reader);
                    reader.close();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25", e);
        }
        {
            return;
        }
    }

    private void read(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            this.parseLine(line);
        }
    }

    private void parseLine(String line) {
        if ((line = line.trim()).matches("\\[.*\\]")) {
            this.currentSecion = line.replaceFirst("\\[(.*)\\]", "$1");
            this.current = new HashMap();
            sections.put(this.currentSecion, this.current);
            this.cfgMap = new HashMap();
        } else if (line.matches("<.*>")) {
            this.currTag = line.replaceFirst("<(.*)>", "$1");
            this.cfgMap = new HashMap();
            this.current.put(this.currTag, this.cfgMap);
        } else if (line.matches(".*=.*") && this.cfgMap != null) {
            int i = line.indexOf(61);
            String name = line.substring(0, i);
            String value = line.substring(i + 1);
            this.cfgMap.put(name, value);
        }
    }

    public HashMap<String, HashMap<String, String>> getConfig(String section) {
        HashMap<String, HashMap<String, String>> p = sections.get(section);
        if (p == null) {
            return null;
        }
        return p;
    }

    public HashMap<String, String> getConfig(String section, String tag) {
        HashMap<String, HashMap<String, String>> p = sections.get(section);
        if (p == null) {
            return null;
        }
        HashMap<String, String> valMap = p.get(tag);
        if (valMap == null) {
            return null;
        }
        return valMap;
    }

    public String getValue(String section, String tag, String name) {
        HashMap<String, String> valMap = this.getConfig(section, tag);
        if (valMap == null) {
            return null;
        }
        return valMap.get(name);
    }

    public IniUtils putValue(String section, String tag, String name, String value) {
        HashMap<String, HashMap<String, String>> map = sections.get(section);
        HashMap<String, String> cfg = null;
        if (map == null) {
            map = new HashMap();
            sections.put(section, map);
            cfg = new HashMap();
            map.put(tag, cfg);
        } else {
            cfg = map.get(tag);
            if (cfg == null) {
                cfg = new HashMap();
                map.put(tag, cfg);
            }
        }
        cfg.put(name, value);
        return this;
    }

    public HashMap<String, String> getActiveCfg(String section) {
        HashMap<String, HashMap<String, String>> map = sections.get(section);
        HashMap<String, String> result = null;
        HashMap<String, String> temp = null;
        if (map != null) {
            String isSelected = "";
            for (Map.Entry<String, HashMap<String, String>> ent : map.entrySet()) {
                temp = ent.getValue();
                isSelected = temp.get("isSelected");
                if (isSelected == null || !isSelected.equals("true")) continue;
                result = temp;
                break;
            }
        }
        return result;
    }

    public HashMap<String, String> replaceActiveCfg(String section, String tag) {
        HashMap<String, HashMap<String, String>> map = sections.get(section);
        HashMap<String, String> result = null;
        if (map != null) {
            result = map.get(tag);
            String key = "";
            for (Map.Entry<String, HashMap<String, String>> ent : map.entrySet()) {
                key = ent.getKey();
                if (key.equals(tag)) {
                    this.putValue(section, key, "isSelected", "true");
                    continue;
                }
                this.putValue(section, key, "isSelected", "false");
            }
        }
        return result;
    }

    public IniUtils save() {
        try {
            StringBuffer sb = new StringBuffer();
            HashMap<String, HashMap<String, String>> currMap = null;
            HashMap<String, String> cfgMap = null;
            for (Map.Entry<String, HashMap<String, HashMap<String, String>>> entry : sections.entrySet()) {
                sb.append("[").append(entry.getKey()).append("]\r\n");
                currMap = entry.getValue();
                if (currMap != null && currMap.entrySet().size() > 0) {
                    for (Map.Entry<String, HashMap<String, String>> ent : currMap.entrySet()) {
                        sb.append("<").append(ent.getKey()).append(">\r\n");
                        cfgMap = ent.getValue();
                        for (Map.Entry<String, String> e : cfgMap.entrySet()) {
                            sb.append(e.getKey() + "=").append(e.getValue() + "\r\n");
                        }
                    }
                }
                sb.append("\r\n");
            }
            FileOutputStream fos = new FileOutputStream(file);
            ((OutputStream)fos).write(sb.toString().getBytes());
            fos.flush();
            ((OutputStream)fos).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public static void main(String[] args) {
        IniUtils reader = IniUtils.getInstance();
        reader.init("/cfg.ini");
        System.out.println(sections);
    }

    private static class IniUtilsHolder {
        private static final IniUtils INSTANCE = new IniUtils();

        private IniUtilsHolder() {
        }
    }
}

