/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.other.LogHelper;
import com.yinsin.security.Base64;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class ImageUtils {
    protected static final LogHelper log = LogHelper.getLogger(ImageUtils.class);

    public static int[][] getImageRGB(BufferedImage bfImage) {
        int width = bfImage.getWidth();
        int height = bfImage.getHeight();
        int[][] result = new int[height][width];
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; ++w) {
                result[h][w] = bfImage.getRGB(w, h) & 0xFFFFFF;
            }
        }
        return result;
    }

    public static void cutImage(String src, String dest, int x, int y, int w, int h) throws IOException {
        BufferedImage image = ImageUtils.cutImage(ImageUtils.getBfImageFromPath(src), x, y, w, h);
        ImageUtils.writeImage(image, dest);
    }

    public static BufferedImage cutImage(String src, int x, int y, int w, int h) throws IOException {
        return ImageUtils.cutImage(ImageUtils.getBfImageFromPath(src), x, y, w, h);
    }

    public static BufferedImage cutImage(BufferedImage image, int x, int y, int w, int h) {
        if (x >= 0 && x + w <= image.getWidth() && y >= 0 && y + h <= image.getHeight()) {
            return image.getSubimage(x, y, w, h);
        }
        return image;
    }

    public static BufferedImage rotateImage(BufferedImage bufferedimage, double degree) {
        int w = bufferedimage.getWidth();
        int h = bufferedimage.getHeight();
        int type = bufferedimage.getColorModel().getTransparency();
        BufferedImage img = new BufferedImage(w, h, type);
        Graphics2D graphics2d = img.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.rotate(degree, w / 2, h / 2);
        graphics2d.drawImage((Image)bufferedimage, 0, 0, null);
        graphics2d.dispose();
        return img;
    }

    public BufferedImage getFullScreenShot(String savePath) throws AWTException {
        BufferedImage bfImage = null;
        int width = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int height = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        Robot robot = new Robot();
        bfImage = robot.createScreenCapture(new Rectangle(0, 0, width, height));
        if (savePath != null) {
            ImageUtils.writeImage(bfImage, savePath);
        }
        return bfImage;
    }

    public static BufferedImage getBfImageFromPath(String imagePath) throws IOException {
        BufferedImage bfImage = ImageIO.read(new File(imagePath));
        return bfImage;
    }

    public static BufferedImage imageLighten(BufferedImage img, int lightenValue) {
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                int rgb = img.getRGB(x, y);
                Color color = new Color(rgb);
                int r = color.getRed() + lightenValue;
                int g = color.getGreen() + lightenValue;
                int b = color.getBlue() + lightenValue;
                if (r > 255) {
                    r = 255;
                } else if (r < 0) {
                    r = 0;
                }
                if (g > 255) {
                    g = 255;
                } else if (g < 0) {
                    g = 0;
                }
                if (b > 255) {
                    b = 255;
                } else if (b < 0) {
                    b = 0;
                }
                color = new Color(r, g, b);
                img.setRGB(x, y, color.getRGB());
            }
        }
        return img;
    }

    public static int[][] getImageRGBGray(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] resRgb = new int[width][height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int gray;
                int pixel = image.getRGB(i, j);
                int r = (pixel & 0xFF0000) >> 16;
                int g = (pixel & 0xFF00) >> 8;
                int b = pixel & 0xFF;
                resRgb[i][j] = gray = (int)((double)r * 0.3 + (double)g * 0.59 + (double)b * 0.11);
            }
        }
        return resRgb;
    }

    public static List<Integer> getImageARGB(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                list.add(image.getRGB(i, j));
            }
        }
        return list;
    }

    public static void writeImage(BufferedImage image, String path) {
        try {
            ImageIO.write((RenderedImage)image, "jpg", new File(path));
        }
        catch (IOException e) {
            log.error("\u5199\u5165\u56fe\u7247\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public static void waterMark(String imgPath, String markPath, int x, int y, float alpha) throws IOException {
        File imgFile = new File(imgPath);
        BufferedImage img = ImageIO.read(imgFile);
        String parent = imgFile.getParentFile().getPath() + "\\";
        String name = imgFile.getName();
        int index = name.lastIndexOf(".");
        String bakName = name.substring(0, index) + "_new" + name.substring(index);
        BufferedImage image = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 1);
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        BufferedImage src_biao = ImageIO.read(new File(markPath));
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        g.drawImage((Image)src_biao, x, y, null);
        g.dispose();
        ImageUtils.writeImage(image, parent + bakName);
    }

    public static void textMark(String imgPath, String text, Font font, Color color, int x, int y, float alpha) throws IOException {
        Font Dfont = font == null ? new Font("\u5b8b\u4f53", 20, 13) : font;
        File imgFile = new File(imgPath);
        BufferedImage img = ImageIO.read(imgFile);
        String parent = imgFile.getParentFile().getPath() + "\\";
        String name = imgFile.getName();
        int index = name.lastIndexOf(".");
        String bakName = name.substring(0, index) + "_new" + name.substring(index);
        BufferedImage image = new BufferedImage(((Image)img).getWidth(null), ((Image)img).getHeight(null), 1);
        Graphics2D g = image.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.setColor(color);
        g.setFont(Dfont);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        g.drawString(text, x, y);
        g.dispose();
        ImageUtils.writeImage(image, parent + bakName);
    }

    public static String getImageBase64(String path) {
        return ImageUtils.getImageBase64(new File(path));
    }

    public static String getImageBase64(File file) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(file);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Base64.encodeToString(data);
    }

    public static void main(String[] args) {
        try {
            System.out.println(ImageUtils.getImageBase64("d:/sss/qrcode.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

