/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.other.LogHelper;
import com.yinsin.utils.CommonUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;

public class FileUtils {
    private static final LogHelper logger = LogHelper.getLogger(FileUtils.class);

    public static boolean createDir(String dirPath) {
        File file;
        boolean fileExists = false;
        if (null != dirPath && "".equals(dirPath.trim()) && !(fileExists = (file = new File(dirPath)).exists())) {
            fileExists = file.mkdirs();
        }
        return fileExists;
    }

    public static boolean createDir(String dirPath, boolean override) {
        File file;
        boolean fileExists = false;
        if (null != dirPath && "".equals(dirPath.trim()) && (!(fileExists = (file = new File(dirPath)).exists()) || override)) {
            fileExists = file.mkdirs();
        }
        return fileExists;
    }

    public static boolean createFile(String filepath) throws IOException {
        File file;
        boolean fileExists = false;
        if (CommonUtils.isNotBlank(filepath) && !(fileExists = (file = new File(filepath)).exists())) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fileExists = file.createNewFile();
        }
        return fileExists;
    }

    public static String getFileSuffix(String fileName) {
        String prefix = null;
        if (null != fileName && "".equals(fileName.trim()) && fileName.lastIndexOf(".") != -1) {
            prefix = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        }
        return CommonUtils.isBlank(prefix) ? "" : prefix.toLowerCase();
    }

    public static String getFilePointSuffix(String fileName) {
        String prefix = null;
        if (null != fileName && "".equals(fileName.trim()) && fileName.lastIndexOf(".") != -1) {
            prefix = fileName.substring(fileName.lastIndexOf("."), fileName.length());
        }
        return CommonUtils.isBlank(prefix) ? "" : prefix.toLowerCase();
    }

    public static String readFileAsString(File file) throws IOException {
        StringBuffer sb;
        FileInputStream fis;
        String result = null;
        if (file.exists()) {
            fis = new FileInputStream(file);
            byte[] byt = new byte[1024];
            int index = -1;
            sb = new StringBuffer();
            while ((index = fis.read(byt)) != -1) {
                sb.append(new String(byt, 0, index));
            }
        } else {
            throw new FileNotFoundException("Not Find File\uff1a" + file.getAbsolutePath());
        }
        fis.close();
        result = sb.toString();
        return result;
    }

    public static byte[] readFileAsByte(File file) throws IOException {
        ByteArrayOutputStream baos;
        FileInputStream fis;
        byte[] byts = null;
        if (file.exists()) {
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] byt = new byte[1024];
            while (fis.read(byt) != -1) {
                baos.write(byt);
            }
        } else {
            throw new FileNotFoundException("Not Find File\uff1a" + file.getAbsolutePath());
        }
        fis.close();
        byts = baos.toByteArray();
        return byts;
    }

    public static void writeFileAsCover(String filePath, String content, String charset) throws FileNotFoundException {
        File file = new File(filePath);
        if (file.exists()) {
            FileOutputStream fos = new FileOutputStream(file);
            try {
                fos.write(content.getBytes(charset));
                fos.flush();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new FileNotFoundException("Not Find File\uff1a" + file.getAbsolutePath());
        }
    }

    public static void copyDirThread(String source, String target) {
        new FileThread(source, target, FILE_TYPE.DIR).start();
    }

    public static void copyFileThread(String source, String target) {
        new FileThread(source, target, FILE_TYPE.FILE).start();
    }

    public static void deleteFileThread(String filePath) {
        new DeleteFileThread(filePath).start();
    }

    public static void copyDir(String source, String target) {
        if (source != null && target != null && !target.equalsIgnoreCase(source)) {
            File[] files;
            File sourceFiles = new File(source);
            File targetFiles = new File(target);
            if (!targetFiles.exists()) {
                targetFiles.mkdirs();
            }
            File tarFile = null;
            for (File file : files = sourceFiles.listFiles()) {
                if (file.isFile()) {
                    tarFile = new File(targetFiles.getAbsolutePath() + File.separator + file.getName());
                    FileUtils.copyFile(file, tarFile);
                    continue;
                }
                FileUtils.copyDir(sourceFiles.getAbsolutePath() + File.separator + file.getName(), targetFiles.getAbsolutePath() + File.separator + file.getName());
            }
        }
    }

    public static void copyFile(File source, File target) {
        if (!target.isFile() && !target.exists()) {
            try {
                byte[] by = new byte[1024];
                FileInputStream in = new FileInputStream(source);
                FileOutputStream out = new FileOutputStream(target);
                while (in.read(by) > 0) {
                    out.write(by);
                }
                in.close();
                out.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getParentDir(String dirPath) {
        String parentDir = null;
        if (CommonUtils.isNotBlank(dirPath)) {
            if (dirPath.endsWith("/")) {
                dirPath = dirPath.substring(0, dirPath.length() - 1);
            }
            if (dirPath.lastIndexOf("/") != -1) {
                parentDir = dirPath.substring(0, dirPath.lastIndexOf("/"));
            }
        }
        return parentDir;
    }

    public static String getFileSize(long size) {
        float fa = size;
        String kb = "0 Kb";
        kb = size < 0x100000L ? CommonUtils.round(fa / 1024.0f) + " Kb" : (size >= 0x100000L && size < 0x40000000L ? CommonUtils.round(fa / 1048576.0f) + " Mb" : CommonUtils.round(fa / 1.0737418E9f) + " Gb");
        return kb;
    }

    public static String getFileNameToPath(String filePath) {
        String fileName = "";
        if (null != filePath) {
            int index = filePath.lastIndexOf("/");
            if (index != -1) {
                fileName = filePath.substring(index);
            } else {
                index = filePath.lastIndexOf("\\");
                if (index != -1) {
                    fileName = filePath.substring(index + 1);
                } else {
                    index = filePath.lastIndexOf("\\\\");
                    if (index != -1) {
                        fileName = filePath.substring(index + 2);
                    }
                }
            }
        }
        return fileName;
    }

    public static String getFileDirName(String fileName) {
        String fix;
        String dirs = "other";
        if (null != fileName && null != (fix = FileUtils.getFileSuffix(fileName)) && !"".trim().equals(fix)) {
            dirs = fix.toLowerCase().equals(".mp3") ? "media" : (fix.toLowerCase().equals(".wma") ? "media" : (fix.toLowerCase().equals(".wmv") ? "media" : (fix.toLowerCase().equals(".avi") ? "media" : (fix.toLowerCase().equals(".flv") ? "media" : (fix.toLowerCase().equals(".swf") ? "media" : (fix.toLowerCase().equals(".rmvb") ? "media" : (fix.toLowerCase().equals(".jpg") ? "image" : (fix.toLowerCase().equals(".gif") ? "image" : (fix.toLowerCase().equals(".png") ? "image" : (fix.toLowerCase().equals(".bmp") ? "image" : (fix.toLowerCase().equals(".ico") ? "image" : (fix.toLowerCase().equals(".txt") ? "text" : (fix.toLowerCase().equals(".html") ? "text" : (fix.toLowerCase().equals(".htm") ? "text" : (fix.toLowerCase().equals(".jsp") ? "text" : (fix.toLowerCase().equals(".asp") ? "text" : (fix.toLowerCase().equals(".xml") ? "text" : (fix.toLowerCase().equals(".rar") ? "application" : (fix.toLowerCase().equals(".zip") ? "application" : (fix.toLowerCase().equals(".exe") ? "application" : (fix.toLowerCase().equals(".iso") ? "application" : (fix.toLowerCase().equals(".7z") ? "application" : "archive"))))))))))))))))))))));
        }
        return dirs;
    }

    public static String addFileNameSuffix(String fileName, String fix) {
        if (fileName != null && fileName.indexOf(".") != -1) {
            int index = fileName.lastIndexOf(".");
            fileName = fileName.substring(0, index) + fix + fileName.substring(index);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMd5ByFile(File file) {
        String value = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            MappedByteBuffer byteBuffer = in.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(byteBuffer);
            BigInteger bi = new BigInteger(1, md5.digest());
            value = bi.toString(16);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6587\u4ef6MD5\u7801\u5f02\u5e38\uff1a" + e.getMessage());
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        File file = new File("D:\\application\\\u5f00\u53d1\u76f8\u5173\\QIYImedia_0_27.exe");
        String md5 = FileUtils.getMd5ByFile(file);
        long end = System.currentTimeMillis();
        System.out.println(file.getTotalSpace() + ", " + md5 + "\uff0c \u8017\u65f6\uff1a" + (end - start));
    }

    private static class DeleteFileThread
    extends Thread {
        private String filePath;
        private File file;
        private int time = 0;

        public DeleteFileThread(String filePath) {
            this.filePath = filePath;
            this.file = new File(filePath);
        }

        @Override
        public void run() {
            try {
                while (this.time < 3) {
                    Thread.sleep(1000L);
                    ++this.time;
                }
                if (this.file != null && this.file.exists()) {
                    logger.info("\u88ab\u5220\u9664\u6587\u4ef6\uff1a" + this.file.getName());
                    logger.info("\t\u8def\u5f84\uff1a" + this.filePath);
                    this.file.delete();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private static class FileThread
    extends Thread {
        private String source;
        private String target;
        private FILE_TYPE type = FILE_TYPE.FILE;

        public FileThread(String source, String target, FILE_TYPE type) {
            this.source = source;
            this.target = target;
            this.type = type;
        }

        @Override
        public void run() {
            if (this.type == FILE_TYPE.DIR) {
                FileUtils.copyDir(this.source, this.target);
            } else if (this.type == FILE_TYPE.FILE) {
                FileUtils.copyFile(new File(this.source), new File(this.target));
            }
        }
    }

    public static enum FILE_TYPE {
        FILE,
        DIR;

    }
}

