/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.utils.CommonUtils;

public class DbUtils {
    public static String tableToEntity(String table) {
        return DbUtils.tableToEntity(table, "_");
    }

    public static String tableToEntity(String table, String split) {
        String entity = "";
        if (table != null && table.length() > 1) {
            if (table.indexOf(split) != -1) {
                String[] strs = table.split(split);
                for (int i = 0; i < strs.length; ++i) {
                    if (strs[i] == null || strs[i].length() <= 0) continue;
                    entity = entity + CommonUtils.firstCharToUpperCase(strs[i]);
                }
            } else {
                entity = CommonUtils.firstCharToUpperCase(table);
            }
            if (entity.matches("[A-Z]+")) {
                entity = CommonUtils.firstCharToUpperCase(entity.toLowerCase());
            }
        }
        return entity;
    }

    public static String entityToTable(String entity) {
        return DbUtils.entityToTable(entity, "_");
    }

    public static String entityToTable(String entity, String split) {
        String table = null;
        if (entity != null && entity.length() > 1) {
            table = entity.replaceAll("[A-Z]", split + "$0").toLowerCase();
        }
        return table;
    }

    public static String feildToColumn(String feild) {
        return DbUtils.entityToTable(feild);
    }

    public static String columnToFeild(String column) {
        return CommonUtils.firstCharToLowerCase(DbUtils.tableToEntity(column));
    }

    public static String getJavaType(String jdbcType) {
        String javaType = "Object";
        if (jdbcType.equalsIgnoreCase("varchar") || jdbcType.equalsIgnoreCase("char")) {
            javaType = "String";
        } else if (jdbcType.equalsIgnoreCase("int") || jdbcType.equalsIgnoreCase("integer")) {
            javaType = "Integer";
        } else if (jdbcType.equalsIgnoreCase("long") || jdbcType.equalsIgnoreCase("bigint")) {
            javaType = "Long";
        } else if (jdbcType.equalsIgnoreCase("float") || jdbcType.equalsIgnoreCase("number")) {
            javaType = "Float";
        } else if (jdbcType.equalsIgnoreCase("double") || jdbcType.equalsIgnoreCase("decimal")) {
            javaType = "Double";
        } else if (jdbcType.equalsIgnoreCase("date")) {
            javaType = "Date";
        } else if (jdbcType.equalsIgnoreCase("timestamp") || jdbcType.equalsIgnoreCase("time")) {
            javaType = "Timestamp";
        } else if (jdbcType.equalsIgnoreCase("blob")) {
            javaType = "byte[]";
        }
        return javaType;
    }

    public static String getJdbcType(String javaType) {
        String jdbcType = "Object";
        if (javaType.equalsIgnoreCase("String")) {
            jdbcType = "varchar";
        } else if (javaType.equalsIgnoreCase("int") || javaType.equalsIgnoreCase("integer")) {
            jdbcType = "int";
        } else if (javaType.equalsIgnoreCase("long")) {
            jdbcType = "bigint";
        } else if (javaType.equalsIgnoreCase("float")) {
            jdbcType = "number";
        } else if (javaType.equalsIgnoreCase("double")) {
            jdbcType = "decimal";
        } else if (javaType.equalsIgnoreCase("date")) {
            jdbcType = "date";
        } else if (javaType.equalsIgnoreCase("timestamp") || javaType.equalsIgnoreCase("time")) {
            jdbcType = "timestamp";
        } else if (javaType.equalsIgnoreCase("Lbyte")) {
            jdbcType = "blob";
        }
        return jdbcType;
    }
}

