/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.other.LogHelper;
import com.yinsin.utils.CommonUtils;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    protected static final LogHelper log = LogHelper.getLogger(DateUtils.class);
    public static final SimpleDateFormat SDF_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat SDF_DATE = new SimpleDateFormat("yyyy-MM-dd");

    public static Date parse(String dateStr) {
        return DateUtils.parse(dateStr, null);
    }

    public static Date parse(String dateStr, String pattern) {
        Date date;
        block6: {
            date = null;
            if (null != dateStr) {
                try {
                    if (dateStr.length() < 12) {
                        dateStr = dateStr + " 00:00:00";
                    }
                    if (pattern != null) {
                        SimpleDateFormat sim = new SimpleDateFormat(pattern);
                        date = sim.parse(dateStr);
                        break block6;
                    }
                    date = SDF_DATETIME.parse(dateStr);
                }
                catch (ParseException e) {
                    log.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5931\u8d25\uff01", e);
                }
            } else {
                log.error("\u5b57\u7b26\u4e32\u4e3a\u7a7a\uff1adateStr=" + dateStr);
            }
        }
        return date;
    }

    public static String format(Date date) {
        return DateUtils.format(date, null);
    }

    public static String format(Date date, String pattern) {
        String dateStr;
        block5: {
            dateStr = null;
            if (date != null) {
                try {
                    if (pattern != null) {
                        SimpleDateFormat sim = new SimpleDateFormat(pattern);
                        dateStr = sim.format(date);
                        break block5;
                    }
                    dateStr = SDF_DATETIME.format(date);
                }
                catch (Exception e) {
                    log.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u5931\u8d25\uff01", e);
                }
            } else {
                log.error("Date\u53c2\u6570\u4e3a\u7a7a\uff1adate=" + date);
            }
        }
        return dateStr;
    }

    public static Timestamp parseToTimestamp(String dateStr, String pattern) {
        Timestamp tmp = null;
        if (CommonUtils.isEmpty(dateStr) || CommonUtils.isEmpty(pattern)) {
            throw new IllegalArgumentException("The parameter is null.");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            tmp = new Timestamp(sdf.parse(dateStr).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return tmp;
    }

    public static Timestamp parseToTimestamp(String dateStr) {
        return DateUtils.parseToTimestamp(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static int getAgeByDate(Date birthDate) {
        Date day = new Date();
        Calendar curr = Calendar.getInstance();
        curr.setTime(day);
        Calendar bir = Calendar.getInstance();
        bir.setTime(birthDate);
        int ageYear = bir.get(1);
        int currYear = curr.get(1);
        int age = currYear - ageYear;
        bir.add(1, age);
        age = bir.getTime().getTime() - day.getTime() > 0L ? age - 1 : age;
        return age;
    }

    public static int getWeekByDate() {
        return DateUtils.getWeekByDate(new Date());
    }

    public static int getWeekByDate(Date date) {
        SimpleDateFormat sim = new SimpleDateFormat("w");
        String wk = sim.format(date);
        return CommonUtils.stringToInt(wk, -1);
    }

    public static int getAgeByDateStr(String birthDateStr) {
        Date birthDate = DateUtils.parse(birthDateStr, "yyyy-MM-dd");
        return DateUtils.getAgeByDate(birthDate);
    }

    public static Date getBeforeOrAfterDateByDayNumber(int dayNumber) {
        return DateUtils.getBeforeOrAfterDateByDayNumber(new Date(), dayNumber);
    }

    public static Date getBeforeOrAfterDateByDayNumber(Date date, int dayNumber) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, dayNumber);
        return c.getTime();
    }

    public static Date getBeforeOrAfterDateByMonthNumber(int monthNumber) {
        return DateUtils.getBeforeOrAfterDateByMonthNumber(new Date(), monthNumber);
    }

    public static Date getBeforeOrAfterDateByMonthNumber(Date date, int monthNumber) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, monthNumber);
        return c.getTime();
    }

    public static boolean compareDateOrTime(Date date, int genre) {
        return DateUtils.compareDateOrTime(date, new Date(), genre);
    }

    public static boolean compareDateOrTime(Date date1, Date date2, int genre) {
        boolean bool = false;
        long times1 = date1.getTime();
        long times2 = date2.getTime();
        if (genre == 1) {
            bool = times1 < times2;
        } else if (genre == 2) {
            bool = times1 > times2;
        } else if (genre == 3) {
            bool = times1 <= times2;
        } else if (genre == 4) {
            bool = times1 >= times2;
        } else if (genre == 5) {
            bool = times1 == times2;
        }
        return bool;
    }

    public static boolean compareDateOrTime(String date, int genre) {
        Date day = new Date();
        if (date != null && date.length() < 12) {
            day = DateUtils.parse(SDF_DATE.format(day));
        }
        return DateUtils.compareDateOrTime(DateUtils.parse(date), day, genre);
    }

    public static boolean compareDateOrTime(String date1, String date2, int genre) {
        return DateUtils.compareDateOrTime(DateUtils.parse(date1), DateUtils.parse(date2), genre);
    }

    public static String getLastMonDay() {
        Date today = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(today);
        int maxDay = cal.getActualMaximum(5);
        cal.set(5, maxDay);
        return DateUtils.format(cal.getTime(), "yyyy-MM-dd");
    }

    public static String getFirstOfWeek(int year, int week) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(3, week);
        c.set(7, 1);
        c.setFirstDayOfWeek(1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(c.getTime());
    }

    public static String getLastOfWeek(int year, int week) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(3, week);
        c.set(7, 1);
        c.setFirstDayOfWeek(1);
        c.set(7, c.getFirstDayOfWeek() + 6);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(c.getTime());
    }

    public static long getCurrentUnixTime() {
        return DateUtils.getUnixTimeLong(new Date());
    }

    public static int getUnixTimeByDate(Date date) {
        return (int)(date.getTime() / 1000L);
    }

    public static long getUnixTimeLong(Date date) {
        return date.getTime() / 1000L;
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.parse("dwqdq55"));
    }
}

