/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.utils.Constants;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;

public final class CommonUtils {
    private CommonUtils() {
    }

    public static boolean isDigit(char sch) {
        int temp = sch & 0xFF;
        return temp >= 45 && temp <= 57;
    }

    public static boolean isDigit(String string) {
        boolean digit = false;
        if (CommonUtils.isNotBlank(string)) {
            digit = Constants.REG_INTEGER.matcher(string).matches();
        }
        return digit;
    }

    public static boolean isLowerCase(char sch) {
        int temp = sch & 0xFF;
        return temp >= 97 && temp <= 122;
    }

    public static boolean isLowerCase(String string) {
        return CommonUtils.isNotBlank(string) ? Constants.REG_IS_LOWCASE.matcher(string).matches() : false;
    }

    public static boolean isUppercase(char sch) {
        int temp = sch & 0xFF;
        return temp >= 65 && temp <= 90;
    }

    public static boolean isUppercases(String string) {
        return CommonUtils.isNotBlank(string) ? Constants.REG_IS_UPPERCASE.matcher(string).matches() : false;
    }

    public static String toHexString(String sourceStr) {
        StringBuffer strBuff = new StringBuffer("");
        if (CommonUtils.isNotBlank(sourceStr)) {
            for (char ch : sourceStr.toCharArray()) {
                strBuff.append(CommonUtils.toHexString(ch));
            }
        }
        return strBuff.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sBuilder = new StringBuilder("");
        if (bytes != null && bytes.length > 0) {
            for (byte byitem : bytes) {
                int tmpv = byitem & 0xFF;
                String thv = Integer.toHexString(tmpv);
                if (thv.length() < 2) {
                    sBuilder.append(0);
                }
                sBuilder.append(thv);
            }
        }
        return sBuilder.toString();
    }

    private static String toUnsignedString(long nums, int shifts) {
        long tmpNums = nums;
        char[] chs = new char[64];
        int charPosition = 64;
        int radix = 1 << shifts;
        int value = radix - 1;
        do {
            chs[--charPosition] = Constants.CHAR_ARRAY[(int)(tmpNums & (long)value)];
        } while (0L < (tmpNums >>>= shifts));
        return new String(chs, charPosition, 64 - charPosition);
    }

    public static String toHexString(int nums) {
        return CommonUtils.toUnsignedString(nums, 4);
    }

    public static String toHexString(long nums) {
        return CommonUtils.toUnsignedString(nums, 4);
    }

    public static String toOctalString(int nums) {
        return CommonUtils.toUnsignedString(nums, 3);
    }

    public static String toOctalString(long nums) {
        return CommonUtils.toUnsignedString(nums, 3);
    }

    public static String toBinaryString(int nums) {
        return CommonUtils.toUnsignedString(nums, 1);
    }

    public static String toBinaryString(long nums) {
        return CommonUtils.toUnsignedString(nums, 1);
    }

    public static boolean isEmpty(Object object) {
        return null == object;
    }

    public static boolean isNotEmpty(Object object) {
        return !CommonUtils.isEmpty(object);
    }

    public static boolean isBlank(String string) {
        return CommonUtils.isEmpty(string) || "".equals(string.trim());
    }

    public static boolean isNotBlank(String string) {
        return CommonUtils.isNotEmpty(string) && !"".equals(string.trim());
    }

    public static String toUTF8(String string) {
        if (CommonUtils.isBlank(string)) {
            throw new IllegalArgumentException("The param can not be null.");
        }
        try {
            return new String(string.getBytes("utf-8"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return string;
        }
    }

    public static String toGBK(String string) {
        if (CommonUtils.isBlank(string)) {
            throw new IllegalArgumentException("The param can not be null.");
        }
        try {
            return new String(string.getBytes("gbk"), "iso-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return string;
        }
    }

    public static boolean isLegalMobile(String mobile) {
        return CommonUtils.isNotBlank(mobile) ? Constants.REG_MOBILE.matcher(mobile).find() : false;
    }

    public static boolean isLegalMail(String mail) {
        return CommonUtils.isNotBlank(mail) ? Constants.REG_MAIL.matcher(mail.toUpperCase(Locale.getDefault())).find() : false;
    }

    public static String byteArrayStreamToString(ByteArrayOutputStream baos) {
        return CommonUtils.byteArrayStreamToString(baos, "utf-8");
    }

    public static String byteArrayStreamToString(ByteArrayOutputStream baos, String charset) {
        if (null == baos) {
            throw new IllegalArgumentException("The param baos can not be null.");
        }
        try {
            return baos.toString("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String excNullToString(String string) {
        return CommonUtils.excNullToString(string, "");
    }

    public static String excNullToString(String string, String added) {
        if (CommonUtils.isEmpty(string)) {
            string = added;
        }
        return string;
    }

    public static Object excNullToObject(Object obj) {
        return CommonUtils.excNullToObject(obj, new Object());
    }

    public static Object excNullToObject(Object obj, Object added) {
        if (CommonUtils.isEmpty(obj)) {
            obj = added;
        }
        return obj;
    }

    public static String objectToString(Object obj) {
        return CommonUtils.objectToString(obj, null);
    }

    public static String objectToString(Object obj, String added) {
        String result = added;
        if (obj != null) {
            result = String.valueOf(obj);
        }
        return result;
    }

    public static int stringToInt(String string) {
        return CommonUtils.stringToInt(string, 0);
    }

    public static int stringToInt(String string, int added) {
        int result = 0;
        try {
            result = Integer.parseInt(string);
        }
        catch (Exception e) {
            result = added;
        }
        return result;
    }

    public static int objectToInt(Object obj) {
        return CommonUtils.objectToInt(obj, 0);
    }

    public static int objectToInt(Object obj, int added) {
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).intValue();
        }
        if (obj instanceof Double) {
            return ((Double)obj).intValue();
        }
        return CommonUtils.stringToInt(CommonUtils.objectToString(obj), added);
    }

    public static long stringToLong(String string) {
        return CommonUtils.stringToLong(string, 0L);
    }

    public static long stringToLong(String string, long added) {
        long result = 0L;
        try {
            result = Long.parseLong(string);
        }
        catch (Exception e) {
            result = added;
        }
        return result;
    }

    public static long objectToLong(Object obj) {
        return CommonUtils.objectToLong(obj, 0L);
    }

    public static long objectToLong(Object obj, long added) {
        long result = 0L;
        try {
            result = Long.parseLong(obj.toString());
        }
        catch (Exception e) {
            result = added;
        }
        return result;
    }

    public static float stringToFloat(String string) {
        return CommonUtils.stringToFloat(string, 0.0f);
    }

    public static float stringToFloat(String string, float added) {
        float result = 0.0f;
        try {
            result = Float.parseFloat(string);
        }
        catch (Exception e) {
            result = added;
        }
        return result;
    }

    public static float objectToFloat(Object obj) {
        return CommonUtils.objectToFloat(obj, 0.0f);
    }

    public static float objectToFloat(Object obj, float added) {
        float result = 0.0f;
        try {
            result = Float.parseFloat(obj.toString());
        }
        catch (Exception e) {
            result = added;
        }
        return result;
    }

    public static double stringToDouble(String string) {
        return CommonUtils.stringToDouble(string, 0.0);
    }

    public static double stringToDouble(String string, double added) {
        double result = 0.0;
        try {
            result = Double.parseDouble(string);
        }
        catch (Exception e) {
            result = added;
        }
        return result;
    }

    public static double objectToDouble(Object obj) {
        return CommonUtils.objectToDouble(obj, 0.0);
    }

    public static double objectToDouble(Object obj, double added) {
        double result = 0.0;
        try {
            result = Double.parseDouble(obj.toString());
        }
        catch (Exception e) {
            result = added;
        }
        return result;
    }

    public static String firstCharToUpperCase(String content) {
        if (!CommonUtils.isEmpty(content)) {
            String tou = content.substring(0, 1);
            String wei = content.substring(1);
            content = tou.toUpperCase() + wei;
        }
        return content;
    }

    public static String firstCharToLowerCase(String content) {
        if (!CommonUtils.isEmpty(content)) {
            String tou = content.substring(0, 1);
            String wei = content.substring(1);
            content = tou.toLowerCase() + wei;
        }
        return content;
    }

    public static String stringUncode(String param) {
        if (param != null && !param.trim().equals("")) {
            try {
                param = URLDecoder.decode(param, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return param;
    }

    public static String stringEncode(String param) {
        if (param != null && !param.trim().equals("")) {
            try {
                param = URLEncoder.encode(param, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return param;
    }

    public static String format(String resource, String ... target) {
        if (resource == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        if (target != null && target.length > 0) {
            int k = target.length;
            for (int i = 0; i < k; ++i) {
                resource = resource.replace("{" + i + "}", target[i]);
            }
        }
        return resource;
    }

    public static long getTimeUnix() {
        return new Date().getTime();
    }

    public static String filterHtml(String str) {
        Matcher matcher = Constants.REG_HTML.matcher(str);
        StringBuffer sb = new StringBuffer();
        boolean result1 = matcher.find();
        while (result1) {
            matcher.appendReplacement(sb, "");
            result1 = matcher.find();
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static float round(float number) {
        return CommonUtils.round(number, 2);
    }

    public static float round(float number, int len) {
        float result = number;
        String sa = String.valueOf(number);
        String ss = null;
        if (sa.indexOf(".") != -1) {
            int n;
            int numlen;
            int startIndex = sa.indexOf(".");
            int endIndex = startIndex + len + 1;
            if (endIndex > (numlen = sa.length())) {
                endIndex = numlen;
            }
            if (endIndex < numlen && len > 0) {
                ss = sa.substring(endIndex, endIndex + 1);
            }
            sa = sa.substring(0, endIndex);
            result = Float.parseFloat(sa);
            if (ss != null && (n = Integer.parseInt(ss)) >= 5) {
                String xs = "0.";
                for (int i = 0; i < len - 1; ++i) {
                    xs = xs + "0";
                }
                xs = xs + "1";
                float nf = Float.parseFloat(xs);
                result += nf;
            }
        }
        return result;
    }

    public static String getRandomNumber(int size) {
        String num = "";
        for (int i = 0; i < size; ++i) {
            double a = Math.random() * 9.0;
            a = Math.ceil(a);
            int randomNum = new Double(a).intValue();
            num = num + randomNum;
        }
        return num;
    }

    public static String getUUID() {
        String uuid = UUID.randomUUID().toString();
        return uuid.replaceAll("-", "");
    }
}

