/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.utils.CommonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CollectionUtils {
    public static List<Object> pickList(List<Object> list, int startIndex, int count) {
        if (count < 0) {
            new IllegalArgumentException("count value is illegality.");
        }
        List<Object> newList = new ArrayList<Object>();
        if (list != null && count > 0) {
            int toIndex;
            int k = list.size();
            if (startIndex < 0) {
                startIndex = 0;
            }
            toIndex = (toIndex = startIndex + count) > k ? k : toIndex;
            newList = list.subList(startIndex, toIndex);
        }
        return newList;
    }

    public static String listJoinToSql(List<?> list) {
        String result = "";
        if (list != null) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : list) {
                if (obj instanceof Integer || obj instanceof Double || obj instanceof Float || obj instanceof Short || obj instanceof Long) {
                    sb.append(obj).append(",");
                    continue;
                }
                sb.append("'").append(obj).append("'").append(",");
            }
            result = sb.toString();
            if (result.length() > 0) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    public static String listJoin(List<?> list, String chars) {
        String result = "";
        if (list != null) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : list) {
                sb.append(CommonUtils.objectToString(obj)).append(chars);
            }
            result = sb.toString();
            if (result.length() > 0) {
                result = result.substring(0, result.length() - chars.length());
            }
        }
        return result;
    }

    public static String arrayJoinToSql(Object[] array) {
        String result = "";
        if (array != null) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : array) {
                if (obj instanceof Integer || obj instanceof Double || obj instanceof Float || obj instanceof Short || obj instanceof Long) {
                    sb.append(obj).append(",");
                    continue;
                }
                sb.append("'").append(obj).append("'").append(",");
            }
            result = sb.toString();
            if (result.length() > 0) {
                result = result.substring(0, result.length() - 1);
            }
        }
        return result;
    }

    public static String arrayJoin(Object[] array, String chars) {
        String result = "";
        if (array != null) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : array) {
                sb.append(CommonUtils.objectToString(obj)).append(chars);
            }
            result = sb.toString();
            if (result.length() > 0) {
                result = result.substring(0, result.length() - chars.length());
            }
        }
        return result;
    }

    public static List<Serializable> listDelDuplicated(List<Serializable> list) {
        if (list != null) {
            HashSet<Serializable> ts = new HashSet<Serializable>();
            ts.addAll(list);
            list.clear();
            Iterator ito = ts.iterator();
            while (ito.hasNext()) {
                list.add((Serializable)ito.next());
            }
        }
        return list;
    }

    public static Object[] listToArray(List<?> list) {
        Object[] objArr = null;
        if (list != null) {
            objArr = new Object[list.size()];
            int k = objArr.length;
            for (int i = 0; i < k; ++i) {
                objArr[i] = list.get(i);
            }
        }
        return objArr;
    }

    public static List<Object> arrayToList(Object[] array) {
        if (array == null) {
            throw new NullPointerException("array is nullable.");
        }
        return CollectionUtils.arrayAppendToList(new ArrayList<Object>(), array);
    }

    public static List<String> arrayToList(String[] array) {
        if (array == null) {
            throw new NullPointerException("array is nullable.");
        }
        return CollectionUtils.arrayAppendToList(new ArrayList<String>(), array);
    }

    public static List<Integer> arrayToList(int[] array) {
        if (array == null) {
            throw new NullPointerException("array is nullable.");
        }
        return CollectionUtils.arrayAppendToList(new ArrayList<Integer>(), array);
    }

    public static List<Double> arrayToList(double[] array) {
        if (array == null) {
            throw new NullPointerException("array is nullable.");
        }
        return CollectionUtils.arrayAppendToList(new ArrayList<Double>(), array);
    }

    public static List<Object> arrayAppendToList(List<Object> desList, Object[] array) {
        if (desList == null) {
            throw new NullPointerException("target list is nullable.");
        }
        if (array != null) {
            for (Object obj : array) {
                desList.add(obj);
            }
        }
        return desList;
    }

    public static List<String> arrayAppendToList(List<String> desList, String[] array) {
        if (desList == null) {
            throw new NullPointerException("target list is nullable.");
        }
        if (array != null) {
            for (String obj : array) {
                desList.add(obj);
            }
        }
        return desList;
    }

    public static List<Integer> arrayAppendToList(List<Integer> desList, int[] array) {
        if (desList == null) {
            throw new NullPointerException("target list is nullable.");
        }
        if (array != null) {
            int[] nArray = array;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                Integer obj = nArray[i];
                desList.add(obj);
            }
        }
        return desList;
    }

    public static List<Double> arrayAppendToList(List<Double> desList, double[] array) {
        if (desList == null) {
            throw new NullPointerException("target list is nullable.");
        }
        if (array != null) {
            double[] dArray = array;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double obj = dArray[i];
                desList.add(obj);
            }
        }
        return desList;
    }

    public static List<Object> arrayAppendToList(List<Object> desList, Object[] array, int startIndex) {
        if (desList == null) {
            throw new NullPointerException("target list is nullable.");
        }
        if (startIndex < 0) {
            startIndex = 0;
        } else if (startIndex > desList.size()) {
            int size;
            for (int i = size = desList.size(); i < startIndex - 1; ++i) {
                desList.add(null);
            }
        }
        if (startIndex >= desList.size()) {
            CollectionUtils.arrayAppendToList(desList, array);
        } else if (startIndex == 0) {
            List<Object> newList = CollectionUtils.arrayToList(array);
            desList = CollectionUtils.copyListTo(desList, newList);
        } else {
            List<Object> list = CollectionUtils.pickList(desList, 0, startIndex);
            CollectionUtils.arrayAppendToList(list, array);
        }
        return desList;
    }

    public static String listToString(List<?> list) {
        String result = "[";
        if (list != null && list.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (Object obj : list) {
                if (obj != null) {
                    sb.append(String.valueOf(obj));
                } else {
                    sb.append("null");
                }
                sb.append(", ");
            }
            result = result + sb.toString();
            result = result.substring(0, result.length() - 2);
        }
        return result + "]";
    }

    public static String arrayToString(Object[] array) {
        return CollectionUtils.listToString(CollectionUtils.arrayToList(array));
    }

    public static String arrayToString(String[] array) {
        return CollectionUtils.listToString(CollectionUtils.arrayToList(array));
    }

    public static String arrayToString(int[] array) {
        return CollectionUtils.listToString(CollectionUtils.arrayToList(array));
    }

    public static String arrayToString(double[] array) {
        return CollectionUtils.listToString(CollectionUtils.arrayToList(array));
    }

    public static List<Object> appendToList(List<Object> list, Object ... value) {
        if (list == null) {
            throw new NullPointerException("target list is nullable.");
        }
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                list.add(value[i]);
            }
        }
        return list;
    }

    public static List<Object> copyListTo(List<Object> resList, List<Object> destList) {
        if (destList == null) {
            throw new NullPointerException("target list is nullable.");
        }
        if (resList != null) {
            for (Object object : resList) {
                destList.add(object);
            }
        }
        return destList;
    }

    public static List<Object> megreListTo(List<Object> resList, List<Object> destList) {
        CollectionUtils.copyListTo(resList, destList);
        resList.clear();
        resList = null;
        return destList;
    }

    public static List<Object> flushList(List<Object> list) {
        if (list != null) {
            int k = list.size();
            for (int i = 0; i < k; ++i) {
                if (list.get(i) != null) continue;
                list.remove(i);
                return CollectionUtils.flushList(list);
            }
        }
        return list;
    }

    public static Object[] flushArray(Object[] array) {
        Object[] newArray = null;
        if (array != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                if (array[i] == null) continue;
                list.add(array[i]);
            }
            newArray = CollectionUtils.listToArray(list);
        }
        return newArray;
    }

    public static int getMaxIndex(int[] array) {
        int result = -1;
        int[] res = (int[])array.clone();
        Arrays.sort(res);
        int max = res[res.length - 1];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != max) continue;
            result = i;
            break;
        }
        return result;
    }

    public static int[] getMaxsIndex(int[] array) {
        int[] res = (int[])array.clone();
        Arrays.sort(res);
        int max = res[res.length - 1];
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != max) continue;
            list.add(i);
        }
        int[] result = new int[list.size()];
        int k = list.size();
        for (int i = 0; i < k; ++i) {
            result[i] = (Integer)list.get(i);
        }
        return result;
    }
}

