/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.utils;

import com.yinsin.other.LogHelper;
import com.yinsin.test.TestBean;
import com.yinsin.utils.CommonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BeanUtils {
    private static LogHelper log = LogHelper.getLogger(BeanUtils.class);

    public static <T> T getBean(String classPath) {
        T t = null;
        try {
            Class<?> aClass = Class.forName(classPath);
            t = (T)aClass.newInstance();
        }
        catch (Exception e) {
            t = null;
        }
        return t;
    }

    public static <T> Object callBeanMethod(T t, String methodName, Object[] param) {
        Object result = null;
        try {
            Method method = t.getClass().getMethod(methodName, BeanUtils.getParamType(t, methodName));
            result = method.invoke(t, param);
        }
        catch (NoSuchMethodException e) {
            log.error("NoSuchMethodException\uff1a" + methodName);
        }
        catch (SecurityException e) {
            log.error("SecurityException\uff1a" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            log.error("ClassNotFoundException\uff1a" + t.getClass());
        }
        catch (IllegalAccessException e) {
            log.error("IllegalAccessException\uff1a" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.error("IllegalArgumentException\uff1a" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException\uff1a" + e.getMessage());
        }
        return result;
    }

    public static <T> Object getFieldValue(T t, String attrName) {
        Object result = null;
        String methodName = "get" + CommonUtils.firstCharToUpperCase(attrName);
        try {
            Method method = t.getClass().getMethod(methodName, new Class[0]);
            result = method.invoke(t, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.error("NoSuchMethodException\uff1a" + methodName);
        }
        catch (SecurityException e) {
            log.error("SecurityException\uff1a" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error("IllegalAccessException\uff1a" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.error("IllegalArgumentException\uff1a" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException\uff1a" + e.getMessage());
        }
        return result;
    }

    public static <T, V> Object getFieldValue(T t, String attrName, V v) {
        Object result = null;
        String methodName = "get" + CommonUtils.firstCharToUpperCase(attrName);
        try {
            Method method = t.getClass().getMethod(methodName, BeanUtils.getParamType(t, methodName));
            result = method.invoke(t, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.error("NoSuchMethodException\uff1a" + methodName);
        }
        catch (SecurityException e) {
            log.error("SecurityException\uff1a" + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.error("IllegalAccessException\uff1a" + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.error("IllegalArgumentException\uff1a" + e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException\uff1a" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            log.error("ClassNotFoundException\uff1a" + e.getMessage());
        }
        return result;
    }

    public static <T> Class<?>[] getParamType(T t, String methodName) throws ClassNotFoundException {
        Class[] paramTypes = null;
        Method[] methods = t.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methodName.equals(methods[i].getName())) continue;
            Class<?>[] params = methods[i].getParameterTypes();
            paramTypes = new Class[params.length];
            for (int j = 0; j < params.length; ++j) {
                paramTypes[j] = Class.forName(params[j].getName());
            }
            break;
        }
        return paramTypes;
    }

    public static Object coventValue(Object value, Class<?> clasz) {
        String type = clasz.getName();
        if (type.equals("java.lang.String")) {
            return value;
        }
        if (type.equals("int")) {
            return CommonUtils.objectToInt(value);
        }
        if (type.equals("float")) {
            return Float.valueOf(CommonUtils.objectToFloat(value, 0.0f));
        }
        if (type.equals("double")) {
            return CommonUtils.objectToDouble(value, 0.0);
        }
        if (type.equals("java.lang.Double")) {
            return CommonUtils.objectToDouble(value, 0.0);
        }
        if (type.equals("java.lang.Float")) {
            return Float.valueOf(CommonUtils.objectToFloat(value, 0.0f));
        }
        if (type.equals("java.util.Date")) {
            if (value != null) {
                return new Date();
            }
        } else if (type.equals("java.sql.Timestamp") && value != null) {
            return new Timestamp(new Date().getTime());
        }
        return null;
    }

    public static <T> Object setProperty(T t, String propertyName, Object value) {
        Object result = null;
        if (t == null) {
            new NullPointerException("\u7c7b\u5bf9\u8c61\u4e3a\u7a7a..");
        }
        result = BeanUtils.callBeanMethod(t, "set" + CommonUtils.firstCharToUpperCase(propertyName), new Object[]{value});
        return result;
    }

    public static <T> boolean hasMethod(T t, String methodName) {
        boolean has = false;
        if (t == null) {
            new NullPointerException("\u7c7b\u5bf9\u8c61\u4e3a\u7a7a..");
        }
        try {
            Method method = t.getClass().getMethod(methodName, BeanUtils.getParamType(t, methodName));
            if (method != null && method.toString().indexOf("java.lang.Object.toString") == -1) {
                has = true;
            }
        }
        catch (NoSuchMethodException e) {
            log.error("NoSuchMethodException\uff1a" + methodName);
        }
        catch (SecurityException e) {
            log.error("SecurityException\uff1a" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            log.error("ClassNotFoundException\uff1a" + t.getClass().getName());
        }
        return has;
    }

    public static <T> Map<String, Object> objectToMap(T t) {
        if (t == null) {
            new NullPointerException("\u7c7b\u5bf9\u8c61\u4e3a\u7a7a..");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] f = t.getClass().getDeclaredFields();
        if (f != null) {
            for (Field field : f) {
                field.getName();
                String fname = field.getName();
                String getMethod = "get" + CommonUtils.firstCharToUpperCase(fname);
                Object value = BeanUtils.callBeanMethod(t, getMethod, null);
                map.put(fname, value);
            }
        }
        return map;
    }

    public static <T> String toString(T t) {
        String result = t.getClass().toString();
        if (BeanUtils.hasMethod(t, "toString")) {
            result = CommonUtils.objectToString(BeanUtils.callBeanMethod(t, "toString", null));
        } else {
            Map<String, Object> objMap = BeanUtils.objectToMap(t);
            StringBuilder sb = new StringBuilder();
            sb.append(t.getClass().getName()).append("[");
            for (Map.Entry<String, Object> ent : objMap.entrySet()) {
                sb.append(ent.getKey()).append("=").append(ent.getValue()).append(", ");
            }
            sb.append("]");
            result = sb.toString().replaceFirst(", \\]$", "]");
        }
        return result;
    }

    public static String getJavaType(String jdbcType) {
        String javaType = "Object";
        if (jdbcType.equalsIgnoreCase("varchar") || jdbcType.equalsIgnoreCase("char")) {
            javaType = "String";
        } else if (jdbcType.equalsIgnoreCase("int") || jdbcType.equalsIgnoreCase("integer")) {
            javaType = "Integer";
        } else if (jdbcType.equalsIgnoreCase("long") || jdbcType.equalsIgnoreCase("bigint")) {
            javaType = "Long";
        } else if (jdbcType.equalsIgnoreCase("float") || jdbcType.equalsIgnoreCase("number")) {
            javaType = "Float";
        } else if (jdbcType.equalsIgnoreCase("double") || jdbcType.equalsIgnoreCase("decimal")) {
            javaType = "Double";
        } else if (jdbcType.equalsIgnoreCase("date")) {
            javaType = "Date";
        } else if (jdbcType.equalsIgnoreCase("timestamp") || jdbcType.equalsIgnoreCase("time")) {
            javaType = "Timestamp";
        } else if (jdbcType.equalsIgnoreCase("blob")) {
            javaType = "byte[]";
        }
        return javaType;
    }

    public static <T> T copy(T o1, T o2) throws Exception {
        Field[] field = o1.getClass().getDeclaredFields();
        for (int j = 0; j < field.length; ++j) {
            Object value2;
            String name = field[j].getName();
            if (!BeanUtils.hasMethod(o2, "get" + CommonUtils.firstCharToUpperCase(name)) || (value2 = BeanUtils.getFieldValue(o2, name)) == null) continue;
            BeanUtils.setProperty(o1, name, value2);
        }
        return o1;
    }

    public static <T> T copy(T o1, T o2, String[] fields) throws Exception {
        if (fields == null) {
            return BeanUtils.copy(o1, o2);
        }
        Field[] field = o1.getClass().getDeclaredFields();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        int k = fields.length;
        for (int i = 0; i < k; ++i) {
            fieldMap.put(fields[i], fields[i]);
        }
        for (int j = 0; j < field.length; ++j) {
            Object value2;
            String name = field[j].getName();
            if (!fieldMap.containsKey(name) || !BeanUtils.hasMethod(o2, "get" + CommonUtils.firstCharToUpperCase(name)) || (value2 = BeanUtils.getFieldValue(o2, name)) == null) continue;
            BeanUtils.setProperty(o1, name, value2);
        }
        return o1;
    }

    public static <T> T copyNew(T o1, T o2, String[] fields) throws Exception {
        if (fields == null) {
            return BeanUtils.copyNew(o1, o2);
        }
        Object newObj = o1.getClass().newInstance();
        newObj = BeanUtils.copy(newObj, o1);
        newObj = BeanUtils.copy(newObj, o2, fields);
        return (T)newObj;
    }

    public static <T> T copyNew(T o1, T o2) throws Exception {
        Object newObj = o1.getClass().newInstance();
        newObj = BeanUtils.copy(newObj, o1);
        newObj = BeanUtils.copy(newObj, o2);
        return (T)newObj;
    }

    public static void main(String[] args) {
        TestBean tb = new TestBean();
        BeanUtils.setProperty(tb, "name", "\u5f20\u4e09");
        System.out.println(BeanUtils.toString(tb));
        String s = CommonUtils.stringEncode("\u707f");
        System.out.println(s);
    }
}

