/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.security;

import com.yinsin.other.LogHelper;
import com.yinsin.utils.ByteUtils;
import com.yinsin.utils.FileUtils;
import com.yinsin.utils.ObjectUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.Cipher;

public class RSA {
    private static final LogHelper log = LogHelper.getLogger(RSA.class);

    public static boolean makekeyfile(String pubkeyfile, String prikeyfile) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        boolean result = false;
        FileUtils.createFile(pubkeyfile);
        FileUtils.createFile(prikeyfile);
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        ObjectUtils.objectToFile(privateKey, prikeyfile);
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        ObjectUtils.objectToFile(publicKey, pubkeyfile);
        result = true;
        return result;
    }

    private static byte[] handleData(Key k, byte[] data, int encrypt) throws Exception {
        if (k != null) {
            Cipher cipher = Cipher.getInstance("RSA");
            if (encrypt == 1) {
                cipher.init(1, k);
                byte[] resultBytes = cipher.doFinal(data);
                return resultBytes;
            }
            if (encrypt == 0) {
                cipher.init(2, k);
                byte[] resultBytes = cipher.doFinal(data);
                return resultBytes;
            }
        }
        return null;
    }

    public static Key getRSAKey(String pubfile) {
        Key pubkey = null;
        try {
            pubkey = ObjectUtils.fileToObject(pubkey, pubfile);
        }
        catch (Exception e) {
            log.error("getRSAKey is error:" + e.getMessage());
        }
        return pubkey;
    }

    public static String encrypt(String keyfile, String data) {
        String str = null;
        Key key = RSA.getRSAKey(keyfile);
        try {
            byte[] result = RSA.handleData(key, data.getBytes("utf-8"), 1);
            str = ByteUtils.parseByte2HexStr(result);
        }
        catch (Exception e) {
            log.error("encrypt is error:" + e.getMessage());
        }
        return str;
    }

    public static byte[] encryptToByte(String keyfile, String data) throws UnsupportedEncodingException, Exception {
        return RSA.handleData(RSA.getRSAKey(keyfile), data.getBytes("utf-8"), 1);
    }

    public static String decrypt(String keyfile, String data) {
        String str = null;
        Key pubkey = RSA.getRSAKey(keyfile);
        try {
            byte[] result = RSA.handleData(pubkey, ByteUtils.parseHexStr2Byte(data), 0);
            str = new String(result, "utf-8");
        }
        catch (Exception e) {
            log.error("decrypt is error:" + e.getMessage());
        }
        return str;
    }

    public static byte[] decryptToByte(String keyfile, byte[] data) throws UnsupportedEncodingException, Exception {
        return RSA.handleData(RSA.getRSAKey(keyfile), data, 0);
    }
}

