/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.other;

import com.yinsin.utils.BeanUtils;
import com.yinsin.utils.DateUtils;
import java.lang.reflect.Method;
import java.util.Date;

public class LogHelper {
    private Object logObj = null;

    private LogHelper() {
    }

    public static LogHelper getLogger(Class<?> clas) {
        LogHelper log = new LogHelper();
        Object logObj = LogHelper.getLoggerBean(clas, "org.slf4j.LoggerFactory");
        if (logObj != null) {
            log.logObj = logObj;
        }
        return log;
    }

    private String getLogInfo(String level, String fix, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("[YsDevKit] ").append(DateUtils.format(new Date(), "HH:mm:ss.SSS")).append(" ").append(level).append(" ").append(fix).append("\uff1a").append(msg);
        return sb.toString();
    }

    public void debug(String msg) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "debug", new Object[]{msg});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.out.println(this.getLogInfo("DEBUG", logFix, msg));
        }
    }

    public void debug(String format, Object ... args) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "debug", args);
        } else {
            this.debug(String.format(format, args));
        }
    }

    public void debug(String msg, Exception e) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "debug", new Object[]{msg, e});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.out.println(this.getLogInfo("DEBUG", logFix, msg));
            e.printStackTrace();
        }
    }

    public void info(String msg) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "info", new Object[]{msg});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.out.println(this.getLogInfo("INFO", logFix, msg));
        }
    }

    public void info(String format, Object ... args) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "info", args);
        } else {
            this.info(String.format(format, args));
        }
    }

    public void info(String msg, Exception e) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "info", new Object[]{msg, e});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.out.println(this.getLogInfo("INFO", logFix, msg));
            e.printStackTrace();
        }
    }

    public void error(String msg) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "error", new Object[]{msg});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.err.println(this.getLogInfo("ERROR", logFix, msg));
        }
    }

    public void error(String format, Object ... args) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "error", args);
        } else {
            this.error(String.format(format, args));
        }
    }

    public void error(String msg, Exception e) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "error", new Object[]{msg, e});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.err.println(this.getLogInfo("ERROR", logFix, msg));
            e.printStackTrace();
        }
    }

    public void waring(String msg) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "waring", new Object[]{msg});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.err.println(this.getLogInfo("WARING", logFix, msg));
        }
    }

    public void waring(String format, Object ... args) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "waring", args);
        } else {
            this.waring(String.format(format, args));
        }
    }

    public void waring(String msg, Exception e) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "waring", new Object[]{msg, e});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.err.println(this.getLogInfo("WARING", logFix, msg));
            e.printStackTrace();
        }
    }

    public void fatch(String msg) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "fatch", new Object[]{msg});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.err.println(this.getLogInfo("FATCH", logFix, msg));
        }
    }

    public void fatch(String format, Object ... args) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "fatch", args);
        } else {
            this.fatch(String.format(format, args));
        }
    }

    public void fatch(String msg, Exception e) {
        if (this.logObj != null) {
            BeanUtils.callBeanMethod(this.logObj, "fatch", new Object[]{msg, e});
        } else {
            StackTraceElement[] temp = Thread.currentThread().getStackTrace();
            StackTraceElement stack = temp[2];
            String logFix = this.getLogClassMethod(stack);
            System.err.println(this.getLogInfo("FATCH", logFix, msg));
            e.printStackTrace();
        }
    }

    private String getLogClassMethod(StackTraceElement stack) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(stack.getClassName()).append("\uff1a").append(stack.getLineNumber()).append("]").append("[").append(stack.getMethodName()).append("]");
        return sb.toString();
    }

    private static <T> T getLoggerBean(Class<?> clasz, String classPath) {
        Object t = null;
        try {
            Class<?> aClass = Class.forName(classPath);
            Method method = aClass.getMethod("getLogger", Class.class);
            t = method.invoke(aClass.newInstance(), clasz);
        }
        catch (Exception e) {
            t = null;
            System.err.println(e.getMessage());
        }
        return (T)t;
    }
}

