/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.io;

import com.yinsin.io.FastByteArrayOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLConnection;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.zip.ZipFile;

public class IOKit {
    public static final String LINE_SEPARATOR;
    private static final int EOF = -1;
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOKit() {
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        IOKit.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(File file) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder data = IOKit.readFromBufferedReader(reader);
            reader.close();
            return new String(data.toString().getBytes(), "utf-8");
        }
        catch (IOException ex) {
            throw new RuntimeException("File " + file + " not found.");
        }
    }

    private static StringBuilder readFromBufferedReader(BufferedReader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[4096];
        int numRead = 0;
        while ((numRead = reader.read(buffer)) != -1) {
            builder.append(String.valueOf(buffer, 0, numRead));
            buffer = new char[4096];
        }
        return builder;
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        FastByteArrayOutputStream os = new FastByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = input.read(buf);
        while (n != -1) {
            os.write(buf, 0, n);
            n = input.read(buf);
        }
        return os.toByteArray();
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOKit.copy(in, output);
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void write(byte[] data, File file) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOKit.closeQuietly(os);
                throw throwable;
            }
        }
        IOKit.closeQuietly(os);
    }

    public static void write(char[] data, File file, String charsetName) {
        IOKit.write(data, file, Charset.forName(charsetName));
    }

    public static void write(char[] data, File file, Charset charset) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(new String(data).getBytes(charset));
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOKit.closeQuietly(os);
                throw throwable;
            }
        }
        IOKit.closeQuietly(os);
    }

    public static void write(String data, File file, String charsetName) {
        IOKit.write(data, file, Charset.forName(charsetName));
    }

    public static void write(String data, File file, Charset charset) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data.getBytes(charset));
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOKit.closeQuietly(os);
                throw throwable;
            }
        }
        IOKit.closeQuietly(os);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        long count = IOKit.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static int copy(InputStream input, Writer output, String charsetName) throws IOException {
        return IOKit.copy(new InputStreamReader(input, Charset.forName(charsetName)), output);
    }

    public static int copy(InputStream input, Writer output, Charset charset) throws IOException {
        return IOKit.copy(new InputStreamReader(input, charset), output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        long count = IOKit.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static void closeQuietly(ZipFile obj) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ServerSocket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Selector selector) {
        try {
            if (selector != null) {
                selector.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(URLConnection conn) {
        if (conn != null && conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String toString(Reader input) throws IOException {
        int n;
        StringBuilder output = new StringBuilder();
        char[] buffer = new char[4096];
        while (-1 != (n = input.read(buffer))) {
            output.append(buffer, 0, n);
        }
        return output.toString();
    }

    static {
        StringWriter buf = new StringWriter(4);
        PrintWriter out = new PrintWriter(buf);
        out.println();
        LINE_SEPARATOR = buf.toString();
    }
}

