/*
 * Decompiled with CFR 0.152.
 */
package com.yinsin.config;

import com.yinsin.io.IOKit;
import com.yinsin.other.LogHelper;
import com.yinsin.utils.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Config {
    private static final LogHelper LOGGER = LogHelper.getLogger(Config.class);
    private final Map<String, String> config = new HashMap<String, String>(32);

    public Config load(Properties props) {
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            this.config.put(key, value);
        }
        return this;
    }

    public Config load(Map<String, String> map) {
        this.config.putAll(map);
        return this;
    }

    public static Config load(String location) {
        return new Config().loadLoaction(location);
    }

    private Config loadLoaction(String location) {
        if (location.startsWith("classpath:")) {
            location = location.substring("classpath:".length());
            return this.loadClasspath(location);
        }
        if (location.startsWith("file:")) {
            location = location.substring("file:".length());
            return this.load(new File(location));
        }
        return this.loadClasspath(location);
    }

    public void add(String location) {
        Config config = this.loadLoaction(location);
        if (null != config) {
            this.config.putAll(config.asMap());
        }
    }

    public Config load(URL url) {
        String location = url.getPath();
        try {
            location = URLDecoder.decode(location, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            return this.loadInputStream(url.openStream(), location);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Config loadClasspath(String classpath) {
        if (classpath.startsWith("/")) {
            classpath = classpath.substring(1);
        }
        InputStream is = Config.getDefault().getResourceAsStream(classpath);
        LOGGER.info("Load config [classpath:" + classpath + "]");
        return this.loadInputStream(is, classpath);
    }

    public Config load(File file) {
        try {
            LOGGER.info("Load config [file:" + file.getPath() + "]");
            return this.loadInputStream(new FileInputStream(file), file.getName());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Config loadInputStream(InputStream is, String location) {
        if (is == null) {
            throw new IllegalStateException("InputStream not found: " + location);
        }
        location = location.toLowerCase();
        try {
            Properties config = new Properties();
            config.load(is);
            this.load(config);
            Config config2 = this;
            return config2;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOKit.closeQuietly(is);
        }
    }

    public Config loadSystemProperties() {
        return this.load(System.getProperties());
    }

    public Config loadSystemEnvs() {
        return this.load(System.getenv());
    }

    public Map<String, String> asMap() {
        return this.config;
    }

    private static ClassLoader getDefault() {
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loader == null && (loader = Config.class.getClassLoader()) == null) {
            try {
                loader = ClassLoader.getSystemClassLoader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return loader;
    }

    public String get(String key) {
        return this.config.get(key);
    }

    public String get(String key, String defaultValue) {
        return null != this.config.get(key) ? this.config.get(key) : defaultValue;
    }

    public Integer getInt(String key) {
        String value = this.get(key);
        if (CommonUtils.isNotBlank(value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public Integer getInt(String key, Integer defaultValue) {
        return null != this.getInt(key) ? this.getInt(key) : defaultValue;
    }

    public Long getLong(String key) {
        String value = this.get(key);
        if (CommonUtils.isNotBlank(value)) {
            return Long.valueOf(value);
        }
        return null;
    }

    public Long getLong(String key, Long defaultValue) {
        return null != this.getLong(key) ? this.getLong(key) : defaultValue;
    }

    public Double getDouble(String key) {
        String value = this.get(key);
        if (CommonUtils.isNotBlank(value)) {
            return Double.valueOf(value);
        }
        return null;
    }

    public double getDouble(String key, double defaultValue) {
        return null != this.getDouble(key) ? this.getDouble(key) : defaultValue;
    }

    public Boolean getBoolean(String key) {
        String value = this.get(key);
        if (CommonUtils.isNotBlank(value)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public Boolean getBoolean(String key, boolean defaultValue) {
        return null != this.getBoolean(key) ? this.getBoolean(key) : defaultValue;
    }
}

