/*
 * Decompiled with CFR 0.152.
 */
package org.jb2011.lnf.beautyeye.widget.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import org.jb2011.lnf.beautyeye.utils.BEUtils;

public class BEDashedRoundRecBorder
extends LineBorder
implements UIResource {
    private int arcWidth = 6;
    private int arcHeight = 6;
    private int separatorSolid = 2;
    private int separatorSpace = 2;

    public BEDashedRoundRecBorder(Color color) {
        super(color);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        BEUtils.drawDashedRect(g, x, y, width, height, this.arcWidth, this.arcHeight, this.separatorSolid, this.separatorSpace);
        g.setColor(oldColor);
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public BEDashedRoundRecBorder setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
        return this;
    }

    public int getArcHeight() {
        return this.arcHeight;
    }

    public BEDashedRoundRecBorder setArcHeight(int arcHeight) {
        this.arcHeight = arcHeight;
        return this;
    }

    public int getSeparatorSolid() {
        return this.separatorSolid;
    }

    public BEDashedRoundRecBorder setSeparatorSolid(int separatorSolid) {
        this.separatorSolid = separatorSolid;
        return this;
    }

    public int getSeparatorSpace() {
        return this.separatorSpace;
    }

    public BEDashedRoundRecBorder setSeparatorSpace(int separatorSpace) {
        this.separatorSpace = separatorSpace;
        return this;
    }
}

