﻿using MHServerEmu.Commands.Attributes;
using MHServerEmu.DatabaseAccess.Models;
using MHServerEmu.Frontend;
using MHServerEmu.Games.Network.Parsing;

namespace MHServerEmu.Commands.Implementations
{
    [CommandGroup("packet", "Provides commands to interact with packet files.", AccountUserLevel.Admin)]
    public class PacketCommands : CommandGroup
    {
        [Command("parse", "Parses messages from all packets\nUsage: packet parse", AccountUserLevel.Admin)]
        public string Parse(string[] @params, FrontendClient client)
        {
            if (client != null) return "You can only invoke this command from the server console.";
            PacketHelper.ParseServerMessagesFromAllPacketFiles();
            return string.Empty;
        }
    }
}
