# MHServerEmu Documentation

If you would like to ask questions or get up to date information, please feel free to join our [Discord](https://discord.gg/hjR8Bj52t3).

## Setup

If this is your first time using MHServerEmu, you may be interested in this.

- [Initial Setup](./Setup/InitialSetup.md) - stable build setup instructions.

- [Manual Setup](./Setup/ManualSetup.md) - manual setup instructions for advanced users.

- [Advanced Setup](./Setup/AdvancedSetup.md) - advanced setup instructions (enabling accounts, remote connections, etc.).

## Server Emulator

MHServerEmu-specific topics.

- [Server Commands](./ServerEmu/ServerCommands.md) - a list of available server commands.

## Game

Topics concerning the game in general.

- [Glossary](./Game/Glossary.md) - a list of terms used by the game internally.
- [Properties](./Game/Properties.md) - information about game properties (entity stats).

## Networking

Information about client <-> server communication.

- [Packet Structure](./Networking/PacketStructure.md) - an overview of the packet structure.

- [Authentication](./Networking/Authentication.md) - an overview of the authentication flow.

## Game Data

Information about how static game data is stored and processed by the game.

- [Overview](./GameData/Overview.md) - a general overview of how game data is implemented.

- [Pak File](./GameData/PakFile.md) - an overview of the custom archive format used by the game.

- [Data References](./GameData/DataReferences.md) - how static data is referenced by the game.

- [Calligraphy](./GameData/Calligraphy.md) - an overview of the Calligraphy data system.

- [Resources](./GameData/Resources.md) - an overview of resource prototype files.

- [Auxiliary Resource Prototypes](./GameData/AuxiliaryResourcePrototypes.md) - information about auxiliary prototypes used in resources (markers and NaviPatches).

- [Locale](./GameData/Locale.md) - a reference table of supported locales and locale file format information.

## Web

Information about various web assets that the client gets via HTTP.

- [SiteConfig](./Web/SiteConfig.md) - SiteConfig.xml file structure.

- [Embedded Browser](./Web/EmbeddedBrowser.md) - API documentation for the web browser embedded in the client.

## Client

Information about how the client functions.

- [Client Versions](./Client/ClientVersions.md) - information on various client versions and how to get them.

- [Client Launch Parameters](./Client/ClientLaunchParameters.md) - a list of various launch parameters that you can use when running the client (such as enabling verbose logging).

- [ClientConfig](./Client/ClientConfig.md) - ClientConfig.xml file structure.

- [Client Chat Commands](./Client/ClientChatCommands.md) - a list of chat commands available in the client.

- [Internal Console Commands](./Client/InternalConsoleCommands.md) - a list of console commands available in internal builds of the game.
