# Branding guidelines

Thank you for downloading the Creative SDK. You may use the provided assets to highlight your application’s integration with Adobe Creative Cloud.

This page provides guidelines for use of the program’s Adobe trademarks. Consider these guidelines when naming, describing and marketing your application. Please submit all apps and app updates to creativesdk@adobe.com for brand approval.

Use of the badges and icons is governed by Adobe’s trademark guidelines and Terms of Use, and if any use violates the branding terms outlined below, we may request that you modify or cease usage of the assets.

We recommend that these assets feel at home in your app, so you may customize them using size, color and effects to best match the style of your app.

**Things not to do:**
* Please do not include Creative Cloud, Photoshop or anything similar in the name of your app.
* Please do not feature the Creative Cloud connected badge, Creative Cloud icon, Behance icon or Adobe logo larger than your own logo.
* Please do not stretch, redraw, or otherwise alter the shape of the assets, letterforms within the icons, or use a different typeface to replace the 2-letter mnemonic for the icons.

## Using the Creative Cloud Badge and Brand

### On your website or marketing materials

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/CC_connected_marketing_badge_blk.svg)
Creative Cloud Connected badge for Marketing use
[Download marketing badge (.ai)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/CC_connected_marketing_badge_blk.ai)

You may use the Creative Cloud connected badge to highlight your app’s integration with Creative Cloud. If you refer to Creative Cloud in connection with your logo, your logo must be larger than the Creative Cloud icon, logo, or badge.

For legibility:

* Use badge should never appear smaller than 30 pixels tall on screen or .25” in print.
* It should be placed on a solid color background.
* You may leave a space equal to half the height of the badge around it so it is separated from other design or text elements.

Example use of the Creative Cloud connected badge in packaging, by Moleskine:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/moleskine_example.jpg)  

### In an application store (i.e. Apple’s App Store, Google Play)

You may include the phrase “Creative Cloud connected” but do not infer that there is a partnership with Adobe or that Adobe endorses your app.

### In your application

Your application should always refer to Creative Cloud in its full name, e.g. “save to Creative Cloud” or “Creative Cloud connected” rather than shortening to “CC.”

The Creative Cloud icon, on tile and off-tile:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/creativecloud_appicon_176x168.png) ![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/creativecloud_appicon_offtile_black_RGB.svg)

[Download Creative Cloud logo assets (.svg & .png)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/CC_logo.zip)

You may use the Creative Cloud icon in your application in several ways:  
1\. As a button that initiates an action with Creative Cloud, such as signing in or saving to Creative Cloud.  
2\. To indicate that a file is stored in Creative Cloud.  
3\. As a button that initiates editing using Creative Cloud technology.  
4\. As a reference to the App Library integration into your product.

Example use of the Creative Cloud logo in app UI, by ArtRage:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/artrage_example.jpg)  

## The Creative Cloud logo & text badge:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/CC_connected_horizontal_badge_blk.svg)  

[Download Creative Cloud logo & text badge (.ai)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/CC_connected_horizontal_badge_blk.ai)

You may use the Creative Cloud connected logo and text badge to promote integration with Adobe Creative Cloud within your application. This treatment should be used instead of the version with the border above. This is the only phrase that should be used within your app to indicate that the technology is powered by the Creative Cloud. Do not use create different lock ups that use phrasing such as “Powered by Lightroom”, or “Powered by Photoshop”.

Example of use of the Creative Cloud connected logo and text asset in an application, by Fabrika:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/fabrika_example.jpg)

## Creative Cloud Sign in

Creative Cloud sign in is instrumental to the SDK and providing customers access to the Creative Cloud and Photoshop technology.

Creative Cloud sign in is used to enable the following experiences:

1\. Account creation  
Creative Cloud sign-in lets people quickly create a free Creative Cloud account, allowing them to access powerful technology across multiple mobile apps and online services.  
2\. File access and storage  
When users are signed in to the Creative Cloud they can access and save Files stored in their Creative Cloud accounts from anywhere, even outside your app easily.  
3\. Access to creative technology in desktop and mobile apps.  
Many highly retentive apps let people not just use the Photoshop-enabled tools within their apps, but also integrate the Send-to-desktop technology that allows people to keep working and refining the work on their desktop computer.

**The Sign in Button**

The sign in button is a simple way to trigger the Creative Cloud sign in process from your app:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/A_signin_blk.svg) ![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/A_signin_short_blk.svg) ![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/CC_signin_blk.svg) ![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/CC_signin_short_blk.svg)  

[Download Creative Cloud Sign In badges (.ai)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/CC_signin.zip)

When asking users to sign in to your app, you may use the phrases “Sign in” or “Sign in with Adobe ID” paired with either the Adobe A logo or the Creative Cloud logo.

Alternately, the phrase “Sign in to Adobe Creative Cloud” without the logos, may also be used.

Example sign-in screen used by Paper, by 53:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/paper_example.jpg)

## Highlighting Features of Creative SDK Integration

Giving your users access to all the features of Creative Cloud is integratal part of the Creative SDK. Whether integrating one or all of the options into your application, make sure to follow these guidelines to ensure clear communication and brand consistency.

### Creative Cloud Market

Creative Cloud Market allows your users to obtain curated assets from our world-class creative community within your app.
![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/cc_market_icon.svg)  
Creative Cloud Market icon for use within application
[Download the Creative Cloud Market icon (.svg)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/cc_market_icon.svg)

You may use the Creative Cloud Market icon to indicate access within the app, much like users would access their photos or Files from another third party File storage account. Please use the full, correct name of the service: “Creative Cloud Market” whenever possible. If there is not enough room, use “Market” but do not shorten the name to “Creative Market” or “CC Market.”

Example use of the Creative Cloud Market icon in UI, by AppCooker:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/appcooker_example.jpg)

## Use of Adobe Desktop Product Branding

Enable your users to tap into the power of the entire Creative Cloud ecosystem with the ability to save layered PSD files and send files directly to open in Photoshop on the desktop.

**Adobe Photoshop CC:**

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/photoshop_24.svg) ![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/photoshop_24_hex.svg)  
Adobe Photoshop icon for use within application
[Download the Adobe Photoshop icons (.svg)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/PS_icons.zip)

You may use the Photoshop icon to indicate:

1\. Using Photoshop-enabled techology within your application.  
2\. Opening a layered Photoshop File (PSD) from the Creative Cloud or saving a layered PSD File to the Creative Cloud.  
3\. Sending the image File from within your application to open in the desktop version of Photoshop CC.

The Photoshop icon should always appear with the rectangular border around it, this element is part of the logo. The icon color may change to match your particular UI color (as shown below), or if you choose to keep the Photoshop blue, use hex color #2287B9.

Indicating opening a layered Photoshop File should always use the terms “Photoshop File”, “Layered Photoshop File,” or “PSD” along with the Photoshop icon above. “PSD” is the File extension for a Photoshop File.

Example use of opening a PSD File from Bazaart:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/bazzart_example.jpg)  

When indicating saving a layered Photoshop File, use the phrasing “Save a PSD” or “Save a layered Photoshop File,” rather than “Saving to Photoshop” or “Save to Ps”.

Example use of saving a PSD File from Concepts:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/concepts_example.jpg)  

When indicating sending to the desktop version of Photoshop, always use the phrase “Send to Photoshop CC” or “Send to Photoshop” along with the icon. Do not use the phrasing “Open in Photoshop” or shorten “Photoshop” to “Ps” or “PS”.

Example use of sending a File to Photoshop from Adobe Comp CC:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/comp_example.jpg)  

**Adobe Illustrator CC:**

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/illustrator_24.svg) ![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/illustrator_24_hex.svg)  
Adobe Illustrator icon for use within application
[Download the Adobe Illustrator icons (.svg)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/AI_icons.zip)

You may use the Illustrator icons to indicate:

1\. Opening an Illustrator File (AI) from the Creative Cloud or saving a vector AI File to the Creative Cloud.  
2\. Sending the image file from within your application to open in the desktop version of Adobe Illustrator.

The Illustrator icon should always appear with the rectangular border around it, this element is part of the logo. The icon color may change to match your particular UI color, or if you choose to keep the Illustrator orange, use hex color #DC6920.

Indicating opening or saving an Illustrator File should always use the terms “Illustrator File”, or “AI” along with the icon. “AI” is the file extension for an Illustrator File.

When indicating sending to the desktop version of Illustrator, always use the phrase “Send to Illustrator CC” or “Send to Illustrator” along with the icon. Do not use the phrasing “Open in Illustrator” or shorten “Illustrator” to “Ai” or “AI”.

**Adobe Photoshop Lightroom CC:**

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/lightroom_24.svg) ![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/lightroom_24_hex.svg)  
Adobe Lightroom icon for use within application
[Download the Adobe Lightroom icons (.svg)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/LR_icons.zip)

You may use the Lightroom icons as a button to indicate connecting to or opening a photo from the users Adobe Photoshop Lightroom library.

The Lightroom icon should always appear with the rectangular border around it, this element is part of the logo. The icon color may change to match your particular UI color, or if you choose to keep the Lightroom blue, use hex color #76ACD4.

To reference the Lightroom library, you may use the terms “Adobe Photoshop Lightroom Photos”, “Lightroom Photos”, “Lightroom Photo Collection”, or “Photos” along with the icon.

## Use of Behance Branding

Allow your users to connect with millions of creatives by sharing to Behance from within your app.

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/behance_24.svg) ![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/behance_24_hex.svg)  
Behance icon for use within application
[Download the Behance icon (.svg)](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/assets/BE_icons.zip)

You may use the Behance logo in your application as a button that initiates an action with Behance, such as publishing to Behance.

If your app takes action with Behance, ensure that the action is clear to the user by clearly stating the action, e.g. “Publish to Behance” or “Publish Work In Progress to Behance”.

The Behance icon should always appear with the rectangular border around it, this element is part of the logo. The icon color may change to match your particular UI color, or if you choose to keep the Behance blue, use hex color: #009FF4.

Example of Behance branding in Adobe Sketch:

![](https://aviarystatic.s3.amazonaws.com/creativesdk/branding/sketch_example.jpg)
