
[![License](https://img.shields.io/github/license/Corsinvest/cv4pve-admin.svg)](LICENSE)
[![Release](https://img.shields.io/github/release/Corsinvest/cv4pve-admin.svg)](https://github.com/Corsinvest/cv4pve-admin/releases/latest) 
[![GitHub All Releases](https://img.shields.io/github/downloads/Corsinvest/cv4pve-admin/total.svg)](https://github.com/Corsinvest/cv4pve-admin/releases)
[![Docker Pulls](https://img.shields.io/docker/pulls/corsinvest/cv4pve-admin)](https://hub.docker.com/r/corsinvest/cv4pve-admin)
[![.NET C#](https://img.shields.io/badge/.NET-C%23-blue)](https://docs.microsoft.com/en-us/dotnet/csharp/)

<img referrerpolicy="no-referrer-when-downgrade" src="https://matomo.corsinvest.it/matomo.php?idsite=4&amp;rec=1&amp;action_name=cv4pve-admin" style="border:0" alt="" />

# CV4PVE-ADMIN


> [!WARNING]
> Technical support is considered valid only if each node of the cluster is covered by the cv4pve-admin license.

![image](https://raw.githubusercontent.com/Corsinvest/cv4pve-admin/main/src/Corsinvest.ProxmoxVE.Admin/wwwroot/doc/images/screenshot/modules/home/home-computerscreen.png)

## 💻 What is it?

The easiest and most effective solution to monitor your multiple Proxmox VE cluster in a single web portal.


## 🚀 Main features

> Discover all the features on the official website: [here](https://corsinvest.it/cv4pve-admin-proxmox)

* Completely written in C#
* Use native Api REST Proxmox VE (library C#)
* Independent os (Windows, Linux, Macosx)
* Installation rapid, unzip file extract
* Docker version [DockerHub](https://hub.docker.com/r/corsinvest/cv4pve-admin)
* Not require installation in Proxmox VE
* Use Credential or Api Token to connect Cluster/Node
* Execute outside Proxmox VE
* Multiple Cluster/Node Management
* Minimum version of Proxmox VE 6.4

## ⬇️ How to install

Immerse yourself in the world of comfort, follow these steps to download and install cv4pve-admin.

You can download cv4pve-admin in two ways: _**binary**_ (via github) and _**docker**_ (via dockerhub)

* [Binary Mode Steps](https://corsinvest.it/cv4pve-admin-download-how-to-install-binary/)
* [Docker Mode Steps](https://corsinvest.it/cv4pve-admin-download-how-to-install-docker/)


## 📙 Documentation

[Documentation](https://htmlpreview.github.io/?https://github.com/Corsinvest/cv4pve-admin/blob/main/src/Corsinvest.ProxmoxVE.Admin/wwwroot/doc/index.html)


## 🟢 Access to the Web App

url: http://ipaddress:5000

username: **admin@local**  password: **Password123!**


## 🌟 We grow together

We really appreciate the stars, they help us grow. Thank you!

## 📰 Copyright 

For licensing details please visit [LICENSE](LICENSE)

```text
     ______                _                      __
    / ____/___  __________(_)___ _   _____  _____/ /_
   / /   / __ \/ ___/ ___/ / __ \ | / / _ \/ ___/ __/
  / /___/ /_/ / /  (__  ) / / / / |/ /  __(__  ) /_
  \____/\____/_/  /____/_/_/ /_/|___/\___/____/\__/


  Proxmox VE Administration CLuster     (Made in Italy)

  For more information visit https://www.corsinvest.it/cv4pve-admin
```

## 🦺 Commercial Support

This open source software is part of an open source suite tools called cv4pve-tools.

If you need commercial support, visit the [site](https://www.corsinvest.it/cv4pve-admin-proxmox)

> [!WARNING]
> Technical support is considered valid only if each node of the cluster is covered by the cv4pve-admin license.


## Screenshots

#### _home page_
![image](https://raw.githubusercontent.com/Corsinvest/cv4pve-admin/main/src/Corsinvest.ProxmoxVE.Admin/wwwroot/doc/images/screenshot/modules/home/homepage.png)
#### _snapshots_
![image](https://raw.githubusercontent.com/Corsinvest/cv4pve-admin/main/src/Corsinvest.ProxmoxVE.Admin/wwwroot/doc/images/screenshot/modules/autosnap/modules-safe-autosnap.png)
#### _cluster usage_
![image](https://raw.githubusercontent.com/Corsinvest/cv4pve-admin/main/src/Corsinvest.ProxmoxVE.Admin/wwwroot/doc/images/screenshot/modules/cluster-usage/by-costs3.png)
#### _multicluster_
![image](https://raw.githubusercontent.com/Corsinvest/cv4pve-admin/main/src/Corsinvest.ProxmoxVE.Admin/wwwroot/doc/images/screenshot/multicluster/multicluster-management.png)

<sub><div align="center"> Proxmox® is a registered trademark of Proxmox Server Solutions GmbH. </div></sub>
